/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.changerecord;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hspm.business.util.PersonModelUtil;
import kd.sdk.hr.hspm.business.helper.ValueConvertHelper;
import kd.sdk.hr.hspm.common.dto.ChangeDto;
import kd.sdk.hr.hspm.common.enums.FieldTypeEnum;
import kd.sdk.hr.hspm.common.ext.file.EmployeeChangeRecordFieldDTO;
import kd.sdk.hr.hspm.common.utils.CommonUtil;
import kd.sdk.hr.hspm.common.utils.PropertyHelper;
import kd.sdk.hr.hspm.formplugin.web.file.ermanfile.ext.service.employee.MobileBillDetailExtUtil;

public class ChangeRecordHelper {
    private static final Log LOGGER = LogFactory.getLog(ChangeRecordHelper.class);
    private static Set<String> FILTER_FIELD = new HashSet<String>();
    private static final Integer MAX_QUERY_COUNT = 1000;

    public static List<Map<String, Object>> getChangeRecord(List<String> entityNames, Map<String, Object> values, boolean onlySelf, boolean onlyCheck) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (!CollectionUtils.isEmpty(entityNames)) {
            for (String entityName : entityNames) {
                List<Map<String, Object>> compareDataList;
                QFilter qFilter = ChangeRecordHelper.getQFilter(entityName, values);
                if (qFilter == null) continue;
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
                Object[] dyArray = serviceHelper.query(ChangeRecordHelper.getSelectProperties(entityName), new QFilter[]{qFilter}, "id desc", MAX_QUERY_COUNT.intValue());
                if (!ArrayUtils.isNotEmpty((Object[])dyArray) || CollectionUtils.isEmpty(compareDataList = ChangeRecordHelper.compareData(serviceHelper, (DynamicObject[])dyArray, onlySelf, onlyCheck))) continue;
                list.addAll(compareDataList);
                if (!onlyCheck) continue;
                break;
            }
            if (!onlyCheck) {
                ChangeRecordHelper.changeRecordSort(list);
            }
        }
        return list;
    }

    private static void changeRecordSort(List<Map<String, Object>> list) {
        if (!CollectionUtils.isEmpty(list)) {
            Collections.sort(list, (o1, o2) -> {
                String entityName = (String)o1.get("entityName");
                Long boId = (Long)o1.get("boid");
                if (entityName != null && entityName.equals(o2.get("entityName")) && boId != null && boId.equals(o2.get("boid"))) {
                    String hisVerson = (String)o1.get("hisversion");
                    String hisVerson2 = (String)o2.get("hisversion");
                    return hisVerson2.compareTo(hisVerson);
                }
                Date date1 = (Date)o1.get("modifytime");
                Date date2 = (Date)o2.get("modifytime");
                if (date1 == null || date2 == null) {
                    return 1;
                }
                return date2.compareTo(date1);
            });
        }
    }

    private static String getSelectProperties(String entityName) {
        Map fields = MetadataServiceHelper.getDataEntityType((String)entityName).getAllFields();
        StringBuilder stringBuilder = new StringBuilder();
        for (String property : fields.keySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(property);
        }
        return stringBuilder.toString();
    }

    private static QFilter getQFilter(String pageNumber, Map<String, Object> values) {
        QFilter qFilter = PersonModelUtil.getQFilter(pageNumber, values);
        if (qFilter != null) {
            qFilter.and("ismodify", "=", (Object)"0");
        }
        return qFilter;
    }

    private static List<Map<String, Object>> compareData(HRBaseServiceHelper serviceHelper, DynamicObject[] dyArray, boolean onlySelf, boolean onlyCheck) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        long currUserId = RequestContext.get().getCurrUserId();
        Map<Integer, List<DynamicObject>> dataMap = Stream.of(dyArray).filter(dy -> HRStringUtils.isNotEmpty((String)dy.getString("hisversion"))).collect(Collectors.groupingBy(dy -> {
            String string = dy.getString("hisversion");
            return Integer.valueOf(string.substring(1));
        }));
        Boolean isFffectiveProp = null;
        for (DynamicObject dynamicObject : dyArray) {
            List<ChangeDto> changeList;
            long modifier;
            DynamicObject user;
            if (HRStringUtils.isEmpty((String)dynamicObject.getString("hisversion"))) continue;
            if (isFffectiveProp == null) {
                isFffectiveProp = dynamicObject.getDynamicObjectType().getProperties().containsKey((Object)"bsed");
            }
            if (isFffectiveProp.booleanValue()) {
                user = dynamicObject.getDynamicObject("modifier");
                modifier = user != null ? user.getLong("id") : 0L;
            } else {
                user = dynamicObject.getDynamicObject("creator");
                long l = modifier = user != null ? user.getLong("id") : 0L;
            }
            if (onlySelf && currUserId != modifier || CollectionUtils.isEmpty(changeList = ChangeRecordHelper.compareData(serviceHelper, dataMap, dynamicObject, onlyCheck))) continue;
            HashMap<String, Object> data = new HashMap<String, Object>(4);
            data.put("value", changeList);
            data.put("modifytime", dynamicObject.getDate("createtime"));
            data.put("entityName", dynamicObject.getDynamicObjectType().getName());
            data.put("hisversion", dynamicObject.getString("hisversion"));
            data.put("boid", dynamicObject.getLong("boid"));
            String name = null;
            if (user != null && user.getLocaleString("name") != null && HRStringUtils.isEmpty((String)(name = user.getLocaleString("name").getLocaleValue()))) {
                name = user.getString("name");
            }
            data.put("modifier", name != null ? name : " ");
            list.add(data);
            if (onlyCheck) break;
        }
        return list;
    }

    private static List<ChangeDto> compareData(HRBaseServiceHelper serviceHelper, Map<Integer, List<DynamicObject>> dataMap, DynamicObject dynamicObject, boolean onlyCheck) {
        String hisVersion = dynamicObject.getString("hisversion");
        Integer integer = Integer.valueOf(hisVersion.substring(1));
        if (integer == 1) {
            return ChangeRecordHelper.compareData(serviceHelper.generateEmptyDynamicObject(), dynamicObject, onlyCheck, true);
        }
        List<DynamicObject> objectList = dataMap.get(integer - 1);
        Optional<DynamicObject> first = objectList.stream().filter(dy -> dynamicObject.getLong("boid") == dy.getLong("boid")).findFirst();
        if (first.isPresent()) {
            DynamicObject dyBefore = first.get();
            return ChangeRecordHelper.compareData(dyBefore, dynamicObject, onlyCheck, false);
        }
        return null;
    }

    private static List<ChangeDto> compareData(DynamicObject before, DynamicObject after, boolean onlyCheck, boolean isNew) {
        ArrayList<ChangeDto> list = new ArrayList<ChangeDto>();
        String entityName = after.getDynamicObjectType().getName();
        Map fields = MetadataServiceHelper.getDataEntityType((String)entityName).getAllFields();
        for (Map.Entry field : fields.entrySet()) {
            IDataEntityProperty property = (IDataEntityProperty)field.getValue();
            String fieldName = property.getName();
            if (FILTER_FIELD.contains(fieldName)) continue;
            FieldTypeEnum fieldType = FieldTypeEnum.getFieldTypeByCode((String)property.getClass().getName());
            if (Objects.isNull(fieldType)) {
                LOGGER.warn(MessageFormat.format("not exist the fieldTypeEnum{0}", property.getClass().getName()));
                continue;
            }
            Object beforeValue = before.get(fieldName);
            Object afterValue = after.get(fieldName);
            if (beforeValue == null && afterValue == null) continue;
            beforeValue = ChangeRecordHelper.handleFieldValue(fieldType, beforeValue);
            afterValue = ChangeRecordHelper.handleFieldValue(fieldType, afterValue);
            if (beforeValue instanceof MulBasedataDynamicObjectCollection && afterValue instanceof MulBasedataDynamicObjectCollection) {
                try {
                    if (CommonUtil.customObjectEquals((Object)afterValue, (Object)beforeValue, null)) continue;
                    ChangeRecordHelper.addCompareData(list, entityName, property, fieldName, fieldType, beforeValue, afterValue, isNew);
                    continue;
                }
                catch (Exception ex) {
                    LOGGER.error("compareDataException", (Throwable)ex);
                }
            }
            if ((beforeValue == null || beforeValue.equals(afterValue)) && (afterValue == null || afterValue.equals(beforeValue))) continue;
            ChangeRecordHelper.addCompareData(list, entityName, property, fieldName, fieldType, beforeValue, afterValue, isNew);
            EmployeeChangeRecordFieldDTO fieldDTO = new EmployeeChangeRecordFieldDTO(before, after, ChangeRecordHelper.showString(entityName, fieldName, fieldType, beforeValue, isNew), ChangeRecordHelper.showString(entityName, fieldName, fieldType, afterValue, false), fieldName);
            MobileBillDetailExtUtil.modifyChangeRecordDetail((EmployeeChangeRecordFieldDTO)fieldDTO);
            for (ChangeDto changeDto : list) {
                if (!changeDto.getFieldKey().equals(fieldDTO.getField())) continue;
                changeDto.setBeforeValue(fieldDTO.getBeforeValue());
                changeDto.setAfterValue(fieldDTO.getAfterValue());
            }
            if (!onlyCheck) continue;
            break;
        }
        return list;
    }

    private static void addCompareData(List<ChangeDto> list, String entityName, IDataEntityProperty property, String fieldName, FieldTypeEnum fieldType, Object beforeValue, Object afterValue, boolean isNew) {
        String name = property.getDisplayName() != null ? property.getDisplayName().getLocaleValue() : fieldName;
        String fieldKey = property.getName();
        ChangeDto changeDto = new ChangeDto(name, fieldType, fieldKey);
        changeDto.setBeforeValue(ChangeRecordHelper.showString(entityName, fieldName, fieldType, beforeValue, isNew));
        changeDto.setAfterValue(ChangeRecordHelper.showString(entityName, fieldName, fieldType, afterValue, false));
        list.add(changeDto);
    }

    private static Object handleFieldValue(FieldTypeEnum fieldType, Object value) {
        if (value == null) {
            value = "";
        } else if (fieldType == FieldTypeEnum.COMBO) {
            value = value.toString().trim();
        } else if (fieldType == FieldTypeEnum.DECIMAL && value instanceof BigDecimal) {
            value = ((BigDecimal)value).setScale(1, 4);
        } else if (value instanceof OrmLocaleValue) {
            OrmLocaleValue ormLocaleValue = (OrmLocaleValue)value;
            value = ormLocaleValue.getLocaleValue() != null ? ormLocaleValue.getLocaleValue() : "";
        }
        return value;
    }

    private static String showString(String entityName, String fieldName, FieldTypeEnum fieldType, Object value, boolean isNew) {
        if (value != null && HRStringUtils.isNotEmpty((String)value.toString())) {
            switch (fieldType) {
                case INTEGER: {
                    return value.equals(0) ? "" : value.toString();
                }
                case DECIMAL: {
                    return ((BigDecimal)value).setScale(1, 4).toString();
                }
                case BILL_STATUS: 
                case COMBO: {
                    return ValueConvertHelper.handleCombo((String)entityName, (String)fieldName, (String)value.toString());
                }
                case DATE: 
                case CREATE_DATE: 
                case MODIFY_DATE: {
                    return HRDateTimeUtils.format((Date)((Date)value), (String)"yyyy-MM-dd");
                }
                case DATE_TIME: {
                    return HRDateTimeUtils.format((Date)((Timestamp)value), (String)"yyyy-MM-dd HH:mm:ss");
                }
                case BOOLEAN: {
                    return isNew ? "" : ValueConvertHelper.handleBoolean((String)value.toString());
                }
                case BASE_DATA: 
                case CREATER: 
                case MODIFIER: 
                case USER: 
                case CITY: 
                case MAIN_ORG: 
                case Currency: 
                case ORGPROP: 
                case QueryProp: 
                case ADDRESSPROP: 
                case HISMODELBASEDATAPROP: {
                    DynamicObject dynamicObject = (DynamicObject)value;
                    if (!HRObjectUtils.isEmpty((Object)dynamicObject)) {
                        if (PropertyHelper.existProperty((DynamicObject)dynamicObject, (String)"name")) {
                            return dynamicObject.getString("name");
                        }
                        if (PropertyHelper.existProperty((DynamicObject)dynamicObject, (String)"number")) {
                            return dynamicObject.getString("number");
                        }
                    }
                }
                case MULBASEDATAPROP: {
                    MulBasedataDynamicObjectCollection mulDys = (MulBasedataDynamicObjectCollection)value;
                    return ValueConvertHelper.handleMulBaseData((List)mulDys);
                }
                case ADMIN_DIVISION: {
                    return ValueConvertHelper.handleAdminDivisionField((String)((String)value));
                }
            }
            return value.toString();
        }
        return "";
    }

    static {
        FILTER_FIELD.add("attachmentpanelap_std");
        FILTER_FIELD.add("id");
        FILTER_FIELD.add("boid");
        FILTER_FIELD.add("iscurrentversion");
        FILTER_FIELD.add("datastatus");
        FILTER_FIELD.add("ismodify");
        FILTER_FIELD.add("sourcevid");
        FILTER_FIELD.add("firstbsed");
        FILTER_FIELD.add("changebsed");
        FILTER_FIELD.add("bred");
        FILTER_FIELD.add("brled");
        FILTER_FIELD.add("brfd");
        FILTER_FIELD.add("hisversion");
        FILTER_FIELD.add("bsed");
        FILTER_FIELD.add("bsled");
        FILTER_FIELD.add("changedescription");
        FILTER_FIELD.add("creator");
        FILTER_FIELD.add("createtime");
        FILTER_FIELD.add("modifier");
        FILTER_FIELD.add("modifytime");
        FILTER_FIELD.add("initdatasource");
        FILTER_FIELD.add("initstatus");
        FILTER_FIELD.add("initbatch");
        FILTER_FIELD.add("pereduexp");
        FILTER_FIELD.add("person");
        FILTER_FIELD.add("depemp");
        FILTER_FIELD.add("employee");
        FILTER_FIELD.add("cmpemp");
    }
}

