/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.domian.handler;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class SyncJudgeHandler {
    private static final Log LOGGER = LogFactory.getLog(SyncJudgeHandler.class);

    public void handleSync(DynamicObject messageContext) {
        LOGGER.info("PositionChangeService SyncJudgeHandler");
        String params = messageContext.getString("msgcontent");
        if (HRStringUtils.isEmpty((String)params)) {
            LOGGER.info("PositionChangeService#message Context is null");
        } else {
            Map parMap = (Map)SerializationUtils.deSerializeFromBase64((String)params);
            if (!HRMapUtils.isEmpty((Map)parMap)) {
                Integer success = 200;
                String eventIdStr = (String)parMap.get("eventId");
                if (HRStringUtils.isEmpty((String)eventIdStr)) {
                    LOGGER.info("PositionChangeService#eventId is null");
                    return;
                }
                long eventId = Long.parseLong(eventIdStr);
                Map positionMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hbpm", (String)"IHBPMPositionHisVersionQueryService", (String)"queryPositionHisVersionCompare", (Object[])new Object[]{Collections.singletonList(eventId)});
                LOGGER.info("PositionChangeService#queryPositionHisVersionCompare\uff1a{}-->{}", (Object)eventId, (Object)positionMap);
                if (success.equals(positionMap.get("code"))) {
                    Long preParent;
                    Object objData = positionMap.get("data");
                    if (!(objData instanceof Map)) {
                        LOGGER.info("PositionChangeService#data is null");
                        return;
                    }
                    Map dataMap = (Map)positionMap.get("data");
                    Object objList = dataMap.get(eventId);
                    if (!(objList instanceof List)) {
                        LOGGER.info("PositionChangeService#list is null");
                        return;
                    }
                    List list = (List)dataMap.get(eventId);
                    if (CollectionUtils.isEmpty((Collection)list)) {
                        LOGGER.info("PositionChangeService#positionList is null");
                        return;
                    }
                    Map versionMap = (Map)list.get(0);
                    Object preVersionObj = versionMap.get("preVersion");
                    if (!(preVersionObj instanceof Map)) {
                        LOGGER.info("PositionChangeService#preVersion is null");
                        return;
                    }
                    Map preMap = (Map)versionMap.get("preVersion");
                    Object hisVersionInfoMap = preMap.get("hisVersionInfo");
                    if (!(hisVersionInfoMap instanceof Map)) {
                        LOGGER.info("PositionChangeService#hisVersionInfo is null");
                        return;
                    }
                    Map preHisMap = (Map)preMap.get("hisVersionInfo");
                    Object currObj = versionMap.get("currentVersion");
                    if (!(currObj instanceof Map)) {
                        LOGGER.info("PositionChangeService#currentVersion is null");
                        return;
                    }
                    Map currMap = (Map)versionMap.get("currentVersion");
                    Object versionInfoObj = currMap.get("hisVersionInfo");
                    if (!(versionInfoObj instanceof Map)) {
                        LOGGER.info("PositionChangeService#versionInfoMap is null");
                        return;
                    }
                    Map currHisMap = (Map)currMap.get("hisVersionInfo");
                    Long currParent = (Long)currHisMap.get("parent");
                    if (!currParent.equals(preParent = (Long)preHisMap.get("parent"))) {
                        this.toSyncData(currHisMap);
                    }
                } else {
                    LOGGER.error("IHBPMPositionHisVersionQueryService.queryPositionHisVersionCompareyError:{}", (Object)JSONObject.toJSONString((Object)positionMap));
                }
            }
        }
    }

    private void toSyncData(Map<String, Object> currHisMap) {
        Long positionId = (Long)currHisMap.get("boid");
        Map positionPersonIds = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getAllUsersOfPosition", (Object[])new Object[]{"1", Collections.singletonList(positionId)});
        LOGGER.info("PositionChangeService#getAllUsersOfPosition\uff1a{}", (Object)positionPersonIds);
        Set personIds = (Set)positionPersonIds.get(positionId);
        if (!CollectionUtils.isEmpty((Collection)personIds)) {
            ArrayList personList = new ArrayList(personIds);
            List partitionList = Lists.partition(personList, (int)5000);
            for (List personIdList : partitionList) {
                ArrayList userList = new ArrayList(10);
                for (Long personId : personIdList) {
                    HashMap<String, Object> temp = new HashMap<String, Object>(16);
                    temp.put("synctype", "update");
                    temp.put("personid", personId);
                    userList.add(temp);
                }
                Map syncMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"syncPersonToSysUer", (Object[])new Object[]{userList});
                LOGGER.info("PositionChangeService#positionChangeSyncUser:{}", (Object)syncMap);
            }
        }
    }
}

