/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.domian.repository;

import com.google.common.collect.Lists;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.dao.factory.HRBaseDaoFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.hr.hspm.business.repository.ext.service.EmpReportExtCommon;

public class EmpReportRepository {
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("hspm_reportquery");
    private static final String FIELD_ADMINIORG = "hrpi_empposorgrel.adminorg";
    private static final Long WORKING_STATE_ID = 1010L;

    public static DynamicObject generate() {
        return HELPER.generateEmptyDynamicObject();
    }

    public static QFilter getOrgFilter(String fieldName) {
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)RequestContext.get().getCurrUserId(), (String)"hspm", (String)"hspm_empreport", (String)"47150e89000000ac");
        if (result == null) {
            return QFilter.isNull((String)"id");
        }
        if (!result.hasAllOrgPerm()) {
            return new QFilter(fieldName, "in", (Object)result.getHasPermOrgs());
        }
        return QFilter.isNotNull((String)"id");
    }

    public static QFilter getAdminOrgFilter(String fieldName) {
        AuthorizedOrgResult result = (AuthorizedOrgResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getAuthorizedAdminOrgsF7", (Object[])new Object[]{RequestContext.get().getCurrUserId(), "hrpi", "hspm_empreport", "47150e89000000ac", "adminorg"});
        if (result == null) {
            return QFilter.isNull((String)"id");
        }
        if (!result.isHasAllOrgPerm()) {
            return new QFilter(fieldName, "in", (Object)result.getHasPermOrgs());
        }
        return QFilter.isNotNull((String)"id");
    }

    public static QFilter handleFilter(FilterInfo filterInfo, Map<String, Object> basedataIdMap) {
        QFilter filter = EmpReportRepository.initFilter(filterInfo);
        EmpReportRepository.andCommonFilter(filterInfo, filter, basedataIdMap);
        EmpReportRepository.andDataRuleFilter(filter);
        EmpReportRepository.andQueryFilter(filterInfo, filter);
        EmpReportExtCommon.addExtQueryFilter((FilterInfo)filterInfo, (QFilter)filter);
        return filter;
    }

    public static Map<String, List<QFilter>> reletionMapFilter(FilterInfo filterInfo) {
        Date queryDate = EmpReportRepository.getQueryDate(filterInfo);
        HashMap<String, List<QFilter>> reletionMap = new HashMap<String, List<QFilter>>(16);
        reletionMap.put("hrpi_empposorgrel", Lists.newArrayList((Object[])new QFilter[]{new QFilter("hrpi_empposorgrel.startdate", "<=", (Object)queryDate).and(new QFilter("hrpi_empposorgrel.enddate", ">=", (Object)queryDate))}));
        reletionMap.put("hrpi_contrworkloc", Lists.newArrayList((Object[])new QFilter[]{new QFilter("hrpi_contrworkloc.startdate", "<=", (Object)queryDate).and(new QFilter("hrpi_contrworkloc.enddate", ">=", (Object)queryDate))}));
        reletionMap.put("hrpi_empjobrel", Lists.newArrayList((Object[])new QFilter[]{new QFilter("hrpi_empjobrel.startdate", "<=", (Object)queryDate).and(new QFilter("hrpi_empjobrel.enddate", ">=", (Object)queryDate))}));
        reletionMap.put("hrpi_employee", Lists.newArrayList((Object[])new QFilter[]{new QFilter("hrpi_employee.bsed", "<=", (Object)queryDate).and(new QFilter("hrpi_employee.bsled", ">=", (Object)queryDate))}));
        reletionMap.put("hrpi_pertsprop", Lists.newArrayList((Object[])new QFilter[]{new QFilter("hrpi_pertsprop.bsed", "<=", (Object)queryDate).and(new QFilter("hrpi_pertsprop.bsled", ">=", (Object)queryDate))}));
        EmpReportExtCommon.addExtReletionFilter((FilterInfo)filterInfo, reletionMap);
        return reletionMap;
    }

    private static QFilter initFilter(FilterInfo filterInfo) {
        QFilter filter = new QFilter("iscurrentversion", "=", (Object)"1").and(new QFilter("datastatus", "=", (Object)"1")).and(new QFilter("person", "!=", (Object)0L)).and(new QFilter("employee", "!=", (Object)0L)).and(new QFilter("depemp", "!=", (Object)0L)).and(new QFilter("initstatus", "=", (Object)"2")).and(new QFilter("hrpi_employee.laborrelstatus.labrelstatusprd", "=", (Object)WORKING_STATE_ID));
        Date queryDate = EmpReportRepository.getQueryDate(filterInfo);
        filter.and(new QFilter("startdate", "<=", (Object)queryDate).and(new QFilter("enddate", ">=", (Object)queryDate)));
        return filter;
    }

    private static void andCommonFilter(FilterInfo filterInfo, QFilter filter, Map<String, Object> basedataIdMap) {
        QFilter commonFilter = (QFilter)filterInfo.getCommFilter().get("hspm_reportquery");
        if (commonFilter != null) {
            filter.and(commonFilter);
        }
        EmpReportRepository.andExtHisCommonFilter(filter, basedataIdMap);
    }

    private static void andExtHisCommonFilter(QFilter filter, Map<String, Object> basedataIdMap) {
        if (CollectionUtils.isEmpty(basedataIdMap)) {
            return;
        }
        for (Map.Entry<String, Object> basedataIdEntry : basedataIdMap.entrySet()) {
            String field = basedataIdEntry.getKey();
            List hisIdList = (List)basedataIdEntry.getValue();
            if (CollectionUtils.isEmpty((Collection)hisIdList) || !field.contains(FIELD_ADMINIORG)) continue;
            DynamicObject[] boidDys = HRBaseDaoFactory.getInstance((String)"haos_adminorghr").query("boid", new QFilter[]{new QFilter("id", "in", (Object)hisIdList)});
            List boidList = Arrays.stream(boidDys).map(boidDy -> boidDy.getLong("boid")).collect(Collectors.toList());
            filter.and(new QFilter("hrpi_empposorgrel.adminorg.boid", "in", boidList));
        }
    }

    private static void andDataRuleFilter(QFilter filter) {
        QFilter dataRuleFilter = (QFilter)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSDataPermissionService", (String)"getDataRule", (Object[])new Object[]{RequestContext.get().getCurrUserId(), "1WXBPN7+OHJZ", "hspm_reportquery", "47150e89000000ac", Collections.emptyMap()});
        if (dataRuleFilter != null) {
            filter.and(dataRuleFilter);
        }
    }

    private static void andQueryFilter(FilterInfo filterInfo, QFilter filter) {
        EmpReportRepository.addOrgListFilter(filterInfo, filter);
        EmpReportRepository.addAdminOrgListFilter(filterInfo, filter);
        EmpReportRepository.addCommonListFilter(filterInfo, filter, "job", "hrpi_empjobrel.job");
        EmpReportRepository.addCommonListFilter(filterInfo, filter, "position", "hrpi_empposorgrel.position");
        EmpReportRepository.addCommonListFilter(filterInfo, filter, "postype", "hrpi_empposorgrel.postype");
        EmpReportRepository.addCommonListFilter(filterInfo, filter, "laborreltypecls", "hrpi_employee.laborreltype.laborreltypecls");
        EmpReportRepository.setPersonFilter(filter, filterInfo, "person");
    }

    private static void addAdminOrgListFilter(FilterInfo filterInfo, QFilter filter) {
        ArrayList<Long> adminOrgFilter = new ArrayList<Long>(16);
        EmpReportRepository.setListFilter(filterInfo, adminOrgFilter, "adminorg", "boid");
        if (!adminOrgFilter.isEmpty()) {
            filter.and(new QFilter(FIELD_ADMINIORG, "in", adminOrgFilter));
        } else {
            filter.and(EmpReportRepository.getAdminOrgFilter(FIELD_ADMINIORG));
        }
    }

    private static void addOrgListFilter(FilterInfo filterInfo, QFilter filter) {
        ArrayList<Long> orgFilter = new ArrayList<Long>(16);
        EmpReportRepository.setListFilter(filterInfo, orgFilter, "org");
        if (!orgFilter.isEmpty()) {
            filter.and(new QFilter("org", "in", orgFilter));
        } else {
            filter.and(EmpReportRepository.getOrgFilter("org"));
        }
    }

    public static Date getQueryDate(FilterInfo filterInfo) {
        FilterItemInfo itemInfo = filterInfo.getFilterItem("date");
        Date queryDate = (Date)itemInfo.getValue();
        if (queryDate == null) {
            queryDate = new Date();
        }
        try {
            queryDate = HRDateTimeUtils.parseDate((String)HRDateTimeUtils.format((Date)queryDate), (String)"yyyy-MM-dd");
        }
        catch (ParseException e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", "EmpReportRepository queryDate format error."), new Object[0]);
        }
        return queryDate;
    }

    private static void addCommonListFilter(FilterInfo filterInfo, QFilter filter, String fieldKey, String showNodeId) {
        ArrayList<Long> list = new ArrayList<Long>(16);
        EmpReportRepository.setListFilter(filterInfo, list, fieldKey);
        if (!list.isEmpty()) {
            filter.and(new QFilter(showNodeId, "in", list));
        }
    }

    public static void setListFilter(FilterInfo filterInfo, List<Long> list, String key) {
        EmpReportRepository.setListFilter(filterInfo, list, key, "id");
    }

    public static void setListFilter(FilterInfo filterInfo, List<Long> list, String key, String field) {
        DynamicObjectCollection curStr;
        FilterItemInfo itemInfo = filterInfo.getFilterItem(key);
        DynamicObjectCollection dynamicObjectCollection = curStr = itemInfo == null ? null : (DynamicObjectCollection)itemInfo.getValue();
        if (curStr != null) {
            list.addAll(curStr.stream().map(item -> item.getLong(field)).collect(Collectors.toList()));
        }
    }

    public static void setPersonFilter(QFilter filter, FilterInfo filterInfo, String key) {
        String curStr;
        FilterItemInfo itemInfo = filterInfo.getFilterItem(key);
        String string = curStr = itemInfo == null ? " " : itemInfo.getString();
        if (HRStringUtils.isNotEmpty((String)curStr)) {
            String[] personFilters = curStr.split(";");
            QFilter personFilter = null;
            for (int index = 0; index < personFilters.length; ++index) {
                String filterStr = '%' + personFilters[index] + '%';
                if (personFilter == null) {
                    personFilter = new QFilter("person.number", "like", (Object)filterStr);
                } else {
                    personFilter.or("person.number", "like", (Object)filterStr);
                }
                personFilter.or("person.name", "like", (Object)filterStr);
            }
            filter.and(personFilter);
        }
    }
}

