/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.domian.repository.infoclassify;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.hr.hspm.business.helper.BasedataHelper;
import kd.sdk.hr.hspm.common.enums.PereduexpcerttypeFieldEnum;
import kd.sdk.hr.hspm.common.enums.PereduexpinfoFieldEnum;
import kd.sdk.hr.hspm.common.utils.HrpiServiceOperateParam;

public class PereduexpinfoRepository {
    private static final Log LOGGER = LogFactory.getLog(PereduexpinfoRepository.class);
    private final PereduexpinfoFieldEnum hrpiPereduexpEnum = PereduexpinfoFieldEnum.HRPI_PEREDUEXP;
    private final PereduexpinfoFieldEnum hrpiPereduexpcertEnum = PereduexpinfoFieldEnum.HRPI_PEREDUEXPCERT;
    private final HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("hspm_pereduexpinfo");
    private final HRBaseServiceHelper HRPI_PEREDUEXP_SERVICE_HELPER = new HRBaseServiceHelper(this.hrpiPereduexpEnum.getFormKey());
    private final HRBaseServiceHelper HRPI_PEREDUEXPCERT_SERVICE_HELPER = new HRBaseServiceHelper(this.hrpiPereduexpcertEnum.getFormKey());

    private PereduexpinfoRepository() {
    }

    public static PereduexpinfoRepository getInstance() {
        return Holder.INSTANCE;
    }

    public DynamicObject createPereduexpinfo() {
        return this.SERVICE_HELPER.generateEmptyDynamicObject();
    }

    public DynamicObject[] queryByPkIdList(List<Long> pkIdList) {
        return this.SERVICE_HELPER.query(new QFilter[]{new QFilter("id", "in", pkIdList)});
    }

    public int queryOtherExistsByPersonIdAndPkId(long personId, Long pkId) {
        QFilter qFilter = new QFilter("person", "=", (Object)personId);
        qFilter.and(new QFilter("id", "!=", (Object)pkId));
        qFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        qFilter.and(new QFilter("datastatus", "=", (Object)"1"));
        return this.SERVICE_HELPER.count(this.SERVICE_HELPER.getEntityName(), qFilter.toArray());
    }

    public int queryExistsByPersonId(long personId) {
        QFilter qFilter = new QFilter("person", "=", (Object)personId);
        qFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        qFilter.and(new QFilter("datastatus", "=", (Object)"1"));
        return this.SERVICE_HELPER.count(this.SERVICE_HELPER.getEntityName(), qFilter.toArray());
    }

    public DynamicObject getPereduexp(Long perhobbyId, String selectProperties) {
        DynamicObject dbDy;
        DynamicObject dynamicObject = dbDy = HRStringUtils.isEmpty((String)selectProperties) ? this.SERVICE_HELPER.loadSingle((Object)perhobbyId) : this.SERVICE_HELPER.queryOne(selectProperties, (Object)perhobbyId);
        if (HRObjectUtils.isEmpty((Object)dbDy)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002", (String)"EmpproexpRepository_0", (String)"hr-hspm-business", (Object[])new Object[0]));
        }
        return dbDy;
    }

    public DynamicObject getHrpiPereduexp(Long pereduexpId) {
        return this.getHrpiPereduexp(pereduexpId, "");
    }

    public DynamicObject getHrpiPereduexp(Long pereduexpId, String selectProperties) {
        if (HRStringUtils.isEmpty((String)selectProperties)) {
            return this.HRPI_PEREDUEXP_SERVICE_HELPER.loadSingle((Object)pereduexpId);
        }
        return this.HRPI_PEREDUEXP_SERVICE_HELPER.queryOne(selectProperties, (Object)pereduexpId);
    }

    public DynamicObject[] queryHrpiPereduexpByPersonId(long personId) {
        QFilter qFilter = new QFilter("person", "=", (Object)personId);
        qFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        qFilter.and(new QFilter("datastatus", "=", (Object)"1"));
        return this.HRPI_PEREDUEXP_SERVICE_HELPER.loadDynamicObjectArray(qFilter.toArray());
    }

    public DynamicObject[] queryMainPereduexpByPersonId(long personId) {
        QFilter qFilter = new QFilter("person", "=", (Object)personId);
        qFilter.and(new QFilter("ishighestdegree", "=", (Object)"1"));
        qFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        qFilter.and(new QFilter("datastatus", "=", (Object)"1"));
        return this.HRPI_PEREDUEXP_SERVICE_HELPER.loadDynamicObjectArray(qFilter.toArray());
    }

    public DynamicObject[] queryIshighestdegreeByPkIdList(List<Long> pkIdList) {
        QFilter qFilter = new QFilter("id", "in", pkIdList);
        return this.HRPI_PEREDUEXP_SERVICE_HELPER.query("person.id,id,education,ishighestdegree", qFilter.toArray());
    }

    public DynamicObject[] queryHrpiPereduexpForPerChg(List<Long> pkIdList) {
        QFilter idFilter = new QFilter("id", "in", pkIdList);
        DynamicObject[] dynamicObjects = this.HRPI_PEREDUEXP_SERVICE_HELPER.query("id,person,boid,sourcevid", idFilter.toArray());
        if (HRObjectUtils.isEmpty((Object)dynamicObjects) || dynamicObjects.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002", (String)"EmpproexpRepository_0", (String)"hr-hspm-business", (Object[])new Object[0]));
        }
        return dynamicObjects;
    }

    public DynamicObject[] queryHrpiPereduexpcertForPerChg(List<Long> pkIdList) {
        QFilter idFilter = new QFilter("id", "in", pkIdList);
        DynamicObject[] dynamicObjects = this.HRPI_PEREDUEXPCERT_SERVICE_HELPER.query("id,person,boid,sourcevid", idFilter.toArray());
        if (HRObjectUtils.isEmpty((Object)dynamicObjects) || dynamicObjects.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002", (String)"EmpproexpRepository_0", (String)"hr-hspm-business", (Object[])new Object[0]));
        }
        return dynamicObjects;
    }

    public DynamicObject[] queryPereduexpcertByPereduexpId(Long pereduexpId) {
        return this.queryPereduexpcertByPereduexpId(pereduexpId, "");
    }

    public DynamicObject[] queryPereduexpcertByPereduexpId(Long pereduexpId, String selectProperties) {
        QFilter pereduexpcertFilter = new QFilter("pereduexp", "=", (Object)pereduexpId);
        pereduexpcertFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        pereduexpcertFilter.and(new QFilter("datastatus", "=", (Object)"1"));
        pereduexpcertFilter.and(new QFilter("certtype", "in", this.queryCerttype()));
        if (HRStringUtils.isEmpty((String)selectProperties)) {
            return this.HRPI_PEREDUEXPCERT_SERVICE_HELPER.loadDynamicObjectArray(pereduexpcertFilter.toArray());
        }
        return this.HRPI_PEREDUEXPCERT_SERVICE_HELPER.query(selectProperties, pereduexpcertFilter.toArray());
    }

    public DynamicObject[] queryPereduexpcertByPereduexpIdList(List<Long> pereduexpIdList, String selectProperties) {
        QFilter pereduexpcertFilter = new QFilter("pereduexp", "in", pereduexpIdList);
        pereduexpcertFilter.and(new QFilter("certtype", "in", this.queryCerttype()));
        pereduexpcertFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        if (HRStringUtils.isEmpty((String)selectProperties)) {
            return this.HRPI_PEREDUEXPCERT_SERVICE_HELPER.loadDynamicObjectArray(pereduexpcertFilter.toArray());
        }
        return this.HRPI_PEREDUEXPCERT_SERVICE_HELPER.query(selectProperties, pereduexpcertFilter.toArray());
    }

    public DynamicObject getPereduexpcertByPereduexpIdAndCerttypeId(Long pereduexpId, Long certtypeId, String selectProperties) {
        QFilter pereduexpcertFilter = new QFilter("pereduexp", "=", (Object)pereduexpId);
        pereduexpcertFilter.and(new QFilter("certtype", "=", (Object)certtypeId));
        pereduexpcertFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        pereduexpcertFilter.and(new QFilter("datastatus", "=", (Object)"1"));
        if (HRStringUtils.isEmpty((String)selectProperties)) {
            return this.HRPI_PEREDUEXPCERT_SERVICE_HELPER.loadDynamicObject(pereduexpcertFilter);
        }
        return this.HRPI_PEREDUEXPCERT_SERVICE_HELPER.queryOne(selectProperties, pereduexpcertFilter.toArray());
    }

    public List<Long> queryCerttype() {
        DynamicObject[] allCerttype = this.queryAllCerttypeNoFilter();
        if (allCerttype == null || allCerttype.length == 0) {
            return new ArrayList<Long>();
        }
        return Arrays.stream(allCerttype).map(dy -> dy.getLong("id")).collect(Collectors.toList());
    }

    public DynamicObject[] queryAllCerttype() {
        QFilter qFilter = new QFilter("enable", "=", (Object)"1").and("status", "=", (Object)"C");
        return BusinessDataServiceHelper.load((String)"hbss_educerttype", (String)"id,number,name", (QFilter[])qFilter.toArray(), (String)"id");
    }

    public DynamicObject[] queryAllCerttypeNoFilter() {
        return (DynamicObject[])QueryServiceHelper.query((String)"hbss_educerttype", (String)"id,number,name", null, (String)"id").toArray((Object[])new DynamicObject[0]);
    }

    public DynamicObject[] queryAllCertTypeByKeys(List<Long> idList) {
        return (DynamicObject[])QueryServiceHelper.query((String)"hbss_educerttype", (String)"id,number,name", (QFilter[])new QFilter("id", "in", idList).toArray(), (String)"id").toArray((Object[])new DynamicObject[0]);
    }

    public DynamicObjectCollection getInvokeSaveByPereduexp(DynamicObject dataEntity) {
        return this.getInvokeSaveByPereduexp(new DynamicObject[]{dataEntity});
    }

    public DynamicObjectCollection getInvokeSaveByPereduexp(DynamicObject[] dataEntities) {
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObject saveDy = HrpiServiceOperateParam.getSaveDy((HRBaseServiceHelper)this.HRPI_PEREDUEXP_SERVICE_HELPER, (DynamicObject)dataEntity);
            saveDy.set("id", dataEntity.get("id"));
            dynamicObjectCollection.add((Object)saveDy);
        }
        return dynamicObjectCollection;
    }

    public DynamicObjectCollection getInvokeUpdateByPereduexp(Long pkId, DynamicObject dataEntity) {
        DynamicObject updateDy = this.getUpdatePereduexpDy(pkId, dataEntity);
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        dynamicObjectCollection.add((Object)updateDy);
        return dynamicObjectCollection;
    }

    private DynamicObject getUpdatePereduexpDy(Long pkId, DynamicObject dataEntity) {
        DynamicObject updateDy = this.HRPI_PEREDUEXP_SERVICE_HELPER.generateEmptyDynamicObject();
        DynamicObject dbDy = this.getHrpiPereduexp(pkId, "");
        HRDynamicObjectUtils.copy((DynamicObject)dataEntity, (DynamicObject)dbDy);
        HRDynamicObjectUtils.copy((DynamicObject)dbDy, (DynamicObject)updateDy);
        updateDy.set("id", (Object)pkId);
        BasedataHelper.setInitData((DynamicObject)updateDy);
        return updateDy;
    }

    public DynamicObjectCollection getBatchInvokeUpdateByPereduexp(List<DynamicObject> updateDyList, DynamicObjectCollection dynamicObjectCollection) {
        Set collect = dynamicObjectCollection.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        for (DynamicObject dataEntity : updateDyList) {
            Long pkId = (Long)dataEntity.getPkValue();
            if (pkId == null || pkId <= 0L || collect.contains(pkId)) continue;
            DynamicObject updateDy = this.getUpdatePereduexpDy(pkId, dataEntity);
            BasedataHelper.setInitData((DynamicObject)updateDy);
            dynamicObjectCollection.add((Object)updateDy);
        }
        return dynamicObjectCollection;
    }

    public DynamicObjectCollection getInvokeSaveByPereduexpcert(DynamicObject dataEntity) {
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        List<Long> certtypeIdList = this.queryCerttype();
        for (Long certtypeId : certtypeIdList) {
            String operateType;
            if (!dataEntity.getDataEntityType().getProperties().containsKey((Object)("operatetype_" + certtypeId)) || HRStringUtils.isEmpty((String)(operateType = dataEntity.getString("operatetype_" + certtypeId))) || !HRStringUtils.equals((String)operateType, (String)"1")) continue;
            this.getInvokeSaveByPereduexpCert(dataEntity, certtypeId, dynamicObjectCollection);
        }
        return dynamicObjectCollection;
    }

    public DynamicObject coverPereduexpinfoToPereduexpcert(DynamicObject dataEntity, Long certtypeId) {
        DynamicObject saveDy = this.HRPI_PEREDUEXPCERT_SERVICE_HELPER.generateEmptyDynamicObject();
        String extendName = dataEntity.getDataEntityType().getExtendName();
        if (HRStringUtils.equals((String)extendName, (String)"hspm_pereduexp_dg")) {
            List viewFields = dataEntity.getDataEntityType().getProperties().stream().map(prop -> prop.getName()).collect(Collectors.toList());
            String[] split = PereduexpcerttypeFieldEnum.getSelectProperties((long)certtypeId).split(",");
            List collect = Arrays.asList(split).stream().filter(field -> {
                for (String prop : viewFields) {
                    if (!prop.contains((CharSequence)field)) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }).collect(Collectors.toList());
            for (String prop2 : collect) {
                if (!dataEntity.getDataEntityType().getProperties().containsKey((Object)String.join((CharSequence)"_", prop2, String.valueOf(certtypeId)))) continue;
                saveDy.set(prop2, dataEntity.get(String.join((CharSequence)"_", prop2, String.valueOf(certtypeId))));
            }
        } else {
            for (String prop3 : PereduexpcerttypeFieldEnum.getSelectProperties((long)certtypeId).split(",")) {
                saveDy.set(prop3, dataEntity.get(String.join((CharSequence)"_", prop3, String.valueOf(certtypeId))));
            }
        }
        return saveDy;
    }

    public void getInvokeSaveByPereduexpCert(DynamicObject dataEntity, Long certtypeId, DynamicObjectCollection dynamicObjectCollection) {
        DynamicObject saveDy = this.coverPereduexpinfoToPereduexpcert(dataEntity, certtypeId);
        long pkId = ORM.create().genLongId(this.hrpiPereduexpcertEnum.getFormKey());
        saveDy.set("id", (Object)pkId);
        saveDy.set("person", dataEntity.get("person"));
        saveDy.set("pereduexp", (Object)dataEntity.getLong("id"));
        saveDy.set("businessstatus", (Object)"1");
        saveDy.set("certtype", (Object)certtypeId);
        BasedataHelper.setInitData((DynamicObject)saveDy);
        dynamicObjectCollection.add((Object)saveDy);
    }

    public void getInvokeUpdateByPereduexpCert(DynamicObject dbDy, DynamicObject dataEntity, Long certtypeId, DynamicObjectCollection dynamicObjectCollection) {
        DynamicObject updateDy = this.HRPI_PEREDUEXPCERT_SERVICE_HELPER.generateEmptyDynamicObject();
        DynamicObject pereduexpcertDy = this.coverPereduexpinfoToPereduexpcert(dataEntity, certtypeId);
        String properties = PereduexpcerttypeFieldEnum.getSelectProperties((long)certtypeId);
        String[] props = properties.split(",");
        Set<Object> collect = new HashSet();
        boolean isFromErmanFile = HRStringUtils.equals((String)dataEntity.getDataEntityType().getExtendName(), (String)"hspm_pereduexp_dg");
        if (isFromErmanFile) {
            List viewFields = dataEntity.getDataEntityType().getProperties().stream().map(prop -> prop.getName()).filter(prop -> prop.contains("_")).collect(Collectors.toList());
            collect = viewFields.stream().map(field -> field.substring(0, field.indexOf("_"))).collect(Collectors.toSet());
        }
        for (String prop2 : props) {
            if (isFromErmanFile && !collect.contains(prop2)) continue;
            dbDy.set(prop2, pereduexpcertDy.get(prop2));
        }
        HRDynamicObjectUtils.copy((DynamicObject)dbDy, (DynamicObject)updateDy);
        BasedataHelper.setInitData((DynamicObject)updateDy);
        dynamicObjectCollection.add((Object)updateDy);
    }

    public DynamicObject[] getImportSaveByPereduexpinfo(DynamicObject[] dataEntities) {
        DynamicObject[] importSaveDys = new DynamicObject[dataEntities.length];
        for (int i = 0; i < dataEntities.length; ++i) {
            DynamicObject importSaveDy;
            importSaveDys[i] = importSaveDy = HrpiServiceOperateParam.getSaveDy((HRBaseServiceHelper)this.HRPI_PEREDUEXP_SERVICE_HELPER, (DynamicObject)dataEntities[i]);
        }
        return importSaveDys;
    }

    public void getImportSaveByPereduexpinfo(List<DynamicObject> dataEntities, DynamicObjectCollection dynamicObjectCollection) {
        for (int i = 0; i < dataEntities.size(); ++i) {
            DynamicObject importSaveDy = HrpiServiceOperateParam.getSaveDy((HRBaseServiceHelper)this.HRPI_PEREDUEXP_SERVICE_HELPER, (DynamicObject)dataEntities.get(i));
            dynamicObjectCollection.add((Object)importSaveDy);
        }
    }

    public DynamicObject[] queryEduByPersonIds(Set<Long> personIdSet) {
        QFilter qFilter = new QFilter("person", "in", personIdSet);
        qFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        qFilter.and(new QFilter("datastatus", "=", (Object)"1"));
        qFilter.and(new QFilter("initstatus", "=", (Object)"2"));
        return this.SERVICE_HELPER.query("person.id,id,education,ishighestdegree", qFilter.toArray());
    }

    private static class Holder {
        static final PereduexpinfoRepository INSTANCE = new PereduexpinfoRepository();

        private Holder() {
        }
    }
}

