/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.domian.repository.inforevise;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;

public class EmpentrelRepository {
    private static final HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("hrpi_empentrel");

    private EmpentrelRepository() {
    }

    public static EmpentrelRepository getInstance() {
        return Holder.INSTANCE;
    }

    public DynamicObject[] queryByPkIdList(List<Long> pkIdList) {
        return SERVICE_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", pkIdList)});
    }

    public DynamicObject[] queryEffectiveHisDataByBoIds(Long boId, Long fid) {
        QFilter boidFilter = new QFilter("boid", "=", (Object)boId);
        QFilter fidFilter = new QFilter("id", "!=", (Object)fid);
        QFilter hisFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter dataStatusFilter = new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()));
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        return SERVICE_HELPER.loadDynamicObjectArray(new QFilter[]{boidFilter, fidFilter, hisFilter, dataStatusFilter, initStatusFilter});
    }

    public DynamicObject[] queryByEmployeeId(Long employeeId) {
        QFilter idFilter = new QFilter("employee", "=", (Object)employeeId);
        QFilter hisFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)EnumHisDataVersionStatus.EFFECTING.getStatus());
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        return SERVICE_HELPER.loadDynamicObjectArray(new QFilter[]{idFilter, hisFilter, dataStatusFilter, initStatusFilter});
    }

    public DynamicObject[] queryhisByEmployeeId(List<Long> employeeId) {
        QFilter idFilter = new QFilter("employee", "in", employeeId);
        QFilter hisFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter dataStatusFilter = new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()));
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        return SERVICE_HELPER.loadDynamicObjectArray(new QFilter[]{idFilter, hisFilter, dataStatusFilter, initStatusFilter});
    }

    private static class Holder {
        static final EmpentrelRepository INSTANCE = new EmpentrelRepository();

        private Holder() {
        }
    }
}

