/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.domian.repository.inforevise;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;

public class ErmanfileRepository {
    private static final HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("hspm_ermanfile");

    private ErmanfileRepository() {
    }

    public static ErmanfileRepository getInstance() {
        return Holder.INSTANCE;
    }

    public DynamicObject[] queryCurrentVersionDataByDepempIds(List<Long> depempIds) {
        QFilter depempFilter = new QFilter("depemp", "in", depempIds);
        QFilter hisFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)EnumHisDataVersionStatus.EFFECTING.getStatus());
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        return SERVICE_HELPER.loadDynamicObjectArray(new QFilter[]{depempFilter, hisFilter, dataStatusFilter, initStatusFilter});
    }

    public DynamicObject queryCurrentVersionDataByDepempId(Long depEmpId) {
        QFilter depEmpFilter = new QFilter("depemp", "=", (Object)depEmpId);
        QFilter hisFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)EnumHisDataVersionStatus.EFFECTING.getStatus());
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        return SERVICE_HELPER.queryOne("id, filetype", new QFilter[]{depEmpFilter, hisFilter, dataStatusFilter, initStatusFilter});
    }

    public DynamicObject[] queryEffectiveHisDataByDepempId(Long depempId) {
        QFilter depempFilter = new QFilter("depemp", "=", (Object)depempId);
        QFilter hisFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter dataStatusFilter = new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()));
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        return SERVICE_HELPER.loadDynamicObjectArray(new QFilter[]{depempFilter, hisFilter, dataStatusFilter, initStatusFilter});
    }

    public DynamicObject[] queryHisDataByBoIdAndBsed(Long depempId, Date bsed, Date bsled) {
        QFilter depempFilter = new QFilter("depemp", "=", (Object)depempId);
        QFilter bsedFilter = new QFilter("bsed", "=", (Object)bsed).and(new QFilter("bsled", "=", (Object)bsled));
        QFilter hisFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter dataStatusFilter = new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()));
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        return SERVICE_HELPER.loadDynamicObjectArray(new QFilter[]{depempFilter, hisFilter, dataStatusFilter, initStatusFilter, bsedFilter});
    }

    public Map<String, Long> getErmanFileByEmployeeId(Long employeeId) {
        QFilter depempFilter = new QFilter("employee", "=", (Object)employeeId);
        QFilter hisFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter dataStatusFilter = new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()));
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        return new HashMap<String, Long>();
    }

    private static class Holder {
        static final ErmanfileRepository INSTANCE = new ErmanfileRepository();

        private Holder() {
        }
    }
}

