/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.domian.repository.inforevise;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;

public class PersonRoleRelRepository {
    private static final HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("hrpi_personrolerel");

    private PersonRoleRelRepository() {
    }

    public static PersonRoleRelRepository getInstance() {
        return Holder.INSTANCE;
    }

    public Map<String, DynamicObject> getPersonRoleRelByDepEmpIdAndRoleId(List<Long> employeeIds, List<Long> roleIds) {
        QFilter employeeFilter = new QFilter("employee", "in", employeeIds);
        QFilter roleFilter = new QFilter("role", "in", roleIds);
        QFilter hisFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)EnumHisDataVersionStatus.EFFECTING.getStatus());
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        DynamicObject[] personRoleRels = SERVICE_HELPER.loadDynamicObjectArray(new QFilter[]{employeeFilter, roleFilter, hisFilter, dataStatusFilter, initStatusFilter});
        return Arrays.asList(personRoleRels).stream().collect(Collectors.toMap(dyn -> String.join((CharSequence)"_", dyn.getString("employee.id"), dyn.getString("role.id")), dyn -> dyn, (v1, v2) -> v2));
    }

    public DynamicObject[] queryEffectiveHisDataByDepEmpIdAndRoleId(Long employeeId, Long roleId) {
        QFilter employeeFilter = new QFilter("employee", "=", (Object)employeeId);
        QFilter roleFilter = new QFilter("role", "=", (Object)roleId);
        QFilter hisFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter dataStatusFilter = new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()));
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        return SERVICE_HELPER.loadDynamicObjectArray(new QFilter[]{employeeFilter, roleFilter, hisFilter, dataStatusFilter, initStatusFilter});
    }

    public DynamicObject[] queryHisDataByBoIdAndBsed(Long employeeId, Long roleId, Date bsed, Date bsled) {
        QFilter employeeFilter = new QFilter("employee", "=", (Object)employeeId);
        QFilter roleFilter = new QFilter("role", "=", (Object)roleId);
        QFilter bsedFilter = new QFilter("bsed", "=", (Object)bsed).and(new QFilter("bsled", "=", (Object)bsled));
        QFilter hisFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter dataStatusFilter = new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()));
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        return SERVICE_HELPER.loadDynamicObjectArray(new QFilter[]{employeeFilter, roleFilter, hisFilter, dataStatusFilter, initStatusFilter, bsedFilter});
    }

    private static class Holder {
        static final PersonRoleRelRepository INSTANCE = new PersonRoleRelRepository();

        private Holder() {
        }
    }
}

