/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.domian.service.impl.infoclassify;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hspm.business.domian.repository.infoclassify.PeraddressRepository;
import kd.hr.hspm.business.domian.service.infoclassify.IPeraddressService;
import kd.sdk.hr.hspm.business.helper.HpfsChgexternalrecordQueueHelper;
import kd.sdk.hr.hspm.business.service.AttacheHandlerService;
import kd.sdk.hr.hspm.common.dto.InfoClassifyEntityKeyDTO;
import kd.sdk.hr.hspm.common.result.HrpiServiceOperateResult;

public class PeraddressServiceImpl
implements IPeraddressService {
    private static final Log LOGGER = LogFactory.getLog(PeraddressServiceImpl.class);
    protected final AttacheHandlerService attacheHandlerService = AttacheHandlerService.getInstance();
    private final PeraddressRepository peraddressRepository = PeraddressRepository.getInstance();

    @Override
    public DynamicObject getPeraddressByPkId(Long pkId) {
        return this.peraddressRepository.getPeraddress(pkId, "");
    }

    @Override
    public HrpiServiceOperateResult insertPeraddress(DynamicObject dataEntity) {
        InfoClassifyEntityKeyDTO infoClassifyEntityKeyDTO = InfoClassifyEntityKeyDTO.getEntityKeyEnumByFormKey((String)"hspm_peraddress");
        HashMap<String, DynamicObjectCollection> paramMap = new HashMap<String, DynamicObjectCollection>(16);
        paramMap.put(infoClassifyEntityKeyDTO.getSourceKey(), this.peraddressRepository.getInvokeSaveByPeraddress(dataEntity));
        boolean syncFlag = this.attacheHandlerService.validateSyncFieldsUpdateChange(paramMap, dataEntity.getLong("person.id"), true);
        Map resultMap = this.attacheHandlerService.invokeSaveOrUpdate(paramMap);
        HrpiServiceOperateResult operateResult = HrpiServiceOperateResult.build((Map)resultMap);
        if (operateResult.isSuccess()) {
            Long pkId = (Long)operateResult.getDataMapForIds().get(0);
            dataEntity.set("id", (Object)pkId);
            LOGGER.info(String.format(Locale.ROOT, "insertPeraddress the id is %s.", pkId));
            HpfsChgexternalrecordQueueHelper.sendHisNonLineInsertMsg((DynamicObject)dataEntity, (String)infoClassifyEntityKeyDTO.getSourceKey(), (String)infoClassifyEntityKeyDTO.getFormKey());
            operateResult.setSyncFlag(syncFlag);
        }
        return operateResult;
    }

    @Override
    public HrpiServiceOperateResult updatePeraddress(Long pkId, DynamicObject dataEntity) {
        InfoClassifyEntityKeyDTO infoClassifyEntityKeyDTO = InfoClassifyEntityKeyDTO.getEntityKeyEnumByFormKey((String)"hspm_peraddress");
        HashMap<String, DynamicObjectCollection> paramMap = new HashMap<String, DynamicObjectCollection>(16);
        paramMap.put(infoClassifyEntityKeyDTO.getSourceKey(), this.peraddressRepository.getInvokeUpdateByPeraddress(pkId, dataEntity));
        boolean syncFlag = this.attacheHandlerService.validateSyncFieldsUpdateChange(paramMap, dataEntity.getLong("person.id"), true);
        Map resultMap = this.attacheHandlerService.invokeSaveOrUpdate(paramMap);
        HrpiServiceOperateResult operateResult = HrpiServiceOperateResult.build((Map)resultMap);
        if (operateResult.isSuccess()) {
            LOGGER.info(String.format(Locale.ROOT, "updatePeraddress the id is %s.", pkId));
            HpfsChgexternalrecordQueueHelper.sendHisNonLineUpdateMsg((DynamicObject)dataEntity, (String)infoClassifyEntityKeyDTO.getSourceKey(), (String)infoClassifyEntityKeyDTO.getFormKey());
            operateResult.setSyncFlag(syncFlag);
        }
        return operateResult;
    }

    @Override
    public HrpiServiceOperateResult deletePeraddress(List<Long> pkIdList) {
        InfoClassifyEntityKeyDTO infoClassifyEntityKeyDTO = InfoClassifyEntityKeyDTO.getEntityKeyEnumByFormKey((String)"hspm_peraddress");
        DynamicObject[] dbDyArr = this.peraddressRepository.queryHrpiPeraddressForPerChg(pkIdList);
        List personIdList = this.attacheHandlerService.validateSyncFieldsDelChange(infoClassifyEntityKeyDTO.getSourceKey(), dbDyArr);
        Map resultMap = this.attacheHandlerService.invokeDel(pkIdList, infoClassifyEntityKeyDTO.getSourceKey(), Boolean.TRUE);
        HrpiServiceOperateResult operateResult = HrpiServiceOperateResult.build((Map)resultMap);
        if (operateResult.isSuccess()) {
            LOGGER.info(String.format(Locale.ROOT, "deletePeraddress the id is %s.", pkIdList));
            HpfsChgexternalrecordQueueHelper.sendBatchHisNonLineDeleteMsg((DynamicObject[])dbDyArr, (String)infoClassifyEntityKeyDTO.getSourceKey(), (String)infoClassifyEntityKeyDTO.getFormKey());
            operateResult.setSyncPersonIdList(personIdList);
        }
        return operateResult;
    }

    @Override
    public HrpiServiceOperateResult saveImportPeraddress(String importtype, DynamicObject[] dataEntities) {
        InfoClassifyEntityKeyDTO infoClassifyEntityKeyDTO = InfoClassifyEntityKeyDTO.getEntityKeyEnumByFormKey((String)"hspm_peraddress");
        DynamicObject[] importSaveDys = this.peraddressRepository.getImportSaveByPeraddress(dataEntities);
        long personId = dataEntities[0].getLong("person.id");
        boolean syncFlag = this.attacheHandlerService.validateSyncFieldsUpdateChange(infoClassifyEntityKeyDTO.getSourceKey(), importSaveDys, personId);
        Map resultMap = this.attacheHandlerService.invokeHisNonLineImportData(importtype, importSaveDys);
        HrpiServiceOperateResult operateResult = HrpiServiceOperateResult.build((Map)resultMap);
        if (operateResult.isSuccess()) {
            LOGGER.info(String.format(Locale.ROOT, "saveImportPeraddress the id is %s.", operateResult.getDataMapForIds()));
            HpfsChgexternalrecordQueueHelper.sendBatchHisNonLineInsertMsg((DynamicObject[])dataEntities, (String)infoClassifyEntityKeyDTO.getSourceKey(), (String)infoClassifyEntityKeyDTO.getFormKey());
            operateResult.setSyncFlag(syncFlag);
        }
        return operateResult;
    }

    @Override
    public List<Long> queryExistsIdByPkIdList(List<Long> pkIdList) {
        DynamicObject[] existsPkIdArr = this.peraddressRepository.queryByPkIdList(pkIdList);
        if (existsPkIdArr.length > 0) {
            return Arrays.stream(existsPkIdArr).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        }
        return new ArrayList<Long>();
    }
}

