/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.domian.service.impl.infoclassify;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hspm.business.domian.repository.infoclassify.PercontactRepository;
import kd.hr.hspm.business.domian.service.infoclassify.IPercontactService;
import kd.sdk.hr.hspm.business.helper.HpfsChgexternalrecordQueueHelper;
import kd.sdk.hr.hspm.business.service.AttacheHandlerService;
import kd.sdk.hr.hspm.common.dto.InfoClassifyEntityKeyDTO;
import kd.sdk.hr.hspm.common.result.HrpiServiceOperateResult;

public class PercontactServiceImpl
implements IPercontactService {
    private static final Log LOGGER = LogFactory.getLog(PercontactServiceImpl.class);
    protected final AttacheHandlerService attacheHandlerService = AttacheHandlerService.getInstance();
    private final PercontactRepository percontactRepository = PercontactRepository.getInstance();

    @Override
    public DynamicObject getPercontactByPkId(Long pkId) {
        return this.percontactRepository.getPercontact(pkId, "");
    }

    @Override
    public HrpiServiceOperateResult updatePercontact(Long pkId, DynamicObject dataEntity) {
        InfoClassifyEntityKeyDTO infoClassifyEntityKeyDTO = InfoClassifyEntityKeyDTO.getEntityKeyEnumByFormKey((String)"hspm_percontact");
        HashMap<String, DynamicObjectCollection> paramMap = new HashMap<String, DynamicObjectCollection>(16);
        paramMap.put(infoClassifyEntityKeyDTO.getSourceKey(), this.percontactRepository.getInvokeUpdateByPercontact(pkId, dataEntity));
        long personId = dataEntity.getLong("person.id");
        boolean syncFlag = this.attacheHandlerService.validateSyncFieldsUpdateChange(paramMap, personId, true);
        Map resultMap = this.attacheHandlerService.invokeSaveOrUpdate(paramMap);
        HrpiServiceOperateResult operateResult = HrpiServiceOperateResult.build((Map)resultMap);
        if (operateResult.isSuccess()) {
            LOGGER.info(String.format(Locale.ROOT, "updatePercontact the id is %s.", pkId));
            HpfsChgexternalrecordQueueHelper.sendHisNonLineUpdateMsg((DynamicObject)dataEntity, (String)infoClassifyEntityKeyDTO.getSourceKey(), (String)infoClassifyEntityKeyDTO.getFormKey());
            operateResult.setSyncFlag(syncFlag);
        }
        return operateResult;
    }

    @Override
    public HrpiServiceOperateResult saveImportPercontact(String importtype, DynamicObject[] dataEntities) {
        InfoClassifyEntityKeyDTO infoClassifyEntityKeyDTO = InfoClassifyEntityKeyDTO.getEntityKeyEnumByFormKey((String)"hspm_percontact");
        DynamicObject[] importSaveDys = this.percontactRepository.getImportOverrideByPercontact(dataEntities);
        long personId = dataEntities[0].getLong("person.id");
        boolean syncFlag = this.attacheHandlerService.validateSyncFieldsUpdateChange(infoClassifyEntityKeyDTO.getSourceKey(), importSaveDys, personId);
        Map resultMap = this.attacheHandlerService.invokeHisNonLineImportData(importtype, importSaveDys);
        HrpiServiceOperateResult operateResult = HrpiServiceOperateResult.build((Map)resultMap);
        if (operateResult.isSuccess()) {
            LOGGER.info(String.format(Locale.ROOT, "saveImportPercontact the id is %s.", operateResult.getDataMapForIds()));
            HpfsChgexternalrecordQueueHelper.sendBatchHisNonLineUpdateMsg((DynamicObject[])dataEntities, (String)infoClassifyEntityKeyDTO.getSourceKey(), (String)infoClassifyEntityKeyDTO.getFormKey());
            operateResult.setSyncFlag(syncFlag);
        }
        return operateResult;
    }

    @Override
    public List<Long> queryExistsIdByPkIdList(List<Long> pkIdList) {
        DynamicObject[] existsPkIdArr = this.percontactRepository.queryByPkIdList(pkIdList);
        if (existsPkIdArr.length > 0) {
            return Arrays.stream(existsPkIdArr).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        }
        return new ArrayList<Long>();
    }
}

