/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.domian.service.impl.infoclassify;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hspm.business.domian.repository.infoclassify.PercreRepository;
import kd.hr.hspm.business.domian.repository.infoclassify.PersoninfoRepository;
import kd.hr.hspm.business.domian.service.infoclassify.IPercreService;
import kd.sdk.hr.hspm.business.helper.BasedataHelper;
import kd.sdk.hr.hspm.business.helper.HpfsChgexternalrecordQueueHelper;
import kd.sdk.hr.hspm.business.service.AttacheHandlerService;
import kd.sdk.hr.hspm.common.dto.InfoClassifyEntityKeyDTO;
import kd.sdk.hr.hspm.common.result.HrpiServiceOperateResult;
import kd.sdk.hr.hspm.common.utils.DynamicPropUtil;

public class PercreServiceImpl
implements IPercreService {
    private static final Log LOGGER = LogFactory.getLog(PercreServiceImpl.class);
    protected final AttacheHandlerService attacheHandlerService = AttacheHandlerService.getInstance();
    private final PercreRepository percreRepository = PercreRepository.getInstance();
    private final PersoninfoRepository personinfoRepository = PersoninfoRepository.getInstance();

    @Override
    public DynamicObject getPercreByPkId(Long pkId) {
        return this.percreRepository.getPercre(pkId, "");
    }

    @Override
    public HrpiServiceOperateResult insertPercre(DynamicObject dataEntity) {
        return this.insertPercre(dataEntity, arg_0 -> ((AttacheHandlerService)this.attacheHandlerService).invokeSaveOrUpdate(arg_0));
    }

    private HrpiServiceOperateResult insertPercre(DynamicObject dataEntity, Function<Map<String, DynamicObjectCollection>, Map<String, Object>> function) {
        InfoClassifyEntityKeyDTO infoClassifyEntityKeyDTO = InfoClassifyEntityKeyDTO.getEntityKeyEnumByFormKey((String)"hspm_percre");
        List<DynamicObject> saveDyList = this.insertPercreMajor(dataEntity);
        HashMap<String, DynamicObjectCollection> paramMap = new HashMap<String, DynamicObjectCollection>(16);
        paramMap.put(infoClassifyEntityKeyDTO.getSourceKey(), this.percreRepository.getInvokeSaveOrUpdateByPercre(saveDyList));
        long personId = dataEntity.getLong("person.id");
        boolean syncFlag = this.attacheHandlerService.validateSyncFieldsUpdateChange(paramMap, dataEntity.getLong("person.id"), true);
        Map<String, Object> resultMap = function.apply(paramMap);
        HrpiServiceOperateResult operateResult = HrpiServiceOperateResult.build(resultMap);
        if (operateResult.isSuccess()) {
            Long pkId = (Long)operateResult.getDataMapForIds().get(0);
            dataEntity.set("id", (Object)pkId);
            LOGGER.info(String.format(Locale.ROOT, "insertPercre the id is %s.", pkId));
            HpfsChgexternalrecordQueueHelper.sendBatchHisNonLineInsertOrUpdateMsg((long)personId, paramMap, (HrpiServiceOperateResult)operateResult, (String)infoClassifyEntityKeyDTO.getFormKey());
            operateResult.setSyncFlag(syncFlag);
        }
        return operateResult;
    }

    private List<DynamicObject> insertPercreMajor(DynamicObject dataEntity) {
        ArrayList<DynamicObject> saveDyList = new ArrayList<DynamicObject>();
        long personId = dataEntity.getLong("person.id");
        DynamicObject[] mainPercreDyArr = this.percreRepository.queryMainPercreByPersonId(personId);
        if (mainPercreDyArr.length == 0) {
            LOGGER.info("insertPercre. the mainPercreDy is null, set now dy ismajor = true");
            dataEntity.set("ismajor", (Object)"1");
        } else {
            boolean ismajor = dataEntity.getBoolean("ismajor");
            if (ismajor) {
                Arrays.stream(mainPercreDyArr).forEach(mainPercreDy -> mainPercreDy.set("ismajor", (Object)Boolean.FALSE));
                saveDyList.addAll(Arrays.asList(mainPercreDyArr));
            }
        }
        BasedataHelper.setInitData((DynamicObject)dataEntity);
        saveDyList.add(dataEntity);
        return saveDyList;
    }

    @Override
    public HrpiServiceOperateResult updatePercre(Long pkId, DynamicObject dataEntity) {
        return this.updatePercre(pkId, dataEntity, this::updatePercreMajor, arg_0 -> ((AttacheHandlerService)this.attacheHandlerService).invokeSaveOrUpdate(arg_0));
    }

    private HrpiServiceOperateResult updatePercre(Long pkId, DynamicObject dataEntity, BiFunction<Long, DynamicObject, List<DynamicObject>> updatePercreMajorFunction, Function<Map<String, DynamicObjectCollection>, Map<String, Object>> function) {
        InfoClassifyEntityKeyDTO infoClassifyEntityKeyDTO = InfoClassifyEntityKeyDTO.getEntityKeyEnumByFormKey((String)"hspm_percre");
        long personId = dataEntity.getLong("person.id");
        HashMap<String, DynamicObjectCollection> paramMap = new HashMap<String, DynamicObjectCollection>(16);
        List<DynamicObject> updateDyList = updatePercreMajorFunction.apply(pkId, dataEntity);
        paramMap.put(infoClassifyEntityKeyDTO.getSourceKey(), this.percreRepository.getInvokeSaveOrUpdateByPercre(updateDyList));
        boolean syncFlag = this.attacheHandlerService.validateSyncFieldsUpdateChange(paramMap, dataEntity.getLong("person.id"), true);
        Map<String, Object> resultMap = function.apply(paramMap);
        HrpiServiceOperateResult operateResult = HrpiServiceOperateResult.build(resultMap);
        if (operateResult.isSuccess()) {
            LOGGER.info(String.format(Locale.ROOT, "updatePercre the id is %s.", pkId));
            HpfsChgexternalrecordQueueHelper.sendBatchHisNonLineInsertOrUpdateMsg((long)personId, paramMap, (HrpiServiceOperateResult)operateResult, (String)infoClassifyEntityKeyDTO.getFormKey());
            operateResult.setSyncFlag(syncFlag);
        }
        return operateResult;
    }

    private List<DynamicObject> updatePercreMajorToExcel(Long pkId, DynamicObject dataEntity) {
        ArrayList<DynamicObject> updateDyList = new ArrayList<DynamicObject>();
        long personId = dataEntity.getLong("person.id");
        DynamicObject[] percreDyArr = this.percreRepository.queryByPersonId(personId);
        Map<Boolean, List<DynamicObject>> percreDyListMap = Arrays.stream(percreDyArr).collect(Collectors.partitioningBy(dy -> pkId.longValue() == dy.getLong("id")));
        List<DynamicObject> percreDyList = percreDyListMap.get(Boolean.FALSE);
        boolean ismajor = dataEntity.getBoolean("ismajor");
        if (ismajor) {
            List<DynamicObject> mainPercreDyList = percreDyList.stream().filter(mainPercreDy -> mainPercreDy.getBoolean("ismajor")).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(mainPercreDyList)) {
                mainPercreDyList.forEach(mainPercreDy -> mainPercreDy.set("ismajor", (Object)Boolean.FALSE));
                updateDyList.addAll(mainPercreDyList);
            }
        } else if (percreDyList.isEmpty()) {
            LOGGER.info("updatePercre. the mainPercreDy equals now dy and the percre is only one, reset now dy ismajor = true");
            dataEntity.set("ismajor", (Object)Boolean.TRUE);
        } else {
            List mainPercreDyList = percreDyList.stream().filter(mainPercreDy -> mainPercreDy.getBoolean("ismajor")).collect(Collectors.toList());
            if (mainPercreDyList.isEmpty()) {
                LOGGER.info("updatePercre. the mainPercreDy equals now dy and the percre is only ismajor one, reset now dy ismajor = true");
                dataEntity.set("ismajor", (Object)Boolean.TRUE);
            }
        }
        BasedataHelper.setInitData((DynamicObject)dataEntity);
        updateDyList.add(dataEntity);
        return updateDyList;
    }

    private List<DynamicObject> updatePercreMajor(Long pkId, DynamicObject dataEntity) {
        ArrayList<DynamicObject> updateDyList = new ArrayList<DynamicObject>();
        long personId = dataEntity.getLong("person.id");
        DynamicObject[] percreDyArr = this.percreRepository.queryByPersonId(personId);
        Map<Boolean, List<DynamicObject>> percreDyListMap = Arrays.stream(percreDyArr).collect(Collectors.partitioningBy(dy -> pkId.longValue() == dy.getLong("id")));
        List<DynamicObject> percreDyList = percreDyListMap.get(Boolean.FALSE);
        boolean ismajor = dataEntity.getBoolean("ismajor");
        if (ismajor) {
            List<DynamicObject> mainPercreDyList = percreDyList.stream().filter(mainPercreDy -> mainPercreDy.getBoolean("ismajor")).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(mainPercreDyList)) {
                mainPercreDyList.forEach(mainPercreDy -> {
                    mainPercreDy.set("ismajor", (Object)Boolean.FALSE);
                    BasedataHelper.setInitData((DynamicObject)mainPercreDy);
                });
                updateDyList.addAll(mainPercreDyList);
            }
        } else if (percreDyList.isEmpty()) {
            LOGGER.info("updatePercre. the mainPercreDy equals now dy and the percre is only one, reset now dy ismajor = true");
            dataEntity.set("ismajor", (Object)Boolean.TRUE);
        } else {
            List mainPercreDyList = percreDyList.stream().filter(mainPercreDy -> mainPercreDy.getBoolean("ismajor")).collect(Collectors.toList());
            if (mainPercreDyList.isEmpty()) {
                DynamicObject lastPercreDy = DynamicPropUtil.getByMaxModifytime(percreDyList);
                LOGGER.info("updatePercre. the mainPercreDy equals now dy, set last createtime dy ismajor = true");
                lastPercreDy.set("ismajor", (Object)Boolean.TRUE);
                BasedataHelper.setInitData((DynamicObject)lastPercreDy);
                updateDyList.add(lastPercreDy);
            }
        }
        BasedataHelper.setInitData((DynamicObject)dataEntity);
        updateDyList.add(dataEntity);
        return updateDyList;
    }

    @Override
    public HrpiServiceOperateResult deletePercre(List<Long> pkIdList) {
        InfoClassifyEntityKeyDTO infoClassifyEntityKeyDTO = InfoClassifyEntityKeyDTO.getEntityKeyEnumByFormKey((String)"hspm_percre");
        DynamicObject[] dbDyArr = this.percreRepository.queryHrpiPercreForPerChg(pkIdList);
        List personIdList = this.attacheHandlerService.validateSyncFieldsDelChange(infoClassifyEntityKeyDTO.getSourceKey(), dbDyArr);
        Map resultMap = this.attacheHandlerService.invokeDel(pkIdList, infoClassifyEntityKeyDTO.getSourceKey(), Boolean.TRUE);
        HrpiServiceOperateResult operateResult = HrpiServiceOperateResult.build((Map)resultMap);
        if (operateResult.isSuccess()) {
            LOGGER.info(String.format(Locale.ROOT, "deletePercre the id is %s.", pkIdList));
            HpfsChgexternalrecordQueueHelper.sendBatchHisNonLineDeleteMsg((DynamicObject[])dbDyArr, (String)infoClassifyEntityKeyDTO.getSourceKey(), (String)infoClassifyEntityKeyDTO.getFormKey());
            operateResult.setSyncPersonIdList(personIdList);
        }
        return operateResult;
    }

    @Override
    public boolean isExistsByCredentialstypeAndNumber(long pkId, long personId, long credentialstypeId, String number) {
        boolean result = false;
        DynamicObject[] pkIdDys = this.percreRepository.queryByCredentialstypeAndNumber(personId, credentialstypeId, number);
        if (pkIdDys.length == 1) {
            result = pkIdDys[0].getLong("id") != pkId;
        }
        return result;
    }

    @Override
    public boolean isExistsByCredentialstype(long pkId, long personId, long credentialstypeId) {
        boolean result = false;
        DynamicObject[] pkIdDys = this.percreRepository.queryByCredentialstype(personId, credentialstypeId);
        if (pkIdDys.length == 1) {
            result = pkIdDys[0].getLong("id") != pkId;
        }
        return result;
    }

    @Override
    public DynamicObject[] queryIsMajorByPkIdList(List<Long> pkIdList) {
        return this.percreRepository.queryIsMajorByPkIdList(pkIdList);
    }

    @Override
    public List<Long> queryExistsIdByPkIdList(List<Long> pkIdList) {
        DynamicObject[] existsPkIdArr = this.percreRepository.queryByPkIdList(pkIdList);
        if (existsPkIdArr.length > 0) {
            return Arrays.stream(existsPkIdArr).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        }
        return new ArrayList<Long>();
    }

    @Override
    public int queryOtherExistsByPersonIdAndPkId(long personId, Long pkId) {
        return this.percreRepository.queryOtherExistsByPersonIdAndPkId(personId, pkId);
    }

    @Override
    public DynamicObject getPernontspropInfoByPersonId(long personId) {
        return this.personinfoRepository.getPernontspropInfoByPersonId(personId);
    }

    @Override
    public HrpiServiceOperateResult saveImportPercre(String importtype, DynamicObject[] dataEntities, Long eventId) {
        this.setPercreIsIdentity(dataEntities);
        if (HRStringUtils.equals((String)"new", (String)importtype)) {
            DynamicObject[] importSaveDys = this.percreRepository.getImportSaveByPercre(dataEntities);
            DynamicObject dataEntity = importSaveDys[0];
            return this.insertPercre(dataEntity, paramMap -> this.attacheHandlerService.invokeHisImportDataByBatchEventid(paramMap, eventId.longValue()));
        }
        DynamicObject[] importSaveOverrideDys = this.percreRepository.getImportOverrideByPercre(dataEntities);
        DynamicObject importSaveOverrideDy = importSaveOverrideDys[0];
        long pkId = importSaveOverrideDy.getLong("id");
        return this.updatePercre(pkId, importSaveOverrideDy, this::updatePercreMajorToExcel, paramMap -> this.attacheHandlerService.invokeHisImportDataByBatchEventid(paramMap, eventId.longValue()));
    }

    private void setPercreIsIdentity(DynamicObject[] dataEntities) {
        if (Objects.isNull(dataEntities) || dataEntities.length == 0 || !dataEntities[0].containsProperty("credentialstype") || !dataEntities[0].containsProperty("isidentity")) {
            return;
        }
        for (DynamicObject percreDy : dataEntities) {
            DynamicObject credentialstype = (DynamicObject)percreDy.get("credentialstype");
            boolean isIdentity = null == credentialstype ? Boolean.FALSE.booleanValue() : credentialstype.getBoolean("isidentity");
            percreDy.set("isidentity", (Object)(isIdentity ? "1" : "0"));
        }
    }
}

