/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.domian.service.impl.infoclassify;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hspm.business.domian.repository.infoclassify.PereduexpinfoRepository;
import kd.hr.hspm.business.domian.service.infoclassify.IPereduexpinfoService;
import kd.sdk.hr.hspm.business.helper.BasedataHelper;
import kd.sdk.hr.hspm.business.helper.HpfsChgexternalrecordQueueHelper;
import kd.sdk.hr.hspm.common.dto.HpfsChgexternalrecordQueueDto;
import kd.sdk.hr.hspm.common.dto.InfoClassifyEntityKeyDTO;
import kd.sdk.hr.hspm.common.enums.PereduexpcerttypeFieldEnum;
import kd.sdk.hr.hspm.common.enums.PereduexpinfoFieldEnum;
import kd.sdk.hr.hspm.common.result.HrpiServiceOperateResult;
import kd.sdk.hr.hspm.common.utils.PropertyHelper;
import org.apache.commons.lang.time.StopWatch;

public class PereduexpinfoServiceImpl
implements IPereduexpinfoService {
    private static final Log LOGGER = LogFactory.getLog(PereduexpinfoServiceImpl.class);
    private final PereduexpinfoRepository pereduexpinfoRepository = PereduexpinfoRepository.getInstance();
    private final PereduexpinfoFieldEnum hrpiPereduexpEnum = PereduexpinfoFieldEnum.HRPI_PEREDUEXP;
    private final PereduexpinfoFieldEnum hrpiPereduexpcertEnum = PereduexpinfoFieldEnum.HRPI_PEREDUEXPCERT;

    @Override
    public DynamicObject getPereduexpinfo(Long pereduexpinfoId) {
        return this.pereduexpinfoRepository.getPereduexp(pereduexpinfoId, "");
    }

    @Override
    public void getPereduexpinfoAndSetValue(Long pereduexpinfoId, DynamicObject dataEntity) {
        DynamicObject pereduexpDy = this.pereduexpinfoRepository.getPereduexp(pereduexpinfoId, "");
        HRDynamicObjectUtils.copy((DynamicObject)pereduexpDy, (DynamicObject)dataEntity);
        Map<Long, DynamicObject> pereduexpcertDyMap = this.queryMapPereduexpcert(pereduexpinfoId);
        if (!pereduexpcertDyMap.isEmpty()) {
            for (Map.Entry<Long, DynamicObject> entry : pereduexpcertDyMap.entrySet()) {
                Long certtypeId = entry.getKey();
                DynamicObject pereduexpcertDy = entry.getValue();
                for (String prop : PereduexpcerttypeFieldEnum.getSelectProperties((long)certtypeId).split(",")) {
                    dataEntity.set(String.join((CharSequence)"_", prop, String.valueOf(certtypeId)), pereduexpcertDy.get(prop));
                }
            }
        }
    }

    @Override
    public DynamicObject[] queryIshighestdegreeByPkIdList(List<Long> pkIdList) {
        return this.pereduexpinfoRepository.queryIshighestdegreeByPkIdList(pkIdList);
    }

    @Override
    public DynamicObject[] queryPereduexpcert(Long pereduexpId) {
        return this.pereduexpinfoRepository.queryPereduexpcertByPereduexpId(pereduexpId);
    }

    @Override
    public List<Long> queryPereduexpcertId(List<Long> pereduexpIdList) {
        DynamicObject[] pereduexpcertIdDyArr = this.pereduexpinfoRepository.queryPereduexpcertByPereduexpIdList(pereduexpIdList, "id");
        List<Long> pereduexpcertIdList = new ArrayList<Long>();
        if (pereduexpcertIdDyArr.length > 0) {
            pereduexpcertIdList = Arrays.stream(pereduexpcertIdDyArr).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
        }
        return pereduexpcertIdList;
    }

    @Override
    public Map<Long, DynamicObject> queryMapPereduexpcert(Long pereduexpId) {
        DynamicObject[] pereduexpcertDyArr = this.pereduexpinfoRepository.queryPereduexpcertByPereduexpId(pereduexpId);
        if (pereduexpcertDyArr.length == 0) {
            return new HashMap<Long, DynamicObject>(16);
        }
        return Arrays.stream(pereduexpcertDyArr).collect(Collectors.toMap(pereduexpcertDy -> pereduexpcertDy.getLong("certtype.id"), pereduexpcertDy -> pereduexpcertDy, (k1, k2) -> k1));
    }

    @Override
    public List<Long> queryCerttype() {
        return this.pereduexpinfoRepository.queryCerttype();
    }

    @Override
    public DynamicObject[] queryAllCerttype() {
        return this.pereduexpinfoRepository.queryAllCerttype();
    }

    @Override
    public DynamicObject[] queryAllCerttypeNoFilter() {
        return this.pereduexpinfoRepository.queryAllCerttypeNoFilter();
    }

    @Override
    public DynamicObject coverPereduexpinfoToPereduexpcert(DynamicObject dataEntity, Long certtypeId) {
        return this.pereduexpinfoRepository.coverPereduexpinfoToPereduexpcert(dataEntity, certtypeId);
    }

    @Override
    public DynamicObject getPereduexpcertIdByPereduexpIdAndCerttypeId(Long pkId, long certtypeId) {
        return this.pereduexpinfoRepository.getPereduexpcertByPereduexpIdAndCerttypeId(pkId, certtypeId, "id");
    }

    @Override
    public HrpiServiceOperateResult insertPereduexpinfo(DynamicObject dataEntity) {
        Map resultMap;
        HrpiServiceOperateResult operateResult;
        HashMap<String, DynamicObjectCollection> paramMap = new HashMap<String, DynamicObjectCollection>(16);
        dataEntity.set("id", (Object)ORM.create().genLongId(this.hrpiPereduexpcertEnum.getFormKey()));
        List<DynamicObject> updateDyList = this.insertPereduexpIshighestdegree(dataEntity);
        paramMap.put(this.hrpiPereduexpEnum.getFormKey(), this.pereduexpinfoRepository.getBatchInvokeUpdateByPereduexp(updateDyList, this.pereduexpinfoRepository.getInvokeSaveByPereduexp(dataEntity)));
        DynamicObjectCollection pereduexpcertDyCollection = this.pereduexpinfoRepository.getInvokeSaveByPereduexpcert(dataEntity);
        if (!pereduexpcertDyCollection.isEmpty()) {
            paramMap.put(this.hrpiPereduexpcertEnum.getFormKey(), this.pereduexpinfoRepository.getInvokeSaveByPereduexpcert(dataEntity));
        }
        if ((operateResult = HrpiServiceOperateResult.build((Map)(resultMap = attacheHandlerService.invokeSaveOrUpdate(paramMap)))).isSuccess()) {
            Long pkId = (Long)operateResult.getDataMapForIds().get(0);
            dataEntity.set("id", (Object)pkId);
            LOGGER.info(String.format(Locale.ROOT, "insertPereduexpinfo the id is %s.", pkId));
            long personId = dataEntity.getLong("person.id");
            HpfsChgexternalrecordQueueHelper.sendCustomerHisNonLineMsgBySavePereduexpinfo((long)personId, paramMap, (DynamicObjectCollection)pereduexpcertDyCollection, (HrpiServiceOperateResult)operateResult);
        }
        return operateResult;
    }

    private List<DynamicObject> insertPereduexpIshighestdegree(DynamicObject dataEntity) {
        String ishighestdegree;
        ArrayList<DynamicObject> updateDyList = new ArrayList<DynamicObject>();
        long personId = dataEntity.getLong("person.id");
        DynamicObject[] mainPereduexpDyArr = this.pereduexpinfoRepository.queryMainPereduexpByPersonId(personId);
        if (mainPereduexpDyArr.length == 0) {
            LOGGER.info("insertPereduexpIshighestdegree. the mainPereduexpDy is null");
            dataEntity.set("ishighestdegree", (Object)"1");
        } else if (PropertyHelper.existProperty((DynamicObject)dataEntity, (String)"ishighestdegree") && HRStringUtils.equals((String)(ishighestdegree = dataEntity.getString("ishighestdegree")), (String)"1")) {
            Arrays.stream(mainPereduexpDyArr).forEach(mainPereduexpDy -> {
                BasedataHelper.setInitData((DynamicObject)dataEntity);
                mainPereduexpDy.set("ishighestdegree", (Object)"0");
            });
            updateDyList.addAll(Arrays.asList(mainPereduexpDyArr));
        }
        return updateDyList;
    }

    @Override
    public HrpiServiceOperateResult updatePereduexpinfo(Long pkId, DynamicObject dataEntity, Map<String, Boolean> checkChangedMap) {
        Map resultMap;
        InfoClassifyEntityKeyDTO infoClassifyEntityKeyDTO = InfoClassifyEntityKeyDTO.getEntityKeyEnumByFormKey((String)"hspm_pereduexpinfo");
        ArrayList<Long> removePereduexpcertIdList = new ArrayList<Long>();
        Map<String, DynamicObjectCollection> paramMap = this.getInvokeSaveOrUpdateParamMap(pkId, dataEntity, checkChangedMap, removePereduexpcertIdList);
        HashMap<Long, HpfsChgexternalrecordQueueDto> hpfsChgexternalrecordQueueDtoMap = new HashMap<Long, HpfsChgexternalrecordQueueDto>(16);
        HrpiServiceOperateResult operateResult = HrpiServiceOperateResult.build((Boolean)Boolean.TRUE, (String)"");
        if (!paramMap.isEmpty() && (operateResult = HrpiServiceOperateResult.build((Map)(resultMap = attacheHandlerService.invokeSaveOrUpdate(paramMap)))).isSuccess()) {
            LOGGER.info(String.format(Locale.ROOT, "updatePereduexpinfo the id is %s.", pkId));
            long personId = dataEntity.getLong("person.id");
            HpfsChgexternalrecordQueueDto hpfsChgexternalrecordQueueDto = HpfsChgexternalrecordQueueHelper.createBatchHisNonLineInsertOrUpdateMsg((long)personId, paramMap, (HrpiServiceOperateResult)operateResult, (String)infoClassifyEntityKeyDTO.getFormKey());
            hpfsChgexternalrecordQueueDtoMap.put(personId, hpfsChgexternalrecordQueueDto);
        }
        if (!removePereduexpcertIdList.isEmpty()) {
            operateResult = this.deletePereduexpcert(removePereduexpcertIdList, hpfsChgexternalrecordQueueDtoMap);
        } else {
            HpfsChgexternalrecordQueueHelper.mergeRecordAndSend(hpfsChgexternalrecordQueueDtoMap, new HashMap(1));
        }
        return operateResult;
    }

    private Map<String, DynamicObjectCollection> getInvokeSaveOrUpdateParamMap(Long pkId, DynamicObject dataEntity, Map<String, Boolean> checkChangedMap, List<Long> removePereduexpcertIdList) {
        HashMap<String, DynamicObjectCollection> paramMap = new HashMap<String, DynamicObjectCollection>(16);
        if (checkChangedMap.get(this.hrpiPereduexpEnum.getFormKey()).booleanValue()) {
            List<DynamicObject> updateDyList = this.updatePereduexpIshighestdegree(pkId, dataEntity);
            paramMap.put(this.hrpiPereduexpEnum.getFormKey(), this.pereduexpinfoRepository.getBatchInvokeUpdateByPereduexp(updateDyList, this.pereduexpinfoRepository.getInvokeUpdateByPereduexp(pkId, dataEntity)));
        }
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        List<Long> certtypeIdList = this.queryCerttype();
        for (Long certtypeId : certtypeIdList) {
            String checkChangeKey = String.join((CharSequence)"_", this.hrpiPereduexpcertEnum.getFormKey(), String.valueOf(certtypeId));
            Boolean checkChangeFlag = checkChangedMap.get(checkChangeKey);
            if (checkChangeFlag == null || !checkChangeFlag.booleanValue()) continue;
            if (!dataEntity.containsProperty("operatetype_" + certtypeId)) {
                LOGGER.info("PereduexpinfoServiceImpl.validatePereduexpCertRequired the certtype is new create. {}", (Object)certtypeId);
                continue;
            }
            String operateType = dataEntity.getString("operatetype_" + certtypeId);
            if (!HRStringUtils.isEmpty((String)operateType) && HRStringUtils.equals((String)operateType, (String)"0")) {
                DynamicObject pereduexpcertDy = this.pereduexpinfoRepository.getPereduexpcertByPereduexpIdAndCerttypeId(pkId, certtypeId, "id");
                long pereduexpcertId = pereduexpcertDy.getLong("id");
                removePereduexpcertIdList.add(pereduexpcertId);
                continue;
            }
            DynamicObject pereduexpcertDbDy = this.pereduexpinfoRepository.getPereduexpcertByPereduexpIdAndCerttypeId(pkId, certtypeId, "");
            if (HRObjectUtils.isEmpty((Object)pereduexpcertDbDy)) {
                this.pereduexpinfoRepository.getInvokeSaveByPereduexpCert(dataEntity, certtypeId, dynamicObjectCollection);
                continue;
            }
            this.pereduexpinfoRepository.getInvokeUpdateByPereduexpCert(pereduexpcertDbDy, dataEntity, certtypeId, dynamicObjectCollection);
        }
        if (!dynamicObjectCollection.isEmpty()) {
            paramMap.put(this.hrpiPereduexpcertEnum.getFormKey(), dynamicObjectCollection);
        }
        return paramMap;
    }

    private List<DynamicObject> updatePereduexpIshighestdegree(Long pkId, DynamicObject dataEntity) {
        ArrayList<DynamicObject> updateDyList = new ArrayList<DynamicObject>();
        long personId = dataEntity.getLong("person.id");
        DynamicObject[] pereduexpDyArr = this.pereduexpinfoRepository.queryHrpiPereduexpByPersonId(personId);
        Map<Boolean, List<DynamicObject>> pereduexpDyListMap = Arrays.stream(pereduexpDyArr).collect(Collectors.partitioningBy(dy -> pkId.longValue() == dy.getLong("id")));
        List<DynamicObject> pereduexpDyList = pereduexpDyListMap.get(Boolean.FALSE);
        if (PropertyHelper.existProperty((DynamicObject)dataEntity, (String)"ishighestdegree")) {
            String ishighestdegree = dataEntity.getString("ishighestdegree");
            if (HRStringUtils.equals((String)ishighestdegree, (String)"1")) {
                List<DynamicObject> mainPereduexpDyList = pereduexpDyList.stream().filter(mainpereduexpDy -> HRStringUtils.equals((String)mainpereduexpDy.getString("ishighestdegree"), (String)"1")).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(mainPereduexpDyList)) {
                    mainPereduexpDyList.forEach(mainPereduexpDy -> {
                        BasedataHelper.setInitData((DynamicObject)mainPereduexpDy);
                        mainPereduexpDy.set("ishighestdegree", (Object)"0");
                    });
                    updateDyList.addAll(mainPereduexpDyList);
                }
            } else if (pereduexpDyList.isEmpty()) {
                dataEntity.set("ishighestdegree", (Object)"1");
                LOGGER.info("updatepereduexp. the mainpereduexpDy equals now dy and the pereduexp is only one");
            } else {
                Optional<DynamicObject> first;
                Optional<DynamicObject> highestDegree = pereduexpDyList.stream().filter(mainpereduexpDy -> HRStringUtils.equals((String)mainpereduexpDy.getString("ishighestdegree"), (String)"1")).findFirst();
                if (!highestDegree.isPresent() && (first = pereduexpDyList.stream().filter(mainpereduexpDy -> HRStringUtils.equals((String)mainpereduexpDy.getString("ishighestdegree"), (String)"0")).sorted(Comparator.comparing(dynamicObject -> dynamicObject.getDate("createtime"), Comparator.reverseOrder())).findFirst()).isPresent()) {
                    DynamicObject object = first.get();
                    object.set("ishighestdegree", (Object)"1");
                    updateDyList.add(object);
                }
            }
        }
        return updateDyList;
    }

    @Override
    public HrpiServiceOperateResult deletePereduexpinfo(List<Long> pkIdList) {
        InfoClassifyEntityKeyDTO infoClassifyEntityKeyDTO = InfoClassifyEntityKeyDTO.getEntityKeyEnumByFormKey((String)"hspm_pereduexpinfo");
        DynamicObject[] dbDyArr = this.pereduexpinfoRepository.queryHrpiPereduexpForPerChg(pkIdList);
        Map resultMap = attacheHandlerService.invokeDel(pkIdList, this.hrpiPereduexpEnum.getFormKey(), Boolean.TRUE);
        HrpiServiceOperateResult operateResult = HrpiServiceOperateResult.build((Map)resultMap);
        if (operateResult.isSuccess()) {
            LOGGER.info(String.format(Locale.ROOT, "deletePereduexpinfo the id is %s.", pkIdList));
            Map hpfsChgexternalrecordQueueDtoMap = HpfsChgexternalrecordQueueHelper.createBatchHisNonLineDeleteMsg((DynamicObject[])dbDyArr, (String)this.hrpiPereduexpEnum.getFormKey(), (String)infoClassifyEntityKeyDTO.getFormKey());
            List<Long> pereduexpcertIdList = this.queryPereduexpcertId(pkIdList);
            if (!pereduexpcertIdList.isEmpty()) {
                operateResult = this.deletePereduexpcert(pereduexpcertIdList, hpfsChgexternalrecordQueueDtoMap);
            } else {
                HpfsChgexternalrecordQueueHelper.mergeRecordAndSend((Map)hpfsChgexternalrecordQueueDtoMap, new HashMap(1));
            }
        }
        return operateResult;
    }

    private HrpiServiceOperateResult deletePereduexpcert(List<Long> pkIdList, Map<Long, HpfsChgexternalrecordQueueDto> pereduexpHpfsChgexternalrecordQueueDtoMap) {
        InfoClassifyEntityKeyDTO infoClassifyEntityKeyDTO = InfoClassifyEntityKeyDTO.getEntityKeyEnumByFormKey((String)"hspm_pereduexpinfo");
        DynamicObject[] dbDyArr = this.pereduexpinfoRepository.queryHrpiPereduexpcertForPerChg(pkIdList);
        Map resultMap = attacheHandlerService.invokeDel(pkIdList, this.hrpiPereduexpcertEnum.getFormKey(), Boolean.TRUE);
        HrpiServiceOperateResult operateResult = HrpiServiceOperateResult.build((Map)resultMap);
        if (operateResult.isSuccess()) {
            LOGGER.info(String.format(Locale.ROOT, "deletePereduexpcert the id is %s.", pkIdList));
            Map pereduexpcertBatchHisNonLineDeleteMsg = HpfsChgexternalrecordQueueHelper.createBatchHisNonLineDeleteMsg((DynamicObject[])dbDyArr, (String)this.hrpiPereduexpcertEnum.getFormKey(), (String)infoClassifyEntityKeyDTO.getFormKey());
            HpfsChgexternalrecordQueueHelper.mergeRecordAndSend(pereduexpHpfsChgexternalrecordQueueDtoMap, (Map)pereduexpcertBatchHisNonLineDeleteMsg);
        }
        return operateResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HrpiServiceOperateResult saveImportPereduexpinfo(String importtype, DynamicObject[] dataEntities, Long eventId) {
        LOGGER.info("PereduexpinfoImport ==> saveImportPereduexpinfo start importtype: {}, dataLen:{}, eventId: {}", new Object[]{importtype, dataEntities.length, eventId});
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            InfoClassifyEntityKeyDTO infoClassifyEntityKeyDTO = InfoClassifyEntityKeyDTO.getEntityKeyEnumByFormKey((String)"hspm_pereduexpinfo");
            ArrayList<DynamicObject> updateDyList = new ArrayList<DynamicObject>();
            DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
            Map<Long, List<DynamicObject>> dataEntitiesMap = Arrays.stream(dataEntities).collect(Collectors.groupingBy(dataEntity -> dataEntity.getLong("person.id")));
            for (Map.Entry<Long, List<DynamicObject>> entry : dataEntitiesMap.entrySet()) {
                DynamicObject dataEntity2 = null;
                List<DynamicObject> dynamicObjects = entry.getValue();
                dataEntity2 = this.getIshighestdegreeDynamicObject(dynamicObjects);
                updateDyList.addAll(this.insertPereduexpIshighestdegree(dataEntity2));
                this.pereduexpinfoRepository.getImportSaveByPereduexpinfo(dynamicObjects, dynamicObjectCollection);
            }
            stopWatch.split();
            LOGGER.info("PereduexpinfoImport ==> saveImportPereduexpinfo execute importdata, eventId: {} time is: {} ms.", (Object)eventId, (Object)stopWatch.getSplitTime());
            HashMap<String, DynamicObjectCollection> paramMap = new HashMap<String, DynamicObjectCollection>(16);
            paramMap.put(this.hrpiPereduexpEnum.getFormKey(), this.pereduexpinfoRepository.getBatchInvokeUpdateByPereduexp(updateDyList, dynamicObjectCollection));
            stopWatch.split();
            LOGGER.info("PereduexpinfoImport ==> saveImportPereduexpinfo before invokeHisImportDataByBatchEventid, eventId: {} time is: {} ms.", (Object)eventId, (Object)stopWatch.getSplitTime());
            Map resultMap = attacheHandlerService.invokeHisImportDataByBatchEventid(paramMap, eventId.longValue());
            stopWatch.split();
            LOGGER.info("PereduexpinfoImport ==> saveImportPereduexpinfo after invokeHisImportDataByBatchEventid, eventId: {} time is: {} ms.", (Object)eventId, (Object)stopWatch.getSplitTime());
            HrpiServiceOperateResult operateResult = HrpiServiceOperateResult.build((Map)resultMap);
            if (operateResult.isSuccess()) {
                LOGGER.info(String.format(Locale.ROOT, "saveImportPereduexpinfo the id is %s.", operateResult.getDataMapForIds()));
                HpfsChgexternalrecordQueueHelper.sendBatchHisNonLineInsertMsg((DynamicObject[])dataEntities, (String)infoClassifyEntityKeyDTO.getSourceKey(), (String)infoClassifyEntityKeyDTO.getFormKey());
            }
            stopWatch.split();
            LOGGER.info("PereduexpinfoImport ==> saveImportPereduexpinfo after hpfs, eventId: {} time is: {} ms.", (Object)eventId, (Object)stopWatch.getSplitTime());
            HrpiServiceOperateResult hrpiServiceOperateResult = operateResult;
            return hrpiServiceOperateResult;
        }
        finally {
            stopWatch.stop();
            LOGGER.info("PereduexpinfoImport ==> saveImportPereduexpinfo end, eventId: {} time is: {} ms.", (Object)eventId, (Object)stopWatch.getTime());
        }
    }

    private DynamicObject getIshighestdegreeDynamicObject(List<DynamicObject> dynamicObjects) {
        DynamicObject dataEntity;
        if (dynamicObjects.size() > 1) {
            ArrayList<DynamicObject> ishighestdegreeDyList = new ArrayList<DynamicObject>(dynamicObjects.size());
            for (DynamicObject dynamicObject : dynamicObjects) {
                String ishighestdegree = dynamicObject.getString("ishighestdegree");
                if (!HRStringUtils.equals((String)ishighestdegree, (String)"1")) continue;
                ishighestdegreeDyList.add(dynamicObject);
            }
            dataEntity = dynamicObjects.get(dynamicObjects.size() - 1);
            if (ishighestdegreeDyList.size() == 1) {
                dataEntity = (DynamicObject)ishighestdegreeDyList.get(0);
            } else if (ishighestdegreeDyList.size() > 1) {
                for (int i = 0; i < ishighestdegreeDyList.size() - 1; ++i) {
                    DynamicObject ishighestdegreeDy = (DynamicObject)ishighestdegreeDyList.get(i);
                    ishighestdegreeDy.set("ishighestdegree", (Object)"0");
                }
                dataEntity = (DynamicObject)ishighestdegreeDyList.get(ishighestdegreeDyList.size() - 1);
            }
        } else {
            dataEntity = dynamicObjects.get(dynamicObjects.size() - 1);
        }
        return dataEntity;
    }

    @Override
    public List<Long> queryExistsIdByPkIdList(List<Long> pkIdList) {
        DynamicObject[] existsPkIdArr = this.pereduexpinfoRepository.queryByPkIdList(pkIdList);
        if (existsPkIdArr.length > 0) {
            return Arrays.stream(existsPkIdArr).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        }
        return new ArrayList<Long>();
    }

    @Override
    public int queryOtherExistsByPersonIdAndPkId(long personId, Long pkId) {
        return this.pereduexpinfoRepository.queryOtherExistsByPersonIdAndPkId(personId, pkId);
    }

    @Override
    public int queryExistsByPersonId(long personId) {
        return this.pereduexpinfoRepository.queryExistsByPersonId(personId);
    }

    @Override
    public DynamicObject[] queryEduByPersonIds(Set<Long> personIdSet) {
        return this.pereduexpinfoRepository.queryEduByPersonIds(personIdSet);
    }
}

