/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.domian.service.impl.infoclassify;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hspm.business.domian.repository.infoclassify.PreworkexpRepository;
import kd.hr.hspm.business.domian.service.infoclassify.IPreworkexpService;
import kd.sdk.hr.hspm.business.helper.HpfsChgexternalrecordQueueHelper;
import kd.sdk.hr.hspm.common.dto.InfoClassifyEntityKeyDTO;
import kd.sdk.hr.hspm.common.result.HrpiServiceOperateResult;

public class PreworkexpServiceImpl
implements IPreworkexpService {
    private static final Log LOGGER = LogFactory.getLog(PreworkexpServiceImpl.class);
    private final PreworkexpRepository preworkexpRepository = PreworkexpRepository.getInstance();

    @Override
    public DynamicObject getPreworkexpByPkId(Long pkId) {
        return this.preworkexpRepository.getPreworkexp(pkId, "");
    }

    @Override
    public HrpiServiceOperateResult insertPreworkexp(DynamicObject dataEntity) {
        InfoClassifyEntityKeyDTO infoClassifyEntityKeyDTO = InfoClassifyEntityKeyDTO.getEntityKeyEnumByFormKey((String)"hspm_preworkexp");
        HashMap<String, DynamicObjectCollection> paramMap = new HashMap<String, DynamicObjectCollection>(16);
        paramMap.put(infoClassifyEntityKeyDTO.getSourceKey(), this.preworkexpRepository.getInvokeSaveByPreworkexp(dataEntity));
        Map resultMap = attacheHandlerService.invokeSaveOrUpdate(paramMap);
        HrpiServiceOperateResult operateResult = HrpiServiceOperateResult.build((Map)resultMap);
        if (operateResult.isSuccess()) {
            Long pkId = (Long)operateResult.getDataMapForIds().get(0);
            dataEntity.set("id", (Object)pkId);
            LOGGER.info(String.format(Locale.ROOT, "insertPreworkexp the id is %s.", pkId));
            HpfsChgexternalrecordQueueHelper.sendHisNonLineInsertMsg((DynamicObject)dataEntity, (String)infoClassifyEntityKeyDTO.getSourceKey(), (String)infoClassifyEntityKeyDTO.getFormKey());
        }
        return operateResult;
    }

    @Override
    public HrpiServiceOperateResult updatePreworkexp(Long pkId, DynamicObject dataEntity) {
        InfoClassifyEntityKeyDTO infoClassifyEntityKeyDTO = InfoClassifyEntityKeyDTO.getEntityKeyEnumByFormKey((String)"hspm_preworkexp");
        HashMap<String, DynamicObjectCollection> paramMap = new HashMap<String, DynamicObjectCollection>(16);
        paramMap.put(infoClassifyEntityKeyDTO.getSourceKey(), this.preworkexpRepository.getInvokeUpdateByPreworkexp(pkId, dataEntity));
        Map resultMap = attacheHandlerService.invokeSaveOrUpdate(paramMap);
        HrpiServiceOperateResult operateResult = HrpiServiceOperateResult.build((Map)resultMap);
        if (operateResult.isSuccess()) {
            LOGGER.info(String.format(Locale.ROOT, "updatePreworkexp the id is %s.", pkId));
            HpfsChgexternalrecordQueueHelper.sendHisNonLineUpdateMsg((DynamicObject)dataEntity, (String)infoClassifyEntityKeyDTO.getSourceKey(), (String)infoClassifyEntityKeyDTO.getFormKey());
        }
        return operateResult;
    }

    @Override
    public HrpiServiceOperateResult deletePreworkexp(List<Long> pkIdList) {
        InfoClassifyEntityKeyDTO infoClassifyEntityKeyDTO = InfoClassifyEntityKeyDTO.getEntityKeyEnumByFormKey((String)"hspm_preworkexp");
        DynamicObject[] dbDyArr = this.preworkexpRepository.queryHrpiPreworkexpForPerChg(pkIdList);
        Map resultMap = attacheHandlerService.invokeDel(pkIdList, infoClassifyEntityKeyDTO.getSourceKey(), Boolean.TRUE);
        HrpiServiceOperateResult operateResult = HrpiServiceOperateResult.build((Map)resultMap);
        if (operateResult.isSuccess()) {
            LOGGER.info(String.format(Locale.ROOT, "deletePreworkexp the id is %s.", pkIdList));
            HpfsChgexternalrecordQueueHelper.sendBatchHisNonLineDeleteMsg((DynamicObject[])dbDyArr, (String)infoClassifyEntityKeyDTO.getSourceKey(), (String)infoClassifyEntityKeyDTO.getFormKey());
        }
        return operateResult;
    }

    @Override
    public HrpiServiceOperateResult saveImportPreworkexp(String importtype, DynamicObject[] dataEntities) {
        InfoClassifyEntityKeyDTO infoClassifyEntityKeyDTO = InfoClassifyEntityKeyDTO.getEntityKeyEnumByFormKey((String)"hspm_preworkexp");
        DynamicObject[] importSaveDys = this.preworkexpRepository.getImportSaveByPreworkexp(dataEntities);
        Map resultMap = attacheHandlerService.invokeHisNonLineImportData(importtype, importSaveDys);
        HrpiServiceOperateResult operateResult = HrpiServiceOperateResult.build((Map)resultMap);
        if (operateResult.isSuccess()) {
            LOGGER.info(String.format(Locale.ROOT, "saveImportPreworkexp the id is %s.", operateResult.getDataMapForIds()));
            HpfsChgexternalrecordQueueHelper.sendBatchHisNonLineInsertMsg((DynamicObject[])dataEntities, (String)infoClassifyEntityKeyDTO.getSourceKey(), (String)infoClassifyEntityKeyDTO.getFormKey());
        }
        return operateResult;
    }

    @Override
    public List<Long> queryExistsIdByPkIdList(List<Long> pkIdList) {
        DynamicObject[] existsPkIdArr = this.preworkexpRepository.queryByPkIdList(pkIdList);
        if (existsPkIdArr.length > 0) {
            return Arrays.stream(existsPkIdArr).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        }
        return new ArrayList<Long>();
    }
}

