/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.domian.service.impl.inforevise;

import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.hr.hbp.business.servicehelper.HRProducerServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hspm.business.domian.repository.inforevise.MsgPublisherRepository;
import kd.hr.hspm.business.domian.service.inforevise.IRevisePublishService;
import kd.sdk.hr.hspm.common.constants.PersonReviseConstants;

public class RevisePublishServiceImpl
implements IRevisePublishService,
PersonReviseConstants {
    private DynamicObject msgPublisherDyn;
    private Object param;
    private Long personId;
    private String groupName;

    public RevisePublishServiceImpl(String entityName, Object param, Long personId, String groupName) {
        this.param = param;
        this.msgPublisherDyn = MsgPublisherRepository.getInstance().loadByNum((String)PersonReviseConstants.entityNameVsPubNumMap.get(entityName));
        this.personId = personId;
        this.groupName = groupName;
    }

    @Override
    public void publish() {
        Map<String, Object> publishInfoMap = this.getPublishInfoMap();
        HRProducerServiceHelper.publishAction(publishInfoMap);
    }

    private Map<String, Object> getPublishInfoMap() {
        HashMap actionInfo = Maps.newHashMapWithExpectedSize((int)16);
        actionInfo.put("msgNumber", String.valueOf(UUID.randomUUID()));
        actionInfo.put("actionId", this.msgPublisherDyn.getLong("action.id"));
        actionInfo.put("senderId", 1L);
        actionInfo.put("sendTime", new Date());
        actionInfo.put("msgPubNo", this.msgPublisherDyn.getString("number"));
        actionInfo.put("msgTitle", this.subString(String.format(ResManager.loadKDString((String)"%s\u4fee\u8ba2\u65e5\u5fd7\u6d88\u606f", (String)"RevisePublishServiceImpl_0", (String)"hr-hspm-business", (Object[])new Object[0]), this.groupName), 100));
        actionInfo.put("params", SerializationUtils.serializeToBase64((Object)this.param));
        actionInfo.put("msgDesc", this.subString(String.format(ResManager.loadKDString((String)"\u81ea\u7136\u4eba\uff1a%1$s \u7684 %2$s\u4fee\u8ba2\u65e5\u5fd7\u6d88\u606f", (String)"RevisePublishServiceImpl_1", (String)"hr-hspm-business", (Object[])new Object[0]), this.personId, this.groupName), 100));
        actionInfo.put("msgTag", this.subString(this.msgPublisherDyn.getString("msgtag"), 100));
        return actionInfo;
    }

    public String subString(String str, int length) {
        if (HRStringUtils.isEmpty((String)str)) {
            return str;
        }
        return str.length() > length ? str.substring(0, length) : str;
    }
}

