/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.domian.service.impl.inforevise;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hspm.business.domian.repository.inforevise.AttachreviseconRepository;
import kd.hr.hspm.business.domian.repository.inforevise.EmpentrelRepository;
import kd.hr.hspm.business.domian.repository.inforevise.TrialperiodRepository;
import kd.hr.hspm.business.domian.service.inforevise.IInfoReviseService;
import kd.sdk.hr.hspm.business.service.AttacheHandlerService;
import kd.sdk.hr.hspm.common.result.HrpiServiceOperateResult;
import kd.sdk.hr.hspm.common.utils.DynamicPropValidateUtil;

public class TrialperiodServiceImpl
implements IInfoReviseService {
    private static final Log LOGGER = LogFactory.getLog(TrialperiodServiceImpl.class);
    protected final AttacheHandlerService attacheHandlerService = AttacheHandlerService.getInstance();
    private static DynamicObjectType trialperiodType = EntityMetadataCache.getDataEntityType((String)"hrpi_trialperiod");

    @Override
    public HrpiServiceOperateResult saveBatch(DynamicObject modelEntity) {
        if (modelEntity == null) {
            return HrpiServiceOperateResult.build((Boolean)Boolean.FALSE, (String)ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TrialperiodServiceImpl_0", (String)"hr-hspm-business", (Object[])new Object[0]));
        }
        DynamicObject dataEntity = (DynamicObject)trialperiodType.createInstance();
        HRDynamicObjectUtils.copy((DynamicObject)modelEntity, (DynamicObject)dataEntity);
        dataEntity.set("id", (Object)modelEntity.getLong("id"));
        Long employeeId = dataEntity.getLong("employee.id");
        Long personId = dataEntity.getLong("person.id");
        if (employeeId == null || employeeId == 0L || personId == null || personId == 0L) {
            return HrpiServiceOperateResult.build((Boolean)false, (String)ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u81ea\u7136\u4eba\u6216\u4f01\u4e1a\u4eba\u3002", (String)"TrialperiodServiceImpl_1", (String)"hr-hspm-business", (Object[])new Object[0]));
        }
        DynamicObject[] trialperiodDyns = TrialperiodRepository.getInstance().queryByEmployeeId(employeeId);
        if (trialperiodDyns.length > 0) {
            return HrpiServiceOperateResult.build((Boolean)false, (String)ResManager.loadKDString((String)"\u5df2\u6709\u8bd5\u7528\u671f\u4fe1\u606f\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u3002", (String)"TrialperiodServiceImpl_2", (String)"hr-hspm-business", (Object[])new Object[0]));
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        ArrayList datas = new ArrayList();
        HashMap<String, DynamicObjectCollection> personGenericDataEntityMap = new HashMap<String, DynamicObjectCollection>(16);
        DynamicObjectCollection hisDyns = new DynamicObjectCollection();
        hisDyns.add((Object)dataEntity);
        personGenericDataEntityMap.put("hisDyns", hisDyns);
        datas.add(personGenericDataEntityMap);
        paramMap.put("data", datas);
        paramMap.put("caller", "hspm");
        paramMap.put("mustAllSuccess", true);
        Map result = this.attacheHandlerService.invokeSaveBatch(paramMap);
        if (((Boolean)result.get("success")).booleanValue()) {
            DynamicObject[] empentrelDyns = EmpentrelRepository.getInstance().queryhisByEmployeeId(Collections.singletonList(employeeId));
            DynamicObjectCollection empentrelHisDyns = new DynamicObjectCollection();
            for (DynamicObject empentrelDyn : empentrelDyns) {
                empentrelDyn.set("isprobation", (Object)"1");
                empentrelHisDyns.add((Object)empentrelDyn);
            }
            HashMap<String, Object> empentrelParamMap = new HashMap<String, Object>(16);
            ArrayList empentrelDatas = new ArrayList();
            HashMap<String, DynamicObjectCollection> personGenericDataEmpentrelDynsMap = new HashMap<String, DynamicObjectCollection>(16);
            personGenericDataEmpentrelDynsMap.put("hisDyns", empentrelHisDyns);
            empentrelDatas.add(personGenericDataEmpentrelDynsMap);
            empentrelParamMap.put("data", empentrelDatas);
            empentrelParamMap.put("caller", "hspm");
            empentrelParamMap.put("mustAllSuccess", true);
            Map reviseResult = this.attacheHandlerService.invokeReviseVersion(empentrelParamMap);
            LOGGER.info(MessageFormat.format("invokeSaveTrialperiod-invokeReviseEmpentrel result:[{0}]", reviseResult));
        }
        return HrpiServiceOperateResult.build((Map)result);
    }

    @Override
    public HrpiServiceOperateResult revise(DynamicObject modelEntity) {
        if (modelEntity == null) {
            return HrpiServiceOperateResult.build((Boolean)Boolean.FALSE, (String)ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TrialperiodServiceImpl_0", (String)"hr-hspm-business", (Object[])new Object[0]));
        }
        DynamicObject[] trialperiodDyns = TrialperiodRepository.getInstance().queryByPkIdList(Collections.singletonList(modelEntity.getLong("id")));
        if (trialperiodDyns == null || trialperiodDyns.length == 0) {
            return HrpiServiceOperateResult.build((Boolean)false, (String)ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002", (String)"TrialperiodServiceImpl_3", (String)"hr-hspm-business", (Object[])new Object[0]));
        }
        DynamicObject trialperiodFromDB = (DynamicObject)trialperiodType.createInstance();
        HRDynamicObjectUtils.copy((DynamicObject)trialperiodDyns[0], (DynamicObject)trialperiodFromDB);
        trialperiodFromDB.set("id", (Object)trialperiodDyns[0].getLong("id"));
        DynamicObject dataEntity = trialperiodDyns[0];
        HRDynamicObjectUtils.copy((DynamicObject)modelEntity, (DynamicObject)dataEntity);
        dataEntity.set("id", (Object)modelEntity.getLong("id"));
        Map changedPropMap = DynamicPropValidateUtil.checkChangedPropMap((DynamicObject)dataEntity, (DynamicObject)trialperiodFromDB);
        DynamicObject[] attachreviseconDyns = AttachreviseconRepository.getInstance().getAttachrevisecon(dataEntity.getDataEntityType().getExtendName(), Collections.singletonList(1010L));
        List corePropNames = attachreviseconDyns[0].getDynamicObjectCollection("entryentity").stream().map(dyn -> dyn.getString("fieldtag")).collect(Collectors.toList());
        ArrayList<String> hasChangedCoreProps = new ArrayList<String>(10);
        for (String corePropName : corePropNames) {
            DynamicObject[] hasChangedProps = (DynamicObject[])changedPropMap.get("hasChangedProps");
            if (!hasChangedProps.contains(corePropName)) continue;
            hasChangedCoreProps.add(corePropName);
        }
        DynamicObjectCollection hisDyns = new DynamicObjectCollection();
        hisDyns.add((Object)dataEntity);
        if (!hasChangedCoreProps.isEmpty()) {
            DynamicObject[] trialperiodHisDyns;
            for (DynamicObject trialperiodHisDyn : trialperiodHisDyns = TrialperiodRepository.getInstance().queryEffectiveHisDataByBoIds(dataEntity.getLong("boid"), dataEntity.getLong("id"))) {
                for (String hasChangedCoreProp : hasChangedCoreProps) {
                    if ("regstatus".equals(hasChangedCoreProp)) continue;
                    trialperiodHisDyn.set(hasChangedCoreProp, dataEntity.get(hasChangedCoreProp));
                }
                hisDyns.add((Object)trialperiodHisDyn);
            }
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        ArrayList datas = new ArrayList();
        HashMap<String, DynamicObjectCollection> personGenericDataEntityMap = new HashMap<String, DynamicObjectCollection>(16);
        personGenericDataEntityMap.put("hisDyns", hisDyns);
        datas.add(personGenericDataEntityMap);
        paramMap.put("data", datas);
        paramMap.put("caller", "hspm");
        paramMap.put("mustAllSuccess", true);
        Map result = this.attacheHandlerService.invokeReviseVersion(paramMap);
        return HrpiServiceOperateResult.build((Map)result);
    }

    @Override
    public HrpiServiceOperateResult discardBo(List<Long> boIdList) {
        DynamicObject[] trialperiodDyns = TrialperiodRepository.getInstance().queryEmployeeByBoId(boIdList);
        List<Long> employeeIds = Arrays.asList(trialperiodDyns).stream().map(dyn -> dyn.getLong("employee.id")).collect(Collectors.toList());
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        ArrayList datas = new ArrayList();
        HashMap<String, Object> dataEntityMap = new HashMap<String, Object>(16);
        dataEntityMap.put("entityNumber", "hrpi_trialperiod");
        dataEntityMap.put("boIdList", Lists.newArrayList(boIdList));
        datas.add(dataEntityMap);
        paramMap.put("data", datas);
        paramMap.put("caller", "hspm");
        Map result = this.attacheHandlerService.invokeDiscardBO(paramMap);
        if (((Boolean)result.get("success")).booleanValue()) {
            DynamicObject[] empentrelDyns = EmpentrelRepository.getInstance().queryhisByEmployeeId(employeeIds);
            DynamicObjectCollection empentrelHisDyns = new DynamicObjectCollection();
            for (DynamicObject empentrelDyn : empentrelDyns) {
                empentrelDyn.set("isprobation", (Object)"0");
                empentrelHisDyns.add((Object)empentrelDyn);
            }
            HashMap<String, Object> empentrelParamMap = new HashMap<String, Object>(16);
            ArrayList empentrelDatas = new ArrayList();
            HashMap<String, DynamicObjectCollection> personGenericDataEmpentrelDynsMap = new HashMap<String, DynamicObjectCollection>(16);
            personGenericDataEmpentrelDynsMap.put("hisDyns", empentrelHisDyns);
            empentrelDatas.add(personGenericDataEmpentrelDynsMap);
            empentrelParamMap.put("data", empentrelDatas);
            empentrelParamMap.put("caller", "hspm");
            empentrelParamMap.put("mustAllSuccess", true);
            Map reviseResult = this.attacheHandlerService.invokeReviseVersion(empentrelParamMap);
            LOGGER.info(MessageFormat.format("invokeSaveTrialperiod-invokeReviseEmpentrel result:[{0}]", reviseResult));
        }
        return HrpiServiceOperateResult.build((Map)result);
    }
}

