/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.infogroup;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.PictureField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hspm.business.infogroup.InfoGroupFilterFieldsHelper;
import kd.sdk.hr.hspm.business.helper.InfoGroupHelper;
import kd.sdk.hr.hspm.common.constants.MultiViewConfigConstants;
import kd.sdk.hr.hspm.common.enums.BusinessTypeEnum;
import kd.sdk.hr.hspm.common.enums.ConfigAreaEnum;
import kd.sdk.hr.hspm.common.enums.FieldTypeEnum;

public class InfoGroupFieldHelper {
    private static final Log LOGGER = LogFactory.getLog(InfoGroupFieldHelper.class);
    private static final HRBaseServiceHelper INFOGROUPPAGEREG_HELPER = new HRBaseServiceHelper("hspm_infogrouppagereg");
    private static final HRBaseServiceHelper INFOGROUPFIELD_HEPLER = new HRBaseServiceHelper("hspm_infogroupfield");
    private static final HRBaseServiceHelper FORMMETA_HEPLER = new HRBaseServiceHelper("bos_formmeta");
    private static final String SELECT_PROPERTIS = "group,number,name,status,isrequired,isedit,category,type,modifytime,enable,refkey,max,min,precision,scale,maxcount,tablename";
    private static final String FIELD_MODIFYDATE = "modifydate";
    private static final ThreadLocal<Map<String, PictureField>> PICTUREFIELD_THREADLOCAL = new ThreadLocal();
    private static final String INFOGROUPFIELDANALYSIS_CACHE = "INFOGROUPFIELDANALYSIS_CACHE:";

    private static boolean isChange(DynamicObject group, DynamicObject dynamicObject, Map.Entry<String, IDataEntityProperty> field, boolean isNotEditable) {
        BasedataProp basedataProp;
        FieldTypeEnum fieldTypeEnum;
        boolean isEdit;
        boolean isFilterField;
        LocaleString title = field.getValue().getDisplayName();
        Boolean isMust = InfoGroupFieldHelper.getMustInput(field.getValue());
        boolean change = false;
        if (!HRObjectUtils.equals((Object)dynamicObject.getLocaleString("name"), (Object)title)) {
            dynamicObject.set("name", (Object)title);
            change = true;
        }
        if (!isMust.equals(dynamicObject.getBoolean("isrequired"))) {
            dynamicObject.set("isrequired", (Object)isMust);
            change = true;
        }
        if (!(isFilterField = InfoGroupFilterFieldsHelper.isFilterField(group, field.getKey())) && !Boolean.TRUE.equals(dynamicObject.getBoolean("enable"))) {
            dynamicObject.set("enable", (Object)"1");
            change = true;
        }
        if (isFilterField && Boolean.TRUE.equals(dynamicObject.getBoolean("enable"))) {
            dynamicObject.set("enable", (Object)"0");
            change = true;
        }
        boolean bl = isEdit = !isNotEditable;
        if (isEdit != dynamicObject.getBoolean("isedit")) {
            dynamicObject.set("isedit", (Object)isEdit);
            change = true;
        }
        if ((fieldTypeEnum = FieldTypeEnum.getFieldTypeByCode((String)field.getValue().getClass().getName())) == null) {
            throw new KDBizException("not support : " + field.getValue().getClass().getName());
        }
        String type = dynamicObject.getString("type");
        if (!HRStringUtils.equals((String)type, (String)fieldTypeEnum.getType())) {
            if (FieldTypeEnum.BASE_DATA.getType().equals(type) || FieldTypeEnum.AMOUNTPROP.getType().equals(type)) {
                dynamicObject.set("refkey", (Object)" ");
            }
            dynamicObject.set("type", (Object)fieldTypeEnum.getType());
            dynamicObject.set("category", (Object)fieldTypeEnum.getCategroy().getValue());
            change = true;
        }
        if (field.getValue() instanceof BasedataProp && !HRObjectUtils.equals((Object)(basedataProp = (BasedataProp)field.getValue()).getBaseEntityId(), (Object)dynamicObject.getString("refkey"))) {
            dynamicObject.set("refkey", (Object)basedataProp.getBaseEntityId());
            change = true;
        }
        if (field.getValue() instanceof MulBasedataProp) {
            basedataProp = (MulBasedataProp)field.getValue();
            if (!HRObjectUtils.equals((Object)basedataProp.getBaseEntityId(), (Object)dynamicObject.getString("refkey"))) {
                dynamicObject.set("refkey", (Object)basedataProp.getBaseEntityId());
                change = true;
            }
            if (!HRObjectUtils.equals((Object)basedataProp.getAlias(), (Object)dynamicObject.getString("tablename"))) {
                dynamicObject.set("tablename", (Object)basedataProp.getAlias());
                change = true;
            }
        }
        if (InfoGroupFieldHelper.handleFieldLengthLimit(dynamicObject, field.getValue())) {
            change = true;
        }
        return change;
    }

    public static void handlePageMeta(Long groupId) {
        InfoGroupFieldHelper.handlePageMeta(groupId, false);
    }

    public static void handlePageMeta(Long groupId, boolean force) {
        IHRAppCache hrAppCache = HRAppCache.get((String)"hspm");
        if (!force && hrAppCache.get(INFOGROUPFIELDANALYSIS_CACHE + groupId, Boolean.class) != null) {
            return;
        }
        DynamicObject group = INFOGROUPPAGEREG_HELPER.queryOne("pageinfo,filterfields,notEditableFields", (Object)groupId);
        QFilter groupFilter = new QFilter("group", "=", (Object)group.getLong("id"));
        DynamicObject[] sources = INFOGROUPFIELD_HEPLER.query(SELECT_PROPERTIS, new QFilter[]{groupFilter});
        if (force || sources.length == 0) {
            InfoGroupFieldHelper.saveOrUpdateSrouce(group, sources);
        } else {
            Date lastUpdateTime;
            if (group.getDynamicObject("pageinfo") == null) {
                return;
            }
            String pageNumber = group.getDynamicObject("pageinfo").getString("number");
            QFilter numberFilter = new QFilter("number", "=", (Object)pageNumber);
            DynamicObject metaPage = FORMMETA_HEPLER.queryOne(FIELD_MODIFYDATE, new QFilter[]{numberFilter});
            Date modifyDate = metaPage.getDate(FIELD_MODIFYDATE);
            if (modifyDate != null && (lastUpdateTime = InfoGroupFieldHelper.getLastUpdateTime(sources)) != null && modifyDate.after(lastUpdateTime)) {
                InfoGroupFieldHelper.saveOrUpdateSrouce(group, sources);
            }
        }
        hrAppCache.put(INFOGROUPFIELDANALYSIS_CACHE + groupId, (Object)Boolean.TRUE);
    }

    private static Date getLastUpdateTime(DynamicObject[] sources) {
        return Stream.of(sources).filter(source -> source.getDate("modifytime") != null).map(source -> source.getDate("modifytime")).distinct().max(Date::compareTo).get();
    }

    private static void saveOrUpdateSrouce(DynamicObject group, DynamicObject[] sources) {
        if (group.getDynamicObject("pageinfo") == null) {
            LOGGER.warn(MessageFormat.format(ResManager.loadKDString((String)"\u4fe1\u606f\u7ec4\u6ce8\u518c\u6ca1\u6709\u7ed1\u5b9a\u5143\u6570\u636e\u4fe1\u606f\uff0cnumber\uff1a{0}\uff0cname\uff1a{1}\u3002", (String)"InfoGroupFieldHelper_0", (String)"hr-hspm-business", (Object[])new Object[0]), group.get("number"), group.get("name")));
            return;
        }
        String pageNumber = group.getDynamicObject("pageinfo").getString("number");
        Map fields = MetadataServiceHelper.getDataEntityType((String)pageNumber).getAllFields();
        if (CollectionUtils.isEmpty((Map)fields)) {
            return;
        }
        List<AttachmentPanelAp> attachs = InfoGroupFieldHelper.getAttachmentPanelAp(pageNumber);
        if (!CollectionUtils.isEmpty(attachs)) {
            List<AttachmentProp> props = InfoGroupFieldHelper.changeToAttachmentProp(attachs);
            for (AttachmentProp prop : props) {
                fields.put(prop.getName(), prop);
            }
        }
        DynamicObjectCollection addCollection = new DynamicObjectCollection();
        DynamicObjectCollection updateCollection = InfoGroupFieldHelper.createUpdateCollection(sources);
        Date createTime = new Date();
        Set<String> notEidtableFields = InfoGroupFieldHelper.getNotEditableFields(group);
        for (Map.Entry<String, IDataEntityProperty> entry : fields.entrySet()) {
            boolean isExist = InfoGroupFieldHelper.isExist(group, updateCollection, sources, entry, createTime);
            if (InfoGroupFilterFieldsHelper.isFilterField(group, entry.getKey()) || isExist) continue;
            addCollection.add((Object)InfoGroupFieldHelper.createNewAddDynamicObject(group, createTime, entry.getValue(), notEidtableFields));
        }
        boolean refreshDate = false;
        InfoGroupFieldHelper.handleDeleteField(sources, fields, updateCollection, createTime);
        if (!CollectionUtils.isEmpty((Collection)updateCollection)) {
            refreshDate = true;
            INFOGROUPFIELD_HEPLER.update((DynamicObject[])updateCollection.toArray((Object[])new DynamicObject[updateCollection.size()]));
        }
        if (!CollectionUtils.isEmpty((Collection)addCollection)) {
            refreshDate = true;
            INFOGROUPFIELD_HEPLER.save(addCollection);
        }
        if (!refreshDate && sources.length > 0) {
            sources[0].set("modifytime", (Object)createTime);
            INFOGROUPFIELD_HEPLER.update(new DynamicObject[]{sources[0]});
        }
        PICTUREFIELD_THREADLOCAL.remove();
    }

    private static List<AttachmentPanelAp> getAttachmentPanelAp(String pageNumber) {
        FormMetadata formMetadata;
        List apList;
        AbstractMetadata abstractMetadata;
        ArrayList<AttachmentPanelAp> list = new ArrayList<AttachmentPanelAp>();
        String id = MetadataDao.getIdByNumber((String)pageNumber, (MetaCategory)MetaCategory.Form);
        if (HRStringUtils.isNotEmpty((String)id) && (abstractMetadata = MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Form)) instanceof FormMetadata && !CollectionUtils.isEmpty((Collection)(apList = (formMetadata = (FormMetadata)abstractMetadata).getItems()))) {
            for (ControlAp ap : apList) {
                if (!(ap instanceof AttachmentPanelAp)) continue;
                list.add((AttachmentPanelAp)ap);
            }
        }
        return list;
    }

    private static List<AttachmentProp> changeToAttachmentProp(List<AttachmentPanelAp> list) {
        ArrayList<AttachmentProp> props = new ArrayList<AttachmentProp>();
        if (!CollectionUtils.isEmpty(list)) {
            for (AttachmentPanelAp ap : list) {
                AttachmentProp attachmentProp = new AttachmentProp();
                attachmentProp.setDisplayName(ap.getName());
                attachmentProp.setName(ap.getKey());
                attachmentProp.setMustInput(false);
                attachmentProp.setMaxAtmCount(ap.getMaxAtmCount());
                attachmentProp.setMaxAtmSize(ap.getMaxAtmSize());
                props.add(attachmentProp);
            }
        }
        return props;
    }

    private static boolean isExist(DynamicObject group, DynamicObjectCollection updateCollection, DynamicObject[] sources, Map.Entry<String, IDataEntityProperty> field, Date createTime) {
        Set<String> notEidtableFields = InfoGroupFieldHelper.getNotEditableFields(group);
        for (DynamicObject dynamicObject : sources) {
            if (!HRStringUtils.equals((String)dynamicObject.getString("number"), (String)field.getKey())) continue;
            boolean isNotEditable = InfoGroupFieldHelper.isNotEditableField(notEidtableFields, field.getKey());
            boolean change = InfoGroupFieldHelper.isChange(group, dynamicObject, field, isNotEditable);
            if (change) {
                dynamicObject.set("modifytime", (Object)createTime);
            } else {
                updateCollection.remove((Object)dynamicObject);
            }
            return true;
        }
        return false;
    }

    private static boolean isTotalGroupNotEditable(Set<String> notEditableFields) {
        return notEditableFields.contains("totalGroup");
    }

    private static boolean isNotEditableField(Set<String> notEditableFields, String fieldName) {
        return notEditableFields.contains(fieldName) || InfoGroupFieldHelper.isTotalGroupNotEditable(notEditableFields);
    }

    private static Set<String> getNotEditableFields(DynamicObject group) {
        HashSet<String> set = new HashSet<String>();
        String notEditableFields = group.getString("notEditableFields");
        if (HRStringUtils.isNotEmpty((String)notEditableFields)) {
            String[] notEditableFieldArray;
            for (String notEditableField : notEditableFieldArray = notEditableFields.split(",")) {
                set.add(notEditableField);
            }
        }
        return set;
    }

    private static DynamicObjectCollection createUpdateCollection(DynamicObject[] sources) {
        DynamicObjectCollection updateCollection = new DynamicObjectCollection();
        for (DynamicObject dynamicObject : sources) {
            updateCollection.add((Object)dynamicObject);
        }
        return updateCollection;
    }

    public static boolean getMustInput(IDataEntityProperty field) {
        if (field instanceof FieldProp) {
            return ((FieldProp)field).isMustInput();
        }
        if (field instanceof BasedataProp) {
            return ((BasedataProp)field).isMustInput();
        }
        if (field instanceof MulBasedataProp) {
            return ((MulBasedataProp)field).isMustInput();
        }
        if (field instanceof AttachmentProp) {
            return ((AttachmentProp)field).isMustInput();
        }
        throw new KDBizException("field type exception");
    }

    private static DynamicObject createNewAddDynamicObject(DynamicObject group, Date createTime, IDataEntityProperty field, Set<String> notEidtableFields) {
        String name = field.getName();
        LocaleString displayName = field.getDisplayName();
        Boolean isMust = InfoGroupFieldHelper.getMustInput(field);
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hspm_infogroupfield"));
        dynamicObject.set("group", (Object)group);
        dynamicObject.set("number", (Object)field.getName());
        dynamicObject.set("name", displayName != null ? displayName : name);
        dynamicObject.set("isrequired", (Object)isMust);
        FieldTypeEnum fieldTypeEnum = FieldTypeEnum.getFieldTypeByCode((String)field.getClass().getName());
        if (fieldTypeEnum == null) {
            throw new KDBizException(MessageFormat.format("not exist the fieldTypeEnum {0}", field.getClass().getName()));
        }
        dynamicObject.set("type", (Object)fieldTypeEnum.getType());
        dynamicObject.set("category", (Object)fieldTypeEnum.getCategroy().getValue());
        if (FieldTypeEnum.BASE_DATA == fieldTypeEnum && field instanceof BasedataProp) {
            BasedataProp basedataProp = (BasedataProp)field;
            dynamicObject.set("refkey", (Object)basedataProp.getBaseEntityId());
        } else if (FieldTypeEnum.AMOUNTPROP == fieldTypeEnum && field instanceof AmountProp) {
            AmountProp amountProp = (AmountProp)field;
            dynamicObject.set("refkey", (Object)amountProp.getControlPropName());
        } else if (field instanceof MulBasedataProp) {
            MulBasedataProp basedataProp = (MulBasedataProp)field;
            dynamicObject.set("refkey", (Object)basedataProp.getBaseEntityId());
            dynamicObject.set("tablename", (Object)basedataProp.getAlias());
        }
        InfoGroupFieldHelper.handleFieldLengthLimit(dynamicObject, field);
        dynamicObject.set("status", (Object)"C");
        dynamicObject.set("enable", (Object)"1");
        dynamicObject.set("isedit", (Object)(!InfoGroupFieldHelper.isNotEditableField(notEidtableFields, field.getName()) ? 1 : 0));
        dynamicObject.set("createtime", (Object)createTime);
        dynamicObject.set("modifytime", (Object)createTime);
        return dynamicObject;
    }

    private static boolean handleFieldLengthLimit(DynamicObject dynamicObject, IDataEntityProperty field) {
        String max = " ";
        String min = " ";
        int maxCount = 0;
        int precision = 0;
        int scale = 0;
        if (field instanceof TextProp) {
            TextProp textProp = (TextProp)field;
            max = String.valueOf(textProp.getMaxLenth());
            min = String.valueOf(textProp.getMinLenth());
        } else if (field instanceof AttachmentProp) {
            AttachmentProp attachmentProp = (AttachmentProp)field;
            max = String.valueOf(attachmentProp.getMaxAtmSize());
            maxCount = attachmentProp.getMaxAtmCount();
        } else if (field instanceof PictureProp) {
            PictureField pictureField;
            DynamicObject pageInfo = dynamicObject.getDynamicObject("group").getDynamicObject("pageinfo");
            if (pageInfo != null && (pictureField = InfoGroupFieldHelper.getPictureField(pageInfo.getString("number"), field.getName())) != null) {
                max = String.valueOf(pictureField.getMaxImgSize());
            }
        } else if (field instanceof DecimalProp) {
            DecimalProp decimalProp = (DecimalProp)field;
            if (decimalProp.getMax() != null) {
                max = decimalProp.getMax().toString();
            }
            if (decimalProp.getMin() != null) {
                min = decimalProp.getMin().toString();
            }
            precision = decimalProp.getPrecision();
            scale = decimalProp.getScale();
        }
        boolean isChange = false;
        if (!max.equals(dynamicObject.getString("max"))) {
            dynamicObject.set("max", (Object)max);
            isChange = true;
        }
        if (!min.equals(dynamicObject.getString("min"))) {
            dynamicObject.set("min", (Object)min);
            isChange = true;
        }
        if (maxCount != dynamicObject.getInt("maxcount")) {
            dynamicObject.set("maxcount", (Object)maxCount);
            isChange = true;
        }
        if (precision != dynamicObject.getInt("precision")) {
            dynamicObject.set("precision", (Object)precision);
            isChange = true;
        }
        if (scale != dynamicObject.getInt("scale")) {
            dynamicObject.set("scale", (Object)scale);
            isChange = true;
        }
        return isChange;
    }

    private static PictureField getPictureField(String pageNumber, String fieldName) {
        Map<String, PictureField> pictureFieldMap = PICTUREFIELD_THREADLOCAL.get();
        if (pictureFieldMap == null) {
            EntityMetadata entityMetadata;
            List items;
            AbstractMetadata abstractMetadata;
            pictureFieldMap = new HashMap<String, PictureField>(16);
            String id = MetadataDao.getIdByNumber((String)pageNumber, (MetaCategory)MetaCategory.Entity);
            if (HRStringUtils.isNotEmpty((String)id) && (abstractMetadata = MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Entity)) instanceof EntityMetadata && !CollectionUtils.isEmpty((Collection)(items = (entityMetadata = (EntityMetadata)abstractMetadata).getItems()))) {
                for (EntityItem item : items) {
                    if (!(item instanceof PictureField)) continue;
                    pictureFieldMap.put(pageNumber + ":" + item.getKey(), (PictureField)item);
                }
            }
            PICTUREFIELD_THREADLOCAL.set(pictureFieldMap);
        }
        return pictureFieldMap.get(pageNumber + ":" + fieldName);
    }

    private static void handleDeleteField(DynamicObject[] sources, Map<String, IDataEntityProperty> fields, DynamicObjectCollection updateCollection, Date modifyTime) {
        if (sources == null || sources.length == 0 || CollectionUtils.isEmpty(fields)) {
            return;
        }
        for (DynamicObject dynamicObject : sources) {
            boolean isExist = false;
            for (Map.Entry<String, IDataEntityProperty> field : fields.entrySet()) {
                String name = field.getKey();
                String fieldName = dynamicObject.getString("number");
                if (HRStringUtils.isEmpty((String)name) || !HRStringUtils.equals((String)name, (String)fieldName)) continue;
                isExist = true;
                break;
            }
            if (isExist) continue;
            dynamicObject.set("enable", (Object)"0");
            dynamicObject.set("modifytime", (Object)modifyTime);
            updateCollection.add((Object)dynamicObject);
        }
    }

    public static List<Long> getRefId(DynamicObjectCollection dynamicObjects) {
        List<Long> refIds = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            refIds = dynamicObjects.stream().filter(val -> val.getDynamicObject(MultiViewConfigConstants.REF_FIELD.intValue()) != null).map(val -> InfoGroupFieldHelper.getRefId(val)).collect(Collectors.toList());
        }
        return refIds;
    }

    public static List<Long> getGroupId(DynamicObjectCollection dynamicObjects) {
        List<Long> refIds = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            refIds = dynamicObjects.stream().filter(val -> val.getDynamicObject(MultiViewConfigConstants.REF_FIELD.intValue()) != null).filter(val -> val.getDynamicObject(MultiViewConfigConstants.REF_FIELD.intValue()).getDynamicObject("group") != null).map(val -> val.getDynamicObject(MultiViewConfigConstants.REF_FIELD.intValue()).getDynamicObject("group").getLong("id")).collect(Collectors.toList());
        }
        return refIds;
    }

    public static Long getRefId(DynamicObject dynamicObject) {
        if (dynamicObject != null && dynamicObject.getDynamicObject(MultiViewConfigConstants.REF_FIELD.intValue()) != null) {
            return dynamicObject.getDynamicObject(MultiViewConfigConstants.REF_FIELD.intValue()).getLong("id");
        }
        return 0L;
    }

    public static Set<Long> selectedGroupIds(DynamicObjectCollection dynamicObjects) {
        HashSet<Long> groupIdSet = new HashSet<Long>();
        if (!CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            boolean isMainArea = InfoGroupHelper.isMainArea((String)dynamicObjects.getDynamicObjectType().getName());
            String groupIdKey = InfoGroupHelper.getConfigArea((boolean)isMainArea).getCode() + "groupid";
            for (DynamicObject dy : dynamicObjects) {
                String groupId = dy.getString(groupIdKey);
                if ("root".equals(groupId) || groupId.startsWith("sub_")) continue;
                groupIdSet.add(Long.valueOf(groupId));
            }
        }
        return groupIdSet;
    }

    public static boolean isSubGroup(String nodeId) {
        return !HRStringUtils.isEmpty((String)nodeId) && nodeId.startsWith("sub_");
    }

    public static DynamicObject[] getAvailableGroup(Long belongId, String viewlocation, boolean isEmployee, List<String> pageNumbers) {
        QFilter groupFilter = new QFilter("group", "=", (Object)belongId).and("enable", "=", (Object)"1");
        if (!CollectionUtils.isEmpty(pageNumbers)) {
            groupFilter.and("pageinfo.number", "in", pageNumbers);
        }
        QFilter typeFilter = new QFilter("viewlocation", "=", (Object)viewlocation);
        if (ConfigAreaEnum.MAIN.getValue().equals(viewlocation)) {
            typeFilter.or("viewlocation", "=", (Object)ConfigAreaEnum.COMMON.getValue());
        }
        QFilter businessTypeFilter = new QFilter("businesstype", "=", (Object)BusinessTypeEnum.COMMON.getCode());
        if (isEmployee) {
            businessTypeFilter.or("businesstype", "=", (Object)BusinessTypeEnum.EMPLOYEE.getCode());
        } else {
            businessTypeFilter.or("businesstype", "=", (Object)BusinessTypeEnum.ADMIN.getCode());
        }
        return INFOGROUPPAGEREG_HELPER.query("pageinfo", new QFilter[]{groupFilter, typeFilter, businessTypeFilter});
    }

    public static String getPageInfoNumber(DynamicObject pageRegDy) {
        if (pageRegDy != null && pageRegDy.getDynamicObject("pageinfo") != null) {
            return pageRegDy.getDynamicObject("pageinfo").getString("number");
        }
        return null;
    }

    public static String getPageInfoNumber(Long groupId) {
        if (groupId != null && groupId > 0L) {
            DynamicObject pageRegDy = INFOGROUPPAGEREG_HELPER.queryOne("pageinfo", (Object)groupId);
            return InfoGroupFieldHelper.getPageInfoNumber(pageRegDy);
        }
        return null;
    }
}

