/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.infogroup;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hspm.business.multiview.MultiViewTemplateService;
import kd.hr.hspm.business.util.PersonModelUtil;
import kd.hr.hspm.common.constants.BusinessTypeEnum;
import kd.hr.hspm.common.constants.ConfigAreaEnum;
import kd.hr.hspm.common.constants.DynConfigConstants;
import kd.hr.hspm.common.constants.InfoGroupFieldCategroyEnum;
import kd.hr.hspm.common.constants.MultiViewConfigConstants;
import kd.hr.hspm.common.constants.PersonModelClassificationEnum;

@Deprecated
public class InfoGroupHelper {
    private static final Log LOGGER = LogFactory.getLog(InfoGroupHelper.class);
    private static final String HRPI_SINGLEROWTPL_ID = "15AY49FHMMO6";
    private static final String HRPI_NONTIMEHISSINGLETPL_ID = "21ZNULG+9Q7D";
    private static final String HRPI_HRPI_TIMEHISTPL_ID = "21YR3KJ5/NUQ";
    private static final String SINGLEROW_CACHEKEY = "SINGLEROW_CACHEKEY:";
    private static final String HINT_CACHEKEY = "HINT_CACHEKEY_%s_%s";
    private static final String HSPM_EMPCONFIGPREVIEW = "hspm_empconfigpreview";

    public static boolean isSingleRowTpl(String pageNumber) {
        if (!HRStringUtils.isEmpty((String)pageNumber)) {
            String cacheKey;
            IHRAppCache hrAppCache = HRAppCache.get((String)"hspm");
            Boolean isSingle = (Boolean)hrAppCache.get(cacheKey = SINGLEROW_CACHEKEY + pageNumber, Boolean.class);
            if (isSingle != null) {
                return isSingle;
            }
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)pageNumber);
            if (mainEntityType != null && !HRStringUtils.isEmpty((String)mainEntityType.getInheritPath())) {
                String[] parents;
                for (String parent : parents = mainEntityType.getInheritPath().split(",")) {
                    if (!HRPI_SINGLEROWTPL_ID.equals(parent) && !HRPI_NONTIMEHISSINGLETPL_ID.equals(parent)) continue;
                    hrAppCache.put(pageNumber, (Object)Boolean.TRUE);
                    return true;
                }
                if (parents.length > 0 && HRPI_HRPI_TIMEHISTPL_ID.equals(parents[parents.length - 1])) {
                    hrAppCache.put(pageNumber, (Object)Boolean.TRUE);
                    return true;
                }
            }
            hrAppCache.put(pageNumber, (Object)Boolean.FALSE);
        }
        return false;
    }

    public static Long getCurrentGroup(DynamicObjectCollection dynamicObjects, String nodeId) {
        boolean isMainArea = InfoGroupHelper.isMainArea(dynamicObjects.getDynamicObjectType().getName());
        String prex = InfoGroupHelper.getConfigArea(isMainArea).getCode();
        String groupIdKey = prex + "groupid";
        Optional<DynamicObject> optional = dynamicObjects.stream().filter(val -> nodeId.equals(val.getString(groupIdKey))).findAny();
        if (optional.isPresent()) {
            List<SubEntryProp> subEntryProps = InfoGroupHelper.getSubEntryProp(dynamicObjects.getDynamicObjectType().getProperties());
            for (SubEntryProp subEntryProp : subEntryProps) {
                DynamicObjectCollection fields = (DynamicObjectCollection)subEntryProp.getValue((Object)optional.get());
                if (CollectionUtils.isEmpty((Collection)fields)) continue;
                for (DynamicObject field : fields) {
                    DynamicObject ref = field.getDynamicObject(MultiViewConfigConstants.REF_FIELD.intValue());
                    if (ref == null || ref.getDynamicObject("group") == null) continue;
                    return ref.getDynamicObject("group").getLong("id");
                }
            }
        }
        return 0L;
    }

    public static String getCurrentEntityKey(boolean isMainArea) {
        return isMainArea ? "maingroupentity" : "sidegroupentity";
    }

    public static ConfigAreaEnum getConfigArea(boolean isMainArea) {
        return isMainArea ? ConfigAreaEnum.MAIN : ConfigAreaEnum.SIDE;
    }

    public static boolean isMainArea(String key) {
        return HRStringUtils.isEmpty((String)key) || !key.startsWith(ConfigAreaEnum.SIDE.getCode());
    }

    public static boolean existDefaultRow(DynamicObjectCollection dynamicObjectCollection) {
        return !CollectionUtils.isEmpty((Collection)dynamicObjectCollection) && ((DynamicObject)dynamicObjectCollection.get(0)).getDynamicObject(MultiViewConfigConstants.REF_FIELD.intValue()) == null;
    }

    public static void removeDefaultRowIFAbsent(DynamicObjectCollection dynamicObjectCollection) {
        if (InfoGroupHelper.existDefaultRow(dynamicObjectCollection)) {
            dynamicObjectCollection.remove(0);
        }
    }

    public static String getTabText(String tabKey) {
        InfoGroupFieldCategroyEnum categroy = InfoGroupFieldCategroyEnum.getByFuzzyCode((String)tabKey);
        if (InfoGroupFieldCategroyEnum.TEXT == categroy) {
            return ResManager.loadKDString((String)"\u6587\u672c\u7c7b\u4fe1\u606f", (String)"InfoGroupSynAndValidatorHelper_4", (String)"hr-hspm-business", (Object[])new Object[0]);
        }
        if (InfoGroupFieldCategroyEnum.IMG == categroy) {
            return ResManager.loadKDString((String)"\u56fe\u7247\u7c7b\u4fe1\u606f", (String)"InfoGroupSynAndValidatorHelper_5", (String)"hr-hspm-business", (Object[])new Object[0]);
        }
        if (InfoGroupFieldCategroyEnum.ATTACH == categroy) {
            return ResManager.loadKDString((String)"\u9644\u4ef6\u7c7b\u4fe1\u606f", (String)"InfoGroupSynAndValidatorHelper_6", (String)"hr-hspm-business", (Object[])new Object[0]);
        }
        throw new KDBizException("category exception");
    }

    public static List<String> getSubGroupIds(DynamicObjectCollection dynamicObjects, String nodeId) {
        boolean isMainArea = InfoGroupHelper.isMainArea(dynamicObjects.getDynamicObjectType().getName());
        ArrayList<String> ids = new ArrayList<String>();
        boolean isRoot = "root".equals(nodeId);
        if (!CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            String prex = InfoGroupHelper.getConfigArea(isMainArea).getCode();
            String groupIdKey = prex + "groupid";
            String parentGroupIdKey = prex + "parentgroupid";
            for (DynamicObject dy : dynamicObjects) {
                String groupId = dy.getString(groupIdKey);
                if ("root".equals(groupId)) continue;
                if (isRoot) {
                    if (!groupId.startsWith("sub_") && !CollectionUtils.isEmpty(InfoGroupHelper.getSubGroupIds(dynamicObjects, groupId))) continue;
                    ids.add(groupId);
                    continue;
                }
                if (!HRStringUtils.equals((String)dy.getString(parentGroupIdKey), (String)nodeId)) continue;
                ids.add(groupId);
            }
        }
        return ids;
    }

    public static List<SubEntryProp> getSubEntryProp(DataEntityPropertyCollection properties) {
        return properties.stream().filter(val -> val instanceof SubEntryProp).map(val -> (SubEntryProp)val).collect(Collectors.toList());
    }

    public static Map<String, SubEntryProp> changeToSubEntryPropsMap(List<SubEntryProp> subEntryProps) {
        HashMap<String, SubEntryProp> map = new HashMap<String, SubEntryProp>(subEntryProps.size());
        for (SubEntryProp entryProp : subEntryProps) {
            InfoGroupFieldCategroyEnum fieldCategroyEnum = InfoGroupFieldCategroyEnum.getByFuzzyCode((String)entryProp.getName());
            map.put(fieldCategroyEnum.getValue(), entryProp);
        }
        return map;
    }

    public static void closeGuideFlex(IFormView view) {
        if (view != null && view.getParentView() != null) {
            view.setVisible(Boolean.FALSE, new String[]{"guideflex"});
            view.getParentView().getPageCache().put("guideflex", "false");
        }
    }

    public static boolean isExistField(DynamicObject group) {
        List<SubEntryProp> subEntryProps;
        if (group != null && !CollectionUtils.isEmpty(subEntryProps = InfoGroupHelper.getSubEntryProp(group.getDynamicObjectType().getProperties()))) {
            for (SubEntryProp subEntryProp : subEntryProps) {
                DynamicObjectCollection fields = (DynamicObjectCollection)subEntryProp.getValue((Object)group);
                InfoGroupHelper.removeDefaultRowIFAbsent(fields);
                if (CollectionUtils.isEmpty((Collection)fields)) continue;
                return true;
            }
        }
        return false;
    }

    public static void showHint(IFormView view) {
        InfoGroupHelper.isShowGuide(view);
        InfoGroupHelper.setSummaryHint(view, "headsummaryhint");
        InfoGroupHelper.setSummaryHint(view, "mainsummaryhint");
        InfoGroupHelper.setSummaryHint(view, "sidesummaryhint");
    }

    private static void setSummaryHint(IFormView view, String key) {
        String prompt;
        if (view.getControl(key) instanceof Label && HRStringUtils.isNotEmpty((String)(prompt = InfoGroupHelper.queryPromptForString(view, key)))) {
            Label label = (Label)view.getControl(key);
            label.setText(prompt);
        }
    }

    public static String queryPromptForString(IFormView view, String key) {
        String cacheKey = String.format(HINT_CACHEKEY, Lang.get().toString(), key);
        String prompt = null;
        IPageCache pageCache = null;
        if (view.getParentView() != null) {
            pageCache = view.getParentView().getPageCache();
            prompt = pageCache.get(cacheKey);
        }
        if (prompt == null) {
            List list = null;
            try {
                list = (List)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSService", (String)"queryPromptForString", (Object[])new Object[]{view.getFormShowParameter().getFormId(), key, view.getModel().getDataEntity()});
                LOGGER.info(MessageFormat.format("queryPromptForString_rep:{0}", list));
            }
            catch (Exception e) {
                LOGGER.error("queryPromptForString_ex:", (Throwable)e);
            }
            prompt = list != null && !list.isEmpty() ? (String)list.get(0) : "";
            if (pageCache != null) {
                pageCache.put(cacheKey, prompt);
            }
        }
        return prompt;
    }

    private static void isShowGuide(IFormView view) {
        IPageCache pageCache;
        if (view != null && view.getParentView() != null && "false".equals((pageCache = view.getParentView().getPageCache()).get("guideflex"))) {
            view.setVisible(Boolean.FALSE, new String[]{"guideflex"});
        }
    }

    public static boolean isEmployee(IDataModel model) {
        return model.getDataEntity().getBoolean("employee");
    }

    public static QFilter getBusinessTypeFilter(IFormView view) {
        QFilter filter = new QFilter("businesstype", "=", (Object)BusinessTypeEnum.COMMON.getCode());
        if (view.getModel().getDataEntity().getBoolean("employee")) {
            filter.or("businesstype", "=", (Object)BusinessTypeEnum.EMPLOYEE.getCode());
        } else {
            filter.or("businesstype", "=", (Object)BusinessTypeEnum.ADMIN.getCode());
        }
        return filter;
    }

    public static void setGroupOpEnable(IFormView view, String pageNumber, String prefix) {
        if (HRStringUtils.isNotEmpty((String)pageNumber)) {
            String isAllowAddOpKey = prefix + "isallowadd" + "op";
            boolean single = InfoGroupHelper.isSingleRowTpl(pageNumber);
            PersonModelClassificationEnum classification = PersonModelUtil.getClassification(pageNumber);
            if (PersonModelClassificationEnum.PERATTACHED == classification) {
                view.setEnable(Boolean.TRUE, new String[]{prefix + "iseditall", prefix + "isrequiredall", prefix + "isauditall"});
                if (single) {
                    view.setEnable(Boolean.FALSE, new String[]{isAllowAddOpKey});
                } else {
                    view.setEnable(Boolean.TRUE, new String[]{isAllowAddOpKey});
                }
            } else {
                view.setEnable(Boolean.FALSE, new String[]{prefix + "iseditall", prefix + "isrequiredall", prefix + "isauditall"});
                if (!single && "hrpi_personrolerel".equals(pageNumber)) {
                    view.setEnable(Boolean.TRUE, new String[]{isAllowAddOpKey});
                } else {
                    view.setEnable(Boolean.FALSE, new String[]{isAllowAddOpKey});
                }
            }
        }
    }

    public static void showPreview(Object pkId, IFormView view) {
        String formId;
        String string = formId = view instanceof ListView ? ((ListView)view).getBillFormId() : view.getEntityId();
        if ("hspm_multiviewconfigemp".equals(formId)) {
            InfoGroupHelper.empPreview(pkId, view);
            return;
        }
        FormShowParameter form = new FormShowParameter();
        MultiViewTemplateService.getInstance().commonForm(form, "hspm_erfilelistdv", null, ShowType.MainNewTabPage);
        form.setCustomParam("cnfid", pkId);
        form.setCustomParam("preview", (Object)"preview");
        form.setStatus(OperationStatus.VIEW);
        form.setCustomParam("employee", (Object)DynConfigConstants.VIRTURAL_PREVIEW_USER);
        form.setCustomParam("cmpemp", (Object)DynConfigConstants.VIRTURAL_PREVIEW_USER);
        form.setCustomParam("person", (Object)DynConfigConstants.VIRTURAL_PREVIEW_USER);
        form.setCustomParam("depemp", (Object)DynConfigConstants.VIRTURAL_PREVIEW_USER);
        form.setSendToClient(false);
        view.showForm(form);
    }

    private static void empPreview(Object pkId, IFormView view) {
        FormShowParameter form = new FormShowParameter();
        form.getOpenStyle().setShowType(ShowType.Modal);
        form.setCustomParam("cnfid", pkId);
        form.setStatus(OperationStatus.VIEW);
        form.setFormId(HSPM_EMPCONFIGPREVIEW);
        view.showForm(form);
    }
}

