/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.mservice.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.fileservice.extension.FileServiceExtFactory;
import kd.bos.form.control.UrlUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.attachment.AttachmentServiceImpl;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.util.io.ByteArrayOutputStream;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hspm.business.mservice.IHspmOcrService;
import kd.hr.hspm.common.entity.ocr.AlgoResultData;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;

public class HspmOcrServiceImpl
implements IHspmOcrService {
    private static CloseableHttpClient httpClient = HttpClients.createDefault();
    private static final Log logger = LogFactory.getLog(HspmOcrServiceImpl.class);
    private static final String API = "/face/detect";
    private static final String HTTP_METHOD = "POST";
    private static final String NEXT_LINE = "\n";
    private static final String KEY_CLIENT_ID = "X-Api-ClientID";
    private static final String KEY_AUTH_VERSION = "X-Api-Auth-Version";
    private static final String VALUE_AUTH_VERSION = "2.0";
    private static final String KEY_TIMESTAMP = "X-Api-TimeStamp";
    private static final String KEY_NONCE = "X-Api-Nonce";
    private static final String KEY_SIGN_HEADERS = "X-Api-SignHeaders";
    private static final String VALUE_SIGN_HEADERS = "X-Api-TimeStamp,X-Api-Nonce";
    private static final String KEY_SIGNATURE = "X-Api-Signature";
    private static final char COLON = ':';
    private static final Pattern PATTERN = Pattern.compile("(\\\\u(\\p{XDigit}{4}))");

    @Override
    public AlgoResultData distinguishOcrImage(String businessObject, String templateNumber, String url) {
        try {
            String imageData = "";
            if (url.endsWith("-expAttach")) {
                String imgUrl = url.substring(0, url.lastIndexOf("-expAttach"));
                imageData = HspmOcrServiceImpl.imageToBase64ByOnline(imgUrl);
                logger.info("imageDataExp=={}==url=={}", (Object)imageData, (Object)imgUrl);
            } else {
                imageData = Base64.getEncoder().encodeToString(this.getImageByte(url));
            }
            if (HRStringUtils.isEmpty((String)imageData)) {
                logger.error("imageToBase64 empty, url:{}!", (Object)url);
                return null;
            }
            logger.info("imageData base64: {}", (Object)imageData);
            Object[] params = new Object[]{businessObject, templateNumber, imageData};
            String result = (String)DispatchServiceHelper.invokeBizService((String)"ai", (String)"cvp", (String)"OcrService", (String)"distinguishOcrImage", (Object[])params);
            AlgoResultData data = (AlgoResultData)SerializationUtils.fromJsonString((String)result, AlgoResultData.class);
            if (data.getErrorCode() != 0) {
                logger.error("OcrService.distinguishOcrImage failed, requestId: {}, errorCode: {}, description: {}", new Object[]{data.getRequestId(), data.getErrorCode(), data.getDescription()});
            }
            return data;
        }
        catch (Exception exception) {
            logger.error("invoke OcrService.distinguishOcrImage failed!", (Throwable)exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String imageToBase64ByOnline(String imgURL) throws IOException {
        InputStream is = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        byte[] byteData = null;
        try {
            logger.info(String.format(Locale.ROOT, "imageToBase64ByOnline %s", imgURL));
            String path = "path=/";
            AttachmentServiceImpl attachmentService = new AttachmentServiceImpl();
            boolean flag = false;
            if (attachmentService.isEncrptyPath() && imgURL.contains(path)) {
                int index = imgURL.indexOf(path);
                String first = imgURL.substring(0, index + path.length() - 1);
                String end = imgURL.substring(index + path.length());
                if (imgURL.contains("attachment/download.do")) {
                    flag = true;
                    imgURL = first + FileServiceExtFactory.getAttachFileServiceExt().getRealPath(end);
                }
            }
            if (!flag) {
                imgURL = FileServiceExtFactory.getImageFileServiceExt().getRealPath(imgURL);
            }
            logger.info(imgURL);
            if (imgURL.contains("tempfile/download.do?configKey")) {
                byteArrayOutputStream = new ByteArrayOutputStream();
                is = CacheFactory.getCommonCacheFactory().getTempFileCache().getInputStream(imgURL);
                byte[] by = new byte[1024];
                int len = -1;
                while ((len = is.read(by)) != -1) {
                    byteArrayOutputStream.write(by, 0, len);
                }
                byteData = byteArrayOutputStream.toByteArray();
                logger.info("CacheFactory.getCommonCacheFactory().getTempFileCache()");
            }
            if (is == null) {
                byteData = HspmOcrServiceImpl.getByteWithHttpUrl(imgURL);
            }
        }
        catch (IOException exception) {
            logger.error("imageToBase64ByOnline fail:", (Throwable)exception);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
        }
        return Base64.getEncoder().encodeToString(byteData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getImageByte(String imgUrl) {
        InputStream is = null;
        try {
            int len;
            String urlByParse;
            if (!imgUrl.endsWith("-expAttach")) {
                is = imgUrl.contains("tempfile/download.do?configKey") ? CacheFactory.getCommonCacheFactory().getTempFileCache().getInputStream(imgUrl) : (HRStringUtils.isEmpty((String)(urlByParse = UrlUtil.getParam((String)imgUrl, (String)"path"))) ? FileServiceFactory.getImageFileService().getInputStream(imgUrl) : FileServiceFactory.getAttachmentFileService().getInputStream(urlByParse));
            }
            if (is == null) {
                logger.warn("InputStreamEmpty");
                urlByParse = null;
                return urlByParse;
            }
            ByteArrayOutputStream data = new ByteArrayOutputStream();
            byte[] by = new byte[1024];
            while ((len = is.read(by)) != -1) {
                data.write(by, 0, len);
            }
            byte[] byArray = data.toByteArray();
            return byArray;
        }
        catch (IOException exception) {
            logger.error("imageToBase64 IOException, url:{}!", (Object)imgUrl, (Object)exception);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioException) {
                    logger.error("InputStream close exception!", (Throwable)ioException);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getByteWithHttpUrl(String fileUrl) {
        logger.info("FileServiceUtils.getByteWithHttpUrl");
        InputStream is = null;
        ByteArrayOutputStream buffer = null;
        try {
            String[] fileServers;
            String tempURL;
            String httpUrlPrefix;
            if (fileUrl.contains("attachment/download.do")) {
                httpUrlPrefix = System.getProperty("attachmentServer.url");
                tempURL = fileUrl.substring(fileUrl.indexOf("=") + 1);
                tempURL = !httpUrlPrefix.endsWith("/") && !tempURL.startsWith("/") ? httpUrlPrefix + "/" + tempURL : httpUrlPrefix + tempURL;
            } else {
                tempURL = fileUrl.contains("/images/mobile") || fileUrl.contains("fileserver") ? HRImageUrlUtil.getImageFullUrl((String)fileUrl) : (!(httpUrlPrefix = System.getProperty("imageServer.url")).endsWith("/") && !fileUrl.startsWith("/") ? httpUrlPrefix + "/" + fileUrl : httpUrlPrefix + fileUrl);
            }
            logger.info(tempURL);
            String[] split = tempURL.split("\\?");
            if (split != null && split.length == 2) {
                tempURL = split[0] + "?" + URLEncoder.encode(split[1], "UTF-8");
            }
            if ((fileServers = tempURL.split("/fileserver/")) != null && fileServers.length == 2) {
                tempURL = fileServers[0] + "/fileserver/" + URLEncoder.encode(fileServers[1], "UTF-8");
            }
            URL url = new URL(tempURL);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(5000);
            is = conn.getInputStream();
            buffer = new ByteArrayOutputStream();
            byte[] bytes = new byte[1024];
            int lenRead = -1;
            while ((lenRead = is.read(bytes, 0, bytes.length)) != -1) {
                buffer.write(bytes, 0, lenRead);
            }
            buffer.flush();
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
        catch (ClientProtocolException clientProtocolException) {
            logger.error((Throwable)clientProtocolException);
        }
        catch (IOException exception) {
            logger.error((Throwable)exception);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                    logger.info("InputStream closed");
                }
                if (buffer != null) {
                    buffer.close();
                }
            }
            catch (IOException exception) {
                logger.error((Throwable)exception);
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    @Override
    public AlgoResultData detectFaceImage(String imageUrl) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Header[] kdCloudPlatformHeader(String method, String url, TreeMap<String, String> paramMap, String traceId) throws Exception {
        String xApiClientID = System.getProperty("hr.client.id", "201230");
        String xApiAuthVersion = VALUE_AUTH_VERSION;
        final String xApiTimeStamp = String.valueOf(System.currentTimeMillis() / 1000L);
        final String xApiNonce = UUID.randomUUID().toString().replace("-", "");
        TreeMap<String, String> xApiSignHeaders = new TreeMap<String, String>(){
            private static final long serialVersionUID = 3083723355901877770L;
            {
                this.put(HspmOcrServiceImpl.KEY_NONCE, xApiNonce);
                this.put(HspmOcrServiceImpl.KEY_TIMESTAMP, xApiTimeStamp);
            }
        };
        String xApiSecretID = System.getProperty("hr.client.secret");
        String signature = URLEncoder.encode(HspmOcrServiceImpl.sign(method, url, paramMap, xApiSignHeaders, xApiSecretID), "utf-8").replaceAll("%0D%0A", "%20");
        return new BasicHeader[]{new BasicHeader(KEY_CLIENT_ID, xApiClientID), new BasicHeader(KEY_AUTH_VERSION, xApiAuthVersion), new BasicHeader(KEY_TIMESTAMP, String.valueOf(xApiTimeStamp)), new BasicHeader(KEY_NONCE, String.valueOf(xApiNonce)), new BasicHeader(KEY_SIGN_HEADERS, VALUE_SIGN_HEADERS), new BasicHeader("X-Request-Id", traceId), new BasicHeader(KEY_SIGNATURE, URLDecoder.decode(signature, "utf-8").replaceAll(" ", "")), new BasicHeader("accept", "*/*"), new BasicHeader("connection", "Keep-Alive")};
    }

    public static String sign(String method, String url, TreeMap<String, String> params, TreeMap<String, String> headers, String key) throws Exception {
        String paramsString;
        String source = method.toUpperCase() + NEXT_LINE;
        source = source + URLEncoder.encode(url, "utf-8") + NEXT_LINE;
        StringBuilder sb = new StringBuilder();
        if (params != null) {
            for (Map.Entry<String, String> obj : params.entrySet()) {
                sb.append(URLEncoder.encode(obj.getKey(), "utf-8")).append('=').append(URLEncoder.encode(obj.getValue(), "utf-8")).append('&');
            }
        }
        if ((paramsString = sb.toString()).length() > 0) {
            paramsString = paramsString.substring(0, paramsString.length() - 1);
            source = source + paramsString + NEXT_LINE;
        } else {
            source = source + paramsString + NEXT_LINE;
        }
        sb = new StringBuilder();
        for (Map.Entry<String, String> obj : headers.entrySet()) {
            sb.append(obj.getKey().toLowerCase()).append(':').append(obj.getValue().trim()).append('\n');
        }
        StringBuilder sourceBuild = new StringBuilder(source);
        sourceBuild.append((CharSequence)sb);
        return HspmOcrServiceImpl.hmac(sourceBuild.toString(), key);
    }

    public static String kdCloudHttpClientTraceIdPost(String url, String api, HttpEntity httpEntity, String traceId) throws Exception {
        String method = HTTP_METHOD;
        Header[] headers = HspmOcrServiceImpl.kdCloudPlatformHeader(method, api, null, traceId);
        String respStr = HspmOcrServiceImpl.httpClientPostByHttpEntity(httpClient, url, httpEntity, headers);
        return HspmOcrServiceImpl.unicodeDecode(respStr);
    }

    private static String hmac(String source, String key) throws Exception {
        byte[] keyBytes = key.getBytes(StandardCharsets.ISO_8859_1);
        SecretKeySpec signingKey = new SecretKeySpec(keyBytes, "HmacSHA256");
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(signingKey);
        byte[] rawHmac = mac.doFinal(source.getBytes(StandardCharsets.ISO_8859_1));
        byte[] bytes1 = HspmOcrServiceImpl.bytesToHex(rawHmac);
        Base64.Encoder encoder = Base64.getEncoder();
        byte[] bytes = encoder.encode(bytes1);
        String encode = new String(bytes, StandardCharsets.UTF_8);
        return encode;
    }

    private static byte[] bytesToHex(byte[] hashInBytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < hashInBytes.length; ++i) {
            String hex = Integer.toHexString(hashInBytes[i] & 0xFF);
            if (hex.length() < 2) {
                hex = '0' + hex;
            }
            sb.append(hex);
        }
        return sb.toString().getBytes(StandardCharsets.ISO_8859_1);
    }

    public static String httpClientPostByHttpEntity(CloseableHttpClient httpClient, String url, HttpEntity httpEntity, Header[] headers) throws Exception {
        String result;
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity(httpEntity);
        httpPost.setHeaders(headers);
        try (CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);){
            result = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException var20) {
            throw new KDBizException(ResManager.loadKDString((String)"\u89c6\u89c9\u8bc6\u522b\u670d\u52a1\u8bf7\u6c42\u5f02\u5e38,\u8bf7\u91cd\u8bd5\u3002", (String)"HspmOcrServiceImpl_0", (String)"hr-hspm-business", (Object[])new Object[0]));
        }
        logger.info(String.format("%s \u63a5\u53e3,\u8c03\u7528\u4e91\u5e73\u53f0\u7b97\u6cd5\u8bc6\u522b\u8fd4\u56de\u4fe1\u606f: %s", url, result));
        return result;
    }

    private static String getOcrServiceIp() {
        StringBuilder servicePath = new StringBuilder();
        String ip = System.getProperty("hr.algo.ocr.service.ip", "http://bj2-api.kingdee.com");
        if (StringUtils.isEmpty((String)ip)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u89c6\u89c9\u8bc6\u522b\u7684\u670d\u52a1\u5730\u5740,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u3002", (String)"HspmOcrServiceImpl_1", (String)"hr-hspm-business", (Object[])new Object[0]));
        }
        if ((ip = ip.trim()).endsWith("/")) {
            ip = ip.substring(0, ip.lastIndexOf(47));
        }
        servicePath.append(ip);
        return servicePath.toString();
    }

    public static String getImageFullUrl(String relativeUrl) {
        String igameServerUrl = System.getProperty("imageServer.url");
        if (relativeUrl.startsWith("/")) {
            return igameServerUrl + relativeUrl;
        }
        return igameServerUrl + "/" + relativeUrl;
    }

    private HttpEntity getHttpFileEntity(String imageUrl) {
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        multipartEntityBuilder.setCharset(StandardCharsets.UTF_8);
        multipartEntityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        byte[] imageData = this.getImageByte(imageUrl);
        if (imageData == null || imageData.length <= 0) {
            return null;
        }
        InputStreamBody bin = new InputStreamBody((InputStream)new ByteArrayInputStream(imageData), new Date().getTime() + ".png");
        multipartEntityBuilder.addPart("image_file", (ContentBody)bin);
        return multipartEntityBuilder.build();
    }

    private static String unicodeDecode(String string) {
        Matcher matcher = PATTERN.matcher(string);
        while (matcher.find()) {
            char ch = (char)Integer.parseInt(matcher.group(2), 16);
            string = string.replace(matcher.group(1), ch + "");
        }
        return string;
    }

    private Header[] buildHeader() {
        String timeStamp = String.valueOf(System.currentTimeMillis());
        String xApiNonce = UUID.randomUUID().toString().replace("-", "");
        SecretKeySpec signingKey = new SecretKeySpec(System.getProperty("hr.ocr.client.secret").getBytes(StandardCharsets.ISO_8859_1), "HmacSHA256");
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(signingKey);
            String srcBuilder = "POST\n" + URLEncoder.encode(API, "utf-8") + NEXT_LINE + NEXT_LINE + "x-api-nonce" + ':' + xApiNonce + NEXT_LINE + "x-api-timestamp" + ':' + timeStamp + NEXT_LINE;
            byte[] rawHmac = mac.doFinal(srcBuilder.getBytes(StandardCharsets.ISO_8859_1));
            StringBuilder sb = new StringBuilder();
            for (byte b : rawHmac) {
                String hex = Integer.toHexString(b & 0xFF);
                if (hex.length() < 2) {
                    hex = '0' + hex;
                }
                sb.append(hex);
            }
            String signature = new String(Base64.getEncoder().encode(sb.toString().getBytes(StandardCharsets.ISO_8859_1)), StandardCharsets.UTF_8);
            return new BasicHeader[]{new BasicHeader(KEY_CLIENT_ID, System.getProperty("hr.ocr.client.id")), new BasicHeader(KEY_AUTH_VERSION, VALUE_AUTH_VERSION), new BasicHeader(KEY_TIMESTAMP, timeStamp), new BasicHeader(KEY_NONCE, xApiNonce), new BasicHeader(KEY_SIGN_HEADERS, VALUE_SIGN_HEADERS), new BasicHeader(KEY_SIGNATURE, signature), new BasicHeader("accept", "*/*"), new BasicHeader("connection", "Keep-Alive")};
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            logger.error("noSuchAlgorithmException: HmacSHA256!", (Throwable)noSuchAlgorithmException);
            return null;
        }
        catch (InvalidKeyException invalidKeyException) {
            logger.error("invalidKeyException: mac.init!", (Throwable)invalidKeyException);
            return null;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.error("unsupportedEncodingException: utf-8!", (Throwable)unsupportedEncodingException);
            return null;
        }
    }
}

