/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.revise;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.utils.HpfsPersonInfoParamUtil;
import kd.sdk.hr.hspm.business.repository.ErmanFileRepository;
import kd.sdk.hr.hspm.business.revise.helper.DynamicConvertUtils;
import kd.sdk.hr.hspm.business.revise.helper.ReviseEntityNameHelperEnum;
import kd.sdk.hr.hspm.common.utils.HspmDateUtils;
import org.apache.curator.shaded.com.google.common.collect.Maps;

public class PersonReviseService {
    private static final Log logger = LogFactory.getLog(PersonReviseService.class);
    private Set<String> needCompareTreeField = Sets.newHashSetWithExpectedSize((int)16);
    private String selectFields;

    public PersonReviseService() {
    }

    public PersonReviseService(boolean initFieldData, String baseEntityName) {
        if (initFieldData) {
            this.initFieldData(baseEntityName);
        }
    }

    public DynamicObject[] getHisVersions(Map<String, Object> customParams) {
        String entityName = (String)customParams.get("entityname");
        Long employeeId = (Long)customParams.get("employeeid");
        Long ermanFileId = (Long)customParams.get("ermanfileid");
        Long personId = (Long)customParams.get("personid");
        return this.getHisVersions(entityName, employeeId, ermanFileId, personId, false, false, true);
    }

    public DynamicObject[] getHisVersions(String baseEntityName, Long employeeId, Long ermanFileId, Long personId, boolean queryRevise, boolean containsCurVersion) {
        ArrayList commonFilterList = Lists.newArrayListWithExpectedSize((int)16);
        if (!containsCurVersion) {
            commonFilterList.add(new QFilter("iscurrentversion", "=", (Object)"0"));
        }
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        QFilter dataFilter = queryRevise ? new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus(), EnumHisDataVersionStatus.REVISED.getStatus(), EnumHisDataVersionStatus.DISCARDED.getStatus())) : new QFilter("datastatus", "in", Arrays.asList("1", "2"));
        QFilter employeeIdFilter = new QFilter("employee", "=", (Object)employeeId);
        commonFilterList.add(employeeIdFilter);
        commonFilterList.add(initStatusFilter);
        commonFilterList.add(dataFilter);
        List<QFilter> systemConfigFilter = this.getSystemConfigFilter(baseEntityName, ermanFileId, personId, commonFilterList, employeeIdFilter);
        commonFilterList.addAll(systemConfigFilter);
        HRBaseServiceHelper helper = new HRBaseServiceHelper(baseEntityName);
        String orderBy = ReviseEntityNameHelperEnum.getReviseOrderByByBaseEntityName((String)baseEntityName);
        return helper.query(this.selectFields, commonFilterList.toArray(new QFilter[0]), orderBy);
    }

    public DynamicObject[] getHisVersions(String baseEntityName, Long employeeId, Long ermanFileId, Long personId, boolean queryRevise, boolean containsCurVersion, boolean includeSystemConfigFilter) {
        ArrayList commonFilterList = Lists.newArrayListWithExpectedSize((int)16);
        if (!containsCurVersion) {
            commonFilterList.add(new QFilter("iscurrentversion", "=", (Object)"0"));
        }
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        QFilter dataFilter = queryRevise ? new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus(), EnumHisDataVersionStatus.REVISED.getStatus(), EnumHisDataVersionStatus.DISCARDED.getStatus())) : new QFilter("datastatus", "in", Arrays.asList("1", "2"));
        QFilter employeeIdFilter = new QFilter("employee", "=", (Object)employeeId);
        commonFilterList.add(employeeIdFilter);
        commonFilterList.add(initStatusFilter);
        commonFilterList.add(dataFilter);
        if (includeSystemConfigFilter) {
            List<QFilter> systemConfigFilter = this.getSystemConfigFilter(baseEntityName, ermanFileId, personId, commonFilterList, employeeIdFilter);
            commonFilterList.addAll(systemConfigFilter);
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper(baseEntityName);
        String orderBy = ReviseEntityNameHelperEnum.getReviseOrderByByBaseEntityName((String)baseEntityName);
        return helper.query(this.selectFields, commonFilterList.toArray(new QFilter[0]), orderBy);
    }

    protected List<QFilter> getSystemConfigFilter(String entityName, Long erFileId, Long personId, List<QFilter> filterList, QFilter employeeIdFilter) {
        if ("hrpi_empposorgrel".equals(entityName)) {
            if (erFileId == null || erFileId == 0L) {
                return filterList;
            }
            DynamicObject ermanfile = ErmanFileRepository.getErmanfile((Long)erFileId);
            Date startDate = ermanfile.getDate("startdate");
            Date endDate = ermanfile.getDate("enddate");
            if (endDate == null) {
                endDate = HspmDateUtils.getMaxEndDate();
            }
            Long orgId = ermanfile.getLong("org.id");
            logger.info("org===={}", (Object)orgId);
            Map paramMap = HpfsPersonInfoParamUtil.getEmpExpType((Long)orgId);
            logger.info("empExpType===={},isincludebefore===={}", paramMap.get("empexptype"), paramMap.get("isincludebefore"));
            this.queryDataByConfig(filterList, startDate, endDate, paramMap);
            this.appendDataForMoreEntry(personId, employeeIdFilter, filterList, paramMap);
        }
        return new ArrayList<QFilter>();
    }

    private void queryDataByConfig(List<QFilter> list, Date startDate, Date endDate, Map<String, Object> paramMap) {
        HpfsPersonInfoParamUtil.EmpExpTypeEnum empexptype = (HpfsPersonInfoParamUtil.EmpExpTypeEnum)paramMap.get("empexptype");
        if (empexptype == HpfsPersonInfoParamUtil.EmpExpTypeEnum.ONLY_DEPT) {
            QFilter dateFilter = new QFilter("enddate", ">=", (Object)startDate).and(new QFilter("startdate", "<=", (Object)endDate));
            list.add(dateFilter);
        } else if (empexptype == HpfsPersonInfoParamUtil.EmpExpTypeEnum.ONLY_AND_AFTER_DEPT) {
            QFilter dateFilter = new QFilter("enddate", ">=", (Object)startDate);
            list.add(dateFilter);
        } else if (empexptype == HpfsPersonInfoParamUtil.EmpExpTypeEnum.ONLY_AND_BEFORE_DEPT) {
            QFilter dateFilter = new QFilter("startdate", "<=", (Object)endDate);
            list.add(dateFilter);
        }
    }

    private void appendDataForMoreEntry(Long personId, QFilter idFilter, List<QFilter> list, Map<String, Object> paramMap) {
        HRBaseServiceHelper helper;
        DynamicObject[] objects;
        if (paramMap.get("isincludebefore") != null && Boolean.TRUE.equals(paramMap.get("isincludebefore")) && personId != null && personId != 0L && (objects = (helper = new HRBaseServiceHelper("hrpi_person")).query("personindexid", new QFilter[]{new QFilter("id", "=", (Object)personId)})) != null && objects.length > 0) {
            long pid = objects[0].getLong("personindexid");
            QFilter curFilter = new QFilter("iscurrentversion", "=", (Object)"1");
            QFilter initstatusFilter = new QFilter("initstatus", "=", (Object)"2");
            QFilter dataFilter = new QFilter("datastatus", "=", (Object)"1");
            DynamicObject[] allPerson = helper.query("id", new QFilter[]{curFilter, initstatusFilter, dataFilter, new QFilter("personindexid", "=", (Object)pid)});
            Set collect = Arrays.stream(allPerson).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet());
            QFilter personFilter = new QFilter("person", "in", collect);
            list.remove(idFilter);
            list.add(personFilter);
        }
    }

    public DynamicObject getHisVersionById(String entityName, Long id) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityName);
        QFilter idFilter = new QFilter("id", "=", (Object)id);
        return helper.queryOne(this.selectFields, new QFilter[]{idFilter});
    }

    private List<String> getSettingField() {
        return null;
    }

    public void openDetailEditRevise(String id, String reviseEntityName, IFormView view, Map<String, Object> customParams) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.setFormId(reviseEntityName);
        showParameter.setCustomParams(customParams);
        String pageId = UUID.randomUUID().toString();
        showParameter.setPageId(pageId);
        customParams.put("revPageId", pageId);
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.getOpenStyle().setTargetKey("revise_info");
        view.showForm((FormShowParameter)showParameter);
    }

    public void openDetailViewRevise(String id, String reviseEntityName, IFormView view, Map<String, Object> customParams) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.setFormId(reviseEntityName);
        showParameter.setCustomParams(customParams);
        showParameter.setPkId((Object)id);
        String pageId = UUID.randomUUID().toString();
        showParameter.setPageId(pageId);
        customParams.put("revPageId", pageId);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.getOpenStyle().setTargetKey("revise_info");
        view.showForm((FormShowParameter)showParameter);
    }

    public void customControlInitData(DynamicObject[] hisVersions, String selectedBoId, String selectId, String sendFrontType, IFormView view) {
        Map<Long, DynamicObject> boIdVsCurDynMap = Arrays.stream(hisVersions).filter(version -> "true".equals(version.getString("iscurrentversion"))).collect(Collectors.toMap(version -> version.getLong("boid"), version -> version));
        List hisVersionList = Arrays.stream(hisVersions).filter(version -> "false".equals(version.getString("iscurrentversion"))).collect(Collectors.toList());
        ArrayList<Long> boIdList = new ArrayList<Long>();
        for (DynamicObject boDyn : hisVersionList) {
            long boId = boDyn.getLong("boid");
            if (boIdList.contains(boId)) continue;
            boIdList.add(boId);
        }
        Map<Long, List<DynamicObject>> boIdVsDynListMap = hisVersionList.stream().collect(Collectors.groupingBy(dyn -> dyn.getLong("boid")));
        ArrayList<HashMap> initData = new ArrayList<HashMap>(hisVersions.length);
        int boIndex = 0;
        for (Long boId : boIdList) {
            String posTypeName;
            List<DynamicObject> hisDynList = boIdVsDynListMap.get(boId);
            HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
            dataMap.put("boid", String.valueOf(boId));
            dataMap.put("boindex", boIndex++);
            Boolean selectBoFlag = Boolean.TRUE;
            ArrayList labelList = Lists.newArrayListWithExpectedSize((int)16);
            if (selectedBoId.equals(String.valueOf(boId))) {
                selectBoFlag = Boolean.TRUE;
                if ("newbo".equals(sendFrontType)) {
                    labelList.add(ResManager.loadKDString((String)"\u65b0\u589e", (String)"PersonReviseService_5", (String)"hr-hspm-business", (Object[])new Object[0]));
                }
                dataMap.put("selectboflag", selectBoFlag);
            } else {
                selectBoFlag = Boolean.FALSE;
                dataMap.put("selectboflag", selectBoFlag);
            }
            DynamicObject firstDyn = hisDynList.get(0);
            String name = firstDyn.getDataEntityType().getName();
            if ("hrpi_empposorgrel".equals(name) && labelList.isEmpty() && !HRStringUtils.isEmpty((String)(posTypeName = firstDyn.getString("postype.name"))) && posTypeName.length() > 2) {
                labelList.add(posTypeName.substring(0, 2));
            }
            dataMap.put("label", labelList);
            DynamicObject curDyn = boIdVsCurDynMap.get(boId);
            if (Objects.isNull(curDyn)) {
                logger.error("boIdVsCurDynMap.get(boId) get null, boid={}", (Object)boId);
                continue;
            }
            this.putFirstLineInfo(dataMap, curDyn);
            this.putSecondLineInfo(dataMap, curDyn);
            List<Map<String, Object>> dataVersionList = this.getDataVersionList(hisDynList, selectBoFlag, selectId, view);
            dataMap.put("dataversonlist", dataVersionList);
            initData.add(dataMap);
        }
        if ("init".equals(sendFrontType)) {
            this.setDataToCustomControl(initData, "init", "init", view);
        } else {
            this.setDataToCustomControl(initData, "update", "updatelist", view);
        }
    }

    private List<Map<String, Object>> getDataVersionList(List<DynamicObject> hisDynList, Boolean keyBoFlag, String selectId, IFormView view) {
        ArrayList dataVersionList = Lists.newArrayListWithExpectedSize((int)hisDynList.size());
        Collections.sort(hisDynList, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                return o2.getDate("bsed").compareTo(o1.getDate("bsed"));
            }
        });
        for (int i = 0; i < hisDynList.size(); ++i) {
            HashMap dataVersionMap = Maps.newHashMapWithExpectedSize((int)16);
            DynamicObject curDyn = hisDynList.get(i);
            String id = curDyn.getString("id");
            dataVersionMap.put("id", String.valueOf(id));
            if (keyBoFlag.booleanValue() && selectId.equals(id)) {
                dataVersionMap.put("selectversionflag", Boolean.TRUE);
            } else {
                dataVersionMap.put("selectversionflag", Boolean.FALSE);
            }
            dataVersionMap.put("index", i);
            dataVersionMap.put("bsed", HRInteDateTimeUtil.formatDate((String)curDyn.getDataEntityType().getName(), (String)"bsed", (Date)curDyn.getDate("bsed")));
            if (i == hisDynList.size() - 1) {
                String groupName = (String)view.getFormShowParameter().getCustomParams().get("groupname");
                dataVersionMap.put("revisedesc", String.format(ResManager.loadKDString((String)"\u521b\u5efa%s", (String)"PersonReviseService_1", (String)"hr-hspm-business", (Object[])new Object[0]), groupName));
            } else {
                DynamicObject nextDyn = hisDynList.get(i + 1);
                this.compareChangeInfo(curDyn, nextDyn, dataVersionMap);
            }
            dataVersionList.add(dataVersionMap);
        }
        return dataVersionList;
    }

    private void putFirstLineInfo(Map<String, Object> dataMap, DynamicObject firstDyn) {
        DateTimeProp startDateProp = (DateTimeProp)firstDyn.getDynamicObjectType().getProperty("startdate");
        DateTimeProp endDateProp = (DateTimeProp)firstDyn.getDynamicObjectType().getProperty("enddate");
        dataMap.put("startdate", HRInteDateTimeUtil.formatDateByFieldProp((DateTimeProp)startDateProp, (Date)firstDyn.getDate("startdate"), (Long)0L));
        Date endDate = firstDyn.getDate("enddate");
        if (!HRDateTimeUtils.dayBefore((Date)endDate, (Date)new Date())) {
            dataMap.put("enddate", ResManager.loadKDString((String)"\u81f3\u4eca", (String)"PersonReviseService_0", (String)"hr-hspm-business", (Object[])new Object[0]));
        } else {
            dataMap.put("enddate", HRInteDateTimeUtil.formatDateByFieldProp((DateTimeProp)endDateProp, (Date)endDate, (Long)0L));
        }
    }

    private void putSecondLineInfo(Map<String, Object> dataMap, DynamicObject firstDyn) {
        String entityName = firstDyn.getDataEntityType().getName();
        dataMap.put("entityname", entityName);
        ArrayList infoList = Lists.newArrayListWithExpectedSize((int)16);
        if ("hrpi_empposorgrel".equals(entityName)) {
            infoList.add(this.getBaseDataNameValue(firstDyn, "adminorg"));
            String aPositionType = firstDyn.getString("apositiontype");
            if ("0".equals(aPositionType)) {
                infoList.add(this.getBaseDataNameValue(firstDyn, "stdposition"));
            } else if ("1".equals(aPositionType)) {
                infoList.add(this.getBaseDataNameValue(firstDyn, "position"));
            } else if ("2".equals(aPositionType)) {
                infoList.add(this.getBaseDataNameValue(firstDyn, "job"));
            }
        } else if ("hrpi_empentrel".equals(entityName)) {
            infoList.add(this.getBaseDataNameValue(firstDyn, "enterprise"));
            infoList.add(this.getBaseDataNameValue(firstDyn, "laborreltype"));
            infoList.add(this.getBaseDataNameValue(firstDyn, "laborrelstatus"));
        } else if ("hrpi_trialperiod".equals(entityName)) {
            // empty if block
        }
        dataMap.put("empinfo", infoList);
    }

    private String getBaseDataNameValue(DynamicObject dyn, String fieldName) {
        try {
            DynamicObject valueDyn = dyn.getDynamicObject(fieldName);
            if (Objects.nonNull(dyn)) {
                return valueDyn.getString("name");
            }
            return "";
        }
        catch (Exception ex) {
            logger.error("there aren't fieldName:{}", (Object)fieldName);
            return "";
        }
    }

    private void compareChangeInfo(DynamicObject curDyn, DynamicObject prevDyn, Map<String, Object> dataVersionMap) {
        try {
            Map<String, String> fieldVsNameMap = this.getFieldVsNameMap(curDyn);
            String baseEntityName = curDyn.getDynamicObjectType().getName();
            StringBuilder changeInfoSb = new StringBuilder();
            StringBuilder detailChangeInfoSb = new StringBuilder();
            List compareExcludeFieldList = ReviseEntityNameHelperEnum.getCompareExcludeFieldList((String)baseEntityName);
            DynamicConvertUtils dynamicCompareUtils = new DynamicConvertUtils(compareExcludeFieldList);
            List compareResults = dynamicCompareUtils.compareAndGetAllDiffCol(curDyn, prevDyn);
            for (DynamicConvertUtils.CompareResult compareResult : compareResults) {
                if (compareResult.isSame() || !this.needCompareTreeField.contains(compareResult.getPropKey())) continue;
                if (HRStringUtils.isEmpty((String)changeInfoSb.toString())) {
                    changeInfoSb.append(ResManager.loadKDString((String)"\u53d8\u66f4\u4e86", (String)"PersonReviseService_2", (String)"hr-hspm-business", (Object[])new Object[0]));
                }
                String fieldName = fieldVsNameMap.get(compareResult.getPropKey());
                changeInfoSb.append(fieldName).append("\u3001");
                detailChangeInfoSb.append(String.format(ResManager.loadKDString((String)"\u5c06%1$s\u7531\u201c%2$s\u201d\u53d8\u66f4\u4e3a\u201c%3$s,\u201c", (String)"PersonReviseService_3", (String)"hr-hspm-business", (Object[])new Object[0]), fieldName, compareResult.getBeforeValue(), compareResult.getAfterValue()));
            }
            if (HRStringUtils.isNotEmpty((String)changeInfoSb.toString())) {
                changeInfoSb.deleteCharAt(changeInfoSb.length() - 1);
            }
            if (HRStringUtils.isNotEmpty((String)detailChangeInfoSb.toString())) {
                detailChangeInfoSb.deleteCharAt(detailChangeInfoSb.length() - 1);
            }
            dataVersionMap.put("revisedesc", changeInfoSb.toString());
            dataVersionMap.put("revisedescdeatil", detailChangeInfoSb.toString());
        }
        catch (Exception ex) {
            logger.error("compareChangeInfo Error!");
        }
    }

    private Map<String, String> getFieldVsNameMap(DynamicObject curDyn) {
        DataEntityPropertyCollection properties = curDyn.getDataEntityType().getProperties();
        HashMap fieldVsNameMap = Maps.newHashMapWithExpectedSize((int)properties.size());
        for (IDataEntityProperty property : curDyn.getDataEntityType().getProperties()) {
            if (!Objects.nonNull(property.getDisplayName())) continue;
            fieldVsNameMap.put(property.getName(), property.getDisplayName().getLocaleValue());
        }
        return fieldVsNameMap;
    }

    public void customControlChangeSelect(String selectId, IFormView view) {
        HashMap selectDataMap = Maps.newHashMapWithExpectedSize((int)8);
        if (HRStringUtils.isEmpty((String)selectId)) {
            selectDataMap.put("canselect", Boolean.FALSE);
        } else {
            selectDataMap.put("canselect", Boolean.TRUE);
        }
        this.setDataToCustomControl(selectDataMap, "update", "changeselect", view);
    }

    public void customControlCancelNewBo(IFormView view) {
        HashMap selectDataMap = Maps.newHashMapWithExpectedSize((int)8);
        selectDataMap.put("iscancel", Boolean.TRUE);
        this.setDataToCustomControl(selectDataMap, "update", "cancelnewbo", view);
    }

    public void customControlNewBo(IFormView view, String groupName) {
        HashMap selectDataMap = Maps.newHashMapWithExpectedSize((int)8);
        selectDataMap.put("newbocaption", String.format(ResManager.loadKDString((String)"\u65b0\u5efa%s", (String)"PersonReviseService_4", (String)"hr-hspm-business", (Object[])new Object[0]), groupName));
        this.setDataToCustomControl(selectDataMap, "update", "newbo", view);
    }

    private void setDataToCustomControl(Object data, String eventStatus, String eventName, IFormView view) {
        Map<String, Object> controlData = this.buildCustomControlData(data, eventStatus, eventName);
        CustomControl customcontrol = (CustomControl)view.getControl("customcontrolap");
        customcontrol.setData(controlData);
    }

    private void initFieldData(String baseEntityName) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)baseEntityName);
        Set propNameSet = dataEntityType.getProperties().stream().map(prop -> prop.getName()).collect(Collectors.toSet());
        List excludeProp = ReviseEntityNameHelperEnum.getCompareExcludeFieldList((String)baseEntityName);
        List coreFieldList = (List)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrpi", (String)"IHRPIAttachReviseConService", (String)"getFieldsByEntityNameAndType", (Object[])new Object[]{baseEntityName, Collections.singletonList(1010L)});
        for (String settingField : propNameSet) {
            if (coreFieldList.contains(settingField) || excludeProp.contains(settingField) || settingField.endsWith("_id")) continue;
            this.needCompareTreeField.add(settingField);
        }
        HashSet<String> selectFieldSet = new HashSet<String>();
        selectFieldSet.addAll(this.needCompareTreeField);
        selectFieldSet.addAll(this.getMustField());
        selectFieldSet.addAll(this.getTreeRequiredField(baseEntityName));
        this.selectFields = String.join((CharSequence)",", selectFieldSet);
    }

    protected List<String> getTreeRequiredField(String baseEntityName) {
        return ReviseEntityNameHelperEnum.getTreeFieldList((String)baseEntityName);
    }

    private List<String> getMustField() {
        ArrayList<String> fieldList = new ArrayList<String>();
        fieldList.add("id");
        fieldList.add("boid");
        fieldList.add("bsed");
        fieldList.add("bsled");
        fieldList.add("datastatus");
        fieldList.add("iscurrentversion");
        fieldList.add("postype");
        return fieldList;
    }

    private Map<String, Object> buildCustomControlData(Object data, String eventStatus, String eventName) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("data", data);
        dataMap.put("code", "200");
        dataMap.put("errorMessage", "");
        dataMap.put("eventStatus", eventStatus);
        dataMap.put("eventName", eventName);
        dataMap.put("time", System.currentTimeMillis());
        return dataMap;
    }

    private String formatDateTimeField(Date date, int regionType) {
        if (date == null) {
            return "";
        }
        if (regionType == 1) {
            return HRDateTimeUtils.format((Date)date, (String)"yyyy-MM-dd");
        }
        return HRDateTimeUtils.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
    }
}

