/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.task;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRPerserlenHelper;
import kd.hr.hbp.common.model.PerserModel;
import kd.hr.hspm.business.domian.handler.CalServiceLengthHandler;
import kd.sdk.hr.hspm.common.utils.BusinessUtils;
import org.apache.commons.lang.time.StopWatch;

public class BusinessDataRefreshTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(BusinessDataRefreshTask.class);
    private static final HRBaseServiceHelper PERSERLEN_HELPER = new HRBaseServiceHelper("hrpi_perserlen");
    private static final HRBaseServiceHelper PERNONTSPROP_HELPER = new HRBaseServiceHelper("hrpi_pernontsprop");
    private static final HRBaseServiceHelper EMPENTREL_HELPER = new HRBaseServiceHelper("hrpi_empentrel");
    protected static final int TOP = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("BusinessDataRefreshTask#execute_start");
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            this.perserlenStart();
            stopWatch.split();
            LOGGER.info("BusinessDataRefreshTask#execute_perserlenUse time is: {} ms.", (Object)stopWatch.getSplitTime());
            this.empentrelStart();
            stopWatch.split();
            LOGGER.info("BusinessDataRefreshTask#execute_empentrelUse time is: {} ms.", (Object)stopWatch.getSplitTime());
        }
        finally {
            stopWatch.stop();
            LOGGER.info("BusinessDataRefreshTask#execute_end time is: {} ms.", (Object)stopWatch.getTime());
        }
    }

    private void perserlenStart() {
        long id = 0L;
        try {
            DynamicObject[] dyArray;
            while ((dyArray = BusinessDataRefreshTask.queryInfoPerserlen(id)) != null && dyArray.length > 0) {
                DynamicObject[] basicInfoList;
                this.updComsercount(dyArray);
                for (DynamicObject dynamicObject : dyArray) {
                    this.calculatePerserlenData(dynamicObject);
                }
                Set collectEmployee = Arrays.stream(dyArray).map(arg -> arg.getLong("employee.id")).collect(Collectors.toSet());
                QFilter qFilter = new QFilter("iscurrentversion", "=", (Object)"1").and("datastatus", "=", (Object)"1");
                QFilter idStatus = new QFilter("employee.id", "in", collectEmployee);
                QFilter[] qFilters = new QFilter[]{qFilter, BusinessDataRefreshTask.getStatusFilter(), BusinessDataRefreshTask.getWorkStatusFilter(1010L), idStatus};
                DynamicObject[] ids = EMPENTREL_HELPER.query("id,person,employee", qFilters);
                Set<Long> longList = Arrays.stream(ids).map(arg -> arg.getLong("person.id")).collect(Collectors.toSet());
                for (DynamicObject dynamicObject : basicInfoList = BusinessDataRefreshTask.queryBasicInfo(longList)) {
                    for (DynamicObject perserlen : dyArray) {
                        if (dynamicObject.getLong("person.id") != perserlen.getLong("person.id")) continue;
                        dynamicObject.set("servicelen", perserlen.get("socialworkage"));
                    }
                }
                DynamicObjectCollection lenObjectCollection = this.addDataToCollection(dyArray, longList);
                PERSERLEN_HELPER.save(lenObjectCollection);
                DynamicObjectCollection perObjectCollection = this.addDataToCollection(basicInfoList, longList);
                PERNONTSPROP_HELPER.save(perObjectCollection);
                if (dyArray.length >= 100) {
                    id = dyArray[dyArray.length - 1].getLong("id");
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            LOGGER.error("handle_perserlen_ex", (Throwable)ex);
        }
    }

    private void updComsercount(DynamicObject[] dyArray) {
        LOGGER.info("===updComsercount start===");
        HashSet<Long> empIds = new HashSet<Long>();
        ArrayList<PerserModel> perserModelList = new ArrayList<PerserModel>();
        for (DynamicObject dynamicObject : dyArray) {
            long empId = dynamicObject.getLong("employee.id");
            if (empId == 0L) continue;
            empIds.add(empId);
        }
        Map<Long, Date> empIdUseDateMap = CalServiceLengthHandler.getUseDateByEmployeeId(empIds);
        for (DynamicObject dynamicObject : dyArray) {
            PerserModel perserModel = new PerserModel();
            long personId = dynamicObject.getLong("person.id");
            long empId = dynamicObject.getLong("employee.id");
            if (personId == 0L || empId == 0L) continue;
            Date useDate = empIdUseDateMap.get(empId);
            Date joincomdate = dynamicObject.getDate("joincomdate");
            BigDecimal adjustcomtime = dynamicObject.getBigDecimal("adjustcomtime");
            if (adjustcomtime == null) {
                adjustcomtime = BigDecimal.ZERO;
            }
            if (useDate == null || joincomdate == null) continue;
            perserModel.setUseDate(useDate);
            perserModel.setJoincomDate(joincomdate);
            perserModel.setAdjustTime(adjustcomtime);
            perserModel.setPersonId(personId);
            perserModel.setEmployeeId(empId);
            perserModelList.add(perserModel);
        }
        if (!CollectionUtils.isEmpty(perserModelList)) {
            HRPerserlenHelper.getBatchCalcComsercount(perserModelList);
            for (DynamicObject dynamicObject : dyArray) {
                List list;
                long empId = dynamicObject.getLong("employee.id");
                if (empId == 0L || CollectionUtils.isEmpty(list = perserModelList.stream().filter(perser -> perser.getEmployeeId() == empId).collect(Collectors.toList()))) continue;
                dynamicObject.set("comsercount", (Object)((PerserModel)list.get(0)).getComserCount());
            }
            PERSERLEN_HELPER.save(dyArray);
        }
        LOGGER.info("===updComsercount end===");
    }

    private void empentrelStart() {
        long id = 0L;
        try {
            DynamicObject[] dyArray;
            while ((dyArray = BusinessDataRefreshTask.queryEmpentrel(id)) != null && dyArray.length > 0) {
                DynamicObject[] basicInfoList;
                ArrayList<DynamicObject> continuationDys = new ArrayList<DynamicObject>(dyArray.length);
                for (DynamicObject dynamicObject : dyArray) {
                    this.calculateEmpentrelData(dynamicObject, continuationDys);
                }
                CalServiceLengthHandler.calcAndSetEmpentrelContinuation(continuationDys, true, "1", dyArray);
                Set<Long> collect = Arrays.stream(dyArray).map(arg -> arg.getLong("person.id")).collect(Collectors.toSet());
                for (DynamicObject dynamicObject : basicInfoList = BusinessDataRefreshTask.queryBasicInfo(collect)) {
                    for (DynamicObject empentrel : dyArray) {
                        if (dynamicObject.getLong("person.id") != empentrel.getLong("person.id")) continue;
                        dynamicObject.set("entservicelen", empentrel.get("servicelength"));
                    }
                }
                DynamicObjectCollection empCollection = this.addDataToCollection(dyArray, collect);
                EMPENTREL_HELPER.save(empCollection);
                DynamicObjectCollection perObjectCollection = this.addDataToCollection(basicInfoList, collect);
                PERNONTSPROP_HELPER.save(perObjectCollection);
                if (dyArray.length >= 100) {
                    id = dyArray[dyArray.length - 1].getLong("id");
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            LOGGER.error("handle_empentrel_ex", (Throwable)ex);
        }
    }

    protected DynamicObjectCollection addDataToCollection(DynamicObject[] dyArray, Set<Long> personIdSet) {
        ArrayList<DynamicObject> collection = new ArrayList<DynamicObject>();
        for (DynamicObject object : dyArray) {
            if (!personIdSet.contains(object.getLong("person.id"))) continue;
            collection.add(object);
        }
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        dynamicObjectCollection.addAll(collection);
        return dynamicObjectCollection;
    }

    private void calculatePerserlenData(DynamicObject dynamicObject) {
        Date firstjoincomdate = dynamicObject.getDate("firstjoincomdate");
        Date joincomdate = dynamicObject.getDate("joincomdate");
        Date joinworktime = dynamicObject.getDate("joinworktime");
        BigDecimal adjustcomtime = dynamicObject.getBigDecimal("adjustcomtime");
        BigDecimal adjustworktime = dynamicObject.getBigDecimal("adjustworktime");
        BigDecimal adjustworkage = dynamicObject.getBigDecimal("adjustworkage");
        if (adjustcomtime == null) {
            adjustcomtime = BigDecimal.ZERO;
        }
        if (adjustworktime == null) {
            adjustworktime = BigDecimal.ZERO;
        }
        if (adjustworkage == null) {
            adjustworkage = BigDecimal.ZERO;
        }
        BigDecimal joinWorkTimeDiff = BusinessUtils.calcYearsDiff((Date)new Date(), (Date)joinworktime);
        BigDecimal workyear = adjustworktime.add(joinWorkTimeDiff);
        BigDecimal socialworkage = adjustworkage.add(joinWorkTimeDiff);
        dynamicObject.set("workyear", (Object)workyear);
        dynamicObject.set("socialworkage", (Object)socialworkage);
    }

    private void calculateEmpentrelData(DynamicObject dynamicObject, List<DynamicObject> continuationDys) {
        String serviceAgeScheme;
        BigDecimal adjustlength = dynamicObject.getBigDecimal("adjustlength");
        Date startdate = dynamicObject.getDate("startdate");
        if (startdate == null) {
            return;
        }
        if (adjustlength == null) {
            adjustlength = BigDecimal.ZERO;
        }
        if ("2".equals(serviceAgeScheme = dynamicObject.getString("serviceagescheme"))) {
            continuationDys.add(dynamicObject);
        } else {
            CalServiceLengthHandler.calcServiceLength(startdate, new Date(), adjustlength, dynamicObject);
        }
    }

    private static DynamicObject[] queryInfoPerserlen(long id) {
        QFilter statusFilter = new QFilter("datastatus", "=", (Object)"1");
        QFilter[] qFilters = new QFilter[]{new QFilter("id", ">", (Object)id), statusFilter};
        DynamicObject[] ids = PERSERLEN_HELPER.query("id", qFilters, "id", 100);
        Object[] idList = Arrays.stream(ids).map(arg -> arg.getLong("id")).toArray();
        QFilter idFilter = new QFilter("id", "in", (Object)idList);
        return PERSERLEN_HELPER.query("id,boid,person,employee,servicelen,workyear,firstjoincomdate,joincomdate,joinworktime,adjustcomtime,adjustworktime,comsercount,workyear,socialworkage,iscurrentversion,adjustworkage", new QFilter[]{idFilter});
    }

    private static DynamicObject[] queryBasicInfo(Set<Long> ids) {
        QFilter statusFilter = new QFilter("datastatus", "=", (Object)"1");
        QFilter idFilter = new QFilter("person.id", "in", ids);
        QFilter[] qFilters = new QFilter[]{statusFilter, idFilter};
        return PERNONTSPROP_HELPER.query("id,boid,person,servicelen ,entservicelen,iscurrentversion", qFilters);
    }

    private static DynamicObject[] queryEmpentrel(long id) {
        QFilter[] qFilters = new QFilter[]{new QFilter("id", ">", (Object)id), BusinessDataRefreshTask.getStatusFilter(), BusinessDataRefreshTask.getWorkStatusFilter(1010L)};
        DynamicObject[] ids = EMPENTREL_HELPER.query("id", qFilters, "id", 100);
        Object[] idList = Arrays.stream(ids).map(arg -> arg.getLong("id")).toArray();
        QFilter idFilter = new QFilter("id", "in", (Object)idList);
        return EMPENTREL_HELPER.query("id,boid,person,entservicelen,employee.mid,servicelength,adjustlength,startdate,iscurrentversion,serviceagescheme", new QFilter[]{idFilter});
    }

    private static QFilter getStatusFilter() {
        return new QFilter("businessstatus", "=", (Object)"1");
    }

    private static QFilter getWorkStatusFilter(Long labrelStatus) {
        return new QFilter("labrelstatusprd.id", "=", (Object)labrelStatus);
    }
}

