/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.lang.time.StopWatch;

public class EmpposorgrelDataRefreshTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(EmpposorgrelDataRefreshTask.class);
    private static final HRBaseServiceHelper EMPPOSORGREL_HELPER = new HRBaseServiceHelper("hrpi_empposorgrel");
    private static final int ENTITY_TOP = 10000;
    private static final int ID_TOP = 1000000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("BusinessDataRefreshTask#execute_start");
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            this.empposorgrelStart();
            stopWatch.split();
            LOGGER.info("BusinessDataRefreshTask#execute_empposorgrelStart time is: {} ms.", (Object)stopWatch.getSplitTime());
        }
        finally {
            stopWatch.stop();
            LOGGER.info("BusinessDataRefreshTask#execute_end time is: {} ms.", (Object)stopWatch.getTime());
        }
    }

    private void empposorgrelStart() {
        long maxId = 0L;
        Date currentDay = new Date();
        try {
            int idsSize;
            do {
                List<Long> ids = EmpposorgrelDataRefreshTask.queryIds(maxId);
                idsSize = ids.size();
                LOGGER.info("id size:{}", (Object)idsSize);
                for (int startIndex = 0; startIndex < idsSize; startIndex += 10000) {
                    Object[] dyArray = EmpposorgrelDataRefreshTask.queryEmpposorgrel(ids, startIndex);
                    if (!ArrayUtils.isEmpty((Object[])dyArray)) {
                        DynamicObjectCollection dynamicObjectCollection = this.addDataToCollection((DynamicObject[])dyArray, currentDay);
                        EMPPOSORGREL_HELPER.save(dynamicObjectCollection);
                    }
                    maxId = dyArray[dyArray.length - 1].getLong("id");
                    LOGGER.info("maxId:{}", (Object)maxId);
                }
            } while (idsSize >= 1000000);
        }
        catch (Exception ex) {
            LOGGER.error("handle_empposorgrel_ex", (Throwable)ex);
        }
    }

    private DynamicObjectCollection addDataToCollection(DynamicObject[] dyArray, Date currentDay) {
        DynamicObjectCollection collection = new DynamicObjectCollection();
        for (DynamicObject dynamicObject : dyArray) {
            boolean flag;
            if (dynamicObject.getLong("id") != dynamicObject.getLong("boid") || !(flag = this.calculateServicelengthData(dynamicObject, currentDay))) continue;
            collection.add((Object)dynamicObject);
        }
        return collection;
    }

    private boolean calculateServicelengthData(DynamicObject dynamicObject, Date currentDay) {
        int servicelength = dynamicObject.getInt("servicelength");
        Date startdate = dynamicObject.getDate("startdate");
        Date enddate = dynamicObject.getDate("enddate");
        String businessstatus = dynamicObject.getString("businessstatus");
        if (startdate == null) {
            return false;
        }
        long diff = 0L;
        if (HRStringUtils.equals((String)businessstatus, (String)"1")) {
            diff = HRDateTimeUtils.dateDiff((String)"d", (Date)startdate, (Date)currentDay);
        } else if (HRStringUtils.equals((String)businessstatus, (String)"2") && enddate != null) {
            diff = HRDateTimeUtils.dateDiff((String)"d", (Date)startdate, (Date)enddate);
        }
        if (diff > 0L && diff != (long)servicelength) {
            dynamicObject.set("servicelength", (Object)diff);
            return true;
        }
        return false;
    }

    private static DynamicObject[] queryEmpposorgrel(List<Long> ids, int startIndex) {
        int endIndex = startIndex + 10000;
        int idsSize = ids.size();
        if (endIndex > idsSize) {
            endIndex = idsSize - 1;
        }
        List<Long> idList = ids.subList(startIndex, endIndex);
        return EMPPOSORGREL_HELPER.query("id,boid,servicelength,startdate,enddate,businessstatus", new QFilter[]{new QFilter("id", "in", idList)});
    }

    private static List<Long> queryIds(long id) {
        QFilter qFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter statusFilter = new QFilter("datastatus", "=", (Object)"1");
        QFilter[] qFilters = new QFilter[]{new QFilter("id", ">", (Object)id), qFilter, statusFilter};
        DataSet ids = EMPPOSORGREL_HELPER.queryDataSet(EMPPOSORGREL_HELPER.getEntityName() + ".queryId", "id", qFilters, "id", 1000000);
        ArrayList<Long> idList = new ArrayList<Long>();
        ids.forEach(data -> idList.add(data.getLong("id")));
        return idList;
    }
}

