/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.task;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hspm.business.infogroup.InfoGroupFieldHelper;
import kd.sdk.hr.hspm.business.service.PageRegConfigService;
import kd.sdk.hr.hspm.common.enums.ClientTypeEnum;

public class InfoGroupFieldAnalysisTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(InfoGroupFieldAnalysisTask.class);
    private static final HRBaseServiceHelper INFOGROUPPAGEREG_HELPER = new HRBaseServiceHelper("hspm_infogrouppagereg");
    private static final int TOP = 100;
    private static final ThreadPool THREADPOOL = ThreadPools.newFixedThreadPool((String)"InfoGroupFieldAnalysisTask", (int)1);
    private static final HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("hspm_multiviewconfig");

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("InfoGroupFieldAnalysis#execute_start");
        InfoGroupFieldAnalysisTask.analysisInfoGroupField(true);
        InfoGroupFieldAnalysisTask.removeMultiViewConfigCache();
        LOGGER.info("InfoGroupFieldAnalysis#execute_end");
    }

    private static DynamicObject[] queryInfoGroupPageReg(long id) {
        QFilter[] qFArray = new QFilter[]{new QFilter("id", ">", (Object)id)};
        return INFOGROUPPAGEREG_HELPER.query("pageinfo", qFArray, "id", 100);
    }

    public static void analysisInfoGroupField(boolean force) {
        DynamicObject[] dyArray;
        LOGGER.info("InfoGroupFieldAnalysis#analysisInfoGroupField_start");
        long id = 0L;
        while ((dyArray = InfoGroupFieldAnalysisTask.queryInfoGroupPageReg(id)) != null && dyArray.length > 0) {
            for (DynamicObject dynamicObject : dyArray) {
                try {
                    InfoGroupFieldHelper.handlePageMeta(dynamicObject.getLong("id"), force);
                }
                catch (Exception ex) {
                    LOGGER.warn("handlePageMeta_ex", (Throwable)ex);
                }
            }
            if (dyArray.length < 100) break;
            id = dyArray[dyArray.length - 1].getLong("id");
        }
        LOGGER.info("InfoGroupFieldAnalysis#analysisInfoGroupField_end");
    }

    public static void removeMultiViewConfigCache() {
        THREADPOOL.execute(() -> {
            DynamicObject[] configArray = SERVICE_HELPER.query("modifytime", new QFilter[]{new QFilter("enable", "=", (Object)"1")});
            if (configArray != null && configArray.length > 0) {
                IHRAppCache appCache = HRAppCache.get((String)"hspm");
                Lang lang = RequestContext.get().getLang();
                for (DynamicObject config : configArray) {
                    Long confId = config.getLong("id");
                    String modTime = config.getString("modifytime");
                    for (ClientTypeEnum clientType : ClientTypeEnum.values()) {
                        if (lang != null) {
                            appCache.remove(PageRegConfigService.getConfCacheKey((String)clientType.getCode(), (Long)confId, (String)modTime, (Lang)lang));
                        }
                        if (Lang.zh_CN != lang) {
                            appCache.remove(PageRegConfigService.getConfCacheKey((String)clientType.getCode(), (Long)confId, (String)modTime, (Lang)Lang.zh_CN));
                        }
                        if (Lang.zh_TW != lang) {
                            appCache.remove(PageRegConfigService.getConfCacheKey((String)clientType.getCode(), (Long)confId, (String)modTime, (Lang)Lang.zh_TW));
                        }
                        if (Lang.en_US == lang) continue;
                        appCache.remove(PageRegConfigService.getConfCacheKey((String)clientType.getCode(), (Long)confId, (String)modTime, (Lang)Lang.en_US));
                    }
                }
            }
        });
    }
}

