/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.task;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import org.apache.commons.lang.time.StopWatch;

public class UpdatePreworkexpIsSingleTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(UpdatePreworkexpIsSingleTask.class);
    private static final HRBaseServiceHelper PERSON_HELPER = new HRBaseServiceHelper("hrpi_person");
    private static final HRBaseServiceHelper PREWORKEXP_HELPER = new HRBaseServiceHelper("hrpi_preworkexp");
    protected static final int TOP = 1000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("UpdatePreworkexpIsSingleTask#execute_start");
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            this.preworkexpStart();
        }
        finally {
            stopWatch.stop();
            LOGGER.info("UpdatePreworkexpIsSingleTask#execute_end time is: {} ms.", (Object)stopWatch.getTime());
        }
    }

    private void preworkexpStart() {
        long id = 0L;
        try {
            DynamicObject[] dyArray;
            while ((dyArray = this.queryInfoPerson(id)) != null && dyArray.length > 0) {
                Set<Long> personIdSet = Arrays.stream(dyArray).map(arg -> arg.getLong("id")).collect(Collectors.toSet());
                DynamicObject[] preworkexpDyArr = this.queryInfoPreworkexp(personIdSet);
                if (preworkexpDyArr != null && preworkexpDyArr.length > 0) {
                    Map<Long, List<DynamicObject>> preworkexpDyListMap = Arrays.stream(preworkexpDyArr).collect(Collectors.groupingBy(preworkexpDy -> preworkexpDy.getLong("person.id")));
                    for (Map.Entry<Long, List<DynamicObject>> preworkexpDyListEntry : preworkexpDyListMap.entrySet()) {
                        this.sortAndcompareAndSetPreworkexpDy(preworkexpDyListEntry);
                    }
                }
                PREWORKEXP_HELPER.update(preworkexpDyArr);
                if (dyArray.length >= 1000) {
                    id = dyArray[dyArray.length - 1].getLong("id");
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            LOGGER.error("handle_preworkexp_ex", (Throwable)ex);
        }
    }

    private void sortAndcompareAndSetPreworkexpDy(Map.Entry<Long, List<DynamicObject>> preworkexpDyListEntry) {
        Comparator<DynamicObject> startdateDesc = Comparator.comparing(dynamicObject -> dynamicObject.getDate("startdate"), Comparator.nullsFirst(Date::compareTo)).reversed();
        Comparator<DynamicObject> comparator = startdateDesc.thenComparing(dynamicObject -> dynamicObject.getLong("boid"), Comparator.reverseOrder());
        List<DynamicObject> preworkexpDyList = preworkexpDyListEntry.getValue();
        preworkexpDyList.sort(comparator);
        DynamicObject maxDy = preworkexpDyList.get(0);
        long maxDyBoid = maxDy.getLong("boid");
        for (DynamicObject preworkexpDy : preworkexpDyList) {
            if (maxDyBoid == preworkexpDy.getLong("boid")) {
                preworkexpDy.set("issingle", (Object)"1");
                continue;
            }
            preworkexpDy.set("issingle", (Object)"0");
        }
    }

    private DynamicObject[] queryInfoPreworkexp(Set<Long> personIdSet) {
        QFilter[] qFilters = new QFilter[]{new QFilter("person", "in", personIdSet)};
        return PREWORKEXP_HELPER.query("id,person,startdate,issingle,boid", qFilters);
    }

    private DynamicObject[] queryInfoPerson(long id) {
        QFilter statusFilter = new QFilter("datastatus", "=", (Object)"1");
        QFilter qFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter[] qFilters = new QFilter[]{new QFilter("id", ">", (Object)id), statusFilter, qFilter};
        return PERSON_HELPER.query("id", qFilters, "id", 1000);
    }
}

