/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.util;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.AttachmentModel;
import kd.bos.orm.ORM;
import kd.hr.hbp.common.util.HRStringUtils;

public class AttachmentUtil {
    private static final Log LOGGER = LogFactory.getLog(AttachmentUtil.class);

    public static List<Map<String, Object>> changePicToAttachment(String picUrl, String formId) {
        int idx;
        HashMap<String, Object> attachMap = new HashMap<String, Object>(8);
        LOGGER.info(MessageFormat.format("picUrl\uff1a{0}", picUrl));
        InputStream inputStream = FileServiceFactory.getImageFileService().getInputStream(picUrl);
        String fieldName = picUrl.substring(picUrl.lastIndexOf("/") + 1);
        String saveUrl = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsFullUrl(fieldName, inputStream, 7200);
        String tempFilePreviewUrl = new AttachmentModel().getTempFilePreviewUrl(saveUrl);
        int size = 0;
        try {
            inputStream = FileServiceFactory.getImageFileService().getInputStream(picUrl);
            size = ByteStreams.toByteArray((InputStream)inputStream).length;
        }
        catch (IOException ex) {
            LOGGER.error("available error", (Throwable)ex);
        }
        attachMap.put("url", saveUrl);
        attachMap.put("previewurl", tempFilePreviewUrl);
        attachMap.put("uid", ORM.create().genStringId(formId));
        attachMap.put("name", fieldName);
        if (HRStringUtils.isNotEmpty((String)fieldName) && (idx = fieldName.lastIndexOf(".")) > 0) {
            attachMap.put("type", fieldName.substring(idx + 1));
        }
        attachMap.put("size", size + "");
        attachMap.put("fattachmentpanel", "attachmentpanel");
        attachMap.put("entityNum", formId);
        attachMap.put("billPkId", String.valueOf(ORM.create().genLongId(formId)));
        attachMap.put("lastModified", System.currentTimeMillis());
        attachMap.put("status", "success");
        attachMap.put("client", null);
        attachMap.put("visible", "1111");
        ArrayList<Map<String, Object>> attachmentDataPanels = new ArrayList<Map<String, Object>>();
        attachmentDataPanels.add(attachMap);
        return attachmentDataPanels;
    }
}

