/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.util;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.ehcache.syncstatus.MemoryCacheSyncStatusMange;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.IFormView;
import kd.bos.form.control.UrlUtil;
import kd.bos.form.field.DateEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMImpl;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hspm.business.util.PageCacheUtils;
import kd.hr.hspm.common.constants.utils.HspmDateUtils;

@Deprecated
public class BusinessUtils {
    private static final Log LOGGER = LogFactory.getLog(BusinessUtils.class);

    public static Set<Long> getUpdateBoIdGenPkId(Map<String, DynamicObjectCollection> attachMap, boolean genPkId) {
        HashSet<Long> updateBoIdSet = new HashSet<Long>(16);
        if (attachMap == null || attachMap.size() == 0) {
            return updateBoIdSet;
        }
        for (Map.Entry<String, DynamicObjectCollection> entry : attachMap.entrySet()) {
            String tempName = entry.getKey();
            DynamicObjectCollection dynamics = attachMap.get(tempName);
            for (DynamicObject dynamicObject : dynamics) {
                long boId = dynamicObject.getLong("boid");
                long pkId = dynamicObject.getLong("id");
                if (boId != 0L) {
                    updateBoIdSet.add(boId);
                    continue;
                }
                if (!genPkId || pkId != 0L) continue;
                dynamicObject.set("id", (Object)BusinessUtils.getORMHelper().genLongId(tempName));
            }
        }
        return updateBoIdSet;
    }

    public static ORM getORMHelper() {
        return new ORMImpl();
    }

    public static List<Map<String, Object>> getTempUrl(String entityNum, Map<String, Object> attachObj) {
        String saveUrl;
        ArrayList<Map<String, Object>> attachDataList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> attachMap = new HashMap<String, Object>(16);
        attachMap.put("type", attachObj.get("type"));
        attachMap.put("name", attachObj.get("name"));
        String url = (String)attachObj.get("url");
        if (url.contains("download.do") && HRStringUtils.isEmpty((String)(url = UrlUtil.getParam((String)url, (String)"path")))) {
            throw new KDBizException("url error");
        }
        InputStream inputStream = FileServiceFactory.getAttachmentFileService().getInputStream(url);
        try {
            saveUrl = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsFullUrl(String.valueOf(attachObj.get("name")), (InputStream)new BufferedInputStream(inputStream), 7200);
        }
        catch (Exception ex) {
            LOGGER.error("use saveAsFullUrl Exception", (Throwable)ex);
            inputStream = FileServiceFactory.getAttachmentFileService().getInputStream(url);
            saveUrl = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(String.valueOf(attachObj.get("name")), (InputStream)new BufferedInputStream(inputStream), 7200);
        }
        attachMap.put("url", saveUrl);
        String uid = (String)attachObj.get("uid");
        if (HRStringUtils.isEmpty((String)uid)) {
            uid = MemoryCacheSyncStatusMange.getUid() + "";
        }
        attachMap.put("uid", uid);
        attachMap.put("size", attachObj.get("size"));
        attachMap.put("fattachmentpanel", "attachmentpanelap_std");
        attachMap.put("entityNum", entityNum);
        attachMap.put("lastModified", System.currentTimeMillis());
        attachMap.put("status", "success");
        attachMap.put("client", null);
        attachDataList.add(attachMap);
        return attachDataList;
    }

    public static boolean checkBirthday(IFormView view, boolean setAge) {
        if (BusinessUtils.notExistBirthday(view.getModel())) {
            return false;
        }
        Date birthday = (Date)view.getModel().getValue("hrpi_pernontsprop-birthday");
        Date midnight = HspmDateUtils.getMidnight();
        if (birthday != null && !birthday.before(midnight)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u51fa\u751f\u65e5\u671f\u9700\u65e9\u4e8e\u5f53\u524d\u65e5\u671f", (String)"PercreMobEditPlugin_1", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (setAge) {
            BusinessUtils.setAge(view, birthday);
        }
        return false;
    }

    private static boolean notExistBirthday(IDataModel model) {
        return !model.getDataEntityType().getAllFields().containsKey("hrpi_pernontsprop-birthday");
    }

    private static void setAge(IFormView view, Date birthday) {
        BigDecimal age;
        if (!view.getModel().getDataEntityType().getAllFields().containsKey("hrpi_pernontsprop-age")) {
            return;
        }
        BigDecimal bigDecimal = age = birthday == null ? BigDecimal.ZERO : BigDecimal.valueOf(HRDateTimeUtils.dateDiff((String)"yyyy", (Date)birthday, (Date)new Date()));
        if (view.getModel().getDataEntityType().getAllFields().containsKey("hrpi_pernontsprop-age")) {
            view.getModel().setValue("hrpi_pernontsprop-age", (Object)age);
        }
    }

    public static boolean isPCFilePage(String pageId) {
        return pageId.endsWith("pdv") || pageId.endsWith("pdg");
    }

    public static void addMapToCollect(IFormView view, Long pkId, String attachKey, Object newValue, Object oldValue, List<HashMap<String, Object>> collection, String entityName) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String groupName = "0000";
        map.put("entityName", entityName);
        map.put("dataid", pkId);
        map.put("isnew", Boolean.FALSE);
        map.put("groupname", groupName);
        map.put("groupnumber", "0000");
        map.put("fieldtype", "PictureProp");
        map.put("displayname", "headsculpture");
        map.put("fieldname", attachKey);
        map.put("newvalue", newValue);
        map.put("oldvalue", oldValue);
        map.put("reason", null);
        map.put("status", null);
        PageCacheUtils.removeDataIfNeedUpdate(collection, pkId, attachKey, "0000");
        collection.add(map);
        if (collection.size() > 0) {
            PageCacheUtils.getHomePageCache(view).put(groupName + "-" + "entrycache", SerializationUtils.toJsonString(collection));
        } else {
            PageCacheUtils.getHomePageCache(view).remove(groupName + "-" + "entrycache");
        }
    }

    public static void setDateLimit(IFormView view, String field, boolean includeCurrentDay, boolean isMax) {
        if (!BusinessUtils.isFieldExist(view, field)) {
            return;
        }
        DateEdit day = (DateEdit)view.getControl(field);
        if (isMax) {
            day.setMaxDate(HspmDateUtils.addDay((Date)new Date(), (long)(includeCurrentDay ? 0L : -1L)));
            return;
        }
        day.setMinDate(HspmDateUtils.addDay((Date)new Date(), (long)(includeCurrentDay ? 0L : 1L)));
    }

    public static boolean isFieldExist(IFormView view, String key) {
        return view.getModel().getDataEntityType().getAllFields().containsKey(key);
    }

    public static List<Long> getCertIds(IFormView view, Long pkid) {
        List<Long> certIdList = new ArrayList<Long>();
        if (view == null) {
            return certIdList;
        }
        if (view.getEntityId().equals("hspm_pereduexp_mdg") || view.getEntityId().equals("hspm_pereduexp_pdg")) {
            QFilter VersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
            QFilter statusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "-3"});
            HRBaseServiceHelper certHelper = new HRBaseServiceHelper("hrpi_pereduexpcert");
            DynamicObject[] certDys = certHelper.loadDynamicObjectArray("hrpi_pereduexpcert", new QFilter[]{new QFilter("pereduexp", "=", (Object)pkid), VersionFilter, statusFilter});
            certIdList = Arrays.stream(certDys).map(certDy -> certDy.getLong("id")).collect(Collectors.toList());
        }
        return certIdList;
    }
}

