/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.business.util;

import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;

public class StyleBuilder {
    Builder builder = new Builder();

    private StyleBuilder() {
    }

    public static StyleBuilder createStyleBuilder() {
        return new StyleBuilder();
    }

    public StyleBuilder withMargin(String top, String right, String bottom, String left) {
        this.builder.margin.setTop(top);
        this.builder.margin.setRight(right);
        this.builder.margin.setBottom(bottom);
        this.builder.margin.setLeft(left);
        return this;
    }

    public StyleBuilder withPadding(String top, String right, String bottom, String left) {
        this.builder.padding.setTop(top);
        this.builder.padding.setRight(right);
        this.builder.padding.setBottom(bottom);
        this.builder.padding.setLeft(left);
        return this;
    }

    public StyleBuilder withBorder(String top, String right, String bottom, String left) {
        this.builder.border.setTop(top);
        this.builder.border.setRight(right);
        this.builder.border.setBottom(bottom);
        this.builder.border.setLeft(left);
        return this;
    }

    public Style build() {
        Style style = new Style();
        style.setPadding(this.builder.padding);
        style.setBorder(this.builder.border);
        style.setMargin(this.builder.margin);
        return style;
    }

    static class Builder {
        private Margin margin = new Margin();
        private Border border = new Border();
        private Padding padding = new Padding();

        Builder() {
        }
    }
}

