/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.mservice;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hspm.business.domian.repository.ERMFileRepository;
import kd.hr.hspm.business.domian.service.HSPMServiceFactory;
import kd.hr.hspm.business.util.UniquenessCheckUtil;
import kd.hr.hspm.mservice.api.IHSPMService;
import kd.sdk.hr.hspm.business.helper.HSPMBusinessDataServiceHelper;
import kd.sdk.hr.hspm.business.repository.ErmanFileRepository;
import kd.sdk.hr.hspm.business.service.AttacheHandlerService;
import kd.sdk.hr.hspm.business.service.PageRegConfigService;
import kd.sdk.hr.hspm.common.enums.ClientTypeEnum;
import kd.sdk.hr.hspm.common.utils.DynamicTransformUtil;

public class HSPMService
implements IHSPMService {
    private static final Log LOGGER = LogFactory.getLog(IHSPMService.class);

    public Map getErmanfile(Long ermanfileId) {
        DynamicObject ermanfile = null;
        try {
            ermanfile = ErmanFileRepository.getErmanfile((Long)ermanfileId);
        }
        catch (Exception ex) {
            LOGGER.error("getErmanfileById:", (Throwable)ex);
        }
        return HRDynamicObjectUtils.convertDynamicObjectToMap((DynamicObject)ermanfile);
    }

    public Map<String, Object> getErmanfileByPersonIdAndPostype(Long personId, Long oldErmanfileId, Long postypeId) {
        DynamicObject ermanfile = null;
        try {
            DynamicObject oldErmanfile;
            if ((null == personId || personId == 0L) && null != (oldErmanfile = ErmanFileRepository.getErmanfile((Long)oldErmanfileId))) {
                personId = oldErmanfile.getLong("person_id");
            }
            ermanfile = ErmanFileRepository.getErmanFileByPersonIdAndPostypeId((Long)personId, (Long)postypeId);
        }
        catch (Exception ex) {
            LOGGER.error("getErmanfileByPersonIdAndPostype:", (Throwable)ex);
        }
        return HRDynamicObjectUtils.convertDynamicObjectToMap(ermanfile);
    }

    public DynamicObject getPrimaryErmanfFile(Long personId) {
        return ErmanFileRepository.getPrimaryErmanFile((Long)personId);
    }

    public Map<Long, DynamicObject> listPrimaryErmanFile(List<Long> personIds) {
        DynamicObject[] fileArr = ErmanFileRepository.listPrimaryErmanfFile(personIds);
        if (fileArr == null || fileArr.length == 0) {
            return new HashMap<Long, DynamicObject>();
        }
        return Arrays.stream(fileArr).collect(Collectors.toMap(dy -> dy.getLong("person.id"), dy -> dy, (k1, k2) -> k1));
    }

    public DynamicObject getPrimaryErmanfFileByEmployeeId(Long employeeId) {
        return ErmanFileRepository.getPrimaryErmanFileByEmployeeId((Long)employeeId);
    }

    public Map<Long, DynamicObject> listPrimaryErmanFileByEmployeeIds(List<Long> emplopyeeIds) {
        DynamicObject[] fileArr = ErmanFileRepository.listPrimaryErmanfFileByEmployeeIds(emplopyeeIds);
        if (fileArr == null || fileArr.length == 0) {
            return new HashMap<Long, DynamicObject>();
        }
        return Arrays.stream(fileArr).collect(Collectors.toMap(dy -> dy.getLong("employee.id"), dy -> dy, (k1, k2) -> k1));
    }

    public List<Map<String, Object>> getCardFields(List<Long> ermanfileIds) {
        ArrayList<Map<String, Object>> list = new ArrayList();
        try {
            list = HSPMServiceFactory.ermanService.listErmanFileInfos(ermanfileIds);
        }
        catch (Exception ex) {
            LOGGER.error("getCardFieldsHasErrorMessage", (Throwable)ex);
        }
        return list;
    }

    public DynamicObject[] getErmanFileByDepempId(List<Long> depempIds) {
        return ErmanFileRepository.listErmanFilesByDepempId(depempIds);
    }

    public DynamicObject[] listPrimaryErmanFilesByEmpnumber(List<String> empnumberList) {
        if (CollectionUtils.isEmpty(empnumberList)) {
            return null;
        }
        return ErmanFileRepository.listPrimaryErmanFilesByEmpnumber(empnumberList);
    }

    public List<Map<String, Object>> getErmanFileIdByEmporgRel(List<Map<String, Object>> importList) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        try {
            LOGGER.info(" getErmanFileIdByEmporgRel {}", importList);
            DynamicObject[] ermanFileIdByEmporgRel = HSPMServiceFactory.ermanService.getErmanFileIdByEmporgRel(importList);
            Map laborrelStatus = ErmanFileRepository.getLaborrelStatus();
            Map laborrelType = ErmanFileRepository.getLaborrelType();
            for (DynamicObject erFileInfo : ermanFileIdByEmporgRel) {
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                map.put("number", erFileInfo.getString("number"));
                map.put("name", erFileInfo.getString("name"));
                map.put("id", erFileInfo.getLong("id"));
                map.put("postype", erFileInfo.getLong("depemp.postype"));
                map.put("adminorg", erFileInfo.getString("depemp.adminorg.number"));
                map.put("position", erFileInfo.getString("depemp.position.number"));
                map.put("stdposition", erFileInfo.getString("depemp.stdposition.number"));
                map.put("job", erFileInfo.getString("empposrel.job.number"));
                Long labrelStatusId = erFileInfo.getLong("employee.laborrelstatus.id");
                Long labrelTypeId = erFileInfo.getLong("employee.laborreltype.id");
                map.put("laborrelstatus", labrelStatusId);
                map.put("laborreltypecls", Collections.singletonList(((DynamicObject)laborrelType.get(labrelTypeId)).getLong("laborreltypecls.id")));
                this.setLabrelStatus((DynamicObject)laborrelStatus.get(labrelStatusId), map);
                resultList.add(map);
            }
        }
        catch (Exception ex) {
            LOGGER.error("getErmanFileIdByEmporgRel error ", (Throwable)ex);
        }
        return resultList;
    }

    public Map<Long, Long> getErmanFileIdByEmployeeId(List<Long> employeeIdList, Boolean excludeQuit) {
        LOGGER.info(" getErmanFileIdByEmployeeId\uff1aexcludeQuit={},employeeIdList={}", (Object)excludeQuit, employeeIdList);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)employeeIdList.size());
        DynamicObject[] ermanFileDynArr = ErmanFileRepository.getPrimaryErmanFileIdByEmployeeId(employeeIdList);
        Map<Long, List<DynamicObject>> employeeIdVsErmanFileDynListMap = Arrays.stream(ermanFileDynArr).collect(Collectors.groupingBy(dyn -> dyn.getLong("employee.id")));
        for (Long employeeId : employeeIdList) {
            List<DynamicObject> ermanFileDynList = employeeIdVsErmanFileDynListMap.get(employeeId);
            if (CollectionUtils.isEmpty(ermanFileDynList)) continue;
            List fileTypeIdList = ermanFileDynList.stream().map(dyn -> dyn.getLong("filetype.id")).collect(Collectors.toList());
            Long quitFileType = 1050L;
            Boolean containsQuitFlag = fileTypeIdList.contains(quitFileType);
            if (CollectionUtils.isEmpty(ermanFileDynList)) continue;
            if (excludeQuit.booleanValue() && containsQuitFlag.booleanValue()) {
                List loseEffectDynList = ermanFileDynList.stream().filter(dyn -> HRStringUtils.equals((String)dyn.getString("businessstatus"), (String)"-1")).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(loseEffectDynList)) continue;
                resultMap.put(employeeId, ((DynamicObject)loseEffectDynList.get(0)).getLong("id"));
                continue;
            }
            List effectDynList = ermanFileDynList.stream().filter(dyn -> HRStringUtils.equals((String)dyn.getString("businessstatus"), (String)"1")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(effectDynList)) continue;
            resultMap.put(employeeId, ((DynamicObject)effectDynList.get(0)).getLong("id"));
        }
        LOGGER.info(" getErmanFileIdByEmployeeId\uff1aresultMap={}", (Object)resultMap);
        return resultMap;
    }

    public List<Map<String, Object>> getAllErmanFileIdByEmporgRel(List<Map<String, Object>> importList) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        try {
            LOGGER.info(" getAllErmanFileIdByEmporgRel#importList={}", importList);
            Object[] ermanFileIdByEmporgRel = HSPMServiceFactory.ermanService.getAllErmanFileIdByEmporgRel(importList);
            if (HRArrayUtils.isEmpty((Object[])ermanFileIdByEmporgRel)) {
                LOGGER.error("getAllErmanFileIdByEmporgRel#ermanFileIdByEmporgRel is empty!");
                return resultList;
            }
            Map laborrelStatus = ErmanFileRepository.getLaborrelStatus();
            Map laborrelType = ErmanFileRepository.getLaborrelType();
            for (Object erFileInfo : ermanFileIdByEmporgRel) {
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                map.put("number", erFileInfo.getString("number"));
                map.put("name", erFileInfo.getString("name"));
                map.put("id", erFileInfo.getLong("id"));
                map.put("postype", erFileInfo.getLong("depemp.postype"));
                map.put("adminorg", erFileInfo.getString("depemp.adminorg.number"));
                map.put("position", erFileInfo.getString("depemp.position.number"));
                map.put("stdposition", erFileInfo.getString("depemp.stdposition.number"));
                map.put("job", erFileInfo.getString("empposrel.job.number"));
                map.put("startdate", erFileInfo.getDate("startdate"));
                Long labrelStatusId = erFileInfo.getLong("employee.laborrelstatus.id");
                Long labrelTypeId = erFileInfo.getLong("employee.laborreltype.id");
                map.put("laborrelstatus", labrelStatusId);
                map.put("laborreltypecls", Collections.singletonList(((DynamicObject)laborrelType.get(labrelTypeId)).getLong("laborreltypecls.id")));
                this.setLabrelStatus((DynamicObject)laborrelStatus.get(labrelStatusId), map);
                resultList.add(map);
            }
        }
        catch (Exception ex) {
            LOGGER.error("getErmanFileIdByEmporgRel error ", (Throwable)ex);
        }
        return resultList;
    }

    private void setLabrelStatus(DynamicObject labrelStatus, Map<String, Object> map) {
        map.put("labrelstatuscls", labrelStatus.getLong("labrelstatuscls.id"));
        map.put("labrelstatusprd", labrelStatus.getLong("labrelstatusprd.id"));
    }

    public Map<String, Object> jumpErManFileDetail(long erFileId, String listFormId) {
        return AttacheHandlerService.getInstance().wrapHandleRuleEngine(null, erFileId, listFormId, ClientTypeEnum.PC.getCode(), true);
    }

    public Map<String, Object> getInfoGroupConfig(long cnfId, String preView) {
        return PageRegConfigService.getInstance().getInfoGroupConfig(cnfId, ClientTypeEnum.PC.getCode(), preView);
    }

    public int countErmanFilesByTypeclsAndStatuscls(List<Long> labreltypeclsList, List<Long> labrelstatusclsList) {
        this.validateErmanFilesByTypeclsAndStatuscls(labreltypeclsList, labrelstatusclsList);
        return ErmanFileRepository.countErmanFilesByTypeclsAndStatuscls(labreltypeclsList, labrelstatusclsList);
    }

    public DynamicObject[] listErmanFilesByTypeclsAndStatuscls(List<Long> labreltypeclsList, List<Long> labrelstatusclsList, String selectProperties, long id, int top) {
        this.validateErmanFilesByTypeclsAndStatuscls(labreltypeclsList, labrelstatusclsList);
        return ErmanFileRepository.listErmanFilesByTypeclsAndStatuscls(labreltypeclsList, labrelstatusclsList, (String)selectProperties, (long)id, (int)top);
    }

    public DynamicObject[] listErManFilesByPkIds(List<Long> pkIds) {
        return ErmanFileRepository.listErManFilesByPkIds(pkIds);
    }

    private void validateErmanFilesByTypeclsAndStatuscls(List<Long> labreltypeclsList, List<Long> labrelstatusclsList) {
        if (CollectionUtils.isEmpty(labreltypeclsList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u201c\u7528\u5de5\u5173\u7cfb\u7c7b\u578b\u201d\u5206\u7c7b\u3002", (String)"HSPMService_1", (String)"hr-hspm-mservice", (Object[])new Object[0]));
        }
        if (CollectionUtils.isEmpty(labrelstatusclsList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u201c\u7528\u5de5\u5173\u7cfb\u72b6\u6001\u201d\u5206\u7c7b\u3002", (String)"HSPMService_2", (String)"hr-hspm-mservice", (Object[])new Object[0]));
        }
    }

    public int countErmanFilesByTerm(Map<String, Object> queryParam) {
        try {
            this.validateQueryParam(queryParam);
            return ERMFileRepository.countErmanFilesByTerm(queryParam);
        }
        catch (Exception ex) {
            LOGGER.error("listErmanFilesByTermError,", (Throwable)ex);
            return 0;
        }
    }

    public DynamicObject[] listErmanFilesByTerm(Map<String, Object> queryParam) {
        try {
            return this.queryFileData(queryParam);
        }
        catch (Exception ex) {
            LOGGER.error("listErmanFilesByTermError,", (Throwable)ex);
            return new DynamicObject[0];
        }
    }

    public List<Map<String, Object>> listErmanFilesMapByTerm(Map<String, Object> queryParam) {
        ArrayList<Map<String, Object>> retList = new ArrayList<Map<String, Object>>(16);
        try {
            DynamicObject[] files;
            for (DynamicObject dy : files = this.queryFileData(queryParam)) {
                retList.add(HRDynamicObjectUtils.convertDynamicObjectToMap((DynamicObject)dy));
            }
        }
        catch (Exception ex) {
            LOGGER.error("listErmanFilesMapByTermError,", (Throwable)ex);
        }
        return retList;
    }

    private DynamicObject[] queryFileData(Map<String, Object> queryParam) {
        this.validateQueryParam(queryParam);
        return ERMFileRepository.listErmanFilesByTerm(queryParam);
    }

    private void validateQueryParam(Map<String, Object> queryParam) {
        LOGGER.info(" listErmanFilesByTerm={}", queryParam);
        if (!(queryParam.get("id") instanceof Long)) {
            throw new KDBizException("id empty or type error");
        }
        if (!queryParam.containsKey("id") || Objects.isNull(queryParam.get("id"))) {
            queryParam.put("id", 0);
        }
        if (queryParam.containsKey("top") && !(queryParam.get("top") instanceof Integer)) {
            throw new KDBizException("top type error");
        }
        if (!queryParam.containsKey("top") || Objects.isNull(queryParam.get("top"))) {
            queryParam.put("top", 1000);
        }
        if (queryParam.containsKey("properties") && !(queryParam.get("properties") instanceof String)) {
            throw new KDBizException("properties type error");
        }
        if (!queryParam.containsKey("properties") || Objects.isNull(queryParam.get("properties"))) {
            queryParam.put("properties", "person,org,name,filetype,businessstatus,empentrel.laborreltype,empentrel.laborrelstatus");
        }
    }

    public Map<String, Object> queryErManFileIds(Map<String, Object> queryMap, int start, int limit) {
        return this.doQueryErManFileInfo(queryMap, start, limit, "0", "id");
    }

    public Map<String, Object> queryErManFileList(Map<String, Object> queryMap, int start, int limit) {
        return this.doQueryErManFileInfo(queryMap, start, limit, "1", null);
    }

    public Map<String, Object> queryErManFileDetail(Map<String, Object> queryMap, int start, int limit) {
        return this.doQueryErManFileInfo(queryMap, start, limit, "2", null);
    }

    public DynamicObject[] getOnBoardPerson(Set<Long> personIds) {
        return UniquenessCheckUtil.getOnBoardEmployee(personIds);
    }

    public DynamicObject[] getOnBoardPersonByEmpId(Set<Long> personIds) {
        return UniquenessCheckUtil.getOnBoardPersonByEmpId(personIds);
    }

    private Map<String, Object> doQueryErManFileInfo(Map<String, Object> queryMap, int start, int limit, String type, String queryField) {
        LOGGER.info("queryErManFileIds-->{},{},{},{}", new Object[]{type, start, limit, queryMap});
        HashMap<String, Object> retMap = new HashMap<String, Object>(16);
        retMap.put("success", true);
        try {
            this.batchQuerySingleEntity(queryMap, start, limit, type, retMap, queryField);
        }
        catch (Exception exception) {
            this.getFail(retMap, exception.getMessage());
            LOGGER.error("queryErManFileIdsError", (Throwable)exception);
        }
        return retMap;
    }

    private void batchQuerySingleEntity(Map<String, Object> queryMap, int start, int limit, String queryDia, Map<String, Object> retMap, String queryField) {
        List<QFilter> qFilterList;
        ArrayList<Map> tmp = new ArrayList<Map>(10);
        int paramLimit = limit;
        if (queryMap == null || queryMap.size() == 0) {
            this.getFail(retMap, "param empty");
            LOGGER.info("batchQuerySingleEntityParamEmpty", retMap.get("message"));
            return;
        }
        String entityName = null;
        if (!queryMap.containsKey("entityname")) {
            this.getFail(retMap, "entityname is empty");
            LOGGER.info("batchQuerySingleEntityParamEmpty", retMap.get("message"));
            return;
        }
        entityName = (String)queryMap.get("entityname");
        if (queryMap.containsKey("page")) {
            Object pageObj = queryMap.get("page");
            if (pageObj instanceof Boolean) {
                if (!((Boolean)pageObj).booleanValue()) {
                    paramLimit = 500;
                }
            } else {
                this.getFail(retMap, "page value is not boolean");
                LOGGER.info("batchQuerySingleEntityParamError", retMap.get("message"));
            }
        } else {
            paramLimit = 500;
        }
        if (this.validateParam(queryMap, queryDia, retMap)) {
            LOGGER.info("batchQuerySingleEntityValidate", retMap.get("message"));
            return;
        }
        if (!((Boolean)retMap.get("success")).booleanValue()) {
            LOGGER.info("batchQuerySingleEntityValidateInfo", retMap.get("message"));
            return;
        }
        String allFields = DynamicTransformUtil.getDynamicPropString((String)entityName);
        if (HRStringUtils.isEmpty((String)queryField)) {
            queryField = allFields;
        }
        if ((qFilterList = this.buildFilter(queryMap, allFields, retMap)) != null && !qFilterList.isEmpty()) {
            QFilter[] qFilters = qFilterList.toArray(new QFilter[0]);
            Object[] dys = HSPMBusinessDataServiceHelper.load((String)entityName, (String)queryField, (QFilter[])qFilters, (String)"id", (int)start, (int)paramLimit);
            if (HRArrayUtils.isNotEmpty((Object[])dys)) {
                for (Object dy : dys) {
                    tmp.add(HRDynamicObjectUtils.convertDynamicObjectToMap((DynamicObject)dy));
                }
            }
            this.getSuccess(retMap, tmp);
        }
    }

    private List<QFilter> buildFilter(Map<String, Object> queryMap, String allFields, Map<String, Object> retMap) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        QFilter currentQf = new QFilter("iscurrentversion", "=", (Object)"1");
        qFilterList.add(currentQf);
        for (Map.Entry<String, Object> paramMap : queryMap.entrySet()) {
            String key = paramMap.getKey();
            if ("entityname".equalsIgnoreCase(key) || "page".equalsIgnoreCase(key)) continue;
            if (!allFields.contains(key)) {
                this.getFail(retMap, key + " field not exist in entity.");
                return null;
            }
            Object valueObj = paramMap.getValue();
            if (valueObj == null) continue;
            if (valueObj instanceof String) {
                if (!HRStringUtils.isNotEmpty((String)((String)valueObj))) continue;
                QFilter strFilter = new QFilter(key, "=", valueObj);
                currentQf.and(strFilter);
                continue;
            }
            if (!(valueObj instanceof List) || CollectionUtils.isEmpty((Collection)((List)valueObj))) continue;
            QFilter listFilter = new QFilter(key, "in", valueObj);
            currentQf.and(listFilter);
        }
        return qFilterList;
    }

    private boolean validateParam(Map<String, Object> queryMap, String queryDia, Map<String, Object> retMap) {
        if ("0".equals(queryDia) || "1".equals(queryDia)) {
            boolean orgEmpty = this.validateList(queryMap, "org", retMap);
            boolean affOrgEmpty = this.validateList(queryMap, "affiliateadminorg", retMap);
            if (orgEmpty && affOrgEmpty) {
                this.getFail(retMap, "org and affiliateadminorg can not all empty.");
                LOGGER.info("batchQuerySingleEntity", retMap.get("message"));
                return true;
            }
        }
        if ("1".equals(queryDia) || "2".equals(queryDia)) {
            this.validateList(queryMap, "employee", retMap);
            this.validateList(queryMap, "person", retMap);
            if ("2".equals(queryDia)) {
                this.validateList(queryMap, "cmpemp", retMap);
                this.validateList(queryMap, "depemp", retMap);
                this.validateList(queryMap, "id", retMap);
            }
        }
        return false;
    }

    private boolean validateList(Map<String, Object> queryMap, String org, Map<String, Object> retMap) {
        if (queryMap.containsKey(org)) {
            Object orgObj = queryMap.get(org);
            if (orgObj != null) {
                if (!(orgObj instanceof List)) {
                    this.getFail(retMap, org + " value is not list.");
                }
                return false;
            }
            return true;
        }
        return true;
    }

    public void getFail(Map<String, Object> result, String message) {
        this.getResult(result, false, message, null);
    }

    public void getSuccess(Map<String, Object> result, Object data) {
        this.getResult(result, true, null, data);
    }

    public void getResult(Map<String, Object> result, boolean flag, String message, Object data) {
        result.put("success", flag);
        result.put("message", message);
        if (null != data) {
            result.put("data", data);
        }
    }
}

