/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.mservice.upgrade;

import java.util.Locale;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;

public class ReviseIsNewClientFlagConfigUpgradeService
implements IUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(ReviseIsNewClientFlagConfigUpgradeService.class);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            LOGGER.info("==ReviseIsNewClientFlagConfigUpgradeService hpfs basedata begin==");
            this.doUpgrade(ver, iteration, dbKey, sqlFileName);
            result.setLog("ReviseIsNewClientFlagConfigUpgradeService hpfs basedata oristatus upgrade success: %s");
            result.setSuccess(true);
            result.setEl("warning");
            LOGGER.info("==ReviseIsNewClientFlagConfigUpgradeService hpfs basedata success==");
            return result;
        }
        catch (Exception exception) {
            LOGGER.error("==ReviseIsNewClientFlagConfigUpgradeService hpfs basedata success==", (Throwable)exception);
            result.setErrorInfo(exception.getMessage());
            result.setSuccess(false);
            throw new KDException((Throwable)exception, BosErrorCode.sQL, new Object[]{String.format(Locale.ROOT, "Error:%s", exception.getMessage())});
        }
    }

    private void doUpgrade(String ver, String iteration, String dbKey, String sqlFileName) {
        boolean exists = this.isExists(dbKey);
        if (!exists) {
            this.updateDevConfigByBusinessKey(dbKey);
        }
    }

    private void updateDevConfigByBusinessKey(String dbKey) {
        this.executeSqlUpdateConfig(dbKey, "hspm_ermanfile_updatebutton_show", "false");
        this.executeSqlUpdateConfig(dbKey, "hspm_ermanfile_revisebutton_show", "true");
    }

    private void executeSqlUpdateConfig(String dbKey, String configKey, String value) {
        String sql = "update t_hpfs_devconfig set fbusinessvalue = ? where fbusinesskey =?";
        DB.update((DBRoute)new DBRoute(dbKey), (String)sql, (Object[])new Object[]{value, configKey});
        IHRAppCache ihrAppCache = HRAppCache.get((String)"hpfs:DevelopParamConfig");
        ihrAppCache.remove(configKey);
    }

    private boolean isExists(String dbKey) {
        String sql = "select count(1) from t_hrpi_person";
        long num = (Long)DB.query((DBRoute)new DBRoute(dbKey), (String)sql, null, rs -> {
            if (rs.next()) {
                return rs.getLong(1);
            }
            return 0L;
        });
        LOGGER.info("==ReviseIsNewClientFlagConfigUpgradeService hpfs basedata num=={}", (Object)num);
        return num > 0L;
    }
}

