/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.opplugin.infoclassify.fertilityinfo;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hspm.business.domian.service.infoclassify.IFertilityinfoService;
import kd.hr.hspm.opplugin.infoclassify.fertilityinfo.FertilityinfoValidator;
import kd.sdk.hr.hspm.common.result.HrpiServiceOperateResult;
import kd.sdk.hr.hspm.common.utils.DynamicPropValidateUtil;
import kd.sdk.hr.hspm.opplugin.InfoclassifySaveOp;

public class FertilityinfoSaveOp
extends InfoclassifySaveOp {
    private static final Log LOGGER = LogFactory.getLog(FertilityinfoSaveOp.class);
    private final IFertilityinfoService fertilityinfoService = IFertilityinfoService.getInstance();

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new FertilityinfoValidator());
    }

    protected void saveNew(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            DynamicPropValidateUtil.trim((DynamicObject)dataEntity);
            HrpiServiceOperateResult operateResult = this.fertilityinfoService.insertFertilityinfo(dataEntity);
            this.validateOperateResult(args, operateResult);
        }
    }

    protected void saveOverride(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            DynamicPropValidateUtil.trim((DynamicObject)dataEntity);
            Long pkId = (Long)dataEntity.getPkValue();
            DynamicObject dbDy = this.fertilityinfoService.getFertilityinfoByPkId(pkId);
            boolean compareResult = DynamicPropValidateUtil.checkChanged((DynamicObject)dataEntity, (DynamicObject)dbDy);
            if (this.isNoDataChanged(args, compareResult)) continue;
            HrpiServiceOperateResult operateResult = this.fertilityinfoService.updateFertilityinfo(pkId, dataEntity);
            this.validateOperateResult(args, operateResult);
        }
    }

    protected void delete(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        List pkIdList = Arrays.stream(dataEntities).map(listSelectedRow -> (Long)listSelectedRow.getPkValue()).collect(Collectors.toList());
        HrpiServiceOperateResult operateResult = this.fertilityinfoService.deleteFertilityinfo(pkIdList);
        this.validateOperateResult(args, operateResult);
    }

    protected List<Long> checkDelete(AfterOperationArgs args, DynamicObject[] dataEntities) {
        List pkIdList = Arrays.stream(dataEntities).map(listSelectedRow -> (Long)listSelectedRow.getPkValue()).collect(Collectors.toList());
        return this.fertilityinfoService.queryExistsIdByPkIdList(pkIdList);
    }

    protected void saveImportNew(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            HrpiServiceOperateResult operateResult = this.fertilityinfoService.saveImportFertilityinfo("new", new DynamicObject[]{dataEntity});
            this.validateOperateResult(args, operateResult, false);
        }
    }
}

