/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.opplugin.infoclassify.peraddress;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hspm.business.domian.service.infoclassify.IPeraddressService;
import kd.hr.hspm.opplugin.infoclassify.peraddress.PeraddressValidator;
import kd.sdk.hr.hspm.business.helper.HpfsChgexternalrecordQueueHelper;
import kd.sdk.hr.hspm.business.service.AttacheHandlerService;
import kd.sdk.hr.hspm.common.dto.InfoClassifyEntityKeyDTO;
import kd.sdk.hr.hspm.common.result.HrpiServiceOperateResult;
import kd.sdk.hr.hspm.common.utils.DynamicPropValidateUtil;
import kd.sdk.hr.hspm.opplugin.InfoclassifySaveOp;

public class PeraddressSaveOp
extends InfoclassifySaveOp {
    private static final Log LOGGER = LogFactory.getLog(PeraddressSaveOp.class);
    private final IPeraddressService peraddressService = IPeraddressService.getInstance();
    protected final AttacheHandlerService attacheHandlerService = AttacheHandlerService.getInstance();
    private final Map<Long, HrpiServiceOperateResult> operateResultMap = new HashMap<Long, HrpiServiceOperateResult>(16);
    private HrpiServiceOperateResult deleteOperateResult;

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new PeraddressValidator());
    }

    protected void saveNew(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            DynamicPropValidateUtil.trim((DynamicObject)dataEntity);
            HrpiServiceOperateResult operateResult = this.peraddressService.insertPeraddress(dataEntity);
            this.validateOperateResult(args, operateResult);
            this.operateResultMap.put(dataEntity.getLong("person.id"), operateResult);
        }
    }

    protected void saveOverride(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            DynamicPropValidateUtil.trim((DynamicObject)dataEntity);
            Long pkId = (Long)dataEntity.getPkValue();
            DynamicObject dbDy = this.peraddressService.getPeraddressByPkId(pkId);
            boolean compareResult = DynamicPropValidateUtil.checkChanged((DynamicObject)dataEntity, (DynamicObject)dbDy);
            if (this.isNoDataChanged(args, compareResult)) continue;
            HrpiServiceOperateResult operateResult = this.peraddressService.updatePeraddress(pkId, dataEntity);
            this.validateOperateResult(args, operateResult);
            this.operateResultMap.put(dataEntity.getLong("person.id"), operateResult);
        }
    }

    protected void delete(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        List pkIdList = Arrays.stream(dataEntities).map(listSelectedRow -> (Long)listSelectedRow.getPkValue()).collect(Collectors.toList());
        this.deleteOperateResult = this.peraddressService.deletePeraddress(pkIdList);
        this.validateOperateResult(args, this.deleteOperateResult);
    }

    protected List<Long> checkDelete(AfterOperationArgs args, DynamicObject[] dataEntities) {
        List pkIdList = Arrays.stream(dataEntities).map(listSelectedRow -> (Long)listSelectedRow.getPkValue()).collect(Collectors.toList());
        return this.peraddressService.queryExistsIdByPkIdList(pkIdList);
    }

    protected void saveImportNew(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            HrpiServiceOperateResult operateResult = this.peraddressService.saveImportPeraddress("new", new DynamicObject[]{dataEntity});
            this.validateOperateResult(args, operateResult, false);
            HrpiServiceOperateResult oldOpRes = this.operateResultMap.get(dataEntity.getLong("person.id"));
            if (!HRObjectUtils.isEmpty((Object)oldOpRes) && oldOpRes.isSyncFlag()) continue;
            this.operateResultMap.put(dataEntity.getLong("person.id"), operateResult);
        }
    }

    protected void afterSaveNew(AfterOperationArgs args, DynamicObject[] dataEntities) {
        super.afterSaveNew(args, dataEntities);
        this.sendChangeInfoSyncToSysUser();
    }

    protected void afterSaveOverride(AfterOperationArgs args, DynamicObject[] dataEntities) {
        super.afterSaveOverride(args, dataEntities);
        this.sendChangeInfoSyncToSysUser();
    }

    protected void afterSaveImport(AfterOperationArgs args, DynamicObject[] dataEntities) {
        super.afterSaveImport(args, dataEntities);
        this.sendChangeInfoSyncToSysUser();
    }

    protected void afterDelete(AfterOperationArgs args, DynamicObject[] dataEntities) {
        super.afterDelete(args, dataEntities);
        if (this.deleteOperateResult != null && !CollectionUtils.isEmpty((Collection)this.deleteOperateResult.getSyncPersonIdList())) {
            this.attacheHandlerService.sendChangeInfoSyncToSysUser(this.deleteOperateResult.getSyncPersonIdList());
        }
    }

    private void sendChangeInfoSyncToSysUser() {
        if (!this.operateResultMap.isEmpty()) {
            List personIdList = this.operateResultMap.entrySet().stream().filter(entry -> ((HrpiServiceOperateResult)entry.getValue()).isSyncFlag()).map(Map.Entry::getKey).collect(Collectors.toList());
            this.attacheHandlerService.sendChangeInfoSyncToSysUser(personIdList);
        }
    }

    protected void saveImportOverride(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        String entityName = dataEntities[0].getDynamicObjectType().getName();
        InfoClassifyEntityKeyDTO infoClassifyEntityKeyDTO = InfoClassifyEntityKeyDTO.getEntityKeyEnumByFormKey((String)entityName);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(infoClassifyEntityKeyDTO.getSourceKey());
        long personId = dataEntities[0].getLong("person.id");
        for (int i = 0; i < dataEntities.length; ++i) {
            DynamicObject[] importSaveDys = this.getImportOverrideDatas(new DynamicObject[]{dataEntities[i]}, serviceHelper);
            boolean syncFlag = AttacheHandlerService.getInstance().validateSyncFieldsUpdateChange(infoClassifyEntityKeyDTO.getSourceKey(), importSaveDys, personId);
            Map resultMap = AttacheHandlerService.getInstance().invokeHisNonLineImportData("override", importSaveDys);
            HrpiServiceOperateResult operateResult = HrpiServiceOperateResult.build((Map)resultMap);
            operateResult.setSyncFlag(syncFlag);
            HrpiServiceOperateResult oldOpRes = this.operateResultMap.get(dataEntities[i].getLong("person.id"));
            if (HRObjectUtils.isEmpty((Object)oldOpRes) || !oldOpRes.isSyncFlag()) {
                this.operateResultMap.put(dataEntities[i].getLong("person.id"), operateResult);
            }
            if (operateResult.isSuccess()) {
                LOGGER.info(String.format(Locale.ROOT, "saveImport%s the id is %s.", entityName, operateResult.getDataMapForIds()));
                HpfsChgexternalrecordQueueHelper.sendBatchHisNonLineInsertMsg((DynamicObject[])new DynamicObject[]{dataEntities[i]}, (String)infoClassifyEntityKeyDTO.getSourceKey(), (String)infoClassifyEntityKeyDTO.getFormKey());
            }
            this.validateOperateResult(args, operateResult, false);
        }
    }

    protected void saveImportOverridenew(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        String entityName = dataEntities[0].getDynamicObjectType().getName();
        InfoClassifyEntityKeyDTO infoClassifyEntityKeyDTO = InfoClassifyEntityKeyDTO.getEntityKeyEnumByFormKey((String)entityName);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(infoClassifyEntityKeyDTO.getSourceKey());
        long personId = dataEntities[0].getLong("person.id");
        for (int i = 0; i < dataEntities.length; ++i) {
            Map resultMap;
            DynamicObject[] importSaveDys;
            boolean syncFlag = false;
            if (dataEntities[i].getLong("boid") != 0L) {
                importSaveDys = this.getImportOverrideDatas(new DynamicObject[]{dataEntities[i]}, serviceHelper);
                syncFlag = AttacheHandlerService.getInstance().validateSyncFieldsUpdateChange(infoClassifyEntityKeyDTO.getSourceKey(), importSaveDys, personId);
                resultMap = AttacheHandlerService.getInstance().invokeHisNonLineImportData("override", importSaveDys);
            } else {
                importSaveDys = this.getImportNewDatas(new DynamicObject[]{dataEntities[i]}, serviceHelper);
                syncFlag = AttacheHandlerService.getInstance().validateSyncFieldsUpdateChange(infoClassifyEntityKeyDTO.getSourceKey(), importSaveDys, personId);
                resultMap = AttacheHandlerService.getInstance().invokeHisNonLineImportData("new", importSaveDys);
            }
            HrpiServiceOperateResult operateResult = HrpiServiceOperateResult.build((Map)resultMap);
            operateResult.setSyncFlag(syncFlag);
            HrpiServiceOperateResult oldOpRes = this.operateResultMap.get(dataEntities[i].getLong("person.id"));
            if (HRObjectUtils.isEmpty((Object)oldOpRes) || !oldOpRes.isSyncFlag()) {
                this.operateResultMap.put(dataEntities[i].getLong("person.id"), operateResult);
            }
            if (operateResult.isSuccess()) {
                LOGGER.info(String.format(Locale.ROOT, "saveImport%s the id is %s.", entityName, operateResult.getDataMapForIds()));
                HpfsChgexternalrecordQueueHelper.sendBatchHisNonLineInsertMsg((DynamicObject[])new DynamicObject[]{dataEntities[i]}, (String)infoClassifyEntityKeyDTO.getSourceKey(), (String)infoClassifyEntityKeyDTO.getFormKey());
            }
            this.validateOperateResult(args, operateResult, false);
        }
    }
}

