/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.opplugin.infoclassify.pereduexpinfo;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hspm.business.domian.service.infoclassify.IPereduexpinfoService;
import kd.hr.hspm.opplugin.infoclassify.pereduexpinfo.PereduexpinfoValidator;
import kd.sdk.hr.hspm.common.constants.HspmCommonConstants;
import kd.sdk.hr.hspm.common.enums.PereduexpcerttypeFieldEnum;
import kd.sdk.hr.hspm.common.enums.PereduexpinfoFieldEnum;
import kd.sdk.hr.hspm.common.result.HrpiServiceOperateResult;
import kd.sdk.hr.hspm.common.utils.DynamicPropValidateUtil;
import kd.sdk.hr.hspm.opplugin.InfoclassifyImportPlugin;
import kd.sdk.hr.hspm.opplugin.InfoclassifySaveOp;
import org.apache.commons.lang.time.StopWatch;

public class PereduexpinfoSaveOp
extends InfoclassifySaveOp {
    private static final Log LOGGER = LogFactory.getLog(PereduexpinfoSaveOp.class);
    private final IPereduexpinfoService pereduexpinfoService = IPereduexpinfoService.getInstance();
    private final PereduexpinfoFieldEnum hrpiPereduexpEnum = PereduexpinfoFieldEnum.HRPI_PEREDUEXP;
    private final PereduexpinfoFieldEnum hrpiPereduexpcertEnum = PereduexpinfoFieldEnum.HRPI_PEREDUEXPCERT;

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new PereduexpinfoValidator());
    }

    protected void saveNew(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            DynamicPropValidateUtil.trim((DynamicObject)dataEntity);
            HrpiServiceOperateResult operateResult = this.pereduexpinfoService.insertPereduexpinfo(dataEntity);
            this.validateOperateResult(args, operateResult);
        }
    }

    protected void saveOverride(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            DynamicPropValidateUtil.trim((DynamicObject)dataEntity);
            Long pkId = (Long)dataEntity.getPkValue();
            DynamicObject dbDy = this.pereduexpinfoService.getPereduexpinfo(pkId);
            Map<String, Boolean> checkChangedMap = this.checkChanged(dataEntity, dbDy);
            boolean flag = false;
            for (Boolean checked : checkChangedMap.values()) {
                if (!checked.booleanValue()) continue;
                flag = true;
                break;
            }
            if (this.isNoDataChanged(args, flag)) continue;
            HrpiServiceOperateResult operateResult = this.pereduexpinfoService.updatePereduexpinfo(pkId, dataEntity, checkChangedMap);
            this.validateOperateResult(args, operateResult);
        }
    }

    protected void delete(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        List pkIdList = Arrays.stream(dataEntities).map(listSelectedRow -> (Long)listSelectedRow.getPkValue()).collect(Collectors.toList());
        if (!pkIdList.isEmpty()) {
            List pereduexpcertIdList = this.pereduexpinfoService.queryPereduexpcertId(pkIdList);
            HrpiServiceOperateResult operateResult = this.pereduexpinfoService.deletePereduexpinfo(pkIdList);
            this.validateOperateResult(args, operateResult);
            this.putAppCache(pereduexpcertIdList);
        }
    }

    private void putAppCache(List<Long> pereduexpcertIdList) {
        IHRAppCache ihrAppCache = HRAppCache.get((String)"hr");
        String pereduexpcertIdListCacheKey = String.format("removePereduexpcertIdList_%s_%s", PereduexpinfoFieldEnum.HRPI_PEREDUEXPCERT.getFormKey(), RequestContext.get().getCurrUserId());
        ihrAppCache.put(pereduexpcertIdListCacheKey, pereduexpcertIdList);
    }

    protected List<Long> checkDelete(AfterOperationArgs args, DynamicObject[] dataEntities) {
        List pkIdList = Arrays.stream(dataEntities).map(listSelectedRow -> (Long)listSelectedRow.getPkValue()).collect(Collectors.toList());
        return this.pereduexpinfoService.queryExistsIdByPkIdList(pkIdList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void afterDelete(AfterOperationArgs args, DynamicObject[] dataEntities) {
        IHRAppCache ihrAppCache = HRAppCache.get((String)"hr");
        String pereduexpcertIdListCacheKey = String.format("removePereduexpcertIdList_%s_%s", PereduexpinfoFieldEnum.HRPI_PEREDUEXPCERT.getFormKey(), RequestContext.get().getCurrUserId());
        try {
            List list = (List)ihrAppCache.get(pereduexpcertIdListCacheKey, List.class);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                List pereduexpcertIdList = list.stream().map(pkId -> (Long)pkId).collect(Collectors.toList());
                this.pereduexpinfoService.removeAttachment(PereduexpinfoFieldEnum.HRPI_PEREDUEXPCERT.getFormKey(), pereduexpcertIdList);
            }
        }
        finally {
            ihrAppCache.remove(pereduexpcertIdListCacheKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveImportNew(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        String entityNumber = dataEntities[0].getDynamicObjectType().getName();
        Long eventId = InfoclassifyImportPlugin.HisBatchImportCache.getInstance().getEventId(entityNumber);
        stopWatch.split();
        LOGGER.info("PereduexpinfoImport ==> start eventId:{}, dataEntities.length: {}, time is: {} ms.", new Object[]{eventId, dataEntities.length, stopWatch.getSplitTime()});
        try {
            for (DynamicObject dataEntity : dataEntities) {
                long graduateschoolId = dataEntity.getLong("graduateschool.id");
                String schoolRecord = dataEntity.getString("schoolrecord");
                if (graduateschoolId == HspmCommonConstants.OTHER_SCHOOL_BOID || !HRStringUtils.isNotEmpty((String)schoolRecord)) continue;
                dataEntity.set("schoolrecord", (Object)"");
            }
            stopWatch.split();
            LOGGER.info("PereduexpinfoImport ==> saveImportNew begin eventId:{}, time is: {} ms.", (Object)eventId, (Object)stopWatch.getSplitTime());
            HrpiServiceOperateResult operateResult = this.pereduexpinfoService.saveImportPereduexpinfo("new", dataEntities, eventId);
            this.validateOperateResult(args, operateResult, false);
        }
        finally {
            stopWatch.stop();
            LOGGER.info("PereduexpinfoImport ==> saveImportNew end eventId:{}, time is: {} ms.", (Object)eventId, (Object)stopWatch.getTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveImportOverride(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        LOGGER.info("PereduexpinfoImport ==> start override");
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            this.saveImportNew(args, dataEntities);
        }
        finally {
            stopWatch.stop();
            LOGGER.info("PereduexpinfoImport ==>end override, time is: {} ms.", (Object)stopWatch.getTime());
        }
    }

    protected void saveImportOverridenew(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        this.saveImportOverride(args, dataEntities);
    }

    private Map<String, Boolean> checkChanged(DynamicObject dataEntity, DynamicObject dbDy) {
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>(16);
        boolean pereduexpChangeFlag = DynamicPropValidateUtil.checkChanged((DynamicObject)dataEntity, (DynamicObject)dbDy);
        resultMap.put(this.hrpiPereduexpEnum.getFormKey(), pereduexpChangeFlag);
        Long pkId = (Long)dataEntity.getPkValue();
        Map pereduexpcertDyMap = this.pereduexpinfoService.queryMapPereduexpcert(pkId);
        List certtypeIdList = this.pereduexpinfoService.queryCerttype();
        for (Long certtypeId : certtypeIdList) {
            if (!dataEntity.containsProperty("operatetype_" + certtypeId)) {
                LOGGER.info("PereduexpinfoSaveOp.validatePereduexpCertRequired the certtype is new create. {}", (Object)certtypeId);
                continue;
            }
            String operateType = dataEntity.getString("operatetype_" + certtypeId);
            if (!HRStringUtils.isEmpty((String)operateType) && HRStringUtils.equals((String)operateType, (String)"0")) {
                resultMap.put(String.join((CharSequence)"_", this.hrpiPereduexpcertEnum.getFormKey(), String.valueOf(certtypeId)), Boolean.TRUE);
            }
            if (HRStringUtils.isEmpty((String)operateType) || !HRStringUtils.equals((String)operateType, (String)"1")) continue;
            DynamicObject pereduexpcertDy = this.pereduexpinfoService.coverPereduexpinfoToPereduexpcert(dataEntity, certtypeId);
            DynamicObject pereduexpcertDbDy = (DynamicObject)pereduexpcertDyMap.get(certtypeId);
            if (HRObjectUtils.isEmpty((Object)pereduexpcertDbDy)) {
                resultMap.put(String.join((CharSequence)"_", this.hrpiPereduexpcertEnum.getFormKey(), String.valueOf(certtypeId)), Boolean.TRUE);
                continue;
            }
            boolean pereduexpcertChangeFlag = DynamicPropValidateUtil.checkChanged((DynamicObject)pereduexpcertDy, (DynamicObject)pereduexpcertDbDy, (String)PereduexpcerttypeFieldEnum.getSelectProperties((long)certtypeId));
            resultMap.put(String.join((CharSequence)"_", this.hrpiPereduexpcertEnum.getFormKey(), String.valueOf(certtypeId)), pereduexpcertChangeFlag);
        }
        return resultMap;
    }
}

