/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.opplugin.infoclassify.perprotitle;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hspm.business.domian.service.infoclassify.IPerprotitleService;
import kd.hr.hspm.opplugin.infoclassify.perprotitle.PerprotitleValidator;
import kd.sdk.hr.hspm.common.result.HrpiServiceOperateResult;
import kd.sdk.hr.hspm.common.utils.DynamicPropValidateUtil;
import kd.sdk.hr.hspm.opplugin.InfoclassifySaveOp;

public class PerprotitleSaveOp
extends InfoclassifySaveOp {
    private static final Log LOGGER = LogFactory.getLog(PerprotitleSaveOp.class);
    private final IPerprotitleService perprotitleService = IPerprotitleService.getInstance();

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new PerprotitleValidator());
    }

    protected void saveNew(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            DynamicPropValidateUtil.trim((DynamicObject)dataEntity);
            HrpiServiceOperateResult operateResult = this.perprotitleService.insertPerprotitle(dataEntity);
            this.validateOperateResult(args, operateResult);
        }
    }

    protected void saveOverride(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            DynamicPropValidateUtil.trim((DynamicObject)dataEntity);
            Long pkId = (Long)dataEntity.getPkValue();
            DynamicObject dbDy = this.perprotitleService.getPerprotitleByPkId(pkId);
            boolean compareResult = DynamicPropValidateUtil.checkChanged((DynamicObject)dataEntity, (DynamicObject)dbDy);
            if (this.isNoDataChanged(args, compareResult)) continue;
            HrpiServiceOperateResult operateResult = this.perprotitleService.updatePerprotitle(pkId, dataEntity);
            this.validateOperateResult(args, operateResult);
        }
    }

    protected void delete(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        List pkIdList = Arrays.stream(dataEntities).map(listSelectedRow -> (Long)listSelectedRow.getPkValue()).collect(Collectors.toList());
        HrpiServiceOperateResult operateResult = this.perprotitleService.deletePerprotitle(pkIdList);
        this.validateOperateResult(args, operateResult);
    }

    protected List<Long> checkDelete(AfterOperationArgs args, DynamicObject[] dataEntities) {
        List pkIdList = Arrays.stream(dataEntities).map(listSelectedRow -> (Long)listSelectedRow.getPkValue()).collect(Collectors.toList());
        return this.perprotitleService.queryExistsIdByPkIdList(pkIdList);
    }

    protected void afterDelete(AfterOperationArgs args, DynamicObject[] dataEntities) {
        OperationResult operationResult = this.getOperationResult();
        List successPkIds = operationResult.getSuccessPkIds();
        if (!CollectionUtils.isEmpty((Collection)successPkIds)) {
            List pkIdList = successPkIds.stream().map(pkId -> (Long)pkId).collect(Collectors.toList());
            this.perprotitleService.removeAttachment("hrpi_perprotitle", pkIdList);
        }
    }

    protected void saveImportNew(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            HrpiServiceOperateResult operateResult = this.perprotitleService.saveImportPerprotitle("new", new DynamicObject[]{dataEntity});
            this.validateOperateResult(args, operateResult, false);
        }
    }
}

