/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.opplugin.infoclassify.personinfo;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hspm.business.domian.service.infoclassify.IPersoninfoService;
import kd.hr.hspm.opplugin.infoclassify.personinfo.PersoninfoValidator;
import kd.sdk.hr.hspm.business.service.AttacheHandlerService;
import kd.sdk.hr.hspm.common.dto.InfoClassifyEntityKeyDTO;
import kd.sdk.hr.hspm.common.enums.PersoninfoFieldEnum;
import kd.sdk.hr.hspm.common.result.HrpiServiceOperateResult;
import kd.sdk.hr.hspm.common.utils.DynamicPropUtil;
import kd.sdk.hr.hspm.common.utils.DynamicPropValidateUtil;
import kd.sdk.hr.hspm.common.utils.HspmDateUtils;
import kd.sdk.hr.hspm.opplugin.InfoclassifyImportPlugin;
import kd.sdk.hr.hspm.opplugin.InfoclassifySaveOp;

public class PersoninfoSaveOp
extends InfoclassifySaveOp {
    private static final Log LOGGER = LogFactory.getLog(PersoninfoSaveOp.class);
    private final IPersoninfoService personinfoService = IPersoninfoService.getInstance();
    protected final AttacheHandlerService attacheHandlerService = AttacheHandlerService.getInstance();
    private final InfoClassifyEntityKeyDTO hspmPersoninfoEnum = InfoClassifyEntityKeyDTO.getEntityKeyEnumByFormKey((String)"hspm_personinfo");
    private final PersoninfoFieldEnum hrpiPernontspropEnum = PersoninfoFieldEnum.HRPI_PERNONTSPROP;
    private final PersoninfoFieldEnum hrpiPertspropEnum = PersoninfoFieldEnum.HRPI_PERTSPROP;
    private final PersoninfoFieldEnum hrpiPerregionEnum = PersoninfoFieldEnum.HRPI_PERREGION;
    private final PersoninfoFieldEnum hrpiPersonEnum = PersoninfoFieldEnum.HRPI_PERSON;
    private final PersoninfoFieldEnum hspmErmanfileEnum = PersoninfoFieldEnum.HSPM_ERMANFILE;
    private final PersoninfoFieldEnum perserlenEnum = PersoninfoFieldEnum.HRPI_PERSERLEN;
    private final Map<Long, HrpiServiceOperateResult> operateResultMap = new HashMap<Long, HrpiServiceOperateResult>(16);

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new PersoninfoValidator());
    }

    protected void saveOverride(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            DynamicPropValidateUtil.trim((DynamicObject)dataEntity);
            this.setAge(dataEntity);
            Long pkId = (Long)dataEntity.getPkValue();
            DynamicObject dbDy = this.personinfoService.getPersoninfo(pkId);
            Map<String, Boolean> checkChangedMap = this.checkChanged(dataEntity, dbDy);
            boolean flag = false;
            for (Boolean checked : checkChangedMap.values()) {
                if (!checked.booleanValue()) continue;
                flag = true;
                break;
            }
            if (this.isNoDataChanged(args, flag)) continue;
            HrpiServiceOperateResult operateResult = this.personinfoService.updatePersoninfo(pkId, dataEntity, checkChangedMap);
            this.validateOperateResult(args, operateResult);
            this.operateResultMap.put(dataEntity.getLong("person.id"), operateResult);
        }
    }

    protected void saveImportOverride(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            this.setAge(dataEntity);
            DynamicObject dbDy = this.personinfoService.getPersoninfo((Long)dataEntity.getPkValue());
            Map<String, Boolean> checkChangedMap = this.checkChanged(dataEntity, dbDy);
            boolean flag = false;
            for (Boolean checked : checkChangedMap.values()) {
                if (!checked.booleanValue()) continue;
                flag = true;
                break;
            }
            if (!flag) {
                this.getOperationResult().setMessage("the entity has not changed.");
                LOGGER.info("the entity has not changed.");
                continue;
            }
            String entityNumber = dataEntity.getDynamicObjectType().getName();
            Long eventId = InfoclassifyImportPlugin.HisBatchImportCache.getInstance().getEventId(entityNumber);
            HrpiServiceOperateResult operateResult = this.personinfoService.saveImportPersoninfo("override", dataEntity, checkChangedMap, eventId);
            this.validateOperateResult(args, operateResult, false);
            this.operateResultMap.put(dataEntity.getLong("person.id"), operateResult);
        }
    }

    private void setAge(DynamicObject dataEntity) {
        Date birthday = dataEntity.getDate("birthday");
        BigDecimal age = HspmDateUtils.dateDiff((Date)birthday);
        dataEntity.set("age", (Object)age);
    }

    public Map<String, Boolean> checkChanged(DynamicObject dataEntity, DynamicObject dbDy) {
        dataEntity.set("entservicelen", dbDy.get("entservicelen"));
        boolean containsVariable = this.getOption().containsVariable("pageoperation");
        if (!containsVariable) {
            dataEntity.set("servicelen", dbDy.get("servicelen"));
        }
        DataEntityPropertyCollection mainProperties = MetadataServiceHelper.getDataEntityType((String)this.hspmPersoninfoEnum.getFormKey()).getProperties();
        DataEntityPropertyCollection pernonsPropProperties = MetadataServiceHelper.getDataEntityType((String)this.hrpiPernontspropEnum.getFormKey()).getProperties();
        String selectProperties = DynamicPropUtil.getSelectProperties((DataEntityPropertyCollection)mainProperties, (DataEntityPropertyCollection)pernonsPropProperties);
        boolean pernontspropChangeFlag = DynamicPropValidateUtil.checkChanged((DynamicObject)dataEntity, (DynamicObject)dbDy, (String)selectProperties);
        DataEntityPropertyCollection pertspropProperties = MetadataServiceHelper.getDataEntityType((String)this.hrpiPertspropEnum.getFormKey()).getProperties();
        selectProperties = DynamicPropUtil.getSelectProperties((DataEntityPropertyCollection)mainProperties, (DataEntityPropertyCollection)pernonsPropProperties, (DataEntityPropertyCollection)pertspropProperties, (String)"person");
        boolean pertspropChangeFlag = DynamicPropValidateUtil.checkChanged((DynamicObject)dataEntity, (DynamicObject)dbDy, (String)selectProperties);
        DataEntityPropertyCollection perregionProperties = MetadataServiceHelper.getDataEntityType((String)this.hrpiPerregionEnum.getFormKey()).getProperties();
        selectProperties = DynamicPropUtil.getSelectProperties((DataEntityPropertyCollection)mainProperties, (DataEntityPropertyCollection)pernonsPropProperties, (DataEntityPropertyCollection)perregionProperties, (String)"person");
        boolean perregionChangeFlag = DynamicPropValidateUtil.checkChanged((DynamicObject)dataEntity, (DynamicObject)dbDy, (String)selectProperties);
        DataEntityPropertyCollection personProperties = MetadataServiceHelper.getDataEntityType((String)this.hrpiPersonEnum.getFormKey()).getProperties();
        selectProperties = DynamicPropUtil.getSelectProperties((DataEntityPropertyCollection)mainProperties, (DataEntityPropertyCollection)pernonsPropProperties, (DataEntityPropertyCollection)personProperties, (String)"headsculpture,name");
        boolean personChangeFlag = DynamicPropValidateUtil.checkChanged((DynamicObject)dataEntity, (DynamicObject)dbDy, (String)selectProperties);
        DataEntityPropertyCollection ermanfileProperties = MetadataServiceHelper.getDataEntityType((String)this.hspmErmanfileEnum.getFormKey()).getProperties();
        selectProperties = DynamicPropUtil.getSelectProperties((DataEntityPropertyCollection)mainProperties, (DataEntityPropertyCollection)pernonsPropProperties, (DataEntityPropertyCollection)ermanfileProperties, (String)"name");
        boolean ermanfileChangeFlag = DynamicPropValidateUtil.checkChanged((DynamicObject)dataEntity, (DynamicObject)dbDy, (String)selectProperties);
        boolean perserlenChangeFlag = DynamicPropValidateUtil.checkChanged((DynamicObject)dataEntity, (DynamicObject)dbDy, (String)"beginservicedate");
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>(16);
        resultMap.put(this.hrpiPernontspropEnum.getFormKey(), pernontspropChangeFlag);
        resultMap.put(this.hrpiPertspropEnum.getFormKey(), pertspropChangeFlag);
        resultMap.put(this.hrpiPerregionEnum.getFormKey(), perregionChangeFlag);
        resultMap.put(this.hrpiPersonEnum.getFormKey(), personChangeFlag);
        resultMap.put(this.hspmErmanfileEnum.getFormKey(), ermanfileChangeFlag);
        resultMap.put(this.perserlenEnum.getFormKey(), perserlenChangeFlag);
        return resultMap;
    }

    protected void afterSaveOverride(AfterOperationArgs args, DynamicObject[] dataEntities) {
        super.afterSaveOverride(args, dataEntities);
        this.sendChangeInfoSyncToSysUser();
    }

    protected void afterSaveImport(AfterOperationArgs args, DynamicObject[] dataEntities) {
        super.afterSaveImport(args, dataEntities);
        this.sendChangeInfoSyncToSysUser();
    }

    private void sendChangeInfoSyncToSysUser() {
        if (!this.operateResultMap.isEmpty()) {
            List personIdList = this.operateResultMap.entrySet().stream().filter(entry -> ((HrpiServiceOperateResult)entry.getValue()).isSyncFlag()).map(Map.Entry::getKey).collect(Collectors.toList());
            this.attacheHandlerService.sendChangeInfoSyncToSysUser(personIdList);
        }
    }
}

