/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.opplugin.infoclassify.preworkexp;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.sdk.hr.hspm.opplugin.InfoClassifyValidator;

public class PreworkexpValidator
extends InfoClassifyValidator {
    protected void validateNew(ExtendedDataEntity[] dataEntities) {
        Date now = this.getNowDate();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            this.commonValidateDateAllowEqual(dataEntity, now);
            this.validateNumber(dataEntity);
        }
    }

    protected void validateOverride(ExtendedDataEntity[] dataEntities) {
        this.validateNew(dataEntities);
    }

    protected void validateImportNew(ExtendedDataEntity[] dataEntities) {
        this.validateNew(dataEntities);
    }

    private void validateNumber(ExtendedDataEntity dataEntity) {
        DynamicObject dy = dataEntity.getDataEntity();
        int subordinates = dy.getInt("subordinates");
        BigDecimal tenuretime = dy.getBigDecimal("tenuretime");
        if (subordinates < 0) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0b\u5c5e\u4eba\u6570\u4e3a\u975e\u8d1f\u6574\u6570\u3002", (String)"PreworkexpValidator_0", (String)"hr-hspm-opplugin", (Object[])new Object[0]));
        }
        if (tenuretime.compareTo(BigDecimal.ZERO) < 0) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4efb\u804c\u65f6\u957f\u4e3a\u975e\u8d1f\u6570\u5b57\u3002", (String)"PreworkexpValidator_2", (String)"hr-hspm-opplugin", (Object[])new Object[0]));
        }
    }
}

