/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.opplugin.web.erfiletype;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class ErFileTypeSaveValidator
extends AbstractValidator {
    private static final Log LOG = LogFactory.getLog(ErFileTypeSaveValidator.class);

    public void validate() {
        Object[] dataEntities = this.getDataEntities();
        HashSet<String> dbUniqueSet = new HashSet<String>(16);
        HashSet<String> contextUniqueSet = new HashSet<String>(16);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hspm_erfiletype");
        Map<Object, Object> dbMap = new HashMap(16);
        String operateKey = this.getOperateKey();
        if ("enable".equals(operateKey)) {
            if (HRArrayUtils.isEmpty((Object[])dataEntities)) {
                return;
            }
            List pkId = Arrays.stream(dataEntities).map(ExtendedDataEntity::getDataEntity).filter(dy -> dy.getLong("id") != 0L).map(dy -> dy.getLong("id")).collect(Collectors.toList());
            Object[] dbDataDys = serviceHelper.query("id,laborreltypemul,laborreltatus,laborreltatus,postype", new QFilter[]{new QFilter("id", "in", pkId)});
            if (HRArrayUtils.isEmpty((Object[])dbDataDys)) {
                return;
            }
            dbMap = Arrays.stream(dbDataDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (k1, k2) -> k1));
        }
        for (Object extendedDataEntity : dataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            MulBasedataDynamicObjectCollection labRelTypeColl = null;
            MulBasedataDynamicObjectCollection labRelStatusColl = null;
            DynamicObject postDy = null;
            if ("enable".equals(operateKey)) {
                DynamicObject dynamicObject = (DynamicObject)dbMap.get(dataEntity.getLong("id"));
                if (dynamicObject == null) continue;
                labRelTypeColl = (MulBasedataDynamicObjectCollection)dynamicObject.getDynamicObjectCollection("laborreltypemul");
                labRelStatusColl = (MulBasedataDynamicObjectCollection)dynamicObject.getDynamicObjectCollection("laborreltatus");
                postDy = dynamicObject.getDynamicObject("postype");
            } else {
                labRelTypeColl = (MulBasedataDynamicObjectCollection)dataEntity.getDynamicObjectCollection("laborreltypemul");
                labRelStatusColl = (MulBasedataDynamicObjectCollection)dataEntity.getDynamicObjectCollection("laborreltatus");
                postDy = dataEntity.getDynamicObject("postype");
            }
            this.validateContextUnique(contextUniqueSet, (ExtendedDataEntity)extendedDataEntity, labRelTypeColl, labRelStatusColl, postDy, true);
            this.validateDbUnique(dbUniqueSet, (ExtendedDataEntity)extendedDataEntity, serviceHelper, labRelTypeColl, labRelStatusColl, postDy);
        }
        LOG.info("showUniqueInfo->{},{}", dbUniqueSet, contextUniqueSet);
    }

    private void validateDbUnique(Set<String> dbUniqueSet, ExtendedDataEntity extendedDataEntity, HRBaseServiceHelper serviceHelper, MulBasedataDynamicObjectCollection labRelTypeColl, MulBasedataDynamicObjectCollection labRelStatusColl, DynamicObject postDy) {
        Object[] dbDataDys;
        if (CollectionUtils.isEmpty((Collection)labRelTypeColl) && CollectionUtils.isEmpty((Collection)labRelStatusColl) && postDy == null) {
            return;
        }
        Set<Object> pageLabTypeIds = new HashSet(16);
        Set<Object> pageLabStatusIds = new HashSet(16);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        long id = dataEntity.getLong("id");
        if (id != 0L) {
            enableFilter.and(new QFilter("id", "!=", (Object)id));
        }
        if (!CollectionUtils.isEmpty((Collection)labRelTypeColl)) {
            pageLabTypeIds = labRelTypeColl.stream().map(dy -> dy.getLong("fbasedataid.id")).collect(Collectors.toSet());
            enableFilter.and(new QFilter("laborreltypemul.fbasedataid", "in", pageLabTypeIds));
        }
        if (!CollectionUtils.isEmpty((Collection)labRelStatusColl)) {
            pageLabStatusIds = labRelStatusColl.stream().map(dy -> dy.getLong("fbasedataid.id")).collect(Collectors.toSet());
            enableFilter.and(new QFilter("laborreltatus.fbasedataid", "in", pageLabStatusIds));
        }
        if (postDy != null) {
            enableFilter.and(new QFilter("postype", "=", (Object)postDy.getLong("id")));
        }
        if (HRArrayUtils.isEmpty((Object[])(dbDataDys = serviceHelper.query("id,laborreltypemul,laborreltatus,laborreltatus,postype", new QFilter[]{enableFilter})))) {
            return;
        }
        for (Object dynamicObject : dbDataDys) {
            MulBasedataDynamicObjectCollection dbLabRelTypeColl = (MulBasedataDynamicObjectCollection)dynamicObject.getDynamicObjectCollection("laborreltypemul");
            MulBasedataDynamicObjectCollection dbLabRelStatusColl = (MulBasedataDynamicObjectCollection)dynamicObject.getDynamicObjectCollection("laborreltatus");
            DynamicObject dbPostDy = dynamicObject.getDynamicObject("postype");
            if (CollectionUtils.isEmpty((Collection)labRelTypeColl) && CollectionUtils.isEmpty((Collection)labRelStatusColl) && postDy != null && dbPostDy != null && CollectionUtils.isEmpty((Collection)dbLabRelTypeColl) && CollectionUtils.isEmpty((Collection)dbLabRelStatusColl) && postDy.getLong("id") == dbPostDy.getLong("id")) {
                StringBuilder errorBd = new StringBuilder(ResManager.loadKDString((String)"\u9002\u7528", (String)"ErFileTypeSaveValidator_0", (String)"hr-hspm-opplugin", (Object[])new Object[0]));
                String postName = postDy.getString("name");
                errorBd.append(postName);
                errorBd.append(ResManager.loadKDString((String)"\u7684", (String)"ErFileTypeSaveValidator_4", (String)"hr-hspm-opplugin", (Object[])new Object[0])).append(ResManager.loadKDString((String)"\u4eba\u4e8b\u4e1a\u52a1\u6863\u6848\u7c7b\u578b\u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c;", (String)"ErFileTypeSaveValidator_1", (String)"hr-hspm-opplugin", (Object[])new Object[0]));
                this.addErrorMessage(extendedDataEntity, errorBd.toString());
                continue;
            }
            this.buildDbUniqueSet(dbLabRelTypeColl, dbLabRelStatusColl, dbPostDy, dbUniqueSet);
            this.validateContextUnique(dbUniqueSet, extendedDataEntity, labRelTypeColl, labRelStatusColl, postDy, false);
        }
    }

    private void buildDbUniqueSet(MulBasedataDynamicObjectCollection dbLabRelTypeColl, MulBasedataDynamicObjectCollection dbLabRelStatusColl, DynamicObject dbPostDy, Set<String> dbUniqueSet) {
        block8: {
            Long postypeId;
            block9: {
                block7: {
                    postypeId = null;
                    if (dbPostDy != null) {
                        postypeId = dbPostDy.getLong("id");
                    }
                    if (CollectionUtils.isEmpty((Collection)dbLabRelTypeColl) || CollectionUtils.isEmpty((Collection)dbLabRelStatusColl)) break block7;
                    for (DynamicObject labStatusDy : dbLabRelStatusColl) {
                        DynamicObject statusDy = labStatusDy.getDynamicObject("fbasedataid");
                        Long labStatusId = null;
                        Long labTypeId = null;
                        if (statusDy != null) {
                            labStatusId = statusDy.getLong("id");
                        }
                        for (DynamicObject labTypeDy : dbLabRelTypeColl) {
                            DynamicObject typeDy = labTypeDy.getDynamicObject("fbasedataid");
                            if (typeDy != null) {
                                labTypeId = typeDy.getLong("id");
                            }
                            dbUniqueSet.add(this.getPostTypeAndStatusAndLabTypeUniqueKey(postypeId, labStatusId, labTypeId));
                        }
                    }
                    break block8;
                }
                if (CollectionUtils.isEmpty((Collection)dbLabRelTypeColl)) break block9;
                for (DynamicObject dy : dbLabRelTypeColl) {
                    DynamicObject labTypeDy = dy.getDynamicObject("fbasedataid");
                    if (labTypeDy == null) continue;
                    dbUniqueSet.add(this.getPostTypeAndStatusAndLabTypeUniqueKey(postypeId, null, labTypeDy.getLong("id")));
                }
                break block8;
            }
            if (CollectionUtils.isEmpty((Collection)dbLabRelStatusColl)) break block8;
            for (DynamicObject dy : dbLabRelStatusColl) {
                DynamicObject labStatusDy = dy.getDynamicObject("fbasedataid");
                if (labStatusDy == null) continue;
                dbUniqueSet.add(this.getPostTypeAndStatusAndLabTypeUniqueKey(postypeId, labStatusDy.getLong("id"), null));
            }
        }
    }

    private void validateContextUnique(Set<String> uniqueSet, ExtendedDataEntity extendedDataEntity, MulBasedataDynamicObjectCollection labRelTypeColl, MulBasedataDynamicObjectCollection labRelStatusColl, DynamicObject postDy, boolean validateContext) {
        if (!CollectionUtils.isEmpty((Collection)labRelTypeColl) && !CollectionUtils.isEmpty((Collection)labRelStatusColl)) {
            this.tipExistKey(uniqueSet, extendedDataEntity, validateContext, labRelTypeColl, labRelStatusColl, postDy);
        } else if (!CollectionUtils.isEmpty((Collection)labRelTypeColl)) {
            this.tipOneEmptyExistKey(uniqueSet, extendedDataEntity, validateContext, labRelTypeColl, postDy, true);
        } else if (!CollectionUtils.isEmpty((Collection)labRelStatusColl)) {
            this.tipOneEmptyExistKey(uniqueSet, extendedDataEntity, validateContext, labRelStatusColl, postDy, false);
        }
    }

    private void tipOneEmptyExistKey(Set<String> contextUniqueSet, ExtendedDataEntity extendedDataEntity, boolean validateContext, MulBasedataDynamicObjectCollection collect, DynamicObject postDy, boolean statusEmpty) {
        Long postypeId = null;
        if (postDy != null) {
            postypeId = postDy.getLong("id");
        }
        StringBuilder errorBd = new StringBuilder(ResManager.loadKDString((String)"\u9002\u7528", (String)"ErFileTypeSaveValidator_0", (String)"hr-hspm-opplugin", (Object[])new Object[0]));
        for (DynamicObject dy : collect) {
            Long notEmptyId = null;
            DynamicObject statusDy = dy.getDynamicObject("fbasedataid");
            if (statusDy != null) {
                notEmptyId = statusDy.getLong("id");
            }
            String uniqueKey = "";
            uniqueKey = statusEmpty ? this.getPostTypeAndStatusAndLabTypeUniqueKey(postypeId, null, notEmptyId) : this.getPostTypeAndStatusAndLabTypeUniqueKey(postypeId, notEmptyId, null);
            if (validateContext) {
                if (!HRStringUtils.isNotEmpty((String)uniqueKey) || contextUniqueSet.add(uniqueKey)) continue;
                this.setDbError(extendedDataEntity, postDy, errorBd, dy);
                continue;
            }
            if (HRStringUtils.isNotEmpty((String)uniqueKey) && contextUniqueSet.contains(uniqueKey)) {
                this.setDbError(extendedDataEntity, postDy, errorBd, dy);
            }
            contextUniqueSet.remove(uniqueKey);
        }
    }

    private void setDbError(ExtendedDataEntity extendedDataEntity, DynamicObject postDy, StringBuilder errorBd, DynamicObject dy) {
        DynamicObject dynamicObject = dy.getDynamicObject("fbasedataid");
        String name = "";
        if (dynamicObject != null) {
            name = dynamicObject.getString("name");
        }
        errorBd.append(name);
        if (postDy != null) {
            errorBd.append("\u3001").append(postDy.getString("name"));
        }
        errorBd.append(ResManager.loadKDString((String)"\u7684", (String)"ErFileTypeSaveValidator_4", (String)"hr-hspm-opplugin", (Object[])new Object[0])).append(ResManager.loadKDString((String)"\u4eba\u4e8b\u4e1a\u52a1\u6863\u6848\u7c7b\u578b\u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c;", (String)"ErFileTypeSaveValidator_1", (String)"hr-hspm-opplugin", (Object[])new Object[0]));
        this.addErrorMessage(extendedDataEntity, errorBd.toString());
    }

    private void tipExistKey(Set<String> uniqueSet, ExtendedDataEntity extendedDataEntity, boolean validateContext, MulBasedataDynamicObjectCollection labRelTypeColl, MulBasedataDynamicObjectCollection labRelStatusColl, DynamicObject postDy) {
        String tip = ResManager.loadKDString((String)"\u9002\u7528%1$s\u3001%2$s\u3001%3$s\u7684\u4eba\u4e8b\u4e1a\u52a1\u6863\u6848\u7c7b\u578b\u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c;", (String)"ErFileTypeSaveValidator_2", (String)"hr-hspm-opplugin", (Object[])new Object[0]);
        String tip1 = ResManager.loadKDString((String)"\u9002\u7528%1$s\u3001%2$s\u7684\u4eba\u4e8b\u4e1a\u52a1\u6863\u6848\u7c7b\u578b\u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c;", (String)"ErFileTypeSaveValidator_3", (String)"hr-hspm-opplugin", (Object[])new Object[0]);
        Long postypeId = null;
        String postName = "";
        if (postDy != null) {
            postypeId = postDy.getLong("id");
            postName = postDy.getString("name");
        }
        for (DynamicObject labStatusDy : labRelStatusColl) {
            DynamicObject statusDy = labStatusDy.getDynamicObject("fbasedataid");
            Long labStatusId = null;
            Long labTypeId = null;
            if (statusDy != null) {
                labStatusId = statusDy.getLong("id");
            }
            for (DynamicObject labTypeDy : labRelTypeColl) {
                DynamicObject dynamicObject1;
                DynamicObject typeDy = labTypeDy.getDynamicObject("fbasedataid");
                if (typeDy != null) {
                    labTypeId = typeDy.getLong("id");
                }
                String uniqueKey = this.getPostTypeAndStatusAndLabTypeUniqueKey(postypeId, labStatusId, labTypeId);
                String typeName = "";
                String statusName = "";
                DynamicObject dynamicObject = labStatusDy.getDynamicObject("fbasedataid");
                if (dynamicObject != null) {
                    typeName = dynamicObject.getString("name");
                }
                if ((dynamicObject1 = labTypeDy.getDynamicObject("fbasedataid")) != null) {
                    statusName = dynamicObject1.getString("name");
                }
                if (validateContext) {
                    if (!HRStringUtils.isNotEmpty((String)uniqueKey) || uniqueSet.add(uniqueKey)) continue;
                    this.addError(extendedDataEntity, tip, tip1, postName, typeName, statusName);
                    continue;
                }
                if (!HRStringUtils.isNotEmpty((String)uniqueKey) || !uniqueSet.contains(uniqueKey)) continue;
                this.addError(extendedDataEntity, tip, tip1, postName, typeName, statusName);
            }
        }
    }

    private void addError(ExtendedDataEntity extendedDataEntity, String tip, String tip1, String postName, String typeName, String statusName) {
        if (HRStringUtils.isNotEmpty((String)postName)) {
            this.addErrorMessage(extendedDataEntity, String.format(tip, typeName, statusName, postName));
        } else {
            this.addErrorMessage(extendedDataEntity, String.format(tip1, typeName, statusName));
        }
    }

    private String getPostTypeAndStatusAndLabTypeUniqueKey(Long postypeId, Long labStatusId, Long labTypeId) {
        if (!(postypeId != null && postypeId != 0L || labStatusId != null && labStatusId != 0L || labTypeId != null && labTypeId != 0L)) {
            return null;
        }
        return postypeId + "-" + labStatusId + "-" + labTypeId;
    }
}

