/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.opplugin.web.revise;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hspm.business.domian.repository.inforevise.EmpposorgrelRepository;

public class EmpPosOrgRelReviseSaveValidator
extends AbstractValidator {
    private static final Log LOG = LogFactory.getLog(EmpPosOrgRelReviseSaveValidator.class);

    public void validate() {
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        List employeeIdList = Arrays.stream(extendedDataEntities).map(extendedDataEntity -> extendedDataEntity.getDataEntity().getLong("employee.id")).collect(Collectors.toList());
        DynamicObject[] allPrimaryDynArr = EmpposorgrelRepository.getInstance().queryIsPrimaryDataByEmployeeIdList(employeeIdList);
        Map<Long, List<DynamicObject>> employeeIdVsPrimaryDynListMap = Arrays.stream(allPrimaryDynArr).collect(Collectors.groupingBy(dyn -> dyn.getLong("employee.id")));
        for (ExtendedDataEntity extendedDataEntity2 : extendedDataEntities) {
            String dateStr;
            DynamicObject employeeDyn;
            Date firstBsed;
            DynamicObject jobVIdDyn;
            Date firstBsed2;
            DynamicObject stdPositionVidDyn;
            DynamicObject dataEntity = extendedDataEntity2.getDataEntity();
            this.validateJustOnePrimaryDyn(employeeIdVsPrimaryDynListMap, extendedDataEntity2);
            Date startDate = dataEntity.getDate("startdate");
            Date endDate = dataEntity.getDate("enddate");
            if (Objects.isNull(endDate)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                endDate = HisEffDateCommonService.getInstance().getDate2999(sdf);
            }
            if (Objects.nonNull(stdPositionVidDyn = dataEntity.getDynamicObject("stdpositionvid")) && Objects.nonNull(firstBsed2 = stdPositionVidDyn.getDate("firstbsed"))) {
                String dateStr2 = HRDateTimeUtils.format((Date)firstBsed2, (String)"yyyy-MM-dd");
                if (HRDateTimeUtils.dayBefore((Date)startDate, (Date)firstBsed2)) {
                    this.addFatalErrorMessage(extendedDataEntity2, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a\u4efb\u804c\u5f00\u59cb\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u6807\u51c6\u5c97\u4f4d\u7684\u751f\u6548\u65e5\u671f\u201c%s\u201d\u3002", (String)"EmpPosOrgRelReviseSaveValidator_0", (String)"hr-hspm-opplugin", (Object[])new Object[0]), dateStr2));
                }
            }
            if (Objects.nonNull(jobVIdDyn = dataEntity.getDynamicObject("jobvid")) && Objects.nonNull(firstBsed = jobVIdDyn.getDate("firstbsed"))) {
                String dateStr3 = HRDateTimeUtils.format((Date)firstBsed, (String)"yyyy-MM-dd");
                if (HRDateTimeUtils.dayBefore((Date)startDate, (Date)firstBsed)) {
                    this.addFatalErrorMessage(extendedDataEntity2, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a\u4efb\u804c\u5f00\u59cb\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u804c\u4f4d\u7684\u751f\u6548\u65e5\u671f\u201c%s\u201d\u3002", (String)"EmpPosOrgRelReviseSaveValidator_1", (String)"hr-hspm-opplugin", (Object[])new Object[0]), dateStr3));
                }
            }
            if (HRDateTimeUtils.dayBefore((Date)endDate, (Date)startDate)) {
                this.addErrorMessage(extendedDataEntity2, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5f00\u59cb\u65e5\u671f\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", (String)"EmpPosOrgRelReviseSaveValidator_2", (String)"hr-hspm-opplugin", (Object[])new Object[0]));
            }
            if (Objects.isNull(employeeDyn = dataEntity.getDynamicObject("employee"))) {
                return;
            }
            Date workStartDate = employeeDyn.getDate("startdate");
            Date workEndDate = employeeDyn.getDate("enddate");
            if (HRDateTimeUtils.dayBefore((Date)startDate, (Date)workStartDate)) {
                dateStr = HRDateTimeUtils.format((Date)workStartDate, (String)"yyyy-MM-dd");
                this.addFatalErrorMessage(extendedDataEntity2, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u4efb\u804c\u5f00\u59cb\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u7528\u5de5\u5f00\u59cb\u65e5\u671f%s\u3002", (String)"EmpPosOrgRelReviseSaveValidator_3", (String)"hr-hspm-opplugin", (Object[])new Object[0]), dateStr));
            }
            if (!HRDateTimeUtils.dayBefore((Date)workEndDate, (Date)endDate)) continue;
            dateStr = HRDateTimeUtils.format((Date)workEndDate, (String)"yyyy-MM-dd");
            this.addErrorMessage(extendedDataEntity2, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u4efb\u804c\u7ed3\u675f\u65e5\u671f\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u7528\u5de5\u7ed3\u675f\u65e5\u671f%s\u3002", (String)"EmpPosOrgRelReviseSaveValidator_4", (String)"hr-hspm-opplugin", (Object[])new Object[0]), dateStr));
        }
    }

    private void validateJustOnePrimaryDyn(Map<Long, List<DynamicObject>> employeeIdVsPrimaryDynListMap, ExtendedDataEntity extendedDataEntity) {
        String isPrimary;
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        Date startDate = dataEntity.getDate("startdate");
        Date endDate = dataEntity.getDate("enddate");
        boolean endDataNullFlag = false;
        if (Objects.isNull(endDate)) {
            endDataNullFlag = true;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            endDate = HisEffDateCommonService.getInstance().getDate2999(sdf);
        }
        if ("0".equals(isPrimary = dataEntity.getString("isprimary"))) {
            return;
        }
        long boId = dataEntity.getLong("boid");
        DynamicObject employeeDyn = dataEntity.getDynamicObject("employee");
        if (Objects.isNull(employeeDyn)) {
            return;
        }
        long employeeId = employeeDyn.getLong("id");
        LOG.info("EmpPosOrgRelReviseSaveValidator#validateJustOnePrimaryDyn.boId={}, employeeId={}", (Object)boId, (Object)employeeId);
        List<DynamicObject> primaryDynList = employeeIdVsPrimaryDynListMap.get(employeeId);
        if (CollectionUtils.isEmpty(primaryDynList)) {
            LOG.info("EmpPosOrgRelReviseSaveValidator#validateJustOnePrimaryDyn.primaryDynList.isempty");
            return;
        }
        LOG.info("EmpPosOrgRelReviseSaveValidator#validateJustOnePrimaryDyn.before.boIdList={}", primaryDynList.stream().map(dyn -> dyn.getLong("boid")).collect(Collectors.toList()));
        List primaryDynListFilterCur = primaryDynList.stream().filter(dyn -> boId != dyn.getLong("boid")).collect(Collectors.toList());
        LOG.info("EmpPosOrgRelReviseSaveValidator#validateJustOnePrimaryDyn.after.boIdList={}", primaryDynListFilterCur.stream().map(dyn -> dyn.getLong("boid")).collect(Collectors.toList()));
        for (DynamicObject isPrimaryDyn : primaryDynListFilterCur) {
            Date endDateFromDB;
            Date startDateFromDB = isPrimaryDyn.getDate("startdate");
            if (!this.isOverlap(startDateFromDB, endDateFromDB = isPrimaryDyn.getDate("enddate"), startDate, endDate)) continue;
            String name = this.getOption().getVariableValue("name", "");
            String startDateStr = HRDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd");
            String endDateStr = HRDateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd");
            if (endDataNullFlag) {
                String curStr = ResManager.loadKDString((String)"\u81f3\u4eca", (String)"EmpPosOrgRelReviseSaveValidator_6", (String)"hr-hspm-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a\u201c%1$s\u201d\u5728\u201c%2$s\u201d~\u201c%3$s\u201d\u5df2\u6709\u4e3b\u4efb\u804c\u7ecf\u5386\u3002", (String)"EmpPosOrgRelReviseSaveValidator_5", (String)"hr-hspm-opplugin", (Object[])new Object[0]), name, startDateStr, curStr));
            } else {
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a\u201c%1$s\u201d\u5728\u201c%2$s\u201d~\u201c%3$s\u201d\u5df2\u6709\u4e3b\u4efb\u804c\u7ecf\u5386\u3002", (String)"EmpPosOrgRelReviseSaveValidator_5", (String)"hr-hspm-opplugin", (Object[])new Object[0]), name, startDateStr, endDateStr));
            }
            return;
        }
    }

    private boolean isOverlap(Date startDateFromDB, Date endDateFromDB, Date startDate, Date endDate) {
        return !HRDateTimeUtils.dayBefore((Date)endDateFromDB, (Date)startDate) && !HRDateTimeUtils.dayBefore((Date)endDate, (Date)startDateFromDB);
    }
}

