/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.opplugin.web.revise;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.opplugin.web.HRCoreBaseBillOp;
import kd.hr.hspm.business.domian.repository.inforevise.ReviseRecordRepository;
import kd.hr.hspm.business.domian.service.impl.inforevise.RevisePublishServiceImpl;
import kd.hr.hspm.business.revise.PersonReviseService;
import kd.sdk.hr.hspm.business.repository.CommonQueryRepository;
import kd.sdk.hr.hspm.business.revise.helper.ReviseEntityNameHelperEnum;
import kd.sdk.hr.hspm.common.constants.PersonReviseConstants;
import org.apache.curator.shaded.com.google.common.collect.Maps;

public class ReviseNoticeOp
extends HRCoreBaseBillOp
implements PersonReviseConstants {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] reviseRecordDynArr;
        OperateOption option = this.getOption();
        String entityName = option.getVariableValue("entityname");
        Long employeeId = Long.valueOf(option.getVariableValue("employeeid"));
        Long ermanFileId = Long.valueOf(option.getVariableValue("ermanfileid"));
        Long personId = Long.valueOf(option.getVariableValue("personid"));
        String groupName = String.valueOf(option.getVariableValue("groupname"));
        PersonReviseService personReviseService = new PersonReviseService(true, entityName);
        DynamicObject[] hisVersions = personReviseService.getHisVersions(entityName, employeeId, ermanFileId, personId, true, false, false);
        List boIdList = Arrays.stream(hisVersions).map(dyn -> dyn.getLong("boid")).collect(Collectors.toList());
        QFilter reviseBoFilter = new QFilter("revisebo", "in", boIdList);
        reviseBoFilter.and(new QFilter("reviserecord.issend", "=", (Object)"0"));
        String logEntityName = ReviseEntityNameHelperEnum.getLogEntityNameByBaseEntityName((String)entityName);
        DynamicObject[] reviseLogDynArr = CommonQueryRepository.getInstance().queryColsInfoByFilter(logEntityName, (Set)Sets.newHashSet((Object[])new String[]{"id", "reviserecord"}), reviseBoFilter);
        Set notSendReviseCordIdSet = Arrays.stream(reviseLogDynArr).map(dyn -> dyn.getLong("reviserecord.id")).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(notSendReviseCordIdSet)) {
            return;
        }
        ArrayList<Long> notSendReviseCordIdList = new ArrayList<Long>(notSendReviseCordIdSet);
        HashMap msgMap = Maps.newHashMapWithExpectedSize((int)2);
        msgMap.put("entityNumber", entityName);
        msgMap.put("reviserecordList", notSendReviseCordIdList);
        RevisePublishServiceImpl revisePublishService = new RevisePublishServiceImpl(entityName, (Object)msgMap, personId, groupName);
        revisePublishService.publish();
        this.saveSendRecordDyn(entityName, notSendReviseCordIdList, msgMap);
        for (DynamicObject reviseRecordDyn : reviseRecordDynArr = ReviseRecordRepository.getInstance().loadByPkIdList(notSendReviseCordIdList)) {
            reviseRecordDyn.set("issend", (Object)"1");
        }
        ReviseRecordRepository.getInstance().save(reviseRecordDynArr);
    }

    private void saveSendRecordDyn(String entityName, List<Long> notSendReviseCordIdList, Map<String, Object> msgMap) {
        HRBaseServiceHelper reviseSendRecordHelper = new HRBaseServiceHelper("hrpi_revisesendrecord");
        DynamicObject reviseSendRecordDyn = reviseSendRecordHelper.generateEmptyDynamicObject();
        Date now = new Date();
        long currUserId = RequestContext.get().getCurrUserId();
        reviseSendRecordDyn.set("createtime", (Object)now);
        reviseSendRecordDyn.set("creator", (Object)currUserId);
        reviseSendRecordDyn.set("modifytime", (Object)now);
        reviseSendRecordDyn.set("modifier", (Object)currUserId);
        reviseSendRecordDyn.set("revisenumber", (Object)entityName);
        reviseSendRecordDyn.set("senddate", (Object)now);
        reviseSendRecordDyn.set("sendparam", (Object)SerializationUtils.toJsonString(msgMap));
        reviseSendRecordDyn.set("sendcount", (Object)1);
        reviseSendRecordDyn.set("sendstatus", (Object)"1");
        DynamicObjectCollection reviseRecordDynCol = reviseSendRecordDyn.getDynamicObjectCollection("reviserecord");
        DynamicObjectType entryType = reviseRecordDynCol.getDynamicObjectType();
        for (Long notSendReviseCordId : notSendReviseCordIdList) {
            DynamicObject row = new DynamicObject(entryType);
            row.set("fbasedataid", (Object)notSendReviseCordId);
            reviseRecordDynCol.add((Object)row);
        }
        reviseSendRecordDyn.set("reviserecord", (Object)reviseRecordDynCol);
        reviseSendRecordHelper.save(new DynamicObject[]{reviseSendRecordDyn});
    }
}

