/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.opplugin.web.revise;

import java.util.Date;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class TrialPeriodReviseSaveValidator
extends AbstractValidator {
    private static final Log LOG = LogFactory.getLog(TrialPeriodReviseSaveValidator.class);

    public void validate() {
        ExtendedDataEntity[] extendedDataEntities;
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities = this.getDataEntities()) {
            DynamicObject employeeDyn;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            Date startDate = dataEntity.getDate("startdate");
            Date endDate = dataEntity.getDate("enddate");
            if (Objects.isNull(endDate)) {
                endDate = HisEffDateCommonService.getInstance().getDate2999(null);
            }
            if (Objects.nonNull(startDate) && Objects.nonNull(endDate) && HRDateTimeUtils.dayBefore((Date)endDate, (Date)startDate)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5f00\u59cb\u65e5\u671f\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", (String)"TrialPeriodReviseSaveValidator_0", (String)"hr-hspm-opplugin", (Object[])new Object[0]));
            }
            if (Objects.isNull(employeeDyn = dataEntity.getDynamicObject("employee"))) {
                return;
            }
            Date workStartDate = employeeDyn.getDate("startdate");
            Date workEndDate = employeeDyn.getDate("enddate");
            if (!Objects.nonNull(startDate) || !Objects.nonNull(workStartDate) || !HRDateTimeUtils.dayBefore((Date)startDate, (Date)workStartDate)) continue;
            String dateStr = HRDateTimeUtils.format((Date)workStartDate, (String)"yyyy-MM-dd");
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a\u5f00\u59cb\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u7528\u5de5\u5f00\u59cb\u65e5\u671f\u201c%s\u201d\u3002", (String)"TrialPeriodReviseSaveValidator_1", (String)"hr-hspm-opplugin", (Object[])new Object[0]), dateStr));
        }
    }
}

