/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.multiviewconfig;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hspm.formplugin.multiviewconfig.MultiViewConfigPlugin;
import kd.sdk.hr.hspm.business.helper.InfoGroupHelper;
import kd.sdk.hr.hspm.common.enums.ConfigAreaEnum;

public class MultiLevelMenuPlugin
extends HRDynamicFormBasePlugin
implements BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(MultiViewConfigPlugin.class);

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        if (!InfoGroupHelper.enableMultiLevelMenu()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"multilevelmenuflex"});
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit headFieldEdit = (BasedataEdit)this.getView().getControl("twolevelmenu");
        headFieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        BasedataEdit basedataEdit = (BasedataEdit)beforeF7SelectEvent.getSource();
        String key = basedataEdit.getKey();
        if ("twolevelmenu".equals(key)) {
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            listShowParameter.setFormId("bos_listf7");
            HashMap<Long, String> nameMap = new HashMap<Long, String>(16);
            this.collectGroupId(nameMap, true);
            this.collectGroupId(nameMap, false);
            if (CollectionUtils.isEmpty(nameMap)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u914d\u7f6e\u4e8c\u7ea7\u83dc\u5355\u7684\u4fe1\u606f\u7ec4\u3002", (String)"MultiLevelMenuPlugin_0", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            DynamicObjectCollection dys = this.getModel().getEntryEntity("multilevelmenuentity");
            if (!CollectionUtils.isEmpty((Collection)dys)) {
                int opRow = beforeF7SelectEvent.getRow();
                for (int index = 0; index < dys.size(); ++index) {
                    DynamicObject dy;
                    DynamicObjectCollection dynamicObjects;
                    if (index == opRow || CollectionUtils.isEmpty((Collection)(dynamicObjects = (dy = (DynamicObject)dys.get(index)).getDynamicObjectCollection("twolevelmenu")))) continue;
                    for (DynamicObject dynamicObject : dynamicObjects) {
                        if (dynamicObject.getDynamicObject("fbasedataid") == null) continue;
                        nameMap.remove(dynamicObject.getDynamicObject("fbasedataid").getLong("id"));
                    }
                }
            }
            if (nameMap.size() == 0) {
                nameMap.put(-1L, "1");
            }
            listShowParameter.setCustomParam("groupname", nameMap);
            listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", nameMap.keySet()));
        }
    }

    private void collectGroupId(Map<Long, String> nameMap, boolean isMainArea) {
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(InfoGroupHelper.getCurrentEntityKey((boolean)isMainArea));
        if (!CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            String prex = InfoGroupHelper.getConfigArea((boolean)isMainArea).getCode();
            String groupIdKey = prex + "groupid";
            String groupNameKey = prex + "groupname";
            for (DynamicObject dy : dynamicObjects) {
                String groupId;
                if (isMainArea && !ConfigAreaEnum.COMMON.getValue().equals(dy.getString("mainconfigarea")) || !HRStringUtils.isNotEmpty((String)(groupId = dy.getString(groupIdKey))) || groupId.startsWith("sub_") || groupId.equals("root")) continue;
                String groupName = null;
                ILocaleString localeString = dy.getLocaleString(groupNameKey);
                if (localeString != null && HRStringUtils.isNotEmpty((String)localeString.getLocaleValue())) {
                    groupName = localeString.getLocaleValue();
                }
                nameMap.put(Long.parseLong(groupId), groupName == null ? dy.getString(groupNameKey) : groupName);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String key = args.getProperty().getName();
        if ("onelevelmenu".equals(key)) {
            LocaleDynamicObjectCollection locales = (LocaleDynamicObjectCollection)args.getChangeSet()[0].getNewValue();
            if (CollectionUtils.isEmpty((Collection)locales)) {
                return;
            }
            DynamicObjectCollection dys = this.getModel().getEntryEntity("multilevelmenuentity");
            if (CollectionUtils.isEmpty((Collection)dys) || dys.size() < 2) {
                return;
            }
            DynamicObject currentDy = args.getChangeSet()[0].getDataEntity();
            Integer currentSeq = currentDy.getInt("seq");
            for (DynamicObject dynamicObject : dys) {
                OrmLocaleValue localeValue;
                if (currentSeq != null && currentSeq.equals(dynamicObject.getInt("seq")) || (localeValue = (OrmLocaleValue)dynamicObject.get("onelevelmenu")) == null) continue;
                for (DynamicObject locale : locales) {
                    String str = localeValue.get(locale.get(1));
                    if (!HRStringUtils.isNotEmpty((String)str) || !str.equals(locale.get(2))) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e00\u7ea7\u83dc\u5355\u540d\u79f0\u4e0d\u80fd\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"MultiLevelMenuPlugin_1", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                    LocaleDynamicObjectCollection oldLocales = (LocaleDynamicObjectCollection)args.getChangeSet()[0].getOldValue();
                    OrmLocaleValue value = (OrmLocaleValue)((DynamicObject)dys.get(currentSeq - 1)).get("onelevelmenu");
                    if (oldLocales != null && oldLocales.size() > 0) {
                        this.changeToOrmLocaleValue(oldLocales, value);
                    } else {
                        value.clear();
                    }
                    this.getModel().setValue("onelevelmenu", (Object)value, currentSeq - 1);
                    return;
                }
            }
        }
    }

    private void changeToOrmLocaleValue(LocaleDynamicObjectCollection localeDyCollection, OrmLocaleValue localeValue) {
        for (DynamicObject dy : localeDyCollection) {
            localeValue.setItem(dy.get(1).toString(), dy.get(2).toString());
        }
    }
}

