/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.print;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.plugin.AbstractPrintPlugin;
import kd.bos.print.core.plugin.event.AfterLoadDataEvent;
import kd.bos.print.core.plugin.event.CustomDataLoadEvent;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hspm.formplugin.common.PrintUtils;

public class PrintInfoPlugin
extends AbstractPrintPlugin {
    private static final Log LOGGER = LogFactory.getLog(PrintInfoPlugin.class);
    private final String[] PROP_NAME = new String[]{"startdate", "enddate"};
    private final String[] PEREDUEXP_PROP = new String[]{"admissiondate", "gradutiondate"};
    private static final Set<String> NUMBERS;
    private static final Map<String, String> SORT_MAP;

    public void setExtParam(Map<String, Object> extParam) {
        super.setExtParam(extParam);
    }

    public void afterLoadData(AfterLoadDataEvent evt) {
        super.afterLoadData(evt);
        List dataRowSets = evt.getDataRowSets();
        String dyName = evt.getDataSource().getDsName();
        LOGGER.info("PrintInfoPlugin_dyName:{}", (Object)dyName);
        if (NUMBERS.contains(dyName) && !CollectionUtils.isEmpty((Collection)dataRowSets)) {
            this.sortData(evt, dataRowSets, dyName, this.PROP_NAME);
        }
        if (HRStringUtils.equals((String)"hrpi_pereduexp", (String)dyName)) {
            this.sortData(evt, dataRowSets, dyName, this.PEREDUEXP_PROP);
        }
        if (HRStringUtils.equals((String)"hrpi_empentrel", (String)dyName)) {
            PrintUtils.replaceDate(dataRowSets, this.PROP_NAME[1], "-");
        }
        if (SORT_MAP.containsKey(dyName) && !CollectionUtils.isEmpty((Collection)dataRowSets)) {
            List<DataRowSet> newDataRowSets = PrintUtils.getSortList((List<DataRowSet>)dataRowSets, SORT_MAP.get(dyName), dyName);
            evt.setDataRowSets(newDataRowSets);
        }
    }

    private void sortData(AfterLoadDataEvent evt, List<DataRowSet> dataRowSets, String dyName, String[] props) {
        List<DataRowSet> newDataRowSets = PrintUtils.getSortList(dataRowSets, props, dyName);
        PrintUtils.replaceDate(newDataRowSets, props[1], ResManager.loadKDString((String)"\u81f3\u4eca", (String)"PrintInfoPlugin_0", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
        evt.setDataRowSets(newDataRowSets);
    }

    public void loadCustomData(CustomDataLoadEvent evt) {
        super.loadCustomData(evt);
    }

    static {
        SORT_MAP = ImmutableMap.builder().put((Object)"hrpi_perrprecord", (Object)"rewarddate").put((Object)"hrpi_perprotitle", (Object)"awardtime").put((Object)"hrpi_perpractqual", (Object)"registratedate").put((Object)"hrpi_perocpqual", (Object)"registratedate").build();
        HashSet lySet = Sets.newHashSet();
        lySet.add("hrpi_laborrelrecord");
        lySet.add("hrpi_empjobrel");
        lySet.add("hrpi_empposorgrel");
        lySet.add("hrpi_projectmemrecord");
        lySet.add("hrpi_preworkexp");
        lySet.add("hrpi_empproexp");
        NUMBERS = Collections.unmodifiableSet(lySet);
    }
}

