/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.print;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.form.FormConfig;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IMobileView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.IListView;
import kd.bos.list.IMobileListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.IReportView;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.query.QueryListPlugin;

public class ResumeListPrintPlugin
extends QueryListPlugin {
    private static final Log LOGGER = LogFactory.getLog(ResumeListPrintPlugin.class);
    private static final String KEY_SELECTTPLPRINT_EXT = "selecttplprintext";
    private static final HRBaseServiceHelper HSPM_ERMANFILE = new HRBaseServiceHelper("hspm_ermanfile");
    private static final int MAX_SELECT_COUNT = 1000;
    private static final long POST_FULLTIME = 1010L;
    private static final String KEY_EMPPOSREL_POSTID = "empposrel.postype.id";

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String opKey = operate.getOperateKey();
        if (HRStringUtils.equals((String)KEY_SELECTTPLPRINT_EXT, (String)opKey)) {
            this.showSelectPrintForm();
        }
    }

    private void showSelectPrintForm() {
        String oriFormId;
        List<Object> pkids = this.getPKIds();
        if (pkids.size() > 1000) {
            this.getView().showMessage(MessageFormat.format(ResManager.loadKDString((String)"\u6253\u5370\u5931\u8d25\uff0c\u4e00\u6b21\u6700\u591a\u53ef\u9009\u62e9\u7684\u6570\u636e\u6761\u6570\u4e3a\uff1a{0}\u3002", (String)"ResumeListPrintPlugin_4", (String)"hr-hspm-formplugin", (Object[])new Object[0]), 1000));
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>(pkids.size());
        HashSet<Long> filterEmployeeIds = new HashSet<Long>(pkids.size());
        DynamicObject[] dys = HSPM_ERMANFILE.query("employee.id,empposrel.postype,businessstatus", new QFilter[]{new QFilter("id", "in", pkids)});
        if (dys != null && dys.length > 0) {
            for (DynamicObject dy : dys) {
                long employeeId = dy.getLong("employee.id");
                if (employeeId == 0L || !"1".equals(dy.getString("businessstatus")) || 1010L != dy.getLong(KEY_EMPPOSREL_POSTID) || !filterEmployeeIds.add(employeeId)) continue;
                ids.add(dy.getLong("id"));
            }
        }
        if (CollectionUtils.isEmpty(ids)) {
            this.getView().showMessage(MessageFormat.format(ResManager.loadKDString((String)"\u6253\u5370\u5931\u8d25\uff1a\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u4eba\u5458\u6863\u6848\u3002\u8bf7\u9009\u62e9\u751f\u6548\u4e2d\u7684\u5168\u804c\u4efb\u804c\u6863\u6848\u8fdb\u884c\u6253\u5370\u3002", (String)"ResumeListPrintPlugin_5", (String)"hr-hspm-formplugin", (Object[])new Object[0]), 1000));
            return;
        }
        String text = MessageFormat.format(ResManager.loadKDString((String)"\u5c06\u6253\u5370\u751f\u6548\u4e2d\u7684\u5168\u804c\u4efb\u804c\u6863\u6848\uff08\u5171\u9009\u62e9\uff1a{0}\uff0c\u5c06\u6253\u5370{1}\uff09\u3002", (String)"ResumeListPrintPlugin_6", (String)"hr-hspm-formplugin", (Object[])new Object[0]), pkids.size(), ids.size());
        String formId = ((IListView)this.getView()).getBillFormId();
        String id = MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form);
        FormMetadata fm = (FormMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Form);
        formId = oriFormId = MetadataDao.getNumberById((String)fm.getEntityId());
        if (this.getView() instanceof IMobileView) {
            FormConfig fc = this.getView().getFormShowParameter().getFormConfig();
            formId = fc.getEntityTypeId();
        }
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("bos_selecttemplate");
        param.setCustomParam("formid", (Object)formId);
        param.setCustomParam("pkids", ids);
        param.setCustomParam("type", (Object)"printpreview");
        param.setCustomParam("showalltpl", (Object)Boolean.TRUE);
        param.setCustomParam("text", (Object)text);
        this.getView().showForm(param);
    }

    private List<Object> getPKIds() {
        ArrayList<Object> pkids = new ArrayList<Object>();
        if (this.getView() instanceof IMobileView) {
            if (!(this.getView() instanceof IMobileListView)) {
                DynamicObject obj = this.getView().getModel().getDataEntity();
                Object pkValue = this.getView().getModel().getDataEntityType().getPrimaryKey().getValue((Object)obj);
                String defaultPk = "0";
                if (pkValue != null && !defaultPk.equals(pkValue)) {
                    pkids.add(pkValue);
                }
            }
        } else if (this.getView() instanceof IListView) {
            ListSelectedRowCollection listSelectedRowCollection = ((IListView)this.getView()).getSelectedRows();
            if (!listSelectedRowCollection.isEmpty()) {
                for (ListSelectedRow listSelectedRowValue : listSelectedRowCollection) {
                    Object pkv = listSelectedRowValue.getPrimaryKeyValue();
                    if (pkids.contains(pkv)) continue;
                    pkids.add(pkv);
                }
            }
        } else if (!(this.getView() instanceof IReportView)) {
            Object pkValue = this.getView().getModel().getDataEntity().getPkValue();
            PKFieldProp pkProp = (PKFieldProp)this.getView().getModel().getDataEntityType().getPrimaryKey();
            if (!pkProp.getValueComparator().compareValue(pkValue)) {
                pkids.add(pkValue);
            }
        }
        return pkids;
    }
}

