/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.infoclassify.pereduexpinfo;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.service.ocr.HROcrValidateServiceHelper;
import kd.hr.hspm.business.mservice.IHspmOcrService;
import kd.hr.hspm.business.util.HpfsParamUtil;
import kd.hr.hspm.common.entity.ocr.AlgoResultData;
import kd.hr.hspm.common.entity.ocr.DegreeResult;
import kd.hr.hspm.common.entity.ocr.EducationResult;
import kd.sdk.hr.hspm.business.helper.BasedataHelper;
import kd.sdk.hr.hspm.common.utils.BusinessUtils;

public class PereduexpinfoOcrHelper {
    private static final Log LOGGER = LogFactory.getLog(PereduexpinfoOcrHelper.class);

    public void initOcrTipsFlex(IFormView view) {
        Object personId = view.getFormShowParameter().getCustomParam("person");
        Map personIdVsStatusMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"checkEmployeeStatus", (Object[])new Object[]{Collections.singletonList(personId), "person"});
        view.setVisible(Boolean.FALSE, new String[]{"ocrtipshide"});
        if (!HpfsParamUtil.isOpenOcr() || !HROcrValidateServiceHelper.checkOcrLicenseGroup()) {
            LOGGER.info("PereduexpinfoOcrHelper#initOcrTipsFlex checkOcrLicenseGroup is false.");
            view.setVisible(Boolean.FALSE, new String[]{"ocrtips"});
            view.setVisible(Boolean.TRUE, new String[]{"ocrtipshide"});
        } else if (!(personId == null || ((Boolean)personIdVsStatusMap.get(personId)).booleanValue() || BusinessUtils.isAllowInfoClassifyEdit().booleanValue() && PereduexpinfoOcrHelper.validEditPerm(view))) {
            view.setVisible(Boolean.FALSE, new String[]{"hrefaddcert"});
        }
    }

    public static boolean validEditPerm(IFormView view) {
        long userId = RequestContext.get().getCurrUserId();
        String appId = view.getFormShowParameter().getAppId();
        String entityName = view.getModel().getDataEntityType().getName();
        boolean hasPermission = PermissionServiceHelper.checkPermission((Long)userId, (String)appId, (String)entityName, (String)"4715a0df000000ac");
        return hasPermission;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOCRValue(IFormView view, long educerttypeId, String url) {
        if (!HpfsParamUtil.isOpenOcr() || !HROcrValidateServiceHelper.checkOcrLicenseGroup()) {
            LOGGER.info("PereduexpinfoOcrHelper#setOCRValue checkOcrLicenseGroup is false.");
            return;
        }
        String number = "";
        if (educerttypeId == 1010L) {
            number = "OPM-Diploma";
        } else if (educerttypeId == 1020L) {
            number = "OPM-CertificateOfDegree";
        }
        if (HRStringUtils.isEmpty((String)number)) {
            return;
        }
        view.showLoading(new LocaleString(ResManager.loadKDString((String)"\u8bc1\u4ef6\u5185\u5bb9\u667a\u80fd\u8bc6\u522b\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"PereduexpinfoEditPlugin_2", (String)"hr-hspm-formplugin", (Object[])new Object[0])));
        try {
            LOGGER.info(String.format("PereduexpinfoOcrHelper#setOCRValue url: %s", url));
            AlgoResultData data = IHspmOcrService.getInstance().distinguishOcrImage(view.getEntityId(), number, url);
            if (data == null) {
                view.showErrorNotification(ResManager.loadKDString((String)"OCR\u8bc6\u522b\u5931\u8d25\uff0c\u65e0\u6cd5\u586b\u5145\u5b57\u6bb5\u3002", (String)"PercreDrawPlugin_35", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                return;
            }
            LOGGER.info(String.format("PereduexpinfoOcrHelper#setOCRValue data: %s", data));
            Object resultData = data.getData();
            if (data.getErrorCode() != 0) {
                view.showErrorNotification(data.getDescription());
            } else {
                IDataModel dataModel = view.getModel();
                if (educerttypeId == 1010L) {
                    EducationResult educationResult = (EducationResult)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)resultData), EducationResult.class);
                    this.setEducationOCRValue(dataModel, educationResult, educerttypeId);
                } else if (educerttypeId == 1020L) {
                    DegreeResult degreeResult = (DegreeResult)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)resultData), DegreeResult.class);
                    this.setDegreeOCRValue(dataModel, degreeResult, educerttypeId);
                }
            }
        }
        catch (Exception e) {
            view.showErrorNotification(ResManager.loadKDString((String)"OCR\u8bc6\u522b\u5931\u8d25\uff0c\u65e0\u6cd5\u586b\u5145\u5b57\u6bb5\u3002", (String)"PercreDrawPlugin_35", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            LOGGER.error("PereduexpinfoOcrHelper#setOCRValue error!", (Throwable)e);
        }
        finally {
            view.hideLoading();
        }
    }

    private void setDegreeOCRValue(IDataModel dataModel, DegreeResult degreeResult, long educerttypeId) {
        this.setOCRTextValue(dataModel, "number_" + educerttypeId, degreeResult.getDegreeCertificationId());
        this.setOCRTextValue(dataModel, "major", degreeResult.getDiscipline());
        this.isAuditBaseData(dataModel, "graduateschool", degreeResult.getSchool(), "hbss_college");
        this.isAuditBaseData(dataModel, "education", degreeResult.getEducation(), "hbss_diploma");
        this.isAuditBaseData(dataModel, "degree", degreeResult.getDegree(), "hbss_degree");
    }

    private void setEducationOCRValue(IDataModel dataModel, EducationResult educationResult, long educerttypeId) {
        this.setOCRTextValue(dataModel, "number_" + educerttypeId, educationResult.getDiplomaId());
        this.setOCRTextValue(dataModel, "major", educationResult.getDiscipline());
        this.isAuditBaseData(dataModel, "graduateschool", educationResult.getSchool(), "hbss_college");
        this.isAuditBaseData(dataModel, "education", educationResult.getEducation(), "hbss_diploma");
        this.setOCRTextValue(dataModel, "schoolsystem", educationResult.getYears());
        this.setOCRDateValue(dataModel, "admissiondate", educationResult.getStartYear());
        this.setOCRDateValue(dataModel, "gradutiondate", educationResult.getEndYear());
    }

    private void setOCRTextValue(IDataModel dataModel, String toField, String value) {
        if (this.isContainsField(dataModel, toField) && HRStringUtils.isNotEmpty((String)value)) {
            dataModel.setValue(toField, (Object)value);
        }
    }

    private void isAuditBaseData(IDataModel dataModel, String toField, String name, String formId) {
        DynamicObject dynamicObject;
        if (this.isContainsField(dataModel, toField) && HRStringUtils.isNotEmpty((String)name) && (dynamicObject = BasedataHelper.getAuditBaseDataByName((String)formId, (String)name)) != null) {
            dataModel.setValue(toField, (Object)dynamicObject);
        }
    }

    private void setOCRDateValue(IDataModel dataModel, String toField, String value) {
        block5: {
            try {
                if (!this.isContainsField(dataModel, toField) || !HRStringUtils.isNotEmpty((String)value)) break block5;
                String date = value.replace(ResManager.loadKDString((String)"\u5e74", (String)"EducationExpEditPlugin_1", (String)"hr-hspm-formplugin", (Object[])new Object[0]), "-").replace(ResManager.loadKDString((String)"\u6708", (String)"EducationExpEditPlugin_2", (String)"hr-hspm-formplugin", (Object[])new Object[0]), "");
                String[] split = date.split("-");
                String month = split[1];
                if (Integer.parseInt(month) <= 9) {
                    month = "0" + month;
                }
                String newDateStr = split[0] + "-" + month;
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
                Date newDate = null;
                try {
                    newDate = format.parse(newDateStr);
                }
                catch (ParseException eve) {
                    LOGGER.error("setOCRDateValueException", (Throwable)eve);
                }
                dataModel.setValue(toField, (Object)newDate);
            }
            catch (ArrayIndexOutOfBoundsException exp) {
                LOGGER.error("SetOCRDateValue===", (Throwable)exp);
            }
        }
    }

    private boolean isContainsField(IDataModel dataModel, String field) {
        return dataModel.getDataEntityType().getAllFields().containsKey(field);
    }
}

