/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.infoclassify.personinfo;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.LoadDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillView;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.service.ocr.HROcrValidateServiceHelper;
import kd.hr.hspm.business.domian.repository.infoclassify.PersoninfoRepository;
import kd.hr.hspm.business.domian.service.infoclassify.IPersoninfoService;
import kd.hr.hspm.business.mservice.IHspmOcrService;
import kd.hr.hspm.business.util.HpfsParamUtil;
import kd.hr.hspm.common.entity.ocr.AlgoResultData;
import kd.sdk.hr.hspm.common.utils.BusinessUtils;
import kd.sdk.hr.hspm.common.utils.HspmDateUtils;
import kd.sdk.hr.hspm.formplugin.infoclassify.InfoClassifyEditPlugin;

public class PersonInfoEditPlugin
extends InfoClassifyEditPlugin {
    private static final Log LOGGER = LogFactory.getLog(PersonInfoEditPlugin.class);
    private final IPersoninfoService personinfoService = IPersoninfoService.getInstance();

    public void loadData(LoadDataEventArgs args) {
        super.loadData(args);
        BillView view = (BillView)this.getView();
        if (view.getStatus() == OperationStatus.EDIT) {
            Long pkId = (Long)args.getPkId();
            DynamicObject personinfo = this.personinfoService.getPersoninfo(pkId);
            personinfo.set("id", (Object)pkId);
            args.setDataEntity(personinfo);
        }
    }

    public void afterBindData(EventObject event) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String headsculptureVal = dataEntity.getString("headsculpture");
        if ("/images/pc/emotion/default_person_82_82.png".equals(headsculptureVal)) {
            this.getModel().setValue("headsculpture", null);
        }
        this.getView().getPageCache().put("headsculpture", headsculptureVal);
        super.afterBindData(event);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (HRStringUtils.equals((String)key, (String)"birthday")) {
            Date birthday = (Date)this.getModel().getValue("birthday");
            Date midnight = HspmDateUtils.getMidnight();
            if (birthday != null && !birthday.before(midnight)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u51fa\u751f\u65e5\u671f\u5e94\u65e9\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"PercreMobEditPlugin_1", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                return;
            }
            BigDecimal age = HspmDateUtils.dateDiff((Date)birthday);
            this.getModel().setValue("age", (Object)age);
            this.getView().updateView("age");
        } else if ("beginservicedate".equals(key)) {
            Date joinDate = (Date)this.getModel().getValue("beginservicedate");
            DynamicObject personDy = (DynamicObject)this.getModel().getValue("person");
            DynamicObject perSerLenByPersonId = PersoninfoRepository.getInstance().getPerSerLenByPersonId(Long.valueOf(personDy.getLong("id")), "adjustworkage");
            if (perSerLenByPersonId != null) {
                BigDecimal adjustTime = perSerLenByPersonId.getBigDecimal("adjustworkage");
                BigDecimal serviceLen = adjustTime.add(BusinessUtils.calcYearsDiff((Date)new Date(), (Date)joinDate));
                this.getModel().setValue("servicelen", (Object)serviceLen);
            } else {
                BigDecimal serviceLen = BusinessUtils.calcYearsDiff((Date)new Date(), (Date)joinDate);
                this.getModel().setValue("servicelen", (Object)serviceLen);
            }
        }
    }

    private void setDefaultHeadPic(DynamicObject dataEntity) {
        if (!dataEntity.getDataEntityType().getProperties().containsKey((Object)"headsculpture")) {
            return;
        }
        if (!dataEntity.getDataEntityType().getProperties().containsKey((Object)"name")) {
            return;
        }
        if (HRStringUtils.isNotEmpty((String)dataEntity.getString("headsculpture"))) {
            return;
        }
        String name = dataEntity.getString("name");
        if (HRStringUtils.isEmpty((String)name)) {
            return;
        }
        String defaultImage = BusinessUtils.createAvatar((String)name);
        dataEntity.set("headsculpture", (Object)defaultImage);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        BigDecimal adjustTime;
        BigDecimal serviceLen;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        operate.getOption().setVariableValue("pageoperation", "1");
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String headsculptureVal = dataEntity.getString("headsculpture");
        if (HRStringUtils.isEmpty((String)headsculptureVal)) {
            this.setDefaultHeadPic(dataEntity);
        } else {
            String errMsg = ResManager.loadKDString((String)"\u4eba\u8138\u8bc6\u522b\u5931\u8d25\uff0c\u65e0\u6cd5\u4fee\u6539\u5934\u50cf\u3002", (String)"HeadDrawPlugin_0", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
            try {
                String oldHeadPic = this.getView().getPageCache().get("headsculpture");
                if (!headsculptureVal.equals(oldHeadPic) && HpfsParamUtil.isOpenOcr() && HROcrValidateServiceHelper.checkOcrLicenseGroup()) {
                    this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"OCR\u4eba\u8138\u8bc6\u522b\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"HeadDrawPlugin_6", (String)"hr-hspm-formplugin", (Object[])new Object[0])));
                    AlgoResultData data = IHspmOcrService.getInstance().detectFaceImage(headsculptureVal);
                    LOGGER.info("PersonInfoEditPlugin#beforeDoOperation algoResultData: {}", (Object)data);
                    if (data == null || data.getErrorCode() != 0 || data.getData() == null) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4eba\u8138\u8bc6\u522b\u5931\u8d25\uff0c\u65e0\u6cd5\u4fee\u6539\u5934\u50cf\u3002", (String)"HeadDrawPlugin_0", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                        this.getModel().setValue("headsculpture", null);
                        this.getView().hideLoading();
                        args.setCancel(true);
                        return;
                    }
                    if (!"1".equals(((Map)data.getData()).get("face_number").toString())) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u56fe\u7247\u5fc5\u987b\u5305\u542b\u5355\u4e2a\u4eba\u50cf\u3002", (String)"HeadDrawPlugin_1", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                        this.getModel().setValue("headsculpture", null);
                        this.getView().hideLoading();
                        args.setCancel(true);
                        return;
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error(errMsg, (Throwable)e);
                this.getView().showErrorNotification(errMsg);
                this.getView().hideLoading();
                this.getModel().setValue("headsculpture", null);
                args.setCancel(true);
            }
        }
        Date birthday = (Date)this.getModel().getValue("birthday");
        Date midnight = HspmDateUtils.getMidnight();
        if (birthday != null && !birthday.before(midnight)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u51fa\u751f\u65e5\u671f\u5e94\u65e9\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"PercreMobEditPlugin_1", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        Date joinDate = (Date)this.getModel().getValue("beginservicedate");
        DynamicObject personDy = (DynamicObject)this.getModel().getValue("person");
        DynamicObject perSerLenByPersonId = PersoninfoRepository.getInstance().getPerSerLenByPersonId(Long.valueOf(personDy.getLong("id")), "adjustworkage");
        if (perSerLenByPersonId != null && (serviceLen = (adjustTime = perSerLenByPersonId.getBigDecimal("adjustworkage")).add(BusinessUtils.calcYearsDiff((Date)new Date(), (Date)joinDate))).compareTo(BigDecimal.ZERO) < 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u793e\u4f1a\u5de5\u9f84\u4e3a\u975e\u8d1f\u6570\u3002", (String)"PerserlenDrawPlugin_12", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        BigDecimal age = HspmDateUtils.dateDiff((Date)birthday);
        this.getModel().setValue("age", (Object)age);
    }
}

