/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.mobile;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ContextMenuClickEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.control.HRFlexPanelAp;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.service.ocr.HROcrValidateServiceHelper;
import kd.hr.hspm.business.helper.FileHeadHelper;
import kd.hr.hspm.business.mservice.IHspmOcrService;
import kd.hr.hspm.business.mservice.impl.HspmOcrServiceImpl;
import kd.hr.hspm.business.util.HpfsParamUtil;
import kd.hr.hspm.common.entity.ocr.AlgoResultData;
import kd.sdk.hr.hspm.business.helper.ApprovalHelper;
import kd.sdk.hr.hspm.business.helper.HomeElyMobHelper;
import kd.sdk.hr.hspm.business.repository.ErmanFileRepository;
import kd.sdk.hr.hspm.business.service.AttacheHandlerService;
import kd.sdk.hr.hspm.business.service.MultiViewTemplateService;
import kd.sdk.hr.hspm.business.service.PageRegConfigService;
import kd.sdk.hr.hspm.common.enums.ClientTypeEnum;
import kd.sdk.hr.hspm.common.model.FileRelationModel;
import kd.sdk.hr.hspm.common.utils.ApprovalEntityUtils;
import kd.sdk.hr.hspm.common.utils.BusinessUtils;
import kd.sdk.hr.hspm.common.utils.CommonUtil;
import kd.sdk.hr.hspm.common.utils.PageCacheUtils;
import kd.sdk.hr.hspm.common.utils.ParamAnalysisUtil;
import kd.sdk.hr.hspm.formplugin.web.file.ermanfile.ext.service.employee.IMobileHomePluginService;

public class MobileHomeTemplatePlugin
extends AbstractMobFormPlugin
implements UploadListener,
ProgresssListener,
BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(MobileHomeTemplatePlugin.class);
    private static final String FILE_UPDATE_RECORD = "001";
    private static final String FILE_APPROVE_RECORD = "002";
    private static final String FILE_RECORD_BUTTON = "filerecordbutton";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        if (HomeElyMobHelper.isOldHss((FormShowParameter)e.getFormShowParameter())) {
            e.getFormShowParameter().setHasRight(true);
        }
        e.getFormShowParameter().setCustomParam("checkRightAppId", (Object)"hssc");
    }

    public void beforeBindData(EventObject args) {
        String isNotSigned = this.getPageCache().get("isNotSigned");
        if (HRStringUtils.isNotEmpty((String)isNotSigned)) {
            this.showMenu(false);
            return;
        }
        this.showMenu(true);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"mtoolbarap"});
        long cnfId = 0L;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String previewCnfId = (String)formShowParameter.getCustomParam("cnfId");
        String isPreview = null;
        if (HRStringUtils.isNotEmpty((String)previewCnfId)) {
            this.getPageCache().put("ispreview", "1");
            cnfId = Long.parseLong(previewCnfId);
            isPreview = "1";
        } else {
            Tuple<Boolean, Long> cnfInfo = this.getConfigInfo();
            if (!((Boolean)cnfInfo.item1).booleanValue()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"contentflex"});
                return;
            }
            cnfId = (Long)cnfInfo.item2;
        }
        if (cnfId == 0L) {
            return;
        }
        Map infoGroupConfig = PageRegConfigService.getInstance().getInfoGroupConfig(cnfId, ClientTypeEnum.EMPLOYEE_MOBILE.getCode(), isPreview);
        logger.info("getcnfid:{}", (Object)cnfId);
        logger.info("getinfoGroupConfig:{}", (Object)infoGroupConfig);
        if (infoGroupConfig == null || infoGroupConfig.size() == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"contentflex"});
            return;
        }
        List groups = (List)infoGroupConfig.get("mainentry");
        HashMap flexMap = Maps.newHashMapWithExpectedSize((int)20);
        for (Map group : groups) {
            String key = (String)group.get("targetkey");
            String pageNumber = (String)group.get("pagenumber");
            flexMap.put(key, pageNumber);
        }
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.put("flexMap", SerializationUtils.toJsonString((Object)flexMap));
        pageCache.put("cnfjson", SerializationUtils.toJsonString((Object)infoGroupConfig));
        this.getView().setVisible(Boolean.FALSE, new String[]{"errorflex"});
        ApprovalEntityUtils.initCacheFromEntry((IFormView)this.getView(), (Map)infoGroupConfig);
        FlexPanelAp flexPanelAp = this.createMainPanelAp();
        String personId = this.getView().getPageCache().get("personId");
        MultiViewTemplateService.getInstance().setApToView(flexPanelAp, "flexpanelapdyn", this.getView());
        if (HRStringUtils.isEmpty((String)personId)) {
            return;
        }
        this.setHeadValue(infoGroupConfig);
        if (CommonUtil.existAuditingEntry((IFormView)this.getView())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"headsculpture"});
        }
        ApprovalHelper.handleSubmitButtonVisible((IFormView)this.getView());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initVisibleNotPassLabel();
        this.getView().addClientCallBack("handleCardAddOp");
        this.initFileRecordButton();
        ApprovalHelper.setSubmitButtonVisibleListener((IFormView)this.getView(), (ProgresssListener)this);
        this.initHyperLinkVector();
        ApprovalHelper.showConfirmWhenFirstOpen((boolean)false, (IFormView)this.getView());
    }

    private void initHyperLinkVector() {
        String cnfStr = this.getView().getPageCache().get("cnfjson");
        if (HRStringUtils.isNotEmpty((String)cnfStr)) {
            Map infoGroupConfig = (Map)SerializationUtils.fromJsonString((String)cnfStr, Map.class);
            List mainEntryList = (List)infoGroupConfig.get("mainentry");
            for (Map map : mainEntryList) {
                String formId = (String)map.get("mappingFormid");
                String targetKey = (String)map.get("targetkey");
                if (!formId.equals("hrpi_trialperiod") && !formId.equals("hrpi_perserlen")) continue;
                this.getView().setVisible(Boolean.FALSE, new String[]{targetKey.toLowerCase(Locale.ROOT) + "-vec"});
            }
        }
    }

    public void customEvent(CustomEventArgs e) {
        String key = e.getKey();
        if (FILE_RECORD_BUTTON.equals(key)) {
            String eventArgs = e.getEventArgs();
            if (FILE_UPDATE_RECORD.equals(eventArgs)) {
                ApprovalHelper.viewChangeRecord((IFormView)this.getView());
            } else if (FILE_APPROVE_RECORD.equals(eventArgs)) {
                ApprovalHelper.viewAuditRecord((IFormView)this.getView());
            }
        }
    }

    private void initFileRecordButton() {
        CustomControl customButtonControl = (CustomControl)this.getView().getControl(FILE_RECORD_BUTTON);
        HashMap returnDataMap = Maps.newHashMapWithExpectedSize((int)4);
        returnDataMap.put("code", "200");
        returnDataMap.put("eventStatus", "init");
        returnDataMap.put("eventName", "init");
        ArrayList list = Lists.newArrayListWithExpectedSize((int)2);
        HashMap approveMap = Maps.newHashMapWithExpectedSize((int)2);
        approveMap.put("id", FILE_UPDATE_RECORD);
        approveMap.put("name", ResManager.loadKDString((String)"\u6863\u6848\u4fee\u6539\u8bb0\u5f55", (String)"MobileHomeTemplatePlugin_14", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
        list.add(approveMap);
        HashMap updateRecordMap = Maps.newHashMapWithExpectedSize((int)2);
        updateRecordMap.put("id", FILE_APPROVE_RECORD);
        updateRecordMap.put("name", ResManager.loadKDString((String)"\u6863\u6848\u5ba1\u6279\u8bb0\u5f55", (String)"MobileHomeTemplatePlugin_15", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
        list.add(updateRecordMap);
        returnDataMap.put("data", list);
        customButtonControl.setData((Object)returnDataMap);
    }

    private void initVisibleNotPassLabel() {
        String cnfStr = this.getView().getPageCache().get("cnfjson");
        if (HRStringUtils.isEmpty((String)cnfStr)) {
            return;
        }
        Map infoGroupConfig = (Map)SerializationUtils.fromJsonString((String)cnfStr, Map.class);
        List tabEntryList = (List)infoGroupConfig.get("mainentry");
        for (Map map : tabEntryList) {
            String targetKey = String.valueOf(map.get("targetkey"));
            String groupName = String.valueOf(map.get("groupname"));
            if (ApprovalHelper.isNotPasss((IFormView)this.getView(), (String)targetKey, (String)groupName)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{targetKey.toLowerCase(Locale.ROOT) + "notpass"});
                continue;
            }
            this.getView().setVisible(Boolean.valueOf(false), new String[]{targetKey.toLowerCase(Locale.ROOT) + "notpass"});
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        if ("handleCardAddOp".equals(e.getName())) {
            HomeElyMobHelper.handleCardAddOp((IFormView)this.getView());
        }
    }

    private void showMenu(boolean isVisible) {
        if (this.getView() instanceof IMobileView) {
            ((IMobileView)this.getView()).setMenuItemVisible(isVisible, new String[]{"auditrecord"});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChanged(PropertyChangedArgs e) {
        String headsculpturesuccess = this.getPageCache().get("headsculpture");
        if (headsculpturesuccess != null && !Boolean.parseBoolean(headsculpturesuccess)) {
            this.getPageCache().remove("headsculpture");
            return;
        }
        String name = e.getProperty().getName();
        if (e.getChangeSet()[0].getNewValue() == null) {
            return;
        }
        String newValue = e.getChangeSet()[0].getNewValue() + "";
        if ("headsculpture".equals(name)) {
            String imageFullUrl = HspmOcrServiceImpl.getImageFullUrl((String)(newValue + ""));
            logger.info("headocr=={}===={}==={}", new Object[]{HROcrValidateServiceHelper.checkOcrLicenseGroup(), newValue, imageFullUrl});
            String errMsg = ResManager.loadKDString((String)"\u4eba\u8138\u8bc6\u522b\u5931\u8d25\uff0c\u65e0\u6cd5\u4fee\u6539\u5934\u50cf\u3002", (String)"HeadDrawPlugin_0", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
            try {
                if (HpfsParamUtil.isOpenOcr() && HROcrValidateServiceHelper.checkOcrLicenseGroup()) {
                    this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"OCR\u4eba\u8138\u8bc6\u522b\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"HeadDrawPlugin_6", (String)"hr-hspm-formplugin", (Object[])new Object[0])));
                    AlgoResultData data = IHspmOcrService.getInstance().detectFaceImage(newValue);
                    logger.info("PersonInfoEditPlugin#beforeDoOperation algoResultData: {}", (Object)data);
                    if (data == null || data.getErrorCode() != 0 || data.getData() == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4eba\u8138\u8bc6\u522b\u5931\u8d25\uff0c\u65e0\u6cd5\u4fee\u6539\u5934\u50cf\u3002", (String)"HeadDrawPlugin_0", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                        this.getPageCache().put("headsculpture", "false");
                        this.getModel().beginInit();
                        this.getModel().setValue("headsculpture", e.getChangeSet()[0].getOldValue());
                        this.getModel().endInit();
                        return;
                    }
                    if (!"1".equals(((Map)data.getData()).get("face_number").toString())) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u56fe\u7247\u5fc5\u987b\u5305\u542b\u5355\u4e2a\u4eba\u50cf\u3002", (String)"HeadDrawPlugin_1", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                        this.getPageCache().put("headsculpture", "false");
                        this.getModel().beginInit();
                        this.getModel().setValue("headsculpture", e.getChangeSet()[0].getOldValue());
                        this.getModel().endInit();
                        return;
                    }
                }
                String personId = this.getView().getPageCache().get("personId");
                if (this.isHeadNeedAuditOrIsEdit("isaudit")) {
                    String entrycache = PageCacheUtils.getHomePageCache((IFormView)this.getView()).get("0000-entrycache");
                    List collection = new ArrayList();
                    if (HRStringUtils.isNotEmpty((String)entrycache)) {
                        collection = (List)SerializationUtils.fromJsonString((String)entrycache, List.class);
                    }
                    BusinessUtils.addMapToCollect((IFormView)this.getView(), (Long)Long.valueOf(personId), (String)"headsculpture", (Object)newValue, (Object)this.getView().getPageCache().get("oldheadpic"), collection, (String)"hrpi_person");
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fee\u6539\u540e\u7684\u5934\u50cf\u9700\u5148\u63d0\u4ea4\u5ba1\u6838\uff0c\u5ba1\u6838\u901a\u8fc7\u540e\u65b9\u53ef\u751f\u6548\u3002", (String)"MobileHomeTemplatePlugin_9", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                } else {
                    AttacheHandlerService.getInstance().saveHeadsCulpture(personId, (Object)newValue);
                }
            }
            catch (Exception exc) {
                logger.error(errMsg, (Throwable)exc);
                this.getView().showErrorNotification(errMsg);
                this.getPageCache().put("headsculpture", String.valueOf(true));
                this.getModel().beginInit();
                this.getModel().setValue("headsculpture", e.getChangeSet()[0].getOldValue());
                this.getModel().endInit();
                return;
            }
            finally {
                this.getView().hideLoading();
            }
            this.getPageCache().remove("headsculpture");
        } else if ("selectinfogroup".equals(name) && e.getChangeSet()[0].getNewValue() instanceof DynamicObject) {
            DynamicObject dynamicObject = (DynamicObject)e.getChangeSet()[0].getNewValue();
            String groupName = dynamicObject.getString("name");
            String pageKey = this.getPageCache().get("selectinfogroupnumber");
            if (HRStringUtils.isNotEmpty((String)groupName) && HRStringUtils.isNotEmpty((String)pageKey)) {
                HomeElyMobHelper.showFilePage((IFormView)this.getView(), (String)pageKey, (ShowType)ShowType.Floating, (String)"");
            }
        }
    }

    private boolean isHeadNeedAuditOrIsEdit(String field) {
        String cnfStr = this.getView().getPageCache().get("cnfjson");
        Map infoGroupConfig = (Map)SerializationUtils.fromJsonString((String)cnfStr, Map.class);
        List headEntity = (List)infoGroupConfig.get("headentity");
        long count = headEntity.stream().filter(map -> map.get("number").equals("headsculpture") && Boolean.TRUE.equals(map.get(field))).count();
        return count > 0L;
    }

    private void setHeadValue(Map<String, Object> infoGroupConfig) {
        List headEntity = (List)infoGroupConfig.get("headentity");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String personId = this.getView().getPageCache().get("personId");
        if (HRStringUtils.isEmpty((String)personId)) {
            return;
        }
        DynamicObject erFileDy = ErmanFileRepository.getPrimaryErmanFile((Long)Long.parseLong(personId));
        HomeElyMobHelper.setCustomParams((FormShowParameter)formShowParameter, (DynamicObject)erFileDy);
        HashMap<String, String> typeMap = new HashMap<String, String>(2);
        typeMap.put("number", "apositiontype");
        typeMap.put("source", "hrpi_empposorgrel");
        headEntity.add(typeMap);
        Map stringDynamicObjectMap = FileHeadHelper.queryDataFromDb((List)headEntity, (FormShowParameter)formShowParameter);
        headEntity.remove(typeMap);
        if (stringDynamicObjectMap.size() > 0) {
            DynamicObject empPosDy = (DynamicObject)stringDynamicObjectMap.get("hrpi_empposorgrel");
            DynamicObject personDy = (DynamicObject)stringDynamicObjectMap.get("hrpi_person");
            if (personDy != null) {
                String nameNumber = "";
                if (HRStringUtils.isNotEmpty((String)personDy.getString("name"))) {
                    nameNumber = nameNumber + personDy.getString("name");
                }
                if (HRStringUtils.isNotEmpty((String)personDy.getString("number"))) {
                    nameNumber = nameNumber.length() > 0 ? nameNumber + "  " + personDy.getString("number") : nameNumber + personDy.getString("number");
                }
                if (HRStringUtils.isNotEmpty((String)nameNumber)) {
                    this.setLabelText("username", nameNumber);
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"usernameflex"});
                }
                this.getView().getPageCache().put("oldheadpic", personDy.getString("headsculpture"));
                if (!this.isHeadNeedAuditOrIsEdit("isedit")) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"headsculpture"});
                }
                this.getModel().beginInit();
                this.getModel().setValue("headsculpture", (Object)personDy.getString("headsculpture"));
                this.getView().updateView("headsculpture");
                this.getModel().endInit();
                if (this.isHeadNeedAuditOrIsEdit("isaudit")) {
                    String newValue;
                    Optional<HashMap> first;
                    String entrycache = PageCacheUtils.getHomePageCache((IFormView)this.getView()).get("0000-entrycache");
                    List collection = new ArrayList();
                    if (HRStringUtils.isNotEmpty((String)entrycache)) {
                        collection = (List)SerializationUtils.fromJsonString((String)entrycache, List.class);
                    }
                    if ((first = collection.stream().filter(map -> map.get("dataid").toString().equals(personId) && map.get("fieldname").equals("headsculpture") && map.get("entityName").equals("hrpi_person")).findFirst()).isPresent() && !HRStringUtils.isEmpty((String)(newValue = (String)first.get().get("newvalue")))) {
                        this.getModel().beginInit();
                        this.getModel().setValue("headsculpture", (Object)newValue);
                        this.getModel().endInit();
                    }
                }
            }
            List<Object> headFields = headEntity.stream().map(field -> field.get("number")).collect(Collectors.toList());
            if (empPosDy != null) {
                this.handlePositionLine(headFields, empPosDy);
                String company = null;
                if (headFields.contains("company") && empPosDy.get("company") != null) {
                    company = empPosDy.getDynamicObject("company").getString("name");
                }
                this.setLabelText("company", company);
            }
            this.handleDepName(headFields);
        }
    }

    private void handleDepName(List<Object> headFields) {
        String depname = null;
        if (headFields.contains("depname")) {
            Long fileId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("erfileid"));
            FileRelationModel fileRelationModel = FileHeadHelper.getFileRelationInfo((Long)fileId);
            logger.info("MobileHomeTemplatePlugin.handleDepName.fileRelationModel{}", (Object)fileRelationModel);
            List depChargeInfoList = fileRelationModel.getDepChargeInfoList();
            if (depChargeInfoList != null && depChargeInfoList.size() > 0) {
                Map depMap = (Map)depChargeInfoList.get(0);
                logger.info("MobileHomeTemplatePlugin.handleDepName.fileRelationModel.first{}", (Object)depMap);
                if (depMap != null) {
                    depname = (String)depMap.get("name");
                }
            }
        }
        if (HRStringUtils.isNotEmpty(depname)) {
            StringBuilder sb = new StringBuilder(ResManager.loadKDString((String)"\u90e8\u95e8\u8d1f\u8d23\u4eba", (String)"MobileHomeTemplatePlugin_12", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            sb.append("\uff1a ");
            sb.append(depname);
            depname = sb.toString();
        }
        this.setLabelText("depname", depname);
    }

    private void handlePositionLine(List<Object> headFields, DynamicObject empPosDy) {
        DynamicObject adminorg;
        String value = "";
        if (headFields.contains("adminorg") && empPosDy.getDynamicObject("adminorg") != null && HRStringUtils.isNotEmpty((String)(adminorg = empPosDy.getDynamicObject("adminorg")).getString("name"))) {
            value = value + adminorg.getString("name");
        }
        DynamicObject positionDyn = null;
        String apositonType = empPosDy.getString("apositiontype");
        if ("0".equals(apositonType)) {
            if (headFields.contains("stdposition")) {
                positionDyn = empPosDy.getDynamicObject("stdposition");
            }
        } else if ("1".equals(apositonType)) {
            if (headFields.contains("position")) {
                positionDyn = empPosDy.getDynamicObject("position");
            }
        } else if ("2".equals(apositonType) && headFields.contains("job")) {
            positionDyn = empPosDy.getDynamicObject("job");
        }
        if (positionDyn != null && HRStringUtils.isNotEmpty((String)positionDyn.getString("name"))) {
            String positionName = positionDyn.getString("name");
            value = HRStringUtils.isNotEmpty((String)value) ? value + " \u00b7 " + positionName : positionName;
        }
        this.setLabelText("position", value);
    }

    private Tuple<Boolean, Long> getConfigInfo() {
        Long cnfId = 0L;
        try {
            HashMap result = Maps.newHashMapWithExpectedSize((int)2);
            HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, IMobileHomePluginService.class, (String)"kd.sdk.hr.hspm.formplugin.web.file.ermanfile.ext.service.employee.IMobileHomePluginService", null);
            hrPluginProxy.callReplace(hrPlugin -> {
                result.putAll(hrPlugin.openAssignMobileFile());
                return null;
            });
            long personId = 0L;
            long configId = 0L;
            if (!CollectionUtils.isEmpty((Map)result)) {
                personId = result.getOrDefault("personId", 0L);
                configId = result.getOrDefault("configId", 0L);
            }
            if (personId == 0L) {
                Map resultPerson = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getPersonModelId", (Object[])new Object[0]);
                logger.info("getPersonModelIdResp{}", (Object)resultPerson);
                if (resultPerson == null || resultPerson.size() == 0) {
                    this.getModel().setValue("errorinfo", (Object)ResManager.loadKDString((String)"\u767b\u5f55\u7528\u6237\u83b7\u53d6\u7684\u4eba\u5458\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"MobileHomeTemplatePlugin_0", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                    return Tuple.create((Object)Boolean.FALSE, (Object)cnfId);
                }
                Map idData = (Map)resultPerson.get("data");
                logger.info("idData{}", (Object)idData);
                if (idData == null || idData.size() == 0 || (Long)idData.get("person") == 0L) {
                    this.getModel().setValue("errorinfo", (Object)ResManager.loadKDString((String)"\u767b\u5f55\u7528\u6237\u83b7\u53d6\u7684\u4eba\u5458ID\u4e3a\u7a7a\u3002", (String)"MobileHomeTemplatePlugin_1", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                    return Tuple.create((Object)Boolean.FALSE, (Object)cnfId);
                }
                personId = (Long)idData.get("person");
            }
            IPageCache pageCache = this.getView().getPageCache();
            logger.info("personId{}", (Object)String.valueOf(personId));
            pageCache.put("personId", String.valueOf(personId));
            DynamicObject erFileDy = ErmanFileRepository.getPrimaryErmanFile((Long)personId);
            if (erFileDy == null) {
                this.getModel().setValue("errorinfo", (Object)ResManager.loadKDString((String)"\u767b\u5f55\u7528\u6237\u83b7\u53d6\u7684\u4eba\u5458\u6863\u6848\u4e3a\u7a7a\u3002", (String)"MobileHomeTemplatePlugin_2", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                return Tuple.create((Object)Boolean.FALSE, (Object)cnfId);
            }
            Tuple tuple = configId != 0L ? Tuple.create((Object)Boolean.TRUE, (Object)configId) : AttacheHandlerService.getInstance().handleRuleEngine(this.getView(), erFileDy.getLong("id"), erFileDy, "hspm" + ClientTypeEnum.EMPLOYEE_MOBILE.getCode(), ClientTypeEnum.EMPLOYEE_MOBILE.getCode(), null, false);
            cnfId = (Long)tuple.item2;
            Boolean getRule = (Boolean)tuple.item1;
            if (!getRule.booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5339\u914d\u7684\u4e1a\u52a1\u89c4\u5219\uff0c\u5f53\u524d\u9875\u9762\u5c06\u4e3a\u60a8\u663e\u793a\u9ed8\u8ba4\u65b9\u6848\u3002\u82e5\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8c03\u6574\u4e1a\u52a1\u89c4\u5219\u3002", (String)"MultiViewTemplatePlugin_1", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            }
        }
        catch (Exception exc) {
            this.getModel().setValue("errorinfo", (Object)ResManager.loadKDString((String)"\u8c03\u7528\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u5f02\u5e38\u3002", (String)"MobileHomeTemplatePlugin_3", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            logger.error("getPersonModelIdError", (Throwable)exc);
            return Tuple.create((Object)Boolean.FALSE, (Object)cnfId);
        }
        return Tuple.create((Object)Boolean.TRUE, (Object)cnfId);
    }

    private void setLabelText(String key, String value) {
        Label label;
        if (HRStringUtils.isNotEmpty((String)value) && (label = (Label)this.getControl(key)) != null) {
            label.setText(value);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{key + "flex"});
        }
    }

    public FlexPanelAp createMainPanelAp() {
        String cnfStr = this.getView().getPageCache().get("cnfjson");
        Map infoGroupConfig = (Map)SerializationUtils.fromJsonString((String)cnfStr, Map.class);
        FlexPanelAp flexPanelAp = ((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder("dynglobalpanel").setWrap(false).setDirection("row").setGrow(1).setShrink(1).setAlignItems("stretch").setMarginBottom("10px")).setWidth("100%").build();
        flexPanelAp.getItems().add(this.buildPanelAp(infoGroupConfig));
        return flexPanelAp;
    }

    public FlexPanelAp buildPanelAp(Map<String, Object> infoGroupConfig) {
        TabAp tabAp = new TabAp();
        tabAp.setKey("tabap");
        tabAp.setId("tabap");
        tabAp.setName(new LocaleString("tabap"));
        List tabEntryList = (List)infoGroupConfig.get("mainentry");
        FlexPanelAp rightPanelAp = new HRFlexPanelAp.Builder("dynglobalpanel").build();
        rightPanelAp.getItems().add(this.buildAssociPanel(tabEntryList));
        return rightPanelAp;
    }

    public void onGetControl(OnGetControlArgs args) {
        Label relateLabel;
        FormView view = (FormView)this.getView();
        logger.info(MessageFormat.format("key:{0}", args.getKey()));
        MultiViewTemplateService.getInstance().setLabelClick(args, view, (AbstractFormPlugin)this, "mainentry");
        String key = args.getKey();
        if ("auditrecord".equals(key)) {
            relateLabel = new Label();
            relateLabel.setKey("auditRecord");
            relateLabel.setView(this.getView());
            relateLabel.addClickListener((ClickListener)this);
            args.setControl((Control)relateLabel);
        } else if ("changeRecord".equalsIgnoreCase(key)) {
            relateLabel = new Label();
            relateLabel.setKey("changeRecord");
            relateLabel.setView(this.getView());
            relateLabel.addClickListener((ClickListener)this);
            args.setControl((Control)relateLabel);
        }
        if (key.contains("lbl") || key.contains("vec")) {
            relateLabel = new Label();
            relateLabel.setKey(key);
            relateLabel.setView(this.getView());
            relateLabel.addClickListener((ClickListener)this);
            args.setControl((Control)relateLabel);
        }
    }

    private FlexPanelAp buildAssociPanel(List<Map<String, Object>> mainEntryList) {
        FlexPanelAp relatePanel = new HRFlexPanelAp.Builder("dynglobalpanel").setForeColor("#333333").setGrow(0).setShrink(0).setWrap(false).setDirection("column").setJustifyContent("center").setWidth("100%").build();
        FlexPanelAp relatePageInfoPanelAp = HomeElyMobHelper.createRelatePageInfoPanelAp((IFormView)this.getView(), mainEntryList);
        relatePanel.getItems().add(relatePageInfoPanelAp);
        return relatePanel;
    }

    public void registerListener(EventObject eventObject) {
        this.addClickListeners(new String[]{"submit", "auditrecord", "changerecord", "close", "abandon"});
        ApprovalHelper.setSubmitButtonVisibleListener((IFormView)this.getView(), (ProgresssListener)this);
        BasedataEdit selectinfogroup = (BasedataEdit)this.getView().getControl("selectinfogroup");
        selectinfogroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        Map flexMap;
        String key = ((Control)evt.getSource()).getKey();
        logger.info(MessageFormat.format("click key:{0}", key));
        if ("submit".equals(key)) {
            ApprovalHelper.submitConfirm((IFormView)this.getView(), (IFormPlugin)this);
            return;
        }
        if (key.equals("auditrecord-lbl") || key.equals("auditrecord-vec") || key.equals("auditRecord")) {
            ApprovalHelper.viewAuditRecord((IFormView)this.getView());
            return;
        }
        if (key.equals("changerecord-lbl") || key.equals("changerecord-vec") || key.equals("changeRecord")) {
            ApprovalHelper.viewChangeRecord((IFormView)this.getView());
            return;
        }
        if (key.equals("close")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"headtipspanel"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"notpassvector"});
            this.getView().getPageCache().put("closeHeadTipsPanel", "true");
        } else if (key.equals("abandon")) {
            String changeDesc = this.getModel().getChangeDesc();
            this.getView().showConfirm(ResManager.loadKDString((String)"\u64cd\u4f5c\u653e\u5f03\u540e\uff0c\u5c06\u6062\u590d\u539f\u59cb\u503c\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AbstractMobileFormDrawEdit_8", (String)"hr-hspm-formplugin", (Object[])new Object[0]), changeDesc, MessageBoxOptions.OKCancel, ConfirmTypes.Save, new ConfirmCallBackListener("abandon", (IFormPlugin)this));
        }
        if (key.endsWith("-addvec")) {
            if (CommonUtil.existAuditingEntry((IFormView)this.getView())) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u5ba1\u6279\u5355\u636e\u5df2\u5728\u5ba1\u6279\u6d41\u7a0b\u4e2d\uff0c\u65e0\u6cd5\u65b0\u589e\u5ba1\u6279\u5355\u3002", (String)"AbstractMobCardEdit_6", (String)"hr-hspm-formplugin", (Object[])new Object[0]), MessageBoxOptions.None);
                return;
            }
            String pageKey = key.substring(0, key.length() - "-addvec".length());
            Map groupMap = HomeElyMobHelper.getMultivewConfigInfoGroup((IFormView)this.getView(), (String)pageKey);
            List groups = ParamAnalysisUtil.getGroups((Map)groupMap);
            if (!CollectionUtils.isEmpty((Collection)groups) && groups.size() > 1 && !HomeElyMobHelper.isEduPage((Map)groupMap)) {
                List list = groups.stream().map(val -> (String)val.get("gname")).collect(Collectors.toList());
                this.getPageCache().put("selectinfogroup", SerializationUtils.toJsonString(list));
                this.getPageCache().put("selectinfogroupnumber", pageKey);
                this.getModel().setValue("selectinfogroup", null);
                BasedataEdit selectinfogroup = (BasedataEdit)this.getControl("selectinfogroup");
                selectinfogroup.click();
                return;
            }
        }
        if (key.startsWith("infogroupcard_")) {
            Object formId;
            String targetKey = key.substring(key.indexOf(95) + 1);
            String cnfStr = this.getView().getPageCache().get("cnfjson");
            Map infoGroupConfig = (Map)SerializationUtils.fromJsonString((String)cnfStr, Map.class);
            List mainentryList = (List)infoGroupConfig.get("mainentry");
            Optional<Map> configOp = mainentryList.stream().filter(val -> targetKey != null && targetKey.equalsIgnoreCase((String)val.get("targetkey"))).findFirst();
            if (configOp.isPresent() && ("hrpi_trialperiod".equals(formId = configOp.get().get("mappingFormid")) || "hrpi_perserlen".equals(formId))) {
                return;
            }
            HomeElyMobHelper.showFilePage((IFormView)this.getView(), (String)key.substring(key.indexOf(95) + 1).toUpperCase(), (ShowType)ShowType.Floating, (String)"");
            return;
        }
        if (key.contains("lbl") || key.contains("vec")) {
            HomeElyMobHelper.showFilePage((IFormView)this.getView(), (String)key.split("-")[0].toUpperCase(), (ShowType)ShowType.Floating, (String)"");
            return;
        }
        String flexMapStr = this.getPageCache().get("flexMap");
        if (HRStringUtils.isNotEmpty((String)flexMapStr) && !CollectionUtils.isEmpty((Map)(flexMap = (Map)SerializationUtils.fromJsonString((String)flexMapStr, Map.class))) && flexMap.containsKey(key)) {
            HomeElyMobHelper.showFilePage((IFormView)this.getView(), (String)key, (ShowType)ShowType.Floating, (String)"");
        }
    }

    public void contextMenuClick(ContextMenuClickEvent evt) {
        super.contextMenuClick(evt);
        logger.info("contextMenuClick method");
        String isNotSigned = this.getPageCache().get("isNotSigned");
        if (HRStringUtils.isNotEmpty((String)isNotSigned)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u672a\u7b7e\u7f72\u9690\u79c1\u534f\u8bae\uff0c\u6682\u65f6\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c\u3002", (String)"MobileHomeTemplatePlugin_4", (String)"hr-hspm-formplugin", (Object[])new Object[0]), MessageBoxOptions.None);
            return;
        }
        if (evt.getItemKey().equalsIgnoreCase("auditrecord")) {
            ApprovalHelper.viewAuditRecord((IFormView)this.getView());
        } else if (evt.getItemKey().equalsIgnoreCase("changerecord")) {
            ApprovalHelper.viewChangeRecord((IFormView)this.getView());
        }
    }

    public void beforeClosed(BeforeClosedEvent closedEvent) {
        super.beforeClosed(closedEvent);
        logger.info("beforeClosed....");
        if (!"true".equals(this.getView().getPageCache().get("HomePageClose")) && ApprovalHelper.existAuditInfo((IFormView)this.getView())) {
            ConfirmCallBackListener confirm = new ConfirmCallBackListener("HomePageCloseCallBack", (IFormPlugin)this);
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u672a\u63d0\u4ea4\u5ba1\u6838\u7684\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u76f4\u63a5\u9000\u51fa\uff1f\u82e5\u76f4\u63a5\u9000\u51fa\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"MobileHomeTemplatePlugin_5", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, confirm);
            closedEvent.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (!MessageBoxResult.Yes.equals((Object)result) && !MessageBoxResult.OK.equals((Object)result)) {
            return;
        }
        String key = messageBoxClosedEvent.getCallBackId();
        if ("ApprovalSubmitCallBack".equals(key)) {
            ApprovalHelper.submit((IFormView)this.getView());
        } else if ("HomePageCloseCallBack".equals(key)) {
            logger.info("HomePageCloaseCallBack...");
            ApprovalHelper.delCacheData((IFormView)this.getView());
            IFormView view = this.getView();
            view.getPageCache().put("HomePageClose", "true");
            if (this.getView().getParentView() != null) {
                logger.info(MessageFormat.format("backtoparentview:[{0}]", this.getView().getParentView().getEntityId()));
                view.sendFormAction(this.getView().getParentView());
            }
            view.close();
        } else if ("abandon".equals(key)) {
            PageCacheUtils.getHomePageCache((IFormView)this.getView()).remove("0000-entrycache");
            this.deleteHeadData();
            ApprovalHelper.updateSyncCacheToDataBase((IFormView)this.getView());
            this.getView().updateView();
            this.getView().setVisible(Boolean.FALSE, new String[]{"headtipspanel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"notpassvector"});
        }
    }

    private void deleteHeadData() {
        String personId = this.getView().getPageCache().get("personId");
        if (HRStringUtils.isEmpty((String)personId)) {
            return;
        }
        DynamicObject[] currentEntry = CommonUtil.getCurrentEntry((Long)Long.valueOf(personId));
        if (currentEntry == null || currentEntry.length == 0) {
            return;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hspm_infoapproval");
        DynamicObject dynamicObject = currentEntry[0];
        DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
        Iterator iterator = entryentity.iterator();
        while (iterator.hasNext()) {
            DynamicObject next = (DynamicObject)iterator.next();
            if (!next.get("firstgroupnum").equals("0000")) continue;
            PageCacheUtils.getHomePageCache((IFormView)this.getView()).remove("0000-entrycache");
            iterator.remove();
        }
        serviceHelper.updateOne(dynamicObject);
        if (entryentity.size() == 0) {
            OperationServiceImpl operationService = new OperationServiceImpl();
            operationService.localInvokeOperation("unsubmit", new DynamicObject[]{dynamicObject}, OperateOption.create());
            serviceHelper.deleteOne(dynamicObject.getPkValue());
            PageCacheUtils.getHomePageCache((IFormView)this.getView()).remove("submitVerson");
        }
    }

    private List<QFilter> setQFilter(String formId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (formId.contains("hspm_empposorgrel")) {
            QFilter primaryFilter = new QFilter("isprimary", "=", (Object)"1");
            QFilter statusFilter = new QFilter("businessstatus", "=", (Object)"1");
            QFilter versionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
            qFilters.add(primaryFilter);
            qFilters.add(statusFilter);
            qFilters.add(versionFilter);
        } else if (formId.contains("hspm_pereduexp")) {
            qFilters.add(new QFilter("ishighestdegree", "=", (Object)"1"));
        } else if (formId.contains("hspm_preworkexp")) {
            // empty if block
        }
        return qFilters;
    }

    public void onProgress(ProgressEvent progressEvent) {
        String ispreview = this.getPageCache().get("ispreview");
        if (HRStringUtils.isNotEmpty((String)ispreview)) {
            return;
        }
        IFormView view = this.getView();
        ApprovalHelper.handleSubmitButtonVisible((IFormView)view);
        this.refreshHeadPicture(view);
        this.initVisibleNotPassLabel();
    }

    private void refreshHeadPicture(IFormView view) {
        boolean isEdit = this.isHeadNeedAuditOrIsEdit("isedit");
        if (isEdit) {
            view.setEnable(Boolean.TRUE, new String[]{"headsculpture"});
        } else {
            view.setEnable(Boolean.FALSE, new String[]{"headsculpture"});
        }
        String personIdStr = view.getPageCache().get("personId");
        DynamicObject bill = ApprovalHelper.getInProcessWorkFlowBill((Long)Long.parseLong(personIdStr));
        if (bill == null) {
            return;
        }
        DynamicObjectCollection entryentity = bill.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryentity)) {
            return;
        }
        for (DynamicObject object : entryentity) {
            String reason;
            String targetkey = String.valueOf(object.get("firstgroupnum"));
            if (!targetkey.equals("0000")) continue;
            String string = reason = HRStringUtils.isNotEmpty((String)object.getString("reason")) ? object.getString("reason") : ResManager.loadKDString((String)"\u672a\u586b\u5199\u4e0d\u901a\u8fc7\u7406\u7531", (String)"AbstractMobileFormDrawEdit_3", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
            if (!"G".equals(bill.getString("billstatus")) || !object.getBoolean("status")) continue;
            this.setLabelText("notpassinfo", String.format(ResManager.loadKDString((String)"\u60a8\u7684\u5934\u50cf\u5df2\u88ab\u9a73\u56de\uff0c\u4e0d\u901a\u8fc7\u539f\u56e0\uff1a%s", (String)"MobileHomeTemplatePlugin_13", (String)"hr-hspm-formplugin", (Object[])new Object[0]), reason));
            String closeHeadTipsPanel = view.getPageCache().get("closeHeadTipsPanel");
            if (closeHeadTipsPanel != null) continue;
            view.setVisible(Boolean.valueOf(true), new String[]{"headtipspanel"});
            view.setVisible(Boolean.valueOf(true), new String[]{"notpassvector"});
        }
        if (!"G".equals(bill.getString("billstatus"))) {
            view.setEnable(Boolean.FALSE, new String[]{"headsculpture"});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        BasedataEdit basedataEdit = (BasedataEdit)beforeF7SelectEvent.getSource();
        String key = basedataEdit.getKey();
        if ("selectinfogroup".equals(key)) {
            long[] ids;
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            String groupNames = this.getPageCache().get("selectinfogroup");
            if (HRStringUtils.isEmpty((String)groupNames)) {
                return;
            }
            HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("hspm_selectinfogroup");
            List groupList = SerializationUtils.fromJsonStringToList((String)groupNames, String.class);
            String multiIds = this.getPageCache().get("multiIds");
            if (HRStringUtils.isEmpty((String)multiIds)) {
                ids = ORM.create().genLongIds("hspm_multiviewconfig", groupList.size());
                StringBuilder multiIdsBuilder = new StringBuilder();
                for (long id : ids) {
                    if (multiIdsBuilder.length() > 0) {
                        multiIdsBuilder.append(',');
                    }
                    multiIdsBuilder.append(id);
                }
                this.getPageCache().put("multiIds", multiIdsBuilder.toString());
            } else {
                String[] str = multiIds.split(",");
                ids = new long[str.length];
                Object[] delIds = new Long[str.length];
                for (int index = 0; index < str.length; ++index) {
                    ids[index] = Long.parseLong(str[index]);
                    delIds[index] = Long.valueOf(str[index]);
                }
                baseServiceHelper.delete(delIds);
            }
            DynamicObjectCollection collection = new DynamicObjectCollection();
            for (int index = 0; index < groupList.size(); ++index) {
                DynamicObject dynamicObject = baseServiceHelper.generateEmptyDynamicObject();
                dynamicObject.set("name", groupList.get(index));
                dynamicObject.set("id", (Object)ids[index]);
                dynamicObject.set("notid", (Object)ids[index]);
                dynamicObject.set("groupid", (Object)"0");
                collection.add((Object)dynamicObject);
            }
            baseServiceHelper.save(collection);
            ArrayList<QFilter> fieldFilters = new ArrayList<QFilter>();
            fieldFilters.add(new QFilter("id", "in", (Object)ids));
            if (CollectionUtils.isEmpty((Collection)listShowParameter.getListFilterParameter().getQFilters())) {
                listShowParameter.getListFilterParameter().setQFilters(fieldFilters);
            } else {
                listShowParameter.getListFilterParameter().getQFilters().addAll(fieldFilters);
            }
            listShowParameter.setCustomParam("selectinfogroup", (Object)this.getPageCache().get("selectinfogroup"));
        }
    }
}

