/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.report;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.list.JoinEntity;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportBatchQueryInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.servicehelper.HRQueryEntityHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hspm.business.domian.repository.EmpReportRepository;
import kd.hr.hspm.business.domian.repository.ReportDisplayRepository;
import kd.hr.hspm.formplugin.web.report.func.EmpReportCalculateMapFunction;
import kd.hr.hspm.formplugin.web.report.func.EmpReportShowHisNameCalculateMapFunction;
import kd.hr.hspm.formplugin.web.report.helper.CreateReportColumn;
import kd.hr.hspm.formplugin.web.report.helper.EmpReportHelper;
import kd.sdk.hr.hspm.business.helper.ShowHisVersionEntityHelper;
import kd.sdk.hr.hspm.business.repository.ext.service.EmpReportExtCommon;
import kd.sdk.hr.hspm.common.entity.ShowHisVersionEntity;

public class EmpReportListPlugin
extends AbstractReportListDataPlugin {
    private static final Log LOGGER = LogFactory.getLog(EmpReportListPlugin.class);
    private static final Integer BATCH_COUNT = 1000;
    private Long reportPlanId;
    private final QueryEntityType queryType = (QueryEntityType)EmpReportRepository.generate().getDataEntityType();
    private static final Map<String, List<String>> CALCULATE_COLUMN_MAP = new HashMap<String, List<String>>(16);
    private static final List<ShowHisVersionEntity> SHOW_HIS_VERSION_ENTITY_LIST = new ArrayList<ShowHisVersionEntity>(16);

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        super.getColumns(columns);
        List joinEntityList = this.queryType.getJoinEntitys();
        Map<String, String> joinEntityAliasMap = joinEntityList.stream().collect(Collectors.toMap(JoinEntity::getAlias, JoinEntity::getEntityName));
        Map map = ReportDisplayRepository.getConfigs((Long)this.reportPlanId);
        map.put("id", null);
        HashMap<String, EntityMetadata> metaMap = new HashMap<String, EntityMetadata>(16);
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            DynamicObject mapValue;
            Map.Entry entry;
            EntityItem entityItem = (EntityItem)EmpReportHelper.getFieldItem(joinEntityAliasMap, (String)((String)entry.getKey()), metaMap).item2;
            entry = iterator.next();
            String mapKey = (String)entry.getKey();
            ReportColumn column = CreateReportColumn.createColumnByType(entityItem, mapKey, mapValue = (DynamicObject)entry.getValue());
            if (column == null) {
                column = CreateReportColumn.createTextColumn(mapValue, mapKey, mapKey);
            }
            if ("id".equals(mapKey)) {
                column.setHide(true);
            }
            EmpReportExtCommon.addExtColumnByType((ReportColumn)column, (EntityItem)entityItem, (String)mapKey, (DynamicObject)mapValue);
            columns.add(columns.size(), (AbstractReportColumn)column);
        }
        return columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet queryBatchBy(ReportQueryParam queryParam) {
        DataSet dataSet;
        LOGGER.info("EmpReportListPlugin.queryBatchBy---start");
        long startTime = System.currentTimeMillis();
        int size = 0;
        try {
            Map basedataIdMap = (Map)queryParam.getCustomParam().get("empCommonfilterBasedataId");
            FilterInfo filterInfo = queryParam.getFilter();
            this.reportPlanId = filterInfo.getLong("report");
            ArrayList ids = HRQueryEntityHelper.getInstance().queryAllPkByKSql(this.queryType, new QFilter[]{EmpReportRepository.handleFilter((FilterInfo)filterInfo, (Map)basedataIdMap)}, ReportDisplayRepository.getSort((Long)this.reportPlanId), EmpReportRepository.reletionMapFilter((FilterInfo)filterInfo));
            if (ids == null) {
                ids = new ArrayList(16);
            }
            dataSet = this.buildBatchDataSet(ids);
            IReportBatchQueryInfo byBatchInfo = queryParam.byBatchInfo();
            byBatchInfo.setCountPerBatch(BATCH_COUNT.intValue());
            size = ids.size();
            byBatchInfo.setMaxRowCountCached(size);
        }
        catch (Throwable throwable) {
            LOGGER.info(MessageFormat.format("EmpReportListPlugin.queryBatchBy---end maxSize={0},batchSize={1},executeTime={2}", size, BATCH_COUNT, System.currentTimeMillis() - startTime));
            throw throwable;
        }
        LOGGER.info(MessageFormat.format("EmpReportListPlugin.queryBatchBy---end maxSize={0},batchSize={1},executeTime={2}", size, BATCH_COUNT, System.currentTimeMillis() - startTime));
        return dataSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet query(ReportQueryParam reportQueryParam, Object selectedObj) {
        Set<String> queryFieldSet;
        FilterInfo filterInfo;
        Set<Object> matIdsOfCurrentBatch;
        long startTime;
        List currentBatchRows;
        block4: {
            DataSet dataSet;
            IReportBatchQueryInfo byBatchInfo = reportQueryParam.byBatchInfo();
            currentBatchRows = byBatchInfo.getCurrentBatchRows();
            if (currentBatchRows == null || currentBatchRows.isEmpty()) {
                LOGGER.info("EmpReportListPlugin.query,not found batch rows");
                return Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSetBuilder(new RowMeta(new Field[0])).build();
            }
            LOGGER.info("EmpReportListPlugin.query---begin query");
            startTime = System.currentTimeMillis();
            matIdsOfCurrentBatch = new HashSet();
            try {
                filterInfo = reportQueryParam.getFilter();
                this.reportPlanId = filterInfo.getLong("report");
                queryFieldSet = this.getQueryFields();
                if (!CollectionUtils.isEmpty(queryFieldSet)) break block4;
                dataSet = null;
            }
            catch (Throwable throwable) {
                LOGGER.info(MessageFormat.format("EmpReportListPlugin.query---end query by batch,current size={0},executeTime={1} ms.", matIdsOfCurrentBatch.size(), System.currentTimeMillis() - startTime));
                throw throwable;
            }
            LOGGER.info(MessageFormat.format("EmpReportListPlugin.query---end query by batch,current size={0},executeTime={1} ms.", matIdsOfCurrentBatch.size(), System.currentTimeMillis() - startTime));
            return dataSet;
        }
        matIdsOfCurrentBatch = this.getQueryIdList(currentBatchRows);
        HRQueryEntityHelper.getCurrentRequestParam().setMulBaseDataCollectionToString(true);
        DataSet dataSet = HRQueryEntityHelper.getInstance().getQueryDataSet(this.queryType, String.join((CharSequence)",", queryFieldSet.toArray(new String[0])), new QFilter[]{new QFilter("id", "in", matIdsOfCurrentBatch)}, ReportDisplayRepository.getSort((Long)this.reportPlanId), EmpReportRepository.reletionMapFilter((FilterInfo)filterInfo));
        dataSet = this.calculate(dataSet, filterInfo, queryFieldSet);
        LOGGER.info(MessageFormat.format("EmpReportListPlugin.query---end query by batch,current size={0},executeTime={1} ms.", matIdsOfCurrentBatch.size(), System.currentTimeMillis() - startTime));
        return dataSet;
    }

    private DataSet calculate(DataSet dataSet, FilterInfo filterInfo, Set<String> queryFieldSet) {
        dataSet = this.addCalculate(dataSet, filterInfo, queryFieldSet);
        dataSet = this.addShowHisNameCalculate(dataSet, filterInfo, queryFieldSet);
        return EmpReportExtCommon.addExtCalculate((DataSet)dataSet, (FilterInfo)filterInfo, queryFieldSet);
    }

    private DataSet addCalculate(DataSet dataSet, FilterInfo filterInfo, Set<String> queryFieldSet) {
        if (dataSet == null) {
            LOGGER.info("EmpReportListPlugin.addCalculate dataset is null");
            return dataSet;
        }
        if (this.hasCalculateField(queryFieldSet)) {
            Date queryDate = EmpReportRepository.getQueryDate((FilterInfo)filterInfo);
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            if (queryFieldSet.contains("hrpi_empjobrel.jobclass.name")) {
                ArrayList<Long> jobBoidList = new ArrayList<Long>(10);
                DataSet copyDataSet = dataSet.copy();
                for (Row row : copyDataSet) {
                    Long jobBoid = row.getLong("hrpi_empjobrel.job.boid");
                    if (jobBoid == null || jobBoid == 0L) continue;
                    jobBoidList.add(jobBoid);
                }
                if (!jobBoidList.isEmpty()) {
                    Map jobClassLongNameMap = (Map)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hbjm", (String)"IHBJMJobClassService", (String)"getJobClassLongNameByJobAndBsed", (Object[])new Object[]{jobBoidList, queryDate});
                    paramMap.put("hrpi_empjobrel.jobclass.name", jobClassLongNameMap);
                }
            }
            if (queryFieldSet.contains("hrpi_pernontsprop.age")) {
                paramMap.put("hrpi_pernontsprop.age", queryDate);
            }
            dataSet = dataSet.map((MapFunction)new EmpReportCalculateMapFunction(dataSet.getRowMeta(), paramMap));
        }
        return dataSet;
    }

    private DataSet addShowHisNameCalculate(DataSet dataSet, FilterInfo filterInfo, Set<String> queryFieldSet) {
        if (dataSet == null) {
            LOGGER.info("EmpReportListPlugin.addShowHisNameCalculate,dataset is null");
            return dataSet;
        }
        if (this.hasShowHisNameField(queryFieldSet) && this.isQueryHisDate(filterInfo)) {
            LOGGER.info("EmpReportListPlugin.addShowHisNameCalculate,queryFieldSet:{}", queryFieldSet);
            DataSet copyDataSet = dataSet.copy();
            ShowHisVersionEntityHelper showHisVersionEntityHelper = ShowHisVersionEntityHelper.getInstance();
            Map hisVersionIdListMap = showHisVersionEntityHelper.getShowHisVersionIdListMap(copyDataSet, queryFieldSet, SHOW_HIS_VERSION_ENTITY_LIST);
            Map hisVersionDysMap = showHisVersionEntityHelper.queryHisVersionDysMap(hisVersionIdListMap, SHOW_HIS_VERSION_ENTITY_LIST, this.getDataStatusAndBsedFilter(filterInfo));
            dataSet = dataSet.map((MapFunction)new EmpReportShowHisNameCalculateMapFunction(dataSet.getRowMeta(), hisVersionDysMap));
        }
        return dataSet;
    }

    private QFilter getDataStatusAndBsedFilter(FilterInfo filterInfo) {
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"0", "1", "2"}));
        dataStatusFilter.and(new QFilter("iscurrentversion", "=", (Object)"0"));
        Date dateParam = EmpReportRepository.getQueryDate((FilterInfo)filterInfo);
        dataStatusFilter.and(new QFilter("bsed", "<=", (Object)dateParam));
        dataStatusFilter.and(new QFilter("bsled", ">=", (Object)dateParam));
        dataStatusFilter.and(new QFilter("initstatus", "=", (Object)"2"));
        return dataStatusFilter;
    }

    private boolean hasCalculateField(Set<String> queryFieldSet) {
        for (String calculateColumn : CALCULATE_COLUMN_MAP.keySet()) {
            if (!queryFieldSet.contains(calculateColumn)) continue;
            return true;
        }
        return false;
    }

    private boolean hasShowHisNameField(Set<String> queryFieldSet) {
        for (ShowHisVersionEntity showHisVersionEntity : SHOW_HIS_VERSION_ENTITY_LIST) {
            if (!queryFieldSet.contains(showHisVersionEntity.getListFieldName())) continue;
            return true;
        }
        return false;
    }

    private boolean isQueryHisDate(FilterInfo filterInfo) {
        Date today;
        Date dateParam = EmpReportRepository.getQueryDate((FilterInfo)filterInfo);
        return dateParam.compareTo(today = HRDateTimeUtils.dateFormatDate((Date)new Date())) < 0;
    }

    public Set<Long> getQueryIdList(List<Row> currentBatchRows) {
        HashSet matIdsOfCurrentBatch = Sets.newHashSetWithExpectedSize((int)BATCH_COUNT);
        for (Row currentBatchRow : currentBatchRows) {
            Long matId = currentBatchRow.getLong(0);
            matIdsOfCurrentBatch.add(matId);
        }
        return matIdsOfCurrentBatch;
    }

    private Set<String> getQueryFields() {
        Map map = ReportDisplayRepository.getField((Long)this.reportPlanId);
        LinkedHashSet queryFieldSet = Sets.newLinkedHashSetWithExpectedSize((int)map.size());
        if (map.size() < 1) {
            return queryFieldSet;
        }
        queryFieldSet.add("id");
        queryFieldSet.addAll(map.keySet());
        this.addCalculateField(queryFieldSet);
        this.addHisNameCalculateField(queryFieldSet);
        EmpReportExtCommon.addExtQueryFields((Set)queryFieldSet);
        return queryFieldSet;
    }

    private void addCalculateField(Set<String> queryFieldSet) {
        for (Map.Entry<String, List<String>> entry : CALCULATE_COLUMN_MAP.entrySet()) {
            if (!queryFieldSet.contains(entry.getKey())) continue;
            queryFieldSet.addAll((Collection<String>)entry.getValue());
        }
    }

    private void addHisNameCalculateField(Set<String> queryFieldSet) {
        for (ShowHisVersionEntity showHisVersionEntity : SHOW_HIS_VERSION_ENTITY_LIST) {
            if (!queryFieldSet.contains(showHisVersionEntity.getListFieldName())) continue;
            queryFieldSet.add(showHisVersionEntity.getListBoidName());
            if (!HRStringUtils.isNotEmpty((String)showHisVersionEntity.getParentEntityName())) continue;
            queryFieldSet.add(showHisVersionEntity.getListParentIdName());
        }
    }

    private DataSet buildBatchDataSet(List<Object> ids) {
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("id", (DataType)DataType.LongType)});
        DataSetBuilder dataSetBuilder = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSetBuilder(rowMeta);
        for (Object id : ids) {
            dataSetBuilder.append(new Object[]{id});
        }
        return dataSetBuilder.build();
    }

    static {
        CALCULATE_COLUMN_MAP.put("hrpi_pernontsprop.age", Collections.singletonList("hrpi_pernontsprop.birthday"));
        CALCULATE_COLUMN_MAP.put("hrpi_empjobrel.jobclass.name", Collections.singletonList("hrpi_empjobrel.job.boid"));
        CALCULATE_COLUMN_MAP.put("sort", Collections.singletonList("sort"));
        SHOW_HIS_VERSION_ENTITY_LIST.addAll(Lists.newArrayList((Object[])new ShowHisVersionEntity[]{new ShowHisVersionEntity("haos_adminorghr", "hrpi_empposorgrel.adminorg.boid", "hrpi_empposorgrel.adminorg.name"), new ShowHisVersionEntity("hbpm_positionhr", "hrpi_empposorgrel.position.boid", "hrpi_empposorgrel.position.name"), new ShowHisVersionEntity("hbpm_stposition", "hrpi_empposorgrel.stdposition.boid", "hrpi_empposorgrel.stdposition.name"), new ShowHisVersionEntity("haos_adminorghr", "hrpi_empposorgrel.company.boid", "hrpi_empposorgrel.company.name"), new ShowHisVersionEntity("hbjm_jobhr", "hrpi_empjobrel.job.boid", "hrpi_empjobrel.job.name"), new ShowHisVersionEntity("hbjm_joblevelhr", "hrpi_empjobrel.joblevel.entryboid", "hrpi_empjobrel.joblevel.name", "hbjm_joblevelscmhr", "hrpi_empjobrel.joblevel.joblevelscm", "entryboid", "joblevelscm"), new ShowHisVersionEntity("hbjm_jobgradehr", "hrpi_empjobrel.jobgrade.entryboid", "hrpi_empjobrel.jobgrade.name", "hbjm_jobgradescmhr", "hrpi_empjobrel.jobgrade.jobgradescm", "entryboid", "jobgradescm")}));
    }
}

