/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.report;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.list.JoinEntity;
import kd.bos.entity.qing.Field;
import kd.bos.entity.qing.IQingDataProvider;
import kd.bos.entity.qing.QingData;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.entity.qing.QingMeta;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.DateField;
import kd.bos.metadata.entity.commonfield.DateTimeField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hspm.business.domian.repository.EmpReportRepository;
import kd.hr.hspm.business.domian.repository.ReportDisplayRepository;
import kd.hr.hspm.formplugin.web.report.helper.EmpReportHelper;

public class QingAnlsListPlugin
extends AbstractFormPlugin
implements IQingDataProvider {
    private static final ArrayList<String> FIELD_KEYS = new ArrayList();
    private final QueryEntityType queryType = (QueryEntityType)EmpReportRepository.generate().getDataEntityType();

    public QingMeta getMeta(String pageId) {
        FIELD_KEYS.clear();
        List joinEntityList = this.queryType.getJoinEntitys();
        Map<String, String> joinEntityAliasMap = joinEntityList.stream().collect(Collectors.toMap(JoinEntity::getAlias, JoinEntity::getEntityName));
        Map filterInfos = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("qingFilter"), Map.class);
        Map map = ReportDisplayRepository.getField((Long)HRJSONUtils.getLongValOfCustomParam(((Map)filterInfos.get("report")).get("id")));
        HashMap<String, EntityMetadata> metaMap = new HashMap<String, EntityMetadata>(16);
        QingMeta meta = new QingMeta();
        for (Map.Entry entry : map.entrySet()) {
            String mapKey = (String)entry.getKey();
            String mapValue = (String)entry.getValue();
            FIELD_KEYS.add(mapKey);
            Tuple<String, EntityItem<?>> fieldInfo = EmpReportHelper.getFieldItem(joinEntityAliasMap, (String)entry.getKey(), metaMap);
            meta.addColumn(this.createColumnByType((String)fieldInfo.item1, (EntityItem)fieldInfo.item2, mapKey, mapValue));
        }
        return meta;
    }

    public QingData getData(String pageId, int startRow, int limit) {
        if (startRow > 10000 || FIELD_KEYS.size() < 1) {
            return null;
        }
        QingData data = new QingData();
        StringBuilder querySb = new StringBuilder();
        for (String entry : FIELD_KEYS) {
            querySb.append(MessageFormat.format("{0},", entry));
        }
        if (querySb.length() > 0) {
            querySb.deleteCharAt(querySb.length() - 1);
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hspm_reportquery");
        QueryEntityType queryType = (QueryEntityType)helper.generateEmptyDynamicObject().getDataEntityType();
        DataSet dataSet = queryType.getQueryDataSet(querySb.toString(), new QFilter[0], null, startRow, limit);
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        this.createDataIndex(data);
        if (dataSet.hasNext()) {
            Row rowData = dataSet.next();
            Object[] row = new Object[FIELD_KEYS.size()];
            for (int i1 = 0; i1 < FIELD_KEYS.size(); ++i1) {
                row[i1] = rowData.get(FIELD_KEYS.get(i1));
            }
            rows.add(row);
        }
        data.setRows(rows);
        return data;
    }

    public void setFilterParameter(String filterParameter) {
        IPageCache pageCache = this.getPageCache();
        pageCache.put("qingFilter", filterParameter);
    }

    private Field createColumnByType(String entityKey, EntityItem<?> item, String mapKey, String mapValue) {
        if (item == null) {
            return null;
        }
        Field column = new Field();
        column.setEntity(entityKey);
        column.setKey(mapKey);
        column.setName(new LocaleString(mapValue));
        if (item instanceof CheckBoxField) {
            column.setFieldType(QingFieldType.Boolean.toNumber());
        } else if (item instanceof IntegerField) {
            column.setFieldType(QingFieldType.Int.toNumber());
        } else if (item instanceof DecimalField) {
            column.setFieldType(QingFieldType.Number.toNumber());
        } else if (item instanceof DateField) {
            column.setFieldType(QingFieldType.Date.toNumber());
        } else if (item instanceof DateTimeField) {
            column.setFieldType(QingFieldType.DateTime.toNumber());
        } else {
            column.setFieldType(QingFieldType.String.toNumber());
        }
        return column;
    }

    private void createDataIndex(QingData data) {
        HashMap<String, Integer> dataindex = new HashMap<String, Integer>(16);
        for (int index = 0; index < FIELD_KEYS.size(); ++index) {
            dataindex.put(FIELD_KEYS.get(index), index);
        }
        data.setDataindex(dataindex);
    }
}

