/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.report;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hspm.common.constants.report.enums.SortRuleEnum;
import kd.hr.hspm.formplugin.web.report.helper.ReportDisplayHelper;

public class ReportDisplayEntryPlugin
extends HRDataBaseEdit {
    private static final String OP_MOVEUP = "donothing_moveup";
    private static final String OP_MOVEDOWN = "donothing_movedown";
    private static final String OP_STICK = "donothing_stick";
    private static final String OP_LOWER = "donothing_lower";
    private static final Set<String> ENTRY_OP = new HashSet<String>(Arrays.asList("donothing_moveup", "donothing_movedown", "donothing_stick", "donothing_lower"));

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (key = operate.getOperateKey()) {
            case "save": {
                Boolean isPass = this.validateSort();
                if (!isPass.booleanValue()) {
                    args.setCancel(true);
                    break;
                }
                this.checkBeforeSave(args);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) {
            return;
        }
        String key = args.getOperateKey();
        this.handleShowEntryOp(key);
        this.handleDetailEntryOp(key);
    }

    private void handleShowEntryOp(String key) {
        if ("donothing_entrydel".equals(key)) {
            HRPageCache pageCache = new HRPageCache(this.getView());
            Map checkMap = (Map)pageCache.get("check", Map.class);
            IFormView view = this.getView();
            EntryGrid grid = (EntryGrid)this.getControl("showentity");
            this.delete(grid.getSelectRows());
            ReportDisplayHelper.buildCheckMap(view, checkMap, pageCache);
            ReportDisplayHelper.setLblTotal(this.getView(), checkMap.size());
        }
    }

    private void handleDetailEntryOp(String key) {
        if (!ENTRY_OP.contains(key)) {
            return;
        }
        EntryGrid grid = (EntryGrid)this.getControl("detailshowentity");
        int[] rows = grid.getSelectRows();
        IFormView view = this.getView();
        if (rows.length < 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"ReportDisplayEntryPlugin_0", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            return;
        }
        HRPageCache pageCache = new HRPageCache(this.getView());
        Map checkMap = (Map)pageCache.get("check", Map.class);
        switch (key) {
            case "donothing_moveup": {
                this.moveUp(rows);
                break;
            }
            case "donothing_movedown": {
                this.moveDown(rows);
                break;
            }
            case "donothing_stick": {
                this.moveToTop(rows);
                break;
            }
            case "donothing_lower": {
                this.moveToBottom(rows);
                break;
            }
        }
        ReportDisplayHelper.buildCheckMap(view, checkMap, pageCache);
    }

    private Boolean validateSort() {
        Boolean flag = Boolean.TRUE;
        DynamicObjectCollection entity = this.getModel().getEntryEntity("detailshowentity");
        HashMap<Integer, String> map = new HashMap<Integer, String>(16);
        for (DynamicObject obj : entity) {
            String systemAlias = obj.getString("systemalias");
            int sortNum = obj.getInt("sortnum");
            String sortRule = obj.getString("sortrule");
            if (SortRuleEnum.NONE.getType().equals(sortRule)) continue;
            String text = null;
            if (HRStringUtils.isEmpty((String)sortRule)) {
                text = MessageFormat.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c{0}\u201d\u7684\u6392\u5e8f\u89c4\u5219\u3002", (String)"ReportDisplayEntryPlugin_1", (String)"hr-hspm-formplugin", (Object[])new Object[0]), systemAlias);
                flag = Boolean.FALSE;
            } else if (0 == sortNum) {
                text = MessageFormat.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c{0}\u201d\u7684\u6392\u5e8f\u987a\u5e8f\u7801\u3002", (String)"ReportDisplayEntryPlugin_2", (String)"hr-hspm-formplugin", (Object[])new Object[0]), systemAlias);
                flag = Boolean.FALSE;
            } else {
                String tempRule = (String)map.get(sortNum);
                if (!HRStringUtils.isEmpty((String)tempRule)) {
                    text = MessageFormat.format(ResManager.loadKDString((String)"\u201c{0}\u201d\u7684\u6392\u5e8f\u987a\u5e8f\u7801\u4e0e\u201c{1}\u201d\u7684\u6392\u5e8f\u987a\u5e8f\u7801\u91cd\u590d\u3002", (String)"ReportDisplayEntryPlugin_3", (String)"hr-hspm-formplugin", (Object[])new Object[0]), systemAlias, map.get(sortNum));
                    flag = Boolean.FALSE;
                } else {
                    map.put(sortNum, systemAlias);
                }
            }
            if (flag.booleanValue()) continue;
            this.getView().showTipNotification(text);
            break;
        }
        return flag;
    }

    private void checkBeforeSave(BeforeDoOperationEventArgs args) {
        OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
        if (HRStringUtils.isEmpty((String)name.getLocaleValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u65b9\u6848\u540d\u79f0\u3002", (String)"ReportDisplayEntryPlugin_7", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    private boolean moveUp(int[] rows) {
        if (rows[0] == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5230\u8fbe\u9876\u90e8", (String)"ReportDisplayEntryPlugin_4", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            return false;
        }
        this.getModel().moveEntryRowsUp("detailshowentity", rows);
        return true;
    }

    private boolean moveDown(int[] rows) {
        DynamicObjectCollection entity = this.getModel().getEntryEntity("showentity");
        int size = entity.size() - 1;
        if (rows[0] == size) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5230\u8fbe\u5e95\u90e8", (String)"ReportDisplayEntryPlugin_5", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            return false;
        }
        this.getModel().moveEntryRowsDown("detailshowentity", rows);
        return true;
    }

    private boolean delete(int[] rows) {
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        ArrayList<String> nodes = new ArrayList<String>(rows.length);
        for (int row : rows) {
            DynamicObject entity = this.getModel().getEntryRowEntity("showentity", row);
            nodes.add(entity.getString("shownodeid1"));
        }
        treeView.uncheckNodes(nodes);
        this.getModel().deleteEntryRows("showentity", rows);
        this.getModel().deleteEntryRows("detailshowentity", rows);
        return true;
    }

    private boolean moveToTop(int[] rows) {
        if (rows.length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u6761\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ReportDisplayEntryPlugin_6", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (rows[0] == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5230\u8fbe\u9876\u90e8", (String)"ReportDisplayEntryPlugin_4", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            return false;
        }
        int row = rows[0];
        while (row > 0) {
            this.getModel().moveEntryRowsUp("detailshowentity", new int[]{row--});
        }
        return true;
    }

    private boolean moveToBottom(int[] rows) {
        DynamicObjectCollection entity = this.getModel().getEntryEntity("showentity");
        if (rows.length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u6761\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ReportDisplayEntryPlugin_6", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            return false;
        }
        int size = entity.size() - 1;
        if (rows[0] == size) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5230\u8fbe\u5e95\u90e8", (String)"ReportDisplayEntryPlugin_5", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            return false;
        }
        int row = rows[0];
        while (row < size) {
            this.getModel().moveEntryRowsDown("detailshowentity", new int[]{row++});
        }
        return true;
    }
}

