/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.report;

import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hspm.business.domian.repository.ReportPlanRepository;
import kd.hr.hspm.formplugin.web.report.helper.ReportDisplayHelper;

public class ReportPlanPlugin
extends HRDataBaseEdit {
    private static final String CACHE_SELECTID = "cache_selectid";
    private static final String OP_CANCEL = "donothing_cancel";

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        if (OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            IFormView view = this.getView();
            IDataModel dataModel = this.getModel();
            dataModel.setValue("person", (Object)RequestContext.get().getCurrUserId());
            String type = (String)view.getFormShowParameter().getCustomParam("type");
            if (!HRStringUtils.isEmpty((String)type)) {
                dataModel.setValue("type", (Object)ReportDisplayHelper.getType(view));
            }
            dataModel.setDataChanged(false);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        String key = source.getOperateKey();
        if ("save".equals(key)) {
            IDataModel model = this.getModel();
            OrmLocaleValue newName = (OrmLocaleValue)model.getValue("name");
            String name = newName.getLocaleValue();
            if (HRStringUtils.isEmpty((String)name)) {
                return;
            }
            Long id = (Long)model.getValue("id");
            if (ReportPlanRepository.isExist((String)model.getDataEntity().getString("type"), (String)name, (Long)id).booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ReportPlanPlugin_0", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        IFormView parentView;
        super.afterDoOperation(args);
        if (args.getOperationResult() != null && !args.getOperationResult().isSuccess()) {
            return;
        }
        String key = args.getOperateKey();
        this.handleSave(args, key);
        this.handleDelete(args, key);
        if ((OP_CANCEL.equals(key) || "delete".equals(key)) && (parentView = this.getView().getParentView()) != null) {
            parentView.getPageCache().remove(CACHE_SELECTID);
            parentView.updateView();
            this.getView().sendFormAction(parentView);
        }
    }

    private void handleSave(AfterDoOperationEventArgs args, String key) {
        if ("save".equals(key)) {
            DynamicObject dy = this.getModel().getDataEntity();
            Long id = dy.getLong("id");
            IFormView view = this.getView();
            IFormView parentView = view.getParentView();
            HRPageCache pageCache = new HRPageCache(parentView);
            pageCache.put(CACHE_SELECTID, (Object)String.valueOf(id));
            this.handleOtherSave();
            args.getOperationResult().setShowMessage(false);
            parentView.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"ReportDisplayEntryPlugin_8", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            parentView.updateView();
            this.getView().sendFormAction(parentView);
        }
    }

    private void handleDelete(AfterDoOperationEventArgs args, String key) {
        if ("delete".equals(key)) {
            IFormView parentView = this.getView().getParentView();
            args.getOperationResult().setShowMessage(false);
            parentView.showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"ReportDisplayEntryPlugin_9", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            parentView.updateView();
            this.getView().sendFormAction(parentView);
        }
    }

    protected void handleOtherSave() {
    }
}

