/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.revise;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.hr.hspm.business.domian.repository.inforevise.EmployeeRepository;
import kd.hr.hspm.business.domian.repository.inforevise.EmpposorgrelRepository;
import kd.hr.hspm.business.domian.repository.inforevise.ErmanfileRepository;
import kd.hr.hspm.business.revise.PersonReviseService;
import kd.hr.hspm.business.revise.ext.helper.ReviseExtHelper;
import kd.hr.hspm.business.revise.helper.PersonReviseHelper;
import kd.sdk.hr.hspm.business.repository.CommonQueryRepository;
import kd.sdk.hr.hspm.business.revise.helper.DynamicConvertUtils;
import kd.sdk.hr.hspm.business.revise.helper.ReviseEntityNameHelperEnum;
import kd.sdk.hr.hspm.common.constants.PersonReviseConstants;

public class PersonReviseDetailEdit
extends HRCoreBaseBillEdit
implements PersonReviseConstants {
    private static final Log LOG = LogFactory.getLog(PersonReviseDetailEdit.class);
    private List<String> specialNotCompareFieldList = Arrays.asList("adminorgvid", "positionvid", "jobvid", "stdpositionvid");

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"revisesave", "revisecancel"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"changeinfoflexpanelap"});
        this.getModel().setValue("revisereason", null);
        this.getModel().setValue("revisedesc", null);
    }

    public void afterBindData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if ("newbo".equals(customParams.get("revisetype")) || "nodatanewbo".equals(customParams.get("formSource"))) {
            PersonReviseService personReviseService = new PersonReviseService();
            personReviseService.customControlNewBo(this.getView().getParentView(), (String)customParams.get("groupname"));
            String entityName = (String)customParams.get("entityname");
            Long newId = ORM.create().genLongId(entityName);
            this.getModel().setValue("id", (Object)newId);
            this.getModel().setValue("bsed", (Object)new Date());
            this.showOperationView(OperationStatus.ADDNEW);
        }
        List<String> data2999Field = this.getData2999Field();
        for (String field : data2999Field) {
            Date dataField = this.getModel().getDataEntity().getDate(field);
            if (!Objects.nonNull(dataField) || 0 != HisEffDateCommonService.getInstance().getDate2999(null).compareTo(dataField)) continue;
            this.getModel().setValue(field, null);
        }
        this.getModel().setDataChanged(false);
    }

    protected List<String> getData2999Field() {
        return new ArrayList<String>();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Map parentCustomParams = this.getView().getParentView().getFormShowParameter().getCustomParams();
        String groupName = (String)customParams.get("groupname");
        Object reviseType = customParams.get("revisetype");
        String reviseEntityName = (String)customParams.get("reviseentityname");
        String baseEntityName = (String)customParams.get("entityname");
        Long personId = (Long)customParams.get("personid");
        FormOperate formOperate = (FormOperate)args.getSource();
        OperateOption operateOption = OperateOption.create();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long id = dataEntity.getLong("id");
        DynamicObject curDyn = CommonQueryRepository.getInstance().queryDataByHisId(baseEntityName, Long.valueOf(id));
        switch (formOperate.getOperateKey()) {
            case "revisecancel": {
                if (this.getModel().getDataChanged()) {
                    args.setCancel(true);
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("continue_cancel", (IFormPlugin)this);
                    String msg = MessageFormat.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u53d6\u6d88\uff1f{0}\u82e5\u53d6\u6d88\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"PersonReviseDetailEdit_0", (String)"hr-hspm-formplugin", (Object[])new Object[0]), System.lineSeparator());
                    this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, ConfirmTypes.Save, confirmCallBacks);
                    break;
                }
                this.releasePageMutex();
                PersonReviseHelper.removeNewBoFlagCacheToParentView((IFormView)this.getView());
                break;
            }
            case "revisesave": {
                HashSet<String> prop = new HashSet<String>();
                for (IDataEntityProperty property : this.getModel().getDataEntity().getDataEntityState().getBizChangedProperties()) {
                    String propName = property.getName();
                    if (HRStringUtils.equals((String)propName, (String)"revisereason") || HRStringUtils.equals((String)propName, (String)"revisedesc")) continue;
                    prop.add(propName);
                }
                if (prop.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u4fe1\u606f\u53d8\u66f4\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5df2\u53d8\u66f4\u4fe1\u606f\u3002", (String)"PersonReviseDetailEdit_1", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
                String dataStatus = dataEntity.getString("datastatus");
                if (Objects.nonNull(reviseType) && String.valueOf(reviseType).equals("reviseversion") && "1".equals(dataStatus)) {
                    long curBoId = dataEntity.getLong("boid");
                    HashSet queryFieldSet = Sets.newHashSet((Object[])new String[]{"id", "datastatus"});
                    DynamicObject[] dynArrFromDb = CommonQueryRepository.getInstance().queryInfoByBoId(baseEntityName, (Set)queryFieldSet, Long.valueOf(curBoId));
                    DynamicObject curHisDyn = Arrays.stream(dynArrFromDb).filter(dyn -> "1".equals(dyn.getString("datastatus"))).findFirst().get();
                    long curHisId = curHisDyn.getLong("id");
                    if (curHisId != id) {
                        this.getView().getParentView().getPageCache().remove("isediting");
                        this.getView().getParentView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a%s\u53d1\u751f\u53d8\u66f4\uff0c\u5c06\u81ea\u52a8\u5237\u65b0\u9875\u9762\u3002", (String)"PersonReviseDetailEdit_19", (String)"hr-hspm-formplugin", (Object[])new Object[0]), groupName));
                        this.openDetailRevise(id, this.getView(), OperationStatus.VIEW);
                        this.getView().sendFormAction(this.getView().getParentView());
                        this.getModel().setDataChanged(false);
                        this.getView().close();
                        args.setCancel(true);
                        return;
                    }
                }
                if (Objects.nonNull(reviseType)) {
                    operateOption.setVariableValue("revisetype", String.valueOf(reviseType));
                    Object reviseRecordId = parentCustomParams.get("reviserecordid");
                    Object entityName = customParams.get("entityname");
                    operateOption.setVariableValue("reviserecordid", String.valueOf(reviseRecordId));
                    operateOption.setVariableValue("personid", String.valueOf(personId));
                    operateOption.setVariableValue("entityname", String.valueOf(entityName));
                    if (Objects.nonNull(customParams.get("name"))) {
                        operateOption.setVariableValue("name", String.valueOf(customParams.get("name")));
                    }
                }
                formOperate.setOption(operateOption);
                break;
            }
            case "reviselog": {
                ListShowParameter showParameter = new ListShowParameter();
                OpenStyle openStyle = new OpenStyle();
                StyleCss styleCss = new StyleCss();
                styleCss.setWidth("90%");
                styleCss.setHeight("90%");
                showParameter.setOpenStyle(openStyle);
                openStyle.setInlineStyleCss(styleCss);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setFormId("bos_list");
                showParameter.setCustomParams(this.getView().getFormShowParameter().getCustomParams());
                String caption = String.format(ResManager.loadKDString((String)"%s\u4fee\u8ba2\u65e5\u5fd7", (String)"PersonReviseDetailEdit_2", (String)"hr-hspm-formplugin", (Object[])new Object[0]), groupName);
                showParameter.setCaption(caption);
                String curPageEntityName = this.getModel().getDataEntity().getDataEntityType().getName();
                String reviseLogPageName = ReviseEntityNameHelperEnum.getLogEntityNameByReviseEntityName((String)curPageEntityName);
                showParameter.setBillFormId(reviseLogPageName);
                showParameter.setCustomParam("baseentityname", (Object)ReviseEntityNameHelperEnum.getBaseEntityNameByReviseEntityName((String)curPageEntityName));
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "deleteboconfirm": {
                if (Objects.isNull(curDyn) || HRStringUtils.equals((String)curDyn.getString("datastatus"), (String)"-2")) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"PersonReviseDetailEdit_20", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (!this.restrictPageMutex(args)) {
                    args.setCancel(true);
                    return;
                }
                String msg = "";
                if ("hspm_revtrialperiod".equals(reviseEntityName)) {
                    String empEntrelGroupName = (String)customParams.get("empentrelgroupname");
                    msg = String.format(ResManager.loadKDString((String)"\u5220\u9664\u540e\u5c06\u201c%1$s\u201d\u4e2d\u7684\u201c\u662f\u5426\u6709\u8bd5\u7528\u671f\u201d\u6539\u4e3a\u201c\u5426\u201d\uff0c\u4e14\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u8ba4\u8981\u5220\u9664\u8bd5\u7528\u671f\u5417\uff1f", (String)"PersonReviseDetailEdit_3", (String)"hr-hspm-formplugin", (Object[])new Object[0]), empEntrelGroupName);
                    this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("revisedeletebo", (IFormPlugin)this));
                } else if ("hspm_revempposorgrel".equals(reviseEntityName)) {
                    String extDeleteResultMsg = ReviseExtHelper.getExtReviseImpl();
                    if (HRStringUtils.isNotEmpty((String)extDeleteResultMsg)) {
                        this.getView().showErrorNotification(extDeleteResultMsg);
                        args.setCancel(true);
                        return;
                    }
                    Long employeeId = dataEntity.getLong("employee.id");
                    DynamicObject[] effectEmpPosOrgRelDynArr = EmpposorgrelRepository.getInstance().queryEffectDataByEmployeeId(employeeId);
                    if (effectEmpPosOrgRelDynArr.length == 1) {
                        DynamicObject employeeDyn = EmployeeRepository.getInstance().queryByPkId(employeeId);
                        String workStartDate = HRDateTimeUtils.format((Date)employeeDyn.getDate("startdate"), (String)"yyyy-MM-dd");
                        String workEndDate = HRDateTimeUtils.format((Date)employeeDyn.getDate("enddate"), (String)"yyyy-MM-dd");
                        String lastDayStr = HRDateTimeUtils.format((Date)HisEffDateCommonService.getInstance().getDate2999(null), (String)"yyyy-MM-dd");
                        if (lastDayStr.equals(workEndDate)) {
                            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u7528\u5de5\u5f00\u59cb\u5230\u7ed3\u675f\u671f\u95f4[%1$s\uff0c\u81f3\u4eca]\u9700\u81f3\u5c11\u4fdd\u7559\u4e00\u6761\u4efb\u804c\u4fe1\u606f\u3002", (String)"PersonReviseDetailEdit_5", (String)"hr-hspm-formplugin", (Object[])new Object[0]), workStartDate));
                        } else {
                            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u7528\u5de5\u5f00\u59cb\u5230\u7ed3\u675f\u671f\u95f4[%1$s\uff0c%2$s]\u9700\u81f3\u5c11\u4fdd\u7559\u4e00\u6761\u4efb\u804c\u4fe1\u606f\u3002", (String)"PersonReviseDetailEdit_4", (String)"hr-hspm-formplugin", (Object[])new Object[0]), workStartDate, workEndDate));
                        }
                        this.releasePageMutex();
                    } else {
                        DynamicObject depEmpDyn = dataEntity.getDynamicObject("depemp");
                        if (depEmpDyn != null) {
                            long depEmpId = depEmpDyn.getLong("id");
                            DynamicObject ermanFileDyn = ErmanfileRepository.getInstance().queryCurrentVersionDataByDepempId(Long.valueOf(depEmpId));
                            String fileTypeName = ermanFileDyn.getString("filetype.name");
                            if (HRStringUtils.isEmpty((String)fileTypeName)) {
                                fileTypeName = ResManager.loadKDString((String)"\u4eba\u4e8b\u4e1a\u52a1\u6863\u6848", (String)"PersonReviseDetailEdit_25", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
                            }
                            msg = String.format(ResManager.loadKDString((String)"\u5220\u9664\u4efb\u804c\u540e\u5173\u8054\u7684\u201c%1$s\u201d\u5c06\u88ab\u5e9f\u5f03\uff0c\u4e14\u65e0\u6cd5\u6062\u590d\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PersonReviseDetailEdit_6", (String)"hr-hspm-formplugin", (Object[])new Object[0]), fileTypeName);
                            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("revisedeletebo", (IFormPlugin)this));
                        }
                    }
                }
                args.setCancel(true);
                break;
            }
            case "reviseedit": {
                if (Objects.isNull(curDyn) || HRStringUtils.equals((String)curDyn.getString("datastatus"), (String)"-2")) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"PersonReviseDetailEdit_20", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (this.restrictPageMutex(args)) break;
                args.setCancel(true);
                return;
            }
            case "revisenewbo": {
                if (!this.restrictPageMutex(args)) {
                    args.setCancel(true);
                    return;
                }
                PersonReviseHelper.putNewBoFlagCacheToParentView((IFormView)this.getView());
                break;
            }
            case "revisedeletebo": {
                Object reviseRecordId = parentCustomParams.get("reviserecordid");
                operateOption.setVariableValue("reviserecordid", String.valueOf(reviseRecordId));
                operateOption.setVariableValue("personid", String.valueOf(personId));
                operateOption.setVariableValue("revisetype", "deletebo");
                Object entityName = customParams.get("entityname");
                operateOption.setVariableValue("entityname", String.valueOf(entityName));
                formOperate.setOption(operateOption);
            }
        }
    }

    private boolean restrictPageMutex(BeforeDoOperationEventArgs args) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String reviseEntityName = (String)customParams.get("reviseentityname");
        Long personId = (Long)customParams.get("personid");
        String errMsg = PersonReviseHelper.doMutex((BeforeDoOperationEventArgs)args, (Long)personId, (String)reviseEntityName);
        if (HRStringUtils.isNotEmpty((String)errMsg)) {
            this.getView().showTipNotification(errMsg);
            return false;
        }
        String pageId = this.getView().getPageId();
        this.getView().getParentView().getPageCache().put("lockPageId", pageId);
        return true;
    }

    private void releasePageMutex() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String pageId = this.getView().getPageId();
        String lockPageId = this.getView().getParentView().getPageCache().get("lockPageId");
        Boolean newFlag = "nodatanewbo".equals(customParams.get("formSource")) || "newbo".equals(customParams.get("revisetype"));
        if (newFlag.booleanValue() || pageId.equals(lockPageId)) {
            String reviseEntityName = (String)customParams.get("reviseentityname");
            Long personId = (Long)customParams.get("personid");
            PersonReviseHelper.releaseMutex((String)reviseEntityName, (Long)personId);
            this.getView().getParentView().getPageCache().remove("lockPageId");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if ("continue_cancel".equals(callBackId) && evt.getResult() == MessageBoxResult.Yes) {
            String reviseType = (String)customParams.get("revisetype");
            if ("nodatanewbo".equals(customParams.get("formSource"))) {
                this.getView().getParentView().invokeOperation("refresh");
                this.getView().sendFormAction(this.getView().getParentView());
            } else if ("newbo".equals(reviseType)) {
                PersonReviseService personReviseService = new PersonReviseService();
                personReviseService.customControlCancelNewBo(this.getView().getParentView());
                Long oldId = (Long)customParams.get("oldId");
                customParams.put("revisetype", null);
                this.openDetailRevise(oldId, this.getView(), OperationStatus.VIEW);
                this.getView().sendFormAction(this.getView().getParentView());
                this.getModel().setDataChanged(false);
                this.getView().close();
            } else {
                this.showOperationView(OperationStatus.VIEW);
                this.getView().invokeOperation("refresh");
            }
            this.releasePageMutex();
            PersonReviseHelper.removeNewBoFlagCacheToParentView((IFormView)this.getView());
        } else if ("revisedeletebo".equals(callBackId)) {
            if (evt.getResult() == MessageBoxResult.Yes) {
                this.getView().invokeOperation("revisedeletebo");
            }
            this.releasePageMutex();
        } else if ("saveconfirm".equals(callBackId) && evt.getResult() == MessageBoxResult.Yes) {
            this.getView().invokeOperation("revisesave");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        String operateKey = eventArgs.getOperateKey();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        switch (operateKey) {
            case "revisesave": {
                if (!eventArgs.getOperationResult().isSuccess()) break;
                FormOperate formOperate = (FormOperate)eventArgs.getSource();
                OperateOption option = formOperate.getOption();
                String resultFlag = option.getVariableValue("resultFlag");
                if ("success".equals(resultFlag)) {
                    this.releasePageMutex();
                    this.getView().getParentView().getPageCache().remove("isediting");
                    String reviseType = this.isNewBoOrReviseVersion(customParams);
                    if ("reviseversion".equals(reviseType)) {
                        this.showMsgAfterSaveForReviseVersion(customParams, option);
                    } else {
                        this.showSaveSuccessNotification();
                    }
                    String newHisId = option.getVariableValue("newHisId");
                    String newBoId = option.getVariableValue("newBoId");
                    String baseEntityName = (String)customParams.get("entityname");
                    Long employeeId = (Long)customParams.get("employeeid");
                    Long ermanFileId = (Long)customParams.get("ermanfileid");
                    Long personId = (Long)customParams.get("personid");
                    this.initTreeDataAndSendToFront(newHisId, newBoId, baseEntityName, employeeId, ermanFileId, personId, reviseType);
                    customParams.put("revisetype", null);
                    customParams.put("formSource", null);
                    LOG.info("afterDoOperation#revisesave newBoId={},newHisId={}", (Object)newBoId, (Object)newHisId);
                    this.openDetailRevise(Long.valueOf(newHisId), this.getView(), OperationStatus.VIEW);
                    this.getView().sendFormAction(this.getView().getParentView());
                    this.getModel().setDataChanged(false);
                    this.getView().close();
                    break;
                }
                if ("noInfoChange".equals(resultFlag)) {
                    String errMsg = option.getVariableValue("errMsg");
                    this.getView().showTipNotification(errMsg);
                    break;
                }
                String errMsg = option.getVariableValue("errMsg");
                this.getView().showErrorNotification(errMsg);
                return;
            }
            case "revisecancel": {
                if ("nodatanewbo".equals(customParams.get("formSource"))) {
                    this.getView().getParentView().invokeOperation("refresh");
                    this.getView().sendFormAction(this.getView().getParentView());
                    break;
                }
                this.showOperationView(OperationStatus.VIEW);
                if ("newbo".equals(customParams.get("revisetype"))) {
                    Long oldId = (Long)customParams.get("oldId");
                    customParams.put("revisetype", null);
                    this.openDetailRevise(oldId, this.getView(), OperationStatus.VIEW);
                    PersonReviseService personReviseService = new PersonReviseService();
                    personReviseService.customControlCancelNewBo(this.getView().getParentView());
                    this.getView().sendFormAction(this.getView().getParentView());
                    this.getModel().setDataChanged(false);
                    this.getView().close();
                    break;
                }
                this.getView().getFormShowParameter().setCustomParam("revisetype", null);
                this.getView().invokeOperation("refresh");
                break;
            }
            case "reviseedit": {
                this.showOperationView(OperationStatus.EDIT);
                this.getView().getFormShowParameter().setCustomParam("revisetype", (Object)"reviseversion");
                this.getView().cacheFormShowParameter();
                this.setFieldEnable();
                break;
            }
            case "revisenewbo": {
                IFormView parentView = this.getView().getParentView();
                customParams.put("revisetype", "newbo");
                customParams.put("oldId", this.getModel().getDataEntity().getLong("id"));
                this.openDetailRevise(0L, this.getView(), OperationStatus.ADDNEW);
                this.getView().sendFormAction(parentView);
                this.getView().close();
                break;
            }
            case "saveconfirm": {
                if (!eventArgs.getOperationResult().isSuccess()) break;
                this.getView().invokeOperation("revisesave");
                break;
            }
            case "revisedeletebo": {
                if (eventArgs.getOperationResult().isSuccess()) {
                    this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"PersonReviseDetailEdit_8", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                    this.getView().getParentView().invokeOperation("refresh");
                    this.getView().sendFormAction(this.getView().getParentView());
                }
                this.releasePageMutex();
                break;
            }
        }
    }

    private void showSaveSuccessNotification() {
        this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"PersonReviseDetailEdit_9", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
    }

    private String isNewBoOrReviseVersion(Map<String, Object> customParams) {
        return "nodatanewbo".equals(customParams.get("formSource")) || "newbo".equals(customParams.get("revisetype")) ? "newbo" : "reviseversion";
    }

    private void showMsgAfterSaveForReviseVersion(Map<String, Object> customParams, OperateOption option) {
        String newHisId = option.getVariableValue("newHisId");
        Long reviseHisId = Long.valueOf(option.getVariableValue("reviseHisId"));
        String baseEntityName = (String)customParams.get("entityname");
        HRBaseServiceHelper helper = new HRBaseServiceHelper(baseEntityName);
        QFilter idFilter = new QFilter("id", "in", Arrays.asList(reviseHisId, Long.valueOf(newHisId)));
        DynamicObject[] dynArr = helper.loadDynamicObjectArray(new QFilter[]{idFilter});
        Map<Long, DynamicObject> idVsDynMap = Arrays.stream(dynArr).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn));
        DynamicObject curDyn = idVsDynMap.get(Long.valueOf(newHisId));
        DynamicObject newHisDyn = idVsDynMap.get(reviseHisId);
        List<String> coreFieldList = this.getCompareFieldList(baseEntityName);
        List<DynamicConvertUtils.CompareResult> compareResults = this.compareForGetResult(curDyn, newHisDyn, coreFieldList);
        Map<String, String> fieldVsNameMap = this.getFieldVsNameMap(ReviseEntityNameHelperEnum.getEntityNameByBaseEntityName((String)baseEntityName));
        StringBuilder fieldSb = new StringBuilder();
        for (DynamicConvertUtils.CompareResult compareResult : compareResults) {
            String propKey;
            if (compareResult.isSame() || this.isNeedShowAfterSave(propKey = compareResult.getPropKey(), curDyn, newHisDyn)) continue;
            fieldSb.append(fieldVsNameMap.get(compareResult.getPropKey())).append("\u3001");
        }
        int curBoDataSize = this.getCurBoDataSize(customParams);
        if (HRStringUtils.isEmpty((String)fieldSb.toString())) {
            this.showSaveSuccessNotification();
        } else {
            String msg = String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\uff0c\u5e76\u5df2\u66f4\u65b0\u201c%1$s\u201d\u4e0b\u5386\u53f2\u8bb0\u5f55\u4e2d\u7684\u201c%3$s\u201d\uff08\u5df2\u66f4\u65b0\u7684\u5386\u53f2\u8bb0\u5f55\u7684\u6761\u6570\uff1a%2$s\uff09\u3002", (String)"PersonReviseDetailEdit_10", (String)"hr-hspm-formplugin", (Object[])new Object[0]), customParams.get("groupname"), curBoDataSize, fieldSb.deleteCharAt(fieldSb.length() - 1));
            this.getView().getParentView().showSuccessNotification(msg);
        }
    }

    protected boolean isNeedShowAfterSave(String fieldName, DynamicObject curDyn, DynamicObject newHisDyn) {
        return false;
    }

    private List<String> getCompareFieldList(String baseEntityName) {
        List coreFieldList = (List)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrpi", (String)"IHRPIAttachReviseConService", (String)"getFieldsByEntityNameAndType", (Object[])new Object[]{baseEntityName, Collections.singletonList(1010L)});
        if (HRStringUtils.equals((String)baseEntityName, (String)"hrpi_empposorgrel")) {
            coreFieldList.removeAll(this.specialNotCompareFieldList);
        }
        return coreFieldList;
    }

    private int getCurBoDataSize(Map<String, Object> customParams) {
        PersonReviseService personReviseService = new PersonReviseService(true, (String)customParams.get("entityname"));
        DynamicObject[] hisVersions = personReviseService.getHisVersions(customParams);
        Map<Long, List<DynamicObject>> boIdVsVersionListMap = Arrays.stream(hisVersions).collect(Collectors.groupingBy(version -> version.getLong("boid")));
        long curBoId = this.getModel().getDataEntity().getLong("boid");
        List<DynamicObject> curBoVersionList = boIdVsVersionListMap.get(curBoId);
        return curBoVersionList.size();
    }

    private List<DynamicConvertUtils.CompareResult> compareForGetResult(DynamicObject sourceDyn, DynamicObject newDyn, List<String> compareFieldList) {
        ArrayList<DynamicConvertUtils.CompareResult> result = new ArrayList<DynamicConvertUtils.CompareResult>(8);
        for (IDataEntityProperty property : sourceDyn.getDataEntityType().getProperties()) {
            DynamicConvertUtils.CompareResult compareResult;
            if (!compareFieldList.contains(property.getName())) continue;
            List<String> hisFieldList = Arrays.asList("adminorgvid", "positionvid", "jobvid", "stdpositionvid");
            if (hisFieldList.contains(property.getName())) {
                compareResult = this.compareHisField(property, sourceDyn, newDyn);
                result.add(compareResult);
                continue;
            }
            compareResult = DynamicConvertUtils.getCompareResult((IDataEntityProperty)property, (DynamicObject)sourceDyn, (DynamicObject)newDyn);
            result.add(compareResult);
        }
        return result;
    }

    private DynamicConvertUtils.CompareResult compareHisField(IDataEntityProperty property, DynamicObject sourceDyn, DynamicObject newDyn) {
        DynamicConvertUtils.CompareResult compareResult = new DynamicConvertUtils.CompareResult();
        compareResult.setPropKey(property.getName());
        compareResult.setPropType(property.getClass().getName());
        DynamicObject data = newDyn.getDynamicObject(property.getName());
        DynamicObject sourceData = sourceDyn.getDynamicObject(property.getName());
        boolean same = DynamicConvertUtils.compareBoBaseDataCol((DynamicObject)data, (DynamicObject)sourceData);
        compareResult.setSame(same);
        if (!same) {
            compareResult.setBeforeValue(String.valueOf(sourceDyn.getLong("id")));
            compareResult.setAfterValue(String.valueOf(newDyn.getLong("id")));
        }
        return compareResult;
    }

    private Map<String, String> getFieldVsNameMap(String entityName) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityName);
        DynamicObject dyn = helper.generateEmptyDynamicObject();
        DataEntityPropertyCollection properties = dyn.getDataEntityType().getProperties();
        HashMap fieldVsNameMap = Maps.newHashMapWithExpectedSize((int)properties.size());
        for (IDataEntityProperty property : dyn.getDataEntityType().getProperties()) {
            if (!Objects.nonNull(property.getDisplayName())) continue;
            fieldVsNameMap.put(property.getName(), property.getDisplayName().getLocaleValue());
        }
        return fieldVsNameMap;
    }

    public void pageRelease(EventObject e) {
        IFormView parentView;
        IFormView view = this.getView();
        if (Objects.nonNull(view) && Objects.nonNull(parentView = view.getParentView())) {
            if ("revisenewbo".equals(this.getView().getParentView().getPageCache().get("fromOperation"))) {
                PersonReviseHelper.removeNewBoFlagCacheToParentView((IFormView)this.getView());
            } else {
                this.releasePageMutex();
            }
        }
    }

    private void initTreeDataAndSendToFront(String newHisId, String newBoId, String baseEntityName, Long employeeId, Long ermanFileId, Long personId, String reviseType) {
        PersonReviseService personReviseService = new PersonReviseService(true, baseEntityName);
        DynamicObject[] hisVersions = personReviseService.getHisVersions(baseEntityName, employeeId, ermanFileId, personId, false, true, true);
        personReviseService.customControlInitData(hisVersions, newBoId, newHisId, reviseType, this.getView().getParentView());
    }

    public void openDetailRevise(Long id, String reviseEntityName, IFormView view, OperationStatus status, Map<String, Object> customParam) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.setFormId(reviseEntityName);
        showParameter.setCustomParams(customParam);
        if (0L != id) {
            showParameter.setPkId((Object)id);
        }
        showParameter.setStatus(status);
        showParameter.getOpenStyle().setTargetKey("revise_info");
        view.showForm((FormShowParameter)showParameter);
    }

    public void openDetailRevise(Long id, IFormView view, OperationStatus status) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        String reviseEntityName = view.getModel().getDataEntity().getDynamicObjectType().getName();
        showParameter.setFormId(reviseEntityName);
        showParameter.setCustomParams(view.getFormShowParameter().getCustomParams());
        if (0L != id) {
            showParameter.setPkId((Object)id);
        }
        showParameter.setStatus(status);
        showParameter.getOpenStyle().setTargetKey("revise_info");
        view.getParentView().showForm((FormShowParameter)showParameter);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String fieldKey = args.getProperty().getName();
        if (HRStringUtils.equals((String)"firstbsed", (String)fieldKey)) {
            this.getModel().getDataEntity().set("bsed", (Object)this.getModel().getDataEntity().getDate("firstbsed"));
        }
    }

    private void showOperationView(OperationStatus status) {
        IFormView parentView = this.getView().getParentView();
        if (status == OperationStatus.EDIT || status == OperationStatus.ADDNEW) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"revisesave", "revisecancel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"reviseedit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"reviselog"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"revisenewbo"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"revisedeletebo"});
            this.getView().setStatus(OperationStatus.EDIT);
            this.getView().setVisible(Boolean.TRUE, new String[]{"changeinfoflexpanelap"});
            Object noDataPageShowObject = this.getView().getFormShowParameter().getCustomParams().get("no_data_page_show");
            if (Objects.isNull(noDataPageShowObject) || !HRStringUtils.equals((String)((String)noDataPageShowObject), (String)"1")) {
                parentView.getPageCache().put("isediting", "1");
            } else {
                parentView.getPageCache().put("isediting", "0");
            }
        }
        if (status == OperationStatus.VIEW) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"revisesave", "revisecancel"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"reviseedit"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"reviselog"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"revisenewbo"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"revisedeletebo"});
            this.getView().setStatus(OperationStatus.VIEW);
            this.getView().setVisible(Boolean.FALSE, new String[]{"changeinfoflexpanelap"});
            parentView.getPageCache().put("isediting", "0");
        }
        this.getView().sendFormAction(this.getView().getParentView());
    }

    protected void setFieldEnable() {
    }

    protected String getEntityName() {
        return "";
    }
}

