/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.revise.list;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.DynamicTextColumnDesc;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hspm.business.revise.PersonReviseService;
import kd.hr.hspm.business.revise.helper.PersonReviseHelper;
import kd.sdk.hr.hspm.business.repository.CommonQueryRepository;
import kd.sdk.hr.hspm.business.revise.helper.DynamicConvertUtils;
import kd.sdk.hr.hspm.business.revise.helper.ReviseEntityNameHelperEnum;
import kd.sdk.hr.hspm.common.constants.PersonReviseConstants;

public class PersonReviseLogListPlugin
extends HRDataBaseList
implements PersonReviseConstants {
    Map<Long, String> idVsAbstractMap = Maps.newHashMapWithExpectedSize((int)20);

    public void setFilter(SetFilterEvent e) {
        String entityName = (String)this.getView().getFormShowParameter().getCustomParam("entityname");
        Long employeeId = (Long)this.getView().getFormShowParameter().getCustomParam("employeeid");
        Long ermanFileId = (Long)this.getView().getFormShowParameter().getCustomParam("ermanfileid");
        Long personId = (Long)this.getView().getFormShowParameter().getCustomParam("personid");
        PersonReviseService personReviseService = new PersonReviseService(true, entityName);
        DynamicObject[] hisVersions = personReviseService.getHisVersions(entityName, employeeId, ermanFileId, personId, true, false, true);
        List boIdList = Arrays.stream(hisVersions).map(dyn -> dyn.getLong("boid")).collect(Collectors.toList());
        e.getQFilters().add(new QFilter("revisebo", "in", boIdList));
        e.setOrderBy("createtime desc");
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        DynamicObjectCollection pageDataCol = e.getPageData();
        ArrayList idList = Lists.newArrayListWithExpectedSize((int)pageDataCol.size());
        for (DynamicObject pageData : pageDataCol) {
            long id = pageData.getLong("id");
            idList.add(id);
        }
        String billFormId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
        QFilter idFilter = new QFilter("id", "in", (Object)idList);
        HashSet queryFieldSet = Sets.newHashSet((Object[])new String[]{"id", "revisetype", "revisebefore", "reviseafter", "revisenumber"});
        DynamicObject[] reviseLogDynArr = CommonQueryRepository.getInstance().queryColsInfoByFilter(billFormId, (Set)queryFieldSet, idFilter);
        if (reviseLogDynArr.length == 0) {
            return;
        }
        Map<Long, DynamicObject> idVsDynMap = this.getIdVsDynMap(reviseLogDynArr);
        for (DynamicObject reviseLogDyn : reviseLogDynArr) {
            String reviseType = reviseLogDyn.getString("revisetype");
            String groupName = (String)this.getView().getFormShowParameter().getCustomParams().get("groupname");
            StringBuilder abstractSb = new StringBuilder();
            if (HRStringUtils.equals((String)reviseType, (String)"0")) {
                abstractSb.append(String.format(ResManager.loadKDString((String)"\u65b0\u589e%s", (String)"PersonReviseLogListPlugin_0", (String)"hr-hspm-formplugin", (Object[])new Object[0]), groupName));
            } else if (HRStringUtils.equals((String)reviseType, (String)"1")) {
                abstractSb.append(String.format(ResManager.loadKDString((String)"\u5220\u9664%s", (String)"PersonReviseLogListPlugin_1", (String)"hr-hspm-formplugin", (Object[])new Object[0]), groupName));
            } else if (HRStringUtils.equals((String)reviseType, (String)"5")) {
                DynamicObject reviseBeforeDyn = idVsDynMap.get(reviseLogDyn.getLong("revisebefore.id"));
                DynamicObject reviseAfterDyn = idVsDynMap.get(reviseLogDyn.getLong("reviseafter.id"));
                String reviseNumber = reviseLogDyn.getString("revisenumber");
                MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)reviseNumber);
                DataEntityPropertyCollection mainEntityTypeProps = mainEntityType.getProperties();
                Map<String, IDataEntityProperty> propMap = mainEntityTypeProps.stream().collect(Collectors.toMap(data -> data.getName(), v1 -> v1, (v1, v2) -> v2));
                List compareExcludeFieldList = ReviseEntityNameHelperEnum.getCompareExcludeFieldList((String)reviseNumber);
                DynamicConvertUtils dynamicConvertUtils = new DynamicConvertUtils(compareExcludeFieldList);
                List compareResults = dynamicConvertUtils.compareAndGetAllDiffCol(reviseAfterDyn, reviseBeforeDyn);
                for (DynamicConvertUtils.CompareResult compareResult : compareResults) {
                    String afterDisplayValue;
                    boolean same = compareResult.isSame();
                    if (same) continue;
                    String reviseFieldName = compareResult.getPropKey();
                    String fieldDisplayName = propMap.get(reviseFieldName).getDisplayName().getLocaleValue();
                    IDataEntityProperty prop = propMap.get(reviseFieldName);
                    if (prop instanceof MuliLangTextProp) {
                        this.treatAbstractForMultiLang(abstractSb, reviseBeforeDyn, reviseAfterDyn, fieldDisplayName, prop);
                        continue;
                    }
                    String beforeDisplayValue = PersonReviseHelper.getDisplayValueByProp((DynamicObject)reviseBeforeDyn, (IDataEntityProperty)propMap.get(reviseFieldName));
                    if (HRStringUtils.isEmpty((String)beforeDisplayValue)) {
                        beforeDisplayValue = ResManager.loadKDString((String)"\u7a7a", (String)"PersonReviseLogListPlugin_4", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
                    }
                    if (HRStringUtils.isEmpty((String)(afterDisplayValue = PersonReviseHelper.getDisplayValueByProp((DynamicObject)reviseAfterDyn, (IDataEntityProperty)propMap.get(reviseFieldName))))) {
                        afterDisplayValue = ResManager.loadKDString((String)"\u7a7a", (String)"PersonReviseLogListPlugin_4", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
                    }
                    if (HRStringUtils.equals((String)reviseFieldName, (String)"servicelength") && HRStringUtils.equals((String)beforeDisplayValue, (String)afterDisplayValue)) continue;
                    abstractSb.append(String.format(ResManager.loadKDString((String)"\u5c06%1$s\u7531%2$s\u4fee\u8ba2\u4e3a%3$s;%4$s", (String)"PersonReviseLogListPlugin_2", (String)"hr-hspm-formplugin", (Object[])new Object[0]), fieldDisplayName, beforeDisplayValue, afterDisplayValue, System.lineSeparator()));
                }
            }
            long id = reviseLogDyn.getLong("id");
            this.idVsAbstractMap.put(id, abstractSb.toString());
        }
    }

    private Map<Long, DynamicObject> getIdVsDynMap(DynamicObject[] reviseLogDynArr) {
        HashSet entityDataIdSet = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject reviseLogDyn : reviseLogDynArr) {
            DynamicObject reviseAfterDyn;
            DynamicObject reviseBeforeDyn = reviseLogDyn.getDynamicObject("revisebefore");
            if (Objects.nonNull(reviseBeforeDyn)) {
                entityDataIdSet.add(reviseBeforeDyn.getLong("id"));
            }
            if (!Objects.nonNull(reviseAfterDyn = reviseLogDyn.getDynamicObject("reviseafter"))) continue;
            entityDataIdSet.add(reviseAfterDyn.getLong("id"));
        }
        String reviseNumber = reviseLogDynArr[0].getString("revisenumber");
        DynamicObject[] reviseDynArr = CommonQueryRepository.getInstance().loadInfoByIds(reviseNumber, (Set)entityDataIdSet);
        return Arrays.stream(reviseDynArr).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn));
    }

    private void treatAbstractForMultiLang(StringBuilder abstractSb, DynamicObject reviseBeforeDyn, DynamicObject reviseAfterDyn, String fieldDisplayName, IDataEntityProperty prop) {
        String propName = prop.getName();
        ILocaleString beforeVal = reviseBeforeDyn.getLocaleString(propName);
        ILocaleString afterVal = reviseAfterDyn.getLocaleString(propName);
        HashSet mulLangType = new HashSet(4);
        mulLangType.addAll(beforeVal.keySet());
        mulLangType.addAll(afterVal.keySet());
        for (String type : mulLangType) {
            String afterSubVal;
            String beforeSubVal;
            if (StringUtils.equals((CharSequence)"GLang", (CharSequence)type) || HRStringUtils.equals((String)(beforeSubVal = (String)beforeVal.getOrDefault((Object)type, (Object)ResManager.loadKDString((String)"\u7a7a", (String)"PersonReviseLogListPlugin_4", (String)"hr-hspm-formplugin", (Object[])new Object[0]))), (String)(afterSubVal = (String)afterVal.getOrDefault((Object)type, (Object)ResManager.loadKDString((String)"\u7a7a", (String)"PersonReviseLogListPlugin_4", (String)"hr-hspm-formplugin", (Object[])new Object[0]))))) continue;
            abstractSb.append(String.format(ResManager.loadKDString((String)"\u5c06%1$s\uff08%2$s\uff09\u7531%3$s\u4fee\u8ba2\u4e3a%4$s;", (String)"PersonReviseLogListPlugin_3", (String)"hr-hspm-formplugin", (Object[])new Object[0]), fieldDisplayName, type, beforeSubVal, afterSubVal));
            abstractSb.append(System.lineSeparator());
        }
    }

    public void packageData(PackageDataEvent e) {
        DynamicTextColumnDesc colum;
        Object source = e.getSource();
        if (source instanceof DynamicTextColumnDesc && "reviseabstract".equals((colum = (DynamicTextColumnDesc)e.getSource()).getKey())) {
            Long id = e.getRowData().getLong("id");
            e.setFormatValue((Object)this.idVsAbstractMap.get(id));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        FilterColumn prdColumn = args.getFilterColumn("creator.name");
        if (Objects.nonNull(prdColumn)) {
            ArrayList<String> defaultList = new ArrayList<String>();
            defaultList.add(String.valueOf(Long.parseLong(RequestContext.get().getUserId())));
            prdColumn.setDefaultValues(defaultList.toArray());
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"reviselogdetial"});
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if ("creator.id".equals(args.getFieldName())) {
            QFilter userIdFilter = new QFilter("id", "=", (Object)Long.parseLong(RequestContext.get().getUserId()));
            args.getCustomQFilters().add(userIdFilter);
        }
    }

    public void itemClick(ItemClickEvent evt) {
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if ("reviselogdetial".equals(operateKey)) {
            Object id = source.getListSelectedData().get(0).getPrimaryKeyValue();
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setStatus(OperationStatus.VIEW);
            formShowParameter.setCustomParam("reviseLogId", id);
            Object baseEntityName = this.getView().getFormShowParameter().getCustomParams().get("baseentityname");
            String logEntityName = ReviseEntityNameHelperEnum.getLogEntityNameByBaseEntityName((String)((String)baseEntityName));
            formShowParameter.setCustomParam("baseentityname", baseEntityName);
            formShowParameter.setCustomParam("logEntityName", (Object)logEntityName);
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setFormId("hspm_reviselogdetail");
            this.getView().showForm(formShowParameter);
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List listColumns = args.getListColumns();
        List<String> list = this.getFixColumn();
    }

    protected List<String> getFixColumn() {
        return Lists.newArrayListWithExpectedSize((int)16);
    }
}

