/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.schedule.draw.cardview;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hspm.business.domian.handler.CalServiceLengthHandler;
import kd.sdk.hr.hspm.common.ext.file.CardBindDataDTO;
import kd.sdk.hr.hspm.common.utils.BusinessUtils;
import kd.sdk.hr.hspm.common.vo.BeforeCreatVo;
import kd.sdk.hr.hspm.common.vo.CardViewCompareVo;
import kd.sdk.hr.hspm.common.vo.DefineSpecialVo;
import kd.sdk.hr.hspm.common.vo.FieldTransVo;
import kd.sdk.hr.hspm.common.vo.PreBindDataVo;
import kd.sdk.hr.hspm.common.vo.QueryDbVo;
import kd.sdk.hr.hspm.formplugin.web.file.ermanfile.base.AbstractCardDrawEdit;

public class EmpEntCardPlugin
extends AbstractCardDrawEdit {
    private static final Log LOGGER = LogFactory.getLog(EmpEntCardPlugin.class);

    protected PreBindDataVo prefixHandlerBeforeBindData(EventObject args) {
        PreBindDataVo preBindDataVo = super.prefixHandlerBeforeBindData(args);
        Long employeeId = HRJSONUtils.getLongValOfCustomParam((Object)preBindDataVo.getFormShowParameter().getCustomParam("employee"));
        if (employeeId == null || employeeId == 0L) {
            return preBindDataVo;
        }
        CardViewCompareVo compareVo = new CardViewCompareVo("startdate,enddate", "enterprise", "", "empnumber,lastworkdate,laborreltype,laborrelstatus,servicelength,adjustlength,isprobation,description", "");
        List fields = this.setChildFieldVo(new FieldTransVo(preBindDataVo.getDataMap(), compareVo));
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_empentrel");
        QFilter[] conFilter = new QFilter[]{new QFilter("employee.id", "=", (Object)employeeId)};
        QFilter curFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter initstatusFilter = new QFilter("initstatus", "=", (Object)"2");
        Object[] query = serviceHelper.query("id,employee.mid,startdate,enddate,labrelstatusprd.id", new QFilter[]{conFilter[0], curFilter, initstatusFilter});
        if (HRArrayUtils.isNotEmpty((Object[])query)) {
            if (this.getControl("totaltext") instanceof Label) {
                Label total = (Label)this.getControl("totaltext");
                total.setText(String.valueOf(query.length));
            } else {
                this.getModel().setValue("totaltext", (Object)query.length);
            }
            this.getView().getPageCache().put("midcache", query[0].getString("employee.mid"));
            this.getView().getPageCache().put("startdatecache", query[0].getString("startdate"));
            this.getView().getPageCache().put("starttimecache", query[0].getDate("startdate").getTime() + "");
            this.getView().getPageCache().put("enddatecache", query[0].getString("enddate"));
            this.getView().getPageCache().put("prdcache", query[0].getString("labrelstatusprd.id"));
        }
        fields.add("serviceagescheme");
        fields.add("boid");
        QueryDbVo queryDbVo = new QueryDbVo(conFilter, fields, "hrpi_empentrel", "startdate desc, sysenddate desc");
        this.childPointModify(new CardBindDataDTO(this.getModel(), this.getView(), args, compareVo, this.getTimeMap(), queryDbVo));
        this.queryAndAssDataFromDb(queryDbVo);
        List extFields = this.setChildFieldVo(new FieldTransVo(preBindDataVo.getDataMap(), compareVo));
        queryDbVo.setFields(extFields);
        this.defineSpecial(new DefineSpecialVo(true, "shamedit_", null, "shamedit_", null));
        return preBindDataVo;
    }

    protected Map<String, Object> defineSpecial(DefineSpecialVo dsVo) {
        Map defineMap = super.defineSpecial(dsVo);
        defineMap.put("viewshowdialog", "1");
        return defineMap;
    }

    protected boolean customChangeLabelValue(BeforeCreatVo beforeCreatVo) {
        super.customChangeLabelValue(beforeCreatVo);
        Map dataMap = beforeCreatVo.getDataMap();
        Map labMap = beforeCreatVo.getLabMap();
        Map relMap = beforeCreatVo.getRelMap();
        String field = (String)labMap.get("number");
        if ("servicelength".equals(field)) {
            this.calServiceLength(dataMap);
            String relStr = this.transferType(field, dataMap);
            String displayName = (String)labMap.get("displayname");
            String number = (String)labMap.get("number");
            String value = HRStringUtils.isEmpty((String)relStr) ? "-" : relStr;
            String relLabStr = String.join((CharSequence)"\uff1a", displayName, value);
            relMap.put(number, relLabStr);
        }
        return false;
    }

    private void calServiceLength(Map<String, Object> dataMap) {
        Timestamp startdate = (Timestamp)dataMap.get("startdate");
        BigDecimal adjustlength = (BigDecimal)dataMap.get("adjustlength");
        if (adjustlength == null) {
            adjustlength = BigDecimal.ZERO;
        }
        if (startdate == null) {
            dataMap.put("servicelength", 0);
            return;
        }
        String scheme = (String)dataMap.get("serviceagescheme");
        if ("2".equals(scheme)) {
            Long boId = (Long)dataMap.get("boid");
            String mid = this.getView().getPageCache().get("midcache");
            String startTimeCache = this.getView().getPageCache().get("starttimecache");
            if (HRStringUtils.isEmpty((String)mid)) {
                return;
            }
            HRBaseServiceHelper empEntHelper = new HRBaseServiceHelper("hrpi_empentrel");
            DynamicObject empEntDy = empEntHelper.generateEmptyDynamicObject();
            Long employeeId = (Long)this.getView().getFormShowParameter().getCustomParam("employee");
            HRBaseServiceHelper empHelper = new HRBaseServiceHelper("hrpi_employee");
            empEntDy.set("employee", (Object)empHelper.loadSingle((Object)employeeId));
            try {
                empEntDy.set("startdate", (Object)new Date(Long.parseLong(startTimeCache)));
            }
            catch (Exception es) {
                LOGGER.error("parseErr", (Throwable)es);
            }
            empEntDy.set("boid", (Object)boId);
            Map serLenMap = CalServiceLengthHandler.calcEmpentrelContinuation(Collections.singletonList(empEntDy), (String)"1", (String)"1");
            BigDecimal serLen = (BigDecimal)serLenMap.get(Long.parseLong(mid));
            if (serLen != null) {
                dataMap.put("servicelength", serLen);
            }
        } else {
            Date endDate = new Date();
            String prdStr = this.getView().getPageCache().get("prdcache");
            if (HRStringUtils.isNotEmpty((String)prdStr) && 1020L == Long.parseLong(prdStr)) {
                String endDateStr = this.getView().getPageCache().get("enddatecache");
                try {
                    endDate = HRDateTimeUtils.parseDate((String)endDateStr);
                }
                catch (Exception es) {
                    LOGGER.error("parseDateErr", (Throwable)es);
                }
            }
            dataMap.put("servicelength", adjustlength.add(BusinessUtils.calcYearsDiff((Date)endDate, (Date)new Date(startdate.getTime()))));
        }
    }

    protected String getOpenPageName() {
        return "hspm_revempentrel";
    }

    protected String getEntityName() {
        return "hrpi_empentrel";
    }
}

